/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.agents;

import io.lucenia.ml.common.action.handler.MLSearchHandler;
import io.lucenia.ml.common.transport.search.MLSearchActionRequest;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.client.metadata.MetadataClient;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.QueryBuilders;

public class TransportSearchAgentAction
extends HandledTransportAction<MLSearchActionRequest, SearchResponse> {
    private static final Logger log = LogManager.getLogger(TransportSearchAgentAction.class);
    private final Client client;
    private final MetadataClient sdkClient;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public TransportSearchAgentAction(TransportService transportService, ActionFilters actionFilters, Client client, MetadataClient sdkClient, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/lucenia/ml/agents/search", transportService, actionFilters, MLSearchActionRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, MLSearchActionRequest request, ActionListener<SearchResponse> actionListener) {
        request.indices(new String[]{".plugins-ml-agent"});
        String tenantId = request.getTenantId();
        if (!TenantAwareHelper.validateTenantId((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, actionListener)) {
            return;
        }
        this.search(request, tenantId, actionListener);
    }

    private void search(SearchRequest request, String tenantId, ActionListener<SearchResponse> actionListener) {
        ActionListener<SearchResponse> listener = MLSearchHandler.wrapRestActionListener(actionListener, "Fail to search agent");
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListenerHelper.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
            BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
            if (request.source().query() != null) {
                queryBuilder.must(request.source().query());
            }
            BoolQueryBuilder shouldQuery = QueryBuilders.boolQuery();
            shouldQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"is_hidden", (boolean)false));
            if (tenantId != null) {
                shouldQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"tenant_id", (String)tenantId));
            }
            shouldQuery.should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"is_hidden")));
            shouldQuery.minimumShouldMatch(1);
            queryBuilder.filter((QueryBuilder)shouldQuery);
            request.source().query((QueryBuilder)queryBuilder);
            this.client.search(request, wrappedListener);
        }
        catch (Exception e) {
            log.error("failed to search the agent index", (Throwable)e);
            actionListener.onFailure(e);
        }
    }
}

