/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.connector;

import io.lucenia.ml.common.helpers.ConnectorAccessControlHelper;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.delete.DeleteRequest;
import io.skylite.core.action.delete.DeleteResponse;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.client.metadata.DeleteDataObjectRequest;
import io.skylite.core.client.metadata.DeleteDataObjectResponse;
import io.skylite.core.client.metadata.MetadataClient;
import io.skylite.core.client.metadata.SearchDataObjectRequest;
import io.skylite.core.client.metadata.SearchDataObjectResponse;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.SearchHit;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.exception.MLValidationException;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.connector.MLConnectorDeleteRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.QueryBuilders;

public class DeleteConnectorTransportAction
extends HandledTransportAction<ActionRequest, DeleteResponse> {
    private static final Logger log = LogManager.getLogger(DeleteConnectorTransportAction.class);
    private final Client client;
    private final MetadataClient sdkClient;
    private final NamedXContentRegistry xContentRegistry;
    private final ConnectorAccessControlHelper connectorAccessControlHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public DeleteConnectorTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, MetadataClient sdkClient, NamedXContentRegistry xContentRegistry, ConnectorAccessControlHelper connectorAccessControlHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/lucenia/ml/connectors/delete", transportService, actionFilters, MLConnectorDeleteRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.xContentRegistry = xContentRegistry;
        this.connectorAccessControlHelper = connectorAccessControlHelper;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<DeleteResponse> actionListener) {
        MLConnectorDeleteRequest mlConnectorDeleteRequest = MLConnectorDeleteRequest.fromActionRequest((ActionRequest)request);
        String connectorId = mlConnectorDeleteRequest.getConnectorId();
        String tenantId = mlConnectorDeleteRequest.getTenantId();
        if (!TenantAwareHelper.validateTenantId((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, actionListener)) {
            return;
        }
        this.connectorAccessControlHelper.validateConnectorAccess(this.sdkClient, this.client, connectorId, tenantId, this.mlFeatureEnabledSetting, (ActionListener<Boolean>)ActionListenerHelper.wrap(isAllowed -> this.handleConnectorAccessValidation(connectorId, tenantId, (boolean)isAllowed, actionListener), e -> this.handleConnectorAccessValidationFailure(connectorId, (Exception)e, actionListener)));
    }

    private void handleConnectorAccessValidation(String connectorId, String tenantId, boolean isAllowed, ActionListener<DeleteResponse> actionListener) {
        if (isAllowed) {
            this.checkForModelsUsingConnector(connectorId, tenantId, actionListener);
        } else {
            actionListener.onFailure((Exception)new MLValidationException("You are not allowed to delete this connector"));
        }
    }

    private void handleConnectorAccessValidationFailure(String connectorId, Exception e, ActionListener<DeleteResponse> actionListener) {
        log.error("Failed to delete ML connector: {}", (Object)connectorId);
        actionListener.onFailure(e);
    }

    private void checkForModelsUsingConnector(String connectorId, String tenantId, ActionListener<DeleteResponse> actionListener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener restoringListener = ActionListenerHelper.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore());
            SearchDataObjectRequest searchRequest = this.buildModelSearchRequest(connectorId, tenantId);
            this.sdkClient.searchDataObjectAsync(searchRequest).whenComplete((searchResponse, throwable) -> this.handleSearchResponse(connectorId, tenantId, (ActionListener<DeleteResponse>)restoringListener, (SearchDataObjectResponse)searchResponse, (Throwable)throwable));
        }
        catch (Exception e) {
            log.error("Failed to check for models using connector: {}", (Object)connectorId);
            actionListener.onFailure(e);
        }
    }

    private SearchDataObjectRequest buildModelSearchRequest(String connectorId, String tenantId) {
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query((QueryBuilder)QueryBuilders.matchQuery((String)"connector_id", (Object)connectorId));
        if (this.mlFeatureEnabledSetting.isMultiTenancyEnabled()) {
            sourceBuilder.query((QueryBuilder)QueryBuilders.matchQuery((String)"tenant_id", (Object)tenantId));
        }
        return SearchDataObjectRequest.builder().indices(new String[]{".plugins-ml-model"}).tenantId(tenantId).searchSourceBuilder(sourceBuilder).build();
    }

    private void handleSearchResponse(String connectorId, String tenantId, ActionListener<DeleteResponse> restoringListener, SearchDataObjectResponse searchResponse, Throwable throwable) {
        if (searchResponse == null) {
            Exception cause = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
            this.handleSearchFailure(connectorId, tenantId, cause, restoringListener);
            return;
        }
        try {
            SearchResponse response = SearchResponse.fromXContent((XContentParser)searchResponse.parser());
            SearchHit[] searchHits = response.getHits().getHits();
            if (searchHits.length == 0) {
                this.deleteConnector(connectorId, tenantId, restoringListener);
            } else {
                this.handleModelsUsingConnector(searchHits, connectorId, restoringListener);
            }
        }
        catch (Exception e) {
            log.error("Failed to parse search response", (Throwable)e);
            restoringListener.onFailure((Exception)new SkyliteStatusException("Failed to parse search response", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
        }
    }

    private void handleModelsUsingConnector(SearchHit[] searchHits, String connectorId, ActionListener<DeleteResponse> actionListener) {
        log.error("{} models are still using this connector, please delete or update the models first!", (Object)searchHits.length);
        ArrayList<String> modelIds = new ArrayList<String>();
        for (SearchHit hit : searchHits) {
            modelIds.add(hit.getId());
        }
        actionListener.onFailure((Exception)new SkyliteStatusException(searchHits.length + " models are still using this connector, please delete or update the models first: " + Arrays.toString(modelIds.toArray(new String[0])), RestStatus.CONFLICT, new Object[0]));
    }

    private void handleSearchFailure(String connectorId, String tenantId, Exception cause, ActionListener<DeleteResponse> actionListener) {
        if (SkyliteExceptionsHelper.unwrap((Throwable)cause, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
            this.deleteConnector(connectorId, tenantId, actionListener);
            return;
        }
        log.error("Failed to search for models using connector: {}", (Object)connectorId);
        actionListener.onFailure(cause);
    }

    private void deleteConnector(String connectorId, String tenantId, ActionListener<DeleteResponse> actionListener) {
        DeleteRequest deleteRequest = new DeleteRequest(".plugins-ml-connector", connectorId);
        try {
            this.sdkClient.deleteDataObjectAsync(((DeleteDataObjectRequest.Builder)((DeleteDataObjectRequest.Builder)((DeleteDataObjectRequest.Builder)DeleteDataObjectRequest.builder().index(deleteRequest.index())).id(deleteRequest.id())).tenantId(tenantId)).build()).whenComplete((response, throwable) -> this.handleDeleteResponse((DeleteDataObjectResponse)response, (Throwable)throwable, connectorId, actionListener));
        }
        catch (Exception e) {
            log.error("Failed to delete ML connector: {}", (Object)connectorId);
            actionListener.onFailure(e);
        }
    }

    private void handleDeleteResponse(DeleteDataObjectResponse response, Throwable throwable, String connectorId, ActionListener<DeleteResponse> actionListener) {
        if (throwable != null) {
            Exception cause = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
            log.error("Failed to delete ML connector: {}", (Object)connectorId);
            actionListener.onFailure(cause);
        } else {
            try {
                DeleteResponse deleteResponse = DeleteResponse.fromXContent((XContentParser)response.parser());
                log.info("Connector deletion result: {}, connector id: {}", (Object)deleteResponse.getResult(), (Object)response.id());
                actionListener.onResponse((Object)deleteResponse);
            }
            catch (IOException e) {
                actionListener.onFailure((Exception)e);
            }
        }
    }
}

