/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.controller;

import io.lucenia.ml.common.model.MLModelManager;
import io.lucenia.ml.common.model.ModelAccessControlHelper;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.action.delete.DeleteRequest;
import io.skylite.core.action.delete.DeleteResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.Strings;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.ml.common.controller.MLController;
import io.skylite.ml.common.model.MLModel;
import io.skylite.ml.common.model.MLModelCacheHelper;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.controller.MLControllerDeleteRequest;
import io.skylite.ml.common.transport.controller.MLUndeployControllerAction;
import io.skylite.ml.common.transport.controller.MLUndeployControllerNodesRequest;
import io.skylite.ml.common.transport.controller.MLUndeployControllerNodesResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeleteControllerTransportAction
extends HandledTransportAction<ActionRequest, DeleteResponse> {
    private static final Logger log = LogManager.getLogger(DeleteControllerTransportAction.class);
    private Client client;
    private NamedXContentRegistry xContentRegistry;
    private ClusterService clusterService;
    private MLModelManager mlModelManager;
    private MLModelCacheHelper mlModelCacheHelper;
    private ModelAccessControlHelper modelAccessControlHelper;
    private MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public DeleteControllerTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, NamedXContentRegistry xContentRegistry, ClusterService clusterService, MLModelManager mlModelManager, MLModelCacheHelper mlModelCacheHelper, ModelAccessControlHelper modelAccessControlHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/lucenia/ml/controllers/delete", transportService, actionFilters, MLControllerDeleteRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.mlModelManager = mlModelManager;
        this.mlModelCacheHelper = mlModelCacheHelper;
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<DeleteResponse> actionListener) {
        MLControllerDeleteRequest controllerDeleteRequest = MLControllerDeleteRequest.fromActionRequest((ActionRequest)request);
        String modelId = controllerDeleteRequest.getModelId();
        User user = RestActionUtils.getUserContext(this.client);
        String[] excludes = new String[]{"model_content", "content"};
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            if (!this.mlFeatureEnabledSetting.isControllerEnabled().booleanValue()) {
                throw new IllegalStateException("Controller is currently disabled. To enable it, update the setting \"plugins.ml_commons.controller_enabled\" to true.");
            }
            ActionListener wrappedListener = ActionListenerHelper.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore());
            this.mlModelManager.getModel(modelId, null, excludes, (ActionListener<MLModel>)ActionListenerHelper.wrap(mlModel -> {
                Boolean isHidden = mlModel.getIsHidden();
                this.modelAccessControlHelper.validateModelGroupAccess(user, mlModel.getModelGroupId(), this.client, (ActionListener<Boolean>)ActionListenerHelper.wrap(hasPermission -> {
                    if (hasPermission.booleanValue()) {
                        this.mlModelManager.getController(modelId, (ActionListener<MLController>)ActionListenerHelper.wrap(controller -> this.deleteControllerWithDeployedModel(modelId, mlModel.getIsHidden(), (ActionListener<DeleteResponse>)wrappedListener), deleteException -> {
                            log.error("exception in deleteControllerWithDeployedModel", (Throwable)deleteException);
                            wrappedListener.onFailure(deleteException);
                        }));
                    } else {
                        wrappedListener.onFailure((Exception)new SkyliteStatusException(Strings.getErrorMessage((String)"User doesn't have privilege to perform this operation on this model controller.", (String)modelId, (boolean)isHidden), RestStatus.FORBIDDEN, new Object[0]));
                    }
                }, exception -> {
                    log.error(Strings.getErrorMessage((String)"Permission denied: Unable to delete the model controller with the provided model. Details: ", (String)modelId, (boolean)isHidden), (Throwable)exception);
                    wrappedListener.onFailure(exception);
                }));
            }, e -> {
                log.warn("Failed to find corresponding model during deleting the model controller. Now trying to delete the model controller alone.");
                this.mlModelManager.getController(modelId, (ActionListener<MLController>)ActionListenerHelper.wrap(controller -> this.deleteControllerWithDeployedModel(modelId, Boolean.TRUE, (ActionListener<DeleteResponse>)wrappedListener), deleteException -> {
                    log.error("exception in deleteControllerWithDeployedModel", (Throwable)deleteException);
                    wrappedListener.onFailure(deleteException);
                }));
            }));
        }
        catch (Exception e2) {
            log.error("Failed to delete model controller for the given model", (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }

    private void deleteControllerWithDeployedModel(String modelId, Boolean isHidden, ActionListener<DeleteResponse> actionListener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            if (this.mlModelCacheHelper.getWorkerNodes(modelId).length != 0) {
                log.info("Model has already been deployed in ML cache, need undeploy model controller before sending delete request.");
                String[] targetNodeIds = this.getAllNodes();
                MLUndeployControllerNodesRequest undeployControllerNodesRequest = new MLUndeployControllerNodesRequest(targetNodeIds, modelId);
                this.client.execute((ActionType)MLUndeployControllerAction.INSTANCE, (ActionRequest)undeployControllerNodesRequest, ActionListenerHelper.runBefore((ActionListener)ActionListenerHelper.wrap(nodesResponse -> {
                    if (nodesResponse != null && this.isUndeployControllerSuccessOnAllNodes((MLUndeployControllerNodesResponse)nodesResponse)) {
                        log.info(Strings.getErrorMessage((String)"Successfully undeploy model controller from cache. Start to delete the model controller", (String)modelId, (boolean)isHidden));
                        this.deleteController(modelId, isHidden, actionListener);
                    } else {
                        Object[] nodeIds = this.getUndeployControllerFailedNodesList((MLUndeployControllerNodesResponse)nodesResponse);
                        String errorMessage = Strings.getErrorMessage((String)("Failed to undeploy model controller with the given model on following nodes " + Arrays.toString(nodeIds) + ", deletion is aborted. Please retry or undeploy the model manually and then perform the deletion."), (String)modelId, (boolean)isHidden);
                        log.error(errorMessage);
                        actionListener.onFailure((Exception)new RuntimeException(errorMessage));
                    }
                }, e -> {
                    log.error(Strings.getErrorMessage((String)"Failed to undeploy model controller from cache and delete the model controller", (String)modelId, (boolean)isHidden));
                    actionListener.onFailure(e);
                }), () -> ((ThreadContext.StoredContext)context).restore()));
            } else {
                this.deleteController(modelId, isHidden, actionListener);
            }
        }
        catch (Exception e2) {
            log.error("Failed to delete model controller", (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }

    private void deleteController(final String modelId, final Boolean isHidden, final ActionListener<DeleteResponse> actionListener) {
        DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(".plugins-ml-controller", modelId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        this.client.delete(deleteRequest, (ActionListener)new ActionListener<DeleteResponse>(){

            public void onResponse(DeleteResponse deleteResponse) {
                log.info("Model controller for the provided successfully deleted from index, result: {} {}", (Object)modelId, (Object)deleteResponse.getResult());
                DeleteControllerTransportAction.this.mlModelManager.updateModel(modelId, isHidden, Map.of("is_controller_enabled", false));
                actionListener.onResponse((Object)deleteResponse);
            }

            public void onFailure(Exception e) {
                log.error(Strings.getErrorMessage((String)"Failed to delete model controller for the provided model.", (String)modelId, (boolean)isHidden), (Throwable)e);
                actionListener.onFailure(e);
            }
        });
    }

    private boolean isUndeployControllerSuccessOnAllNodes(MLUndeployControllerNodesResponse undeployControllerNodesResponse) {
        return undeployControllerNodesResponse.failures() == null || undeployControllerNodesResponse.failures().isEmpty();
    }

    private String[] getUndeployControllerFailedNodesList(MLUndeployControllerNodesResponse undeployControllerNodesResponse) {
        if (undeployControllerNodesResponse == null) {
            return this.getAllNodes();
        }
        ArrayList<String> nodeIds = new ArrayList<String>();
        for (FailedNodeException failedNodeException : undeployControllerNodesResponse.failures()) {
            nodeIds.add(failedNodeException.nodeId());
        }
        return nodeIds.toArray(new String[0]);
    }

    private String[] getAllNodes() {
        Iterator iterator = this.clusterService.state().nodes().iterator();
        ArrayList<String> nodeIds = new ArrayList<String>();
        while (iterator.hasNext()) {
            nodeIds.add(((DiscoveryNode)iterator.next()).getId());
        }
        return nodeIds.toArray(new String[0]);
    }
}

