/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.deploy;

import io.lucenia.ml.common.model.MLModelManager;
import io.lucenia.ml.common.model.ModelAccessControlHelper;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.lucenia.ml.common.task.MLTaskDispatcher;
import io.lucenia.ml.common.task.MLTaskManager;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.index.IndexResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.update.UpdateResponse;
import io.skylite.core.client.Client;
import io.skylite.core.client.metadata.MetadataClient;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.Strings;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.cluster.DiscoveryNodeHelper;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.engine.ModelDownloader;
import io.skylite.ml.common.exception.MLExceptionUtils;
import io.skylite.ml.common.model.MLModel;
import io.skylite.ml.common.model.MLModelState;
import io.skylite.ml.common.settings.MLCommonsSettings;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.stats.MLStats;
import io.skylite.ml.common.task.MLTask;
import io.skylite.ml.common.task.MLTaskState;
import io.skylite.ml.common.task.MLTaskType;
import io.skylite.ml.common.transport.deploy.MLDeployModelInput;
import io.skylite.ml.common.transport.deploy.MLDeployModelNodesRequest;
import io.skylite.ml.common.transport.deploy.MLDeployModelNodesResponse;
import io.skylite.ml.common.transport.deploy.MLDeployModelOnNodeAction;
import io.skylite.ml.common.transport.deploy.MLDeployModelRequest;
import io.skylite.ml.common.transport.deploy.MLDeployModelResponse;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportDeployModelAction
extends HandledTransportAction<ActionRequest, MLDeployModelResponse> {
    private static final Logger log = LogManager.getLogger(TransportDeployModelAction.class);
    TransportService transportService;
    ModelDownloader modelDownloader;
    MLTaskManager mlTaskManager;
    ClusterService clusterService;
    ThreadPool threadPool;
    Client client;
    MetadataClient sdkClient;
    Settings settings;
    NamedXContentRegistry xContentRegistry;
    DiscoveryNodeHelper nodeFilter;
    MLTaskDispatcher mlTaskDispatcher;
    MLModelManager mlModelManager;
    MLStats mlStats;
    private volatile boolean allowCustomDeploymentPlan;
    private final ModelAccessControlHelper modelAccessControlHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public TransportDeployModelAction(TransportService transportService, ActionFilters actionFilters, ModelDownloader modelDownloader, MLTaskManager mlTaskManager, ClusterService clusterService, ThreadPool threadPool, Client client, MetadataClient sdkClient, NamedXContentRegistry xContentRegistry, DiscoveryNodeHelper nodeFilter, MLTaskDispatcher mlTaskDispatcher, MLModelManager mlModelManager, MLStats mlStats, Settings settings, ModelAccessControlHelper modelAccessControlHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/lucenia/ml/deploy_model", transportService, actionFilters, MLDeployModelRequest::new);
        this.transportService = transportService;
        this.modelDownloader = modelDownloader;
        this.mlTaskManager = mlTaskManager;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.client = client;
        this.sdkClient = sdkClient;
        this.xContentRegistry = xContentRegistry;
        this.nodeFilter = nodeFilter;
        this.mlTaskDispatcher = mlTaskDispatcher;
        this.mlModelManager = mlModelManager;
        this.mlStats = mlStats;
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        this.settings = settings;
        this.allowCustomDeploymentPlan = (Boolean)MLCommonsSettings.ML_COMMONS_ALLOW_CUSTOM_DEPLOYMENT_PLAN.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_ALLOW_CUSTOM_DEPLOYMENT_PLAN, it -> {
            this.allowCustomDeploymentPlan = it;
        });
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLDeployModelResponse> listener) {
        MLDeployModelRequest deployModelRequest = MLDeployModelRequest.fromActionRequest((ActionRequest)request);
        String modelId = deployModelRequest.getModelId();
        String tenantId = deployModelRequest.getTenantId();
        if (!TenantAwareHelper.validateTenantId((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, listener)) {
            return;
        }
        boolean isUserInitiatedDeployRequest = deployModelRequest.isUserInitiatedDeployRequest();
        User user = RestActionUtils.getUserContext(this.client);
        boolean isSuperAdmin = this.isSuperAdminUserWrapper(this.clusterService, this.client);
        String[] excludes = new String[]{"model_content", "content"};
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListenerHelper.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
            this.mlModelManager.getModel(modelId, tenantId, null, excludes, (ActionListener<MLModel>)ActionListenerHelper.wrap(mlModel -> {
                FunctionName functionName = mlModel.getAlgorithm();
                Boolean isHidden = mlModel.getIsHidden();
                if (!TenantAwareHelper.validateTenantResource((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, (String)mlModel.getTenantId(), (ActionListener)listener)) {
                    return;
                }
                if (functionName == FunctionName.REMOTE && !this.mlFeatureEnabledSetting.isRemoteInferenceEnabled()) {
                    throw new IllegalStateException("Remote Inference is currently disabled. To enable it, update the setting \"plugins.ml_commons.remote_inference_enabled\" to true.");
                }
                if (FunctionName.isDLModel((FunctionName)functionName) && !this.mlFeatureEnabledSetting.isLocalModelEnabled()) {
                    throw new IllegalStateException("Local Model is currently disabled. To enable it, update the setting \"plugins.ml_commons.local_model.enabled\" to true.");
                }
                if (!isUserInitiatedDeployRequest) {
                    this.deployModel(deployModelRequest, (MLModel)mlModel, modelId, tenantId, (ActionListener<MLDeployModelResponse>)wrappedListener, listener);
                } else if (Boolean.TRUE.equals(isHidden)) {
                    if (isSuperAdmin) {
                        this.deployModel(deployModelRequest, (MLModel)mlModel, modelId, tenantId, (ActionListener<MLDeployModelResponse>)wrappedListener, listener);
                    } else {
                        wrappedListener.onFailure((Exception)new SkyliteStatusException("User doesn't have privilege to perform this operation on this model", RestStatus.FORBIDDEN, new Object[0]));
                    }
                } else {
                    this.modelAccessControlHelper.validateModelGroupAccess(user, mlModel.getModelGroupId(), this.client, (ActionListener<Boolean>)ActionListenerHelper.wrap(access -> {
                        if (!access.booleanValue()) {
                            wrappedListener.onFailure((Exception)new SkyliteStatusException("User doesn't have privilege to perform this operation on this model", RestStatus.FORBIDDEN, new Object[0]));
                        } else {
                            this.deployModel(deployModelRequest, (MLModel)mlModel, modelId, tenantId, (ActionListener<MLDeployModelResponse>)wrappedListener, listener);
                        }
                    }, e -> {
                        log.error(Strings.getErrorMessage((String)"Failed to Validate Access for the given model", (String)modelId, (boolean)isHidden), (Throwable)e);
                        wrappedListener.onFailure(e);
                    }));
                }
            }, e -> {
                log.error("Failed to retrieve the ML model with the given ID", (Throwable)e);
                wrappedListener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            log.error("Failed to deploy the ML model", (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    private void deployModel(MLDeployModelRequest deployModelRequest, MLModel mlModel, String modelId, String tenantId, ActionListener<MLDeployModelResponse> wrappedListener, ActionListener<MLDeployModelResponse> listener) {
        boolean deployToAllNodes;
        String[] targetNodeIds = deployModelRequest.getModelNodeIds();
        boolean bl = deployToAllNodes = targetNodeIds == null || targetNodeIds.length == 0;
        if (!this.allowCustomDeploymentPlan && !deployToAllNodes) {
            throw new IllegalArgumentException("Don't allow custom deployment plan");
        }
        DiscoveryNode[] allEligibleNodes = this.nodeFilter.getEligibleNodes(mlModel.getAlgorithm());
        HashMap<String, DiscoveryNode> nodeMapping = new HashMap<String, DiscoveryNode>();
        for (DiscoveryNode discoveryNode : allEligibleNodes) {
            nodeMapping.put(discoveryNode.getId(), discoveryNode);
        }
        Set allEligibleNodeIds = Arrays.stream(allEligibleNodes).map(DiscoveryNode::getId).collect(Collectors.toSet());
        ArrayList<DiscoveryNode> eligibleNodes = new ArrayList<DiscoveryNode>();
        ArrayList<String> eligibleNodeIds = new ArrayList<String>();
        if (!deployToAllNodes) {
            for (String nodeId : targetNodeIds) {
                if (!allEligibleNodeIds.contains(nodeId)) continue;
                eligibleNodes.add((DiscoveryNode)nodeMapping.get(nodeId));
                eligibleNodeIds.add(nodeId);
            }
            String[] stringArray = this.mlModelManager.getWorkerNodes(modelId, mlModel.getAlgorithm());
            if (stringArray != null && stringArray.length > 0) {
                HashSet<String> difference = new HashSet<String>(Arrays.asList(stringArray));
                Arrays.asList(targetNodeIds).forEach(difference::remove);
                if (!difference.isEmpty()) {
                    wrappedListener.onFailure((Exception)new IllegalArgumentException("Model already deployed to these nodes: " + Arrays.toString(difference.toArray(new String[0])) + ", but they are not included in target node ids. Undeploy model from these nodes if don't need them any more.Undeploy from old nodes before try to deploy model on new nodes. Or include all old nodes on your target nodes."));
                    return;
                }
            }
        } else {
            eligibleNodeIds.addAll(allEligibleNodeIds);
            eligibleNodes.addAll(Arrays.asList(allEligibleNodes));
        }
        if (eligibleNodeIds.isEmpty()) {
            wrappedListener.onFailure((Exception)new IllegalArgumentException("no eligible node found"));
            return;
        }
        log.info("Will deploy model on these nodes: {}", (Object)String.join((CharSequence)",", eligibleNodeIds));
        String string = this.clusterService.localNode().getId();
        FunctionName algorithm = mlModel.getAlgorithm();
        MLTask mlTask = MLTask.builder().async(true).modelId(modelId).taskType(MLTaskType.DEPLOY_MODEL).functionName(algorithm).createTime(Instant.now()).lastUpdateTime(Instant.now()).state(MLTaskState.CREATED).workerNodes(eligibleNodeIds).tenantId(tenantId).build();
        this.mlTaskManager.createMLTask(mlTask, (ActionListener<IndexResponse>)ActionListenerHelper.wrap(response -> {
            String taskId = response.getId();
            mlTask.setTaskId(taskId);
            if (algorithm == FunctionName.REMOTE) {
                this.mlTaskManager.add(mlTask, eligibleNodeIds);
                this.deployRemoteModel(mlModel, mlTask, localNodeId, eligibleNodes, deployToAllNodes, listener);
                return;
            }
            try {
                this.mlTaskManager.add(mlTask, eligibleNodeIds);
                wrappedListener.onResponse((Object)new MLDeployModelResponse(taskId, MLTaskType.DEPLOY_MODEL, MLTaskState.CREATED.name()));
                this.threadPool.executor("lucenia_ml_deploy").execute(() -> this.updateModelDeployStatusAndTriggerOnNodesAction(modelId, taskId, tenantId, mlModel, localNodeId, mlTask, eligibleNodes, deployToAllNodes));
            }
            catch (Exception ex) {
                log.error("Failed to deploy model", (Throwable)ex);
                this.mlTaskManager.updateMLTask(taskId, tenantId, Map.of("state", MLTaskState.FAILED, "error", MLExceptionUtils.getRootCauseMessage((Throwable)ex)), MLTaskManager.TASK_SEMAPHORE_TIMEOUT, true);
                wrappedListener.onFailure(ex);
            }
        }, exception -> {
            if (mlModel.getIsHidden().booleanValue()) {
                log.error("Failed to create deploy model task for the provided model", (Throwable)exception);
            } else {
                log.error("Failed to create deploy model task for {}", (Object)modelId);
            }
            wrappedListener.onFailure(exception);
        }));
    }

    void deployRemoteModel(MLModel mlModel, MLTask mlTask, String localNodeId, List<DiscoveryNode> eligibleNodes, boolean deployToAllNodes, ActionListener<MLDeployModelResponse> listener) {
        MLDeployModelInput deployModelInput = new MLDeployModelInput(mlModel.getModelId(), mlTask.getTaskId(), mlModel.getModelContentHash(), Integer.valueOf(eligibleNodes.size()), localNodeId, Boolean.valueOf(deployToAllNodes), mlTask, mlModel.getTenantId());
        MLDeployModelNodesRequest deployModelRequest = new MLDeployModelNodesRequest(eligibleNodes.toArray(new DiscoveryNode[0]), deployModelInput);
        ActionListener<MLDeployModelNodesResponse> actionListener = this.deployModelNodesResponseListener(mlTask.getTaskId(), mlModel.getModelId(), mlModel.getTenantId(), mlModel.getIsHidden(), listener);
        List workerNodes = eligibleNodes.stream().map(DiscoveryNode::getId).collect(Collectors.toList());
        this.mlModelManager.updateModel(mlModel.getModelId(), mlModel.getTenantId(), Map.of("model_state", MLModelState.DEPLOYING, "planning_worker_node_count", eligibleNodes.size(), "planning_worker_nodes", workerNodes, "deploy_to_all_nodes", deployToAllNodes), (ActionListener<UpdateResponse>)ActionListenerHelper.wrap(r -> this.client.execute((ActionType)MLDeployModelOnNodeAction.INSTANCE, (ActionRequest)deployModelRequest, actionListener), arg_0 -> actionListener.onFailure(arg_0)));
    }

    private ActionListener<MLDeployModelNodesResponse> deployModelNodesResponseListener(String taskId, String modelId, String tenantId, Boolean isHidden, ActionListener<MLDeployModelResponse> listener) {
        return ActionListenerHelper.wrap(r -> {
            if (this.mlTaskManager.contains(taskId)) {
                this.mlTaskManager.updateMLTask(taskId, tenantId, Map.of("state", MLTaskState.RUNNING), MLTaskManager.TASK_SEMAPHORE_TIMEOUT, false);
            }
            listener.onResponse((Object)new MLDeployModelResponse(taskId, MLTaskType.DEPLOY_MODEL, MLTaskState.COMPLETED.name()));
        }, e -> {
            log.error("Failed to deploy model {}", (Object)modelId);
            this.mlTaskManager.updateMLTask(taskId, tenantId, Map.of("error", MLExceptionUtils.getRootCauseMessage((Throwable)e), "state", MLTaskState.FAILED), MLTaskManager.TASK_SEMAPHORE_TIMEOUT, true);
            this.mlModelManager.updateModel(modelId, tenantId, isHidden, Map.of("model_state", MLModelState.DEPLOY_FAILED));
            listener.onFailure(e);
        });
    }

    void updateModelDeployStatusAndTriggerOnNodesAction(String modelId, String taskId, String tenantId, MLModel mlModel, String localNodeId, MLTask mlTask, List<DiscoveryNode> eligibleNodes, boolean deployToAllNodes) {
        MLDeployModelInput deployModelInput = new MLDeployModelInput(modelId, taskId, mlModel.getModelContentHash(), Integer.valueOf(eligibleNodes.size()), localNodeId, Boolean.valueOf(deployToAllNodes), mlTask, tenantId);
        MLDeployModelNodesRequest deployModelRequest = new MLDeployModelNodesRequest(eligibleNodes.toArray(new DiscoveryNode[0]), deployModelInput);
        ActionListener actionListener = ActionListenerHelper.wrap(r -> {
            if (this.mlTaskManager.contains(taskId)) {
                this.mlTaskManager.updateMLTask(taskId, mlModel.getTenantId(), Map.of("state", MLTaskState.RUNNING), MLTaskManager.TASK_SEMAPHORE_TIMEOUT, false);
            }
        }, e -> {
            log.error("Failed to deploy model {}", (Object)modelId);
            this.mlTaskManager.updateMLTask(taskId, mlModel.getTenantId(), Map.of("error", MLExceptionUtils.getRootCauseMessage((Throwable)e), "state", MLTaskState.FAILED), MLTaskManager.TASK_SEMAPHORE_TIMEOUT, true);
            this.mlModelManager.updateModel(modelId, mlModel.getTenantId(), mlModel.getIsHidden(), Map.of("model_state", MLModelState.DEPLOY_FAILED));
        });
        List<String> workerNodes = eligibleNodes.stream().map(DiscoveryNode::getId).toList();
        this.mlModelManager.updateModel(modelId, mlModel.getTenantId(), Map.of("model_state", MLModelState.DEPLOYING, "planning_worker_node_count", eligibleNodes.size(), "planning_worker_nodes", workerNodes, "deploy_to_all_nodes", deployToAllNodes), (ActionListener<UpdateResponse>)ActionListenerHelper.wrap(r -> this.client.execute((ActionType)MLDeployModelOnNodeAction.INSTANCE, (ActionRequest)deployModelRequest, actionListener), arg_0 -> ((ActionListener)actionListener).onFailure(arg_0)));
    }

    boolean isSuperAdminUserWrapper(ClusterService clusterService, Client client) {
        return RestActionUtils.isSuperAdminUser(clusterService, client);
    }
}

