/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.forward;

import io.lucenia.ml.common.autoredeploy.MLModelAutoReDeployer;
import io.lucenia.ml.common.model.MLModelManager;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.lucenia.ml.common.task.MLTaskManager;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.update.UpdateResponse;
import io.skylite.core.client.Client;
import io.skylite.core.client.metadata.MetadataClient;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.cluster.DiscoveryNodeHelper;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.exception.MLExceptionUtils;
import io.skylite.ml.common.model.MLModelState;
import io.skylite.ml.common.settings.MLCommonsSettings;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.task.MLTask;
import io.skylite.ml.common.task.MLTaskCache;
import io.skylite.ml.common.task.MLTaskState;
import io.skylite.ml.common.transport.forward.MLForwardInput;
import io.skylite.ml.common.transport.forward.MLForwardRequest;
import io.skylite.ml.common.transport.forward.MLForwardRequestType;
import io.skylite.ml.common.transport.forward.MLForwardResponse;
import io.skylite.ml.common.transport.register.MLRegisterModelInput;
import io.skylite.ml.common.transport.sync.MLSyncUpAction;
import io.skylite.ml.common.transport.sync.MLSyncUpInput;
import io.skylite.ml.common.transport.sync.MLSyncUpNodesRequest;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportForwardAction
extends HandledTransportAction<ActionRequest, MLForwardResponse> {
    private static final Logger log = LogManager.getLogger(TransportForwardAction.class);
    private final ClusterService clusterService;
    private MLTaskManager mlTaskManager;
    private Client client;
    private final MetadataClient sdkClient;
    private MLModelManager mlModelManager;
    private DiscoveryNodeHelper nodeHelper;
    private final Settings settings;
    private volatile float modelAutoRedeploySuccessRatio;
    private boolean enableAutoReDeployModel;
    private final MLModelAutoReDeployer mlModelAutoReDeployer;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public TransportForwardAction(TransportService transportService, ActionFilters actionFilters, MLTaskManager mlTaskManager, Client client, MetadataClient sdkClient, MLModelManager mlModelManager, DiscoveryNodeHelper nodeHelper, Settings settings, ClusterService clusterService, MLModelAutoReDeployer mlModelAutoReDeployer, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/opensearch/mlinternal/forward", transportService, actionFilters, MLForwardRequest::new);
        this.mlTaskManager = mlTaskManager;
        this.client = client;
        this.sdkClient = sdkClient;
        this.mlModelManager = mlModelManager;
        this.nodeHelper = nodeHelper;
        this.settings = settings;
        this.clusterService = clusterService;
        this.mlModelAutoReDeployer = mlModelAutoReDeployer;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        this.modelAutoRedeploySuccessRatio = ((Float)MLCommonsSettings.ML_COMMONS_MODEL_AUTO_REDEPLOY_SUCCESS_RATIO.get(settings)).floatValue();
        this.enableAutoReDeployModel = (Boolean)MLCommonsSettings.ML_COMMONS_MODEL_AUTO_REDEPLOY_ENABLE.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_MODEL_AUTO_REDEPLOY_ENABLE, it -> {
            this.enableAutoReDeployModel = it;
        });
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLForwardResponse> listener) {
        MLForwardRequest mlForwardRequest = MLForwardRequest.fromActionRequest((ActionRequest)request);
        MLForwardInput forwardInput = mlForwardRequest.getForwardInput();
        String modelId = forwardInput.getModelId();
        String taskId = forwardInput.getTaskId();
        String tenantId = forwardInput.getTenantId();
        if (!TenantAwareHelper.validateTenantId((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, listener)) {
            return;
        }
        MLRegisterModelInput registerModelInput = forwardInput.getRegisterModelInput();
        MLTask mlTask = forwardInput.getMlTask();
        String workerNodeId = forwardInput.getWorkerNodeId();
        MLForwardRequestType requestType = forwardInput.getRequestType();
        String error = forwardInput.getError();
        log.debug("receive forward request: {}", (Object)forwardInput.getRequestType());
        try {
            switch (requestType) {
                case DEPLOY_MODEL_DONE: {
                    Set<String> workNodes = this.mlTaskManager.getWorkNodes(taskId);
                    MLTaskCache mlTaskCache = this.mlTaskManager.getMLTaskCache(taskId);
                    FunctionName functionName = mlTaskCache.getMlTask().getFunctionName();
                    if (workNodes != null) {
                        workNodes.remove(workerNodeId);
                    }
                    if (error != null) {
                        this.mlTaskManager.addNodeError(taskId, workerNodeId, error);
                    } else {
                        this.mlModelManager.addModelWorkerNode(modelId, workerNodeId);
                        this.syncModelWorkerNodes(modelId, functionName);
                    }
                    Set<Object> workNodesRemovedFromCluster = new HashSet();
                    if (workNodes != null && !workNodes.isEmpty()) {
                        HashSet<String> allNodesInCluster = new HashSet<String>(List.of(RestActionUtils.getAllNodes(this.clusterService)));
                        workNodesRemovedFromCluster = workNodes.stream().filter(node -> !allNodesInCluster.contains(node)).collect(Collectors.toSet());
                        if (!workNodesRemovedFromCluster.isEmpty()) {
                            workNodes.removeAll(workNodesRemovedFromCluster);
                        }
                    }
                    if (workNodes == null || workNodes.isEmpty()) {
                        MLModelState modelState;
                        MLTaskState taskState;
                        if (!workNodesRemovedFromCluster.isEmpty()) {
                            mlTaskCache.updateWorkerNode(workNodesRemovedFromCluster);
                            this.mlModelManager.removeModelWorkerNode(modelId, false, workNodesRemovedFromCluster.toArray(new String[0]));
                        }
                        int currentWorkerNodeCount = mlTaskCache.getWorkerNodeSize();
                        MLTaskState mLTaskState = taskState = mlTaskCache.hasError() ? MLTaskState.COMPLETED_WITH_ERROR : MLTaskState.COMPLETED;
                        if (mlTaskCache.allNodeFailed() || mlTaskCache.getWorkerNodeSize() == 0) {
                            taskState = MLTaskState.FAILED;
                            currentWorkerNodeCount = 0;
                        } else {
                            this.syncModelWorkerNodes(modelId, functionName);
                        }
                        HashMap<String, Object> builder = new HashMap<String, Object>();
                        builder.put("state", taskState);
                        if (mlTaskCache.hasError()) {
                            currentWorkerNodeCount = mlTaskCache.getWorkerNodeSize() - mlTaskCache.getErrors().size();
                            builder.put("error", MLExceptionUtils.toJsonString((Map)mlTaskCache.getErrors()));
                        }
                        boolean clearAutoReDeployRetryTimes = this.triggerNextModelDeployAndCheckIfRestRetryTimes(workNodes, taskId);
                        this.mlTaskManager.updateMLTask(taskId, tenantId, Map.copyOf(builder), MLTaskManager.TASK_SEMAPHORE_TIMEOUT, true);
                        if (mlTaskCache.allNodeFailed() || mlTaskCache.getWorkerNodeSize() == 0) {
                            modelState = MLModelState.DEPLOY_FAILED;
                            log.error("deploy model failed on all nodes, model id: {}", (Object)modelId);
                        } else {
                            modelState = mlTaskCache.hasError() ? MLModelState.PARTIALLY_DEPLOYED : MLModelState.DEPLOYED;
                        }
                        HashMap<String, Object> updateFields = new HashMap<String, Object>();
                        updateFields.put("model_state", modelState);
                        updateFields.put("last_deployed_time", Instant.now().toEpochMilli());
                        updateFields.put("current_worker_node_count", currentWorkerNodeCount);
                        if (clearAutoReDeployRetryTimes) {
                            log.debug("Model successfully deployed in cluster, setting the auto retry times to 0");
                            updateFields.put("auto_redeploy_retry_times", 0);
                        }
                        log.info("deploy model done with state: {}, model id: {}", (Object)modelState, (Object)modelId);
                        ActionListener updateModelListener = ActionListenerHelper.wrap(response -> {
                            if (response.status() == RestStatus.OK) {
                                log.debug("Updated ML model successfully: {}, model id: {}", (Object)response.status(), (Object)modelId);
                            } else {
                                log.error("Failed to update ML model {}, status: {}", (Object)modelId, (Object)response.status());
                            }
                        }, e -> log.error("Failed to update ML model: {}", (Object)modelId));
                        this.mlModelManager.updateModel(modelId, tenantId, updateFields, (ActionListener<UpdateResponse>)ActionListenerHelper.runBefore((ActionListener)updateModelListener, () -> this.mlModelManager.removeAutoDeployModel(modelId)));
                    }
                    listener.onResponse((Object)new MLForwardResponse("ok", null));
                    break;
                }
                case REGISTER_MODEL: {
                    this.mlModelManager.registerMLModel(registerModelInput, mlTask);
                    listener.onResponse((Object)new MLForwardResponse("ok", null));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported request type");
                }
            }
        }
        catch (Exception e2) {
            MLExceptionUtils.logException((String)("Failed to execute forward action " + String.valueOf(forwardInput.getRequestType())), (Exception)e2, (Logger)log);
            listener.onFailure(e2);
        }
    }

    private boolean triggerNextModelDeployAndCheckIfRestRetryTimes(Set<String> workNodes, String taskId) {
        MLTaskCache mlTaskCache;
        int expectedWorkerNodeCount;
        int receivedWorkerNodesCount;
        int successWorkerNodesCount;
        if (this.enableAutoReDeployModel && workNodes != null && this.mlTaskManager.getMLTaskCache(taskId) != null && (float)(successWorkerNodesCount = (receivedWorkerNodesCount = (expectedWorkerNodeCount = (mlTaskCache = this.mlTaskManager.getMLTaskCache(taskId)).getWorkerNodeSize().intValue()) - workNodes.size()) - mlTaskCache.errorNodesCount()) / (float)expectedWorkerNodeCount >= this.modelAutoRedeploySuccessRatio) {
            this.mlModelAutoReDeployer.redeployAModel();
            return true;
        }
        return false;
    }

    private void syncModelWorkerNodes(String modelId, FunctionName functionName) {
        DiscoveryNode[] allNodes = this.nodeHelper.getAllNodes();
        Object[] workerNodes = this.mlModelManager.getWorkerNodes(modelId, functionName);
        if (allNodes.length > 1 && workerNodes != null && workerNodes.length > 0) {
            log.debug("Sync to other nodes about worker nodes of model {}: {}", (Object)modelId, (Object)Arrays.toString(workerNodes));
            MLSyncUpInput syncUpInput = MLSyncUpInput.builder().addedWorkerNodes(Map.of(modelId, workerNodes)).build();
            MLSyncUpNodesRequest syncUpRequest = new MLSyncUpNodesRequest(allNodes, syncUpInput);
            this.client.execute((ActionType)MLSyncUpAction.INSTANCE, (ActionRequest)syncUpRequest, ActionListenerHelper.wrap(r -> log.debug("Sync up successfully"), e -> log.error("Failed to sync up", (Throwable)e)));
        }
    }
}

