/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.handler;

import io.lucenia.ml.common.model.ModelAccessControlHelper;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.search.SearchResponseSections;
import io.skylite.core.action.search.ShardSearchFailure;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.util.CollectionUtils;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.ExistsQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.indices.InvalidIndexNameException;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.SearchHits;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import io.skylite.core.search.internal.InternalSearchResponse;
import io.skylite.core.security.auth.User;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.ml.common.exception.MLException;
import io.skylite.ml.common.exception.MLResourceNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.util.Throwables;
import org.apache.lucene.search.TotalHits;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.TermsQueryBuilder;

public class MLSearchHandler {
    private static final Logger log = LogManager.getLogger(MLSearchHandler.class);
    private final Client client;
    private NamedXContentRegistry xContentRegistry;
    private ModelAccessControlHelper modelAccessControlHelper;
    private ClusterService clusterService;

    public MLSearchHandler(Client client, NamedXContentRegistry xContentRegistry, ModelAccessControlHelper modelAccessControlHelper, ClusterService clusterService) {
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
    }

    public void search(SearchRequest request, String tenantId, ActionListener<SearchResponse> actionListener) {
        User user = Client.getUserContext((Client)this.client);
        ActionListener<SearchResponse> listener = MLSearchHandler.wrapRestActionListener(actionListener, "Fail to search model version");
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListenerHelper.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
            List excludes = Optional.ofNullable(request.source()).map(SearchSourceBuilder::fetchSource).map(FetchSourceContext::excludes).map(x -> Arrays.stream(x).collect(Collectors.toList())).orElse(new ArrayList());
            excludes.add("connector.credential");
            FetchSourceContext rebuiltFetchSourceContext = new FetchSourceContext(Optional.ofNullable(request.source()).map(SearchSourceBuilder::fetchSource).map(FetchSourceContext::fetchSource).orElse(true).booleanValue(), (String[])Optional.ofNullable(request.source()).map(SearchSourceBuilder::fetchSource).map(FetchSourceContext::includes).orElse(null), excludes.toArray(new String[0]));
            BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
            if (request.source().query() != null) {
                queryBuilder.must(request.source().query());
            }
            BoolQueryBuilder shouldQuery = QueryBuilders.boolQuery();
            shouldQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"is_hidden", (boolean)false));
            if (tenantId != null) {
                shouldQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"tenant_id", (String)tenantId));
            }
            shouldQuery.should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"is_hidden")));
            shouldQuery.minimumShouldMatch(1);
            queryBuilder.filter((QueryBuilder)shouldQuery);
            request.source().query((QueryBuilder)queryBuilder);
            request.source().fetchSource(rebuiltFetchSourceContext);
            ActionListener doubleWrapperListener = ActionListenerHelper.wrap(arg_0 -> ((ActionListener)wrappedListener).onResponse(arg_0), e -> MLSearchHandler.wrapListenerToHandleSearchIndexNotFound(e, (ActionListener<SearchResponse>)wrappedListener));
            if (this.modelAccessControlHelper.skipModelAccessControl(user)) {
                this.client.search(request, doubleWrapperListener);
            } else if (!this.clusterService.state().metadata().hasIndex(".plugins-ml-model-group")) {
                this.client.search(request, doubleWrapperListener);
            } else {
                SearchSourceBuilder sourceBuilder = this.modelAccessControlHelper.createSearchSourceBuilder(user);
                SearchRequest modelGroupSearchRequest = new SearchRequest();
                sourceBuilder.fetchSource(new String[]{"model_group_id"}, null);
                sourceBuilder.size(10000);
                modelGroupSearchRequest.source(sourceBuilder);
                modelGroupSearchRequest.indices(new String[]{".plugins-ml-model-group"});
                ActionListener modelGroupSearchActionListener = ActionListenerHelper.wrap(r -> {
                    if (Optional.ofNullable(r).map(SearchResponse::getHits).map(SearchHits::getTotalHits).map(TotalHits::value).orElse(0L) > 0L) {
                        ArrayList<String> modelGroupIds = new ArrayList<String>();
                        Arrays.stream(r.getHits().getHits()).forEach(hit -> modelGroupIds.add(hit.getId()));
                        request.source().query(MLSearchHandler.rewriteQueryBuilder(request.source().query(), modelGroupIds));
                        this.client.search(request, doubleWrapperListener);
                    } else {
                        log.debug("No model group found");
                        request.source().query(MLSearchHandler.rewriteQueryBuilder(request.source().query(), null));
                        this.client.search(request, doubleWrapperListener);
                    }
                }, e -> {
                    log.error("Fail to search model groups!", (Throwable)e);
                    wrappedListener.onFailure(e);
                });
                this.client.search(modelGroupSearchRequest, modelGroupSearchActionListener);
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }

    static QueryBuilder rewriteQueryBuilder(QueryBuilder queryBuilder, List<String> modelGroupIds) {
        ExistsQueryBuilder existsQueryBuilder = new ExistsQueryBuilder("model_group_id");
        BoolQueryBuilder modelGroupIdMustNotExistBoolQuery = new BoolQueryBuilder();
        modelGroupIdMustNotExistBoolQuery.mustNot((QueryBuilder)existsQueryBuilder);
        BoolQueryBuilder accessControlledBoolQuery = new BoolQueryBuilder();
        if (!CollectionUtils.isEmpty(modelGroupIds)) {
            TermsQueryBuilder modelGroupIdTermsQuery = new TermsQueryBuilder("model_group_id", modelGroupIds);
            accessControlledBoolQuery.should((QueryBuilder)modelGroupIdTermsQuery);
        }
        accessControlledBoolQuery.should((QueryBuilder)modelGroupIdMustNotExistBoolQuery);
        if (queryBuilder == null) {
            return accessControlledBoolQuery;
        }
        if (queryBuilder instanceof BoolQueryBuilder) {
            ((BoolQueryBuilder)queryBuilder).must((QueryBuilder)accessControlledBoolQuery);
            return queryBuilder;
        }
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder.must(queryBuilder);
        boolQueryBuilder.must((QueryBuilder)modelGroupIdMustNotExistBoolQuery);
        return boolQueryBuilder;
    }

    public static <T> ActionListener<T> wrapRestActionListener(ActionListener<T> actionListener, String generalErrorMessage) {
        return ActionListenerHelper.wrap(r -> actionListener.onResponse(r), e -> {
            log.error("Wrap exception before sending back to user", (Throwable)e);
            Throwable cause = Throwables.getRootCause((Throwable)e);
            if (MLSearchHandler.isProperExceptionToReturn(e)) {
                actionListener.onFailure(e);
            } else if (MLSearchHandler.isProperExceptionToReturn(cause)) {
                actionListener.onFailure((Exception)cause);
            } else {
                RestStatus status = MLSearchHandler.isBadRequest(e) ? RestStatus.BAD_REQUEST : RestStatus.INTERNAL_SERVER_ERROR;
                String errorMessage = generalErrorMessage;
                if (MLSearchHandler.isBadRequest(e) || e instanceof MLException) {
                    errorMessage = e.getMessage();
                } else if (MLSearchHandler.isBadRequest(cause) || cause instanceof MLException) {
                    errorMessage = cause.getMessage();
                }
                actionListener.onFailure((Exception)new SkyliteStatusException(errorMessage, status, new Object[0]));
            }
        });
    }

    public static boolean isProperExceptionToReturn(Throwable e) {
        return e instanceof SkyliteStatusException || e instanceof IndexNotFoundException || e instanceof InvalidIndexNameException;
    }

    public static boolean isBadRequest(Throwable e) {
        return e instanceof IllegalArgumentException || e instanceof MLResourceNotFoundException;
    }

    public static void wrapListenerToHandleSearchIndexNotFound(Exception e, ActionListener<SearchResponse> listener) {
        if (SkyliteExceptionsHelper.unwrapCause((Throwable)e) instanceof IndexNotFoundException || SkyliteExceptionsHelper.unwrap((Throwable)e, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
            log.debug("Connectors index not created yet, therefore we will swallow the exception and return an empty search result");
            InternalSearchResponse internalSearchResponse = InternalSearchResponse.empty();
            SearchResponse emptySearchResponse = new SearchResponse((SearchResponseSections)internalSearchResponse, null, 0, 0, 0, 0L, null, ShardSearchFailure.EMPTY_ARRAY, SearchResponse.Clusters.EMPTY, null);
            listener.onResponse((Object)emptySearchResponse);
        } else {
            listener.onFailure(e);
        }
    }
}

