/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.mcpserver;

import io.lucenia.action.support.nodes.TransportNodesAction;
import io.lucenia.ml.common.action.mcpserver.McpStatelessServerHolder;
import io.lucenia.ml.common.transport.mcpserver.requests.remove.MLMcpToolsRemoveNodeRequest;
import io.lucenia.ml.common.transport.mcpserver.requests.remove.MLMcpToolsRemoveNodesRequest;
import io.lucenia.ml.common.transport.mcpserver.responses.remove.MLMcpToolsRemoveNodeResponse;
import io.lucenia.ml.common.transport.mcpserver.responses.remove.MLMcpToolsRemoveNodesResponse;
import io.skylite.SkyliteException;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class TransportMcpToolsRemoveOnNodesAction
extends TransportNodesAction<MLMcpToolsRemoveNodesRequest, MLMcpToolsRemoveNodesResponse, MLMcpToolsRemoveNodeRequest, MLMcpToolsRemoveNodeResponse> {
    private static final Logger log = LogManager.getLogger(TransportMcpToolsRemoveOnNodesAction.class);
    TransportService transportService;
    ClusterService clusterService;
    ThreadPool threadPool;
    Client client;
    NamedXContentRegistry xContentRegistry;
    McpStatelessServerHolder mcpStatelessServerHolder;

    @Inject
    public TransportMcpToolsRemoveOnNodesAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry, McpStatelessServerHolder mcpStatelessServerHolder) {
        super("cluster:admin/lucenia/ml/mcp_tools/remove_on_nodes", threadPool, clusterService, transportService, actionFilters, MLMcpToolsRemoveNodesRequest::new, MLMcpToolsRemoveNodeRequest::new, "management", MLMcpToolsRemoveNodeResponse.class);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.mcpStatelessServerHolder = mcpStatelessServerHolder;
    }

    protected MLMcpToolsRemoveNodesResponse newResponse(MLMcpToolsRemoveNodesRequest nodesRequest, List<MLMcpToolsRemoveNodeResponse> responses, List<FailedNodeException> failures) {
        return new MLMcpToolsRemoveNodesResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected MLMcpToolsRemoveNodeRequest newNodeRequest(MLMcpToolsRemoveNodesRequest request) {
        return new MLMcpToolsRemoveNodeRequest(request.getMcpTools());
    }

    protected MLMcpToolsRemoveNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new MLMcpToolsRemoveNodeResponse(in);
    }

    protected MLMcpToolsRemoveNodeResponse nodeOperation(MLMcpToolsRemoveNodeRequest request) {
        return this.removeMcpTools(request.getMcpTools());
    }

    private MLMcpToolsRemoveNodeResponse removeMcpTools(List<String> tools) {
        AtomicReference errors = new AtomicReference(new HashSet());
        Flux.fromStream(tools.stream()).flatMap(toolName -> {
            if (McpStatelessServerHolder.IN_MEMORY_MCP_TOOLS.containsKey(toolName)) {
                return this.mcpStatelessServerHolder.getMcpStatelessAsyncServerInstance().removeTool(toolName).onErrorResume(e -> {
                    String errorMsg = e.getMessage();
                    if (errorMsg != null && (errorMsg.contains("not found") || errorMsg.contains("does not exist") || errorMsg.contains("doesn't exist"))) {
                        McpStatelessServerHolder.IN_MEMORY_MCP_TOOLS.remove(toolName);
                        log.debug("Tool {} not found in MCP server on node {} but was in memory map - cleaned up map", toolName, (Object)this.clusterService.localNode().getId());
                        return Mono.empty();
                    }
                    log.error("Failed to remove mcp tool {} on node: {} with error: {}", toolName, (Object)this.clusterService.localNode().getId(), (Object)e.getMessage());
                    ((Set)errors.get()).add(toolName);
                    return Mono.empty();
                }).thenReturn((Object)"removed");
            }
            log.debug("Tool {} not found in memory on node {} (nothing to remove)", toolName, (Object)this.clusterService.localNode().getId());
            return Mono.just((Object)"not_found");
        }).doOnComplete(() -> log.debug("Completed removal attempt for {} tools on node: {}", (Object)tools.size(), (Object)this.clusterService.localNode().getId())).collectList().block();
        if (!((Set)errors.get()).isEmpty()) {
            String errMsg = String.format(Locale.ROOT, "Failed to remove tools: %s on node: %s", errors.get(), this.clusterService.localNode().getId());
            SkyliteException openSearchException = new SkyliteException(errMsg, new Object[0]);
            throw new FailedNodeException(this.clusterService.localNode().getId(), openSearchException.getMessage(), (Throwable)openSearchException);
        }
        return new MLMcpToolsRemoveNodeResponse(this.clusterService.localNode(), true);
    }
}

