/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.memory.conversation;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class CreateInteractionRequest
extends ActionRequest {
    private String conversationId;
    private String input;
    private String promptTemplate;
    private String response;
    private String origin;
    private Map<String, String> additionalInfo;
    private String parentIid;
    private Integer traceNumber;

    public CreateInteractionRequest(String conversationId, String input, String promptTemplate, String response, String origin, Map<String, String> additionalInfo) {
        this.conversationId = conversationId;
        this.input = input;
        this.promptTemplate = promptTemplate;
        this.response = response;
        this.origin = origin;
        this.additionalInfo = additionalInfo;
    }

    public CreateInteractionRequest(String conversationId, String input, String promptTemplate, String response, String origin, Map<String, String> additionalInfo, String parentIid, Integer traceNumber) {
        this.conversationId = conversationId;
        this.input = input;
        this.promptTemplate = promptTemplate;
        this.response = response;
        this.origin = origin;
        this.additionalInfo = additionalInfo;
        this.parentIid = parentIid;
        this.traceNumber = traceNumber;
    }

    public CreateInteractionRequest(StreamInput in) throws IOException {
        super(in);
        this.conversationId = in.readString();
        this.input = in.readString();
        this.promptTemplate = in.readString();
        this.response = in.readString();
        this.origin = in.readOptionalString();
        if (in.readBoolean()) {
            this.additionalInfo = in.readMap(s -> s.readString(), s -> s.readString());
        }
        this.parentIid = in.readOptionalString();
        this.traceNumber = in.readOptionalInt();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.conversationId);
        out.writeString(this.input);
        out.writeString(this.promptTemplate);
        out.writeString(this.response);
        out.writeOptionalString(this.origin);
        if (this.additionalInfo != null) {
            out.writeBoolean(true);
            out.writeMap(this.additionalInfo, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.parentIid);
        out.writeOptionalInt(this.traceNumber);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException exception = null;
        if (this.conversationId == null) {
            exception = ValidateActions.addValidationError((String)"Interaction MUST belong to a conversation ID", exception);
        }
        return exception;
    }

    public static CreateInteractionRequest fromRestRequest(RestRequest request) throws IOException {
        boolean allFieldsEmpty;
        String cid = request.param("memory_id");
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        String input = null;
        String prompt = null;
        String response = null;
        String origin = null;
        HashMap<String, String> addinf = new HashMap();
        String parintid = null;
        Integer tracenum = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block18: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "input": {
                    input = parser.text();
                    continue block18;
                }
                case "prompt_template": {
                    prompt = parser.text();
                    continue block18;
                }
                case "response": {
                    response = parser.text();
                    continue block18;
                }
                case "origin": {
                    origin = parser.text();
                    continue block18;
                }
                case "additional_info": {
                    addinf = parser.mapStrings();
                    continue block18;
                }
                case "parent_message_id": {
                    parintid = parser.text();
                    continue block18;
                }
                case "trace_number": {
                    tracenum = parser.intValue(false);
                    continue block18;
                }
            }
            parser.skipChildren();
        }
        boolean bl = allFieldsEmpty = !(input != null && !input.trim().isEmpty() || prompt != null && !prompt.trim().isEmpty() || response != null && !response.trim().isEmpty() || origin != null && !origin.trim().isEmpty() || addinf != null && !addinf.isEmpty());
        if (allFieldsEmpty) {
            throw new IllegalArgumentException("At least one of the following parameters must be non-empty: input, prompt_template, response, origin, additional_info");
        }
        return new CreateInteractionRequest(cid, input, prompt, response, origin, addinf, parintid, tracenum);
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public String getInput() {
        return this.input;
    }

    public String getPromptTemplate() {
        return this.promptTemplate;
    }

    public String getResponse() {
        return this.response;
    }

    public String getOrigin() {
        return this.origin;
    }

    public Map<String, String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public String getParentIid() {
        return this.parentIid;
    }

    public Integer getTraceNumber() {
        return this.traceNumber;
    }
}

