/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.memory.conversation;

import io.lucenia.ml.common.action.memory.conversation.CreateInteractionRequest;
import io.lucenia.ml.common.action.memory.conversation.CreateInteractionResponse;
import io.lucenia.ml.common.conversation.ConversationalSearchService;
import io.skylite.SkyliteException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.DocWriteResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.update.UpdateResponse;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.ml.common.conversation.ConversationalIndexConstants;
import io.skylite.ml.common.conversation.ConversationalMemoryHandler;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CreateInteractionTransportAction
extends HandledTransportAction<CreateInteractionRequest, CreateInteractionResponse> {
    private static final Logger log = LogManager.getLogger(CreateInteractionTransportAction.class);
    private final ConversationalMemoryHandler cmHandler;
    private final Client client;
    private volatile boolean featureIsEnabled;

    @Inject
    public CreateInteractionTransportAction(TransportService transportService, ActionFilters actionFilters, ConversationalSearchService cmHandler, Client client, ClusterService clusterService) {
        super("cluster:admin/lucenia/ml/memory/interaction/create", transportService, actionFilters, CreateInteractionRequest::new);
        this.client = client;
        this.cmHandler = cmHandler;
        this.featureIsEnabled = (Boolean)ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_ENABLED.get(clusterService.getSettings());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_ENABLED, it -> {
            this.featureIsEnabled = it;
        });
    }

    protected void doExecute(Task task, CreateInteractionRequest request, ActionListener<CreateInteractionResponse> actionListener) {
        if (!this.featureIsEnabled) {
            actionListener.onFailure((Exception)new SkyliteException(ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_DISABLED_MESSAGE, new Object[0]));
            return;
        }
        String cid = request.getConversationId();
        String inp = request.getInput();
        String rsp = request.getResponse();
        String ogn = request.getOrigin();
        String prompt = request.getPromptTemplate();
        Map<String, String> additionalInfo = request.getAdditionalInfo();
        String parintIid = request.getParentIid();
        Integer traceNumber = request.getTraceNumber();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().newStoredContext(true);){
            ActionListener internalListener = ActionListenerHelper.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore());
            ActionListener al = ActionListenerHelper.wrap(iid -> {
                this.cmHandler.updateConversation(cid, new HashMap(), this.getUpdateResponseListener(cid, (String)iid, (ActionListener<CreateInteractionResponse>)internalListener));
                log.info("Updating the memory {} after the message {} is created", (Object)cid, iid);
            }, arg_0 -> ((ActionListener)internalListener).onFailure(arg_0));
            if (parintIid == null || traceNumber == null) {
                this.cmHandler.createInteraction(cid, inp, prompt, rsp, ogn, additionalInfo, al);
            } else {
                this.cmHandler.createInteraction(cid, inp, prompt, rsp, ogn, additionalInfo, al, parintIid, traceNumber);
            }
        }
        catch (Exception e) {
            log.error("Failed to create message for memory {}", (Object)cid);
            actionListener.onFailure(e);
        }
    }

    private ActionListener<UpdateResponse> getUpdateResponseListener(String conversationId, String interactionId, ActionListener<CreateInteractionResponse> actionListener) {
        return ActionListenerHelper.wrap(updateResponse -> {
            if (updateResponse != null && updateResponse.getResult() == DocWriteResponse.Result.UPDATED) {
                log.debug("Successfully updated the memory with ID: {} after message {} is created", (Object)conversationId, (Object)interactionId);
                actionListener.onResponse((Object)new CreateInteractionResponse(interactionId));
            } else {
                log.error("Failed to update the memory with ID: {} after message {} is created", (Object)conversationId, (Object)interactionId);
                actionListener.onResponse((Object)new CreateInteractionResponse(interactionId));
            }
        }, exception -> {
            log.error("Failed to update memory with ID {} after message {} is created. Details: {}", (Object)conversationId, (Object)interactionId, exception);
            actionListener.onResponse((Object)new CreateInteractionResponse(interactionId));
        });
    }
}

