/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.memory.conversation;

import io.lucenia.ml.common.action.memory.conversation.DeleteConversationRequest;
import io.lucenia.ml.common.action.memory.conversation.DeleteConversationResponse;
import io.lucenia.ml.common.conversation.ConversationalSearchService;
import io.skylite.SkyliteException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.ml.common.conversation.ConversationalIndexConstants;
import io.skylite.ml.common.conversation.ConversationalMemoryHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeleteConversationTransportAction
extends HandledTransportAction<DeleteConversationRequest, DeleteConversationResponse> {
    private static final Logger log = LogManager.getLogger(DeleteConversationTransportAction.class);
    private Client client;
    private ConversationalMemoryHandler cmHandler;
    private volatile boolean featureIsEnabled;

    @Inject
    public DeleteConversationTransportAction(TransportService transportService, ActionFilters actionFilters, ConversationalSearchService cmHandler, Client client, ClusterService clusterService) {
        super("cluster:admin/lucenia/ml/memory/conversation/delete", transportService, actionFilters, DeleteConversationRequest::new);
        this.client = client;
        this.cmHandler = cmHandler;
        this.featureIsEnabled = (Boolean)ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_ENABLED.get(clusterService.getSettings());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_ENABLED, it -> {
            this.featureIsEnabled = it;
        });
    }

    public void doExecute(Task task, DeleteConversationRequest request, ActionListener<DeleteConversationResponse> listener) {
        if (!this.featureIsEnabled) {
            listener.onFailure((Exception)new SkyliteException(ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_DISABLED_MESSAGE, new Object[0]));
            return;
        }
        String conversationId = request.getId();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().newStoredContext(true);){
            ActionListener internalListener = ActionListenerHelper.runBefore(listener, () -> context.restore());
            ActionListener al = ActionListenerHelper.wrap(success -> {
                DeleteConversationResponse response = new DeleteConversationResponse((boolean)success);
                internalListener.onResponse((Object)response);
            }, e -> internalListener.onFailure(e));
            this.cmHandler.deleteConversation(conversationId, al);
        }
        catch (Exception e2) {
            log.error("Failed to delete memory " + conversationId, (Throwable)e2);
            listener.onFailure(e2);
        }
    }
}

