/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.memory.conversation;

import io.skylite.core.action.ActionResponse;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.ml.common.conversation.ConversationMeta;
import java.io.IOException;
import java.util.List;

public class GetConversationsResponse
extends ActionResponse
implements ToXContentObject {
    private List<ConversationMeta> conversations;
    private int nextToken;
    private boolean hasMoreTokens;

    public GetConversationsResponse(List<ConversationMeta> conversations, int nextToken, boolean hasMoreTokens) {
        this.conversations = conversations;
        this.nextToken = nextToken;
        this.hasMoreTokens = hasMoreTokens;
    }

    public GetConversationsResponse(StreamInput in) throws IOException {
        super(in);
        this.conversations = in.readList(ConversationMeta::fromStream);
        this.nextToken = in.readInt();
        this.hasMoreTokens = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.conversations);
        out.writeInt(this.nextToken);
        out.writeBoolean(this.hasMoreTokens);
    }

    public boolean hasMorePages() {
        return this.hasMoreTokens;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("memories");
        for (ConversationMeta conversation : this.conversations) {
            conversation.toXContent(builder, params);
        }
        builder.endArray();
        if (this.hasMoreTokens) {
            builder.field("next_token", this.nextToken);
        }
        builder.endObject();
        return builder;
    }

    public List<ConversationMeta> getConversations() {
        return this.conversations;
    }

    public int getNextToken() {
        return this.nextToken;
    }

    public boolean isHasMoreTokens() {
        return this.hasMoreTokens;
    }
}

