/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.memory.conversation;

import io.lucenia.ml.common.action.memory.conversation.GetConversationsRequest;
import io.lucenia.ml.common.action.memory.conversation.GetConversationsResponse;
import io.lucenia.ml.common.conversation.ConversationalSearchService;
import io.skylite.SkyliteException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.ml.common.conversation.ConversationMeta;
import io.skylite.ml.common.conversation.ConversationalIndexConstants;
import io.skylite.ml.common.conversation.ConversationalMemoryHandler;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GetConversationsTransportAction
extends HandledTransportAction<GetConversationsRequest, GetConversationsResponse> {
    private static final Logger log = LogManager.getLogger(GetConversationsTransportAction.class);
    private final Client client;
    private final ConversationalMemoryHandler cmHandler;
    private volatile boolean featureIsEnabled;

    @Inject
    public GetConversationsTransportAction(TransportService transportService, ActionFilters actionFilters, ConversationalSearchService cmHandler, Client client, ClusterService clusterService) {
        super("cluster:admin/lucenia/ml/memory/conversation/list", transportService, actionFilters, GetConversationsRequest::new);
        this.client = client;
        this.cmHandler = cmHandler;
        this.featureIsEnabled = (Boolean)ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_ENABLED.get(clusterService.getSettings());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_ENABLED, it -> {
            this.featureIsEnabled = it;
        });
    }

    public void doExecute(Task task, GetConversationsRequest request, ActionListener<GetConversationsResponse> actionListener) {
        if (!this.featureIsEnabled) {
            actionListener.onFailure((Exception)new SkyliteException(ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_DISABLED_MESSAGE, new Object[0]));
            return;
        }
        int maxResults = request.getMaxResults();
        int from = request.getFrom();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().newStoredContext(true);){
            ActionListener internalListener = ActionListenerHelper.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore());
            ActionListener al = ActionListenerHelper.wrap(conversations -> internalListener.onResponse((Object)new GetConversationsResponse((List<ConversationMeta>)conversations, from + maxResults, conversations.size() == maxResults)), e -> {
                log.error("Failed to get memories", (Throwable)e);
                internalListener.onFailure(e);
            });
            this.cmHandler.getConversations(from, maxResults, al);
        }
        catch (Exception e2) {
            log.error("Failed to get memories", (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }
}

