/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.memory.conversation;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.rest.RestRequest;
import java.io.IOException;

public class GetInteractionRequest
extends ActionRequest {
    private String interactionId;

    public GetInteractionRequest(String interactionId) {
        this.interactionId = interactionId;
    }

    public GetInteractionRequest(StreamInput in) throws IOException {
        super(in);
        this.interactionId = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.interactionId);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException exception = null;
        if (this.interactionId == null) {
            exception = ValidateActions.addValidationError((String)"Get Interaction Request must have an interaction id", exception);
        }
        return exception;
    }

    public static GetInteractionRequest fromRestRequest(RestRequest request) throws IOException {
        String interactionId = request.param("message_id");
        return new GetInteractionRequest(interactionId);
    }

    public String getInteractionId() {
        return this.interactionId;
    }
}

