/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.memory.conversation;

import io.lucenia.ml.common.action.memory.conversation.GetInteractionRequest;
import io.lucenia.ml.common.action.memory.conversation.GetInteractionResponse;
import io.lucenia.ml.common.conversation.ConversationalSearchService;
import io.skylite.SkyliteException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.ml.common.conversation.ConversationalIndexConstants;
import io.skylite.ml.common.conversation.Interaction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GetInteractionTransportAction
extends HandledTransportAction<GetInteractionRequest, GetInteractionResponse> {
    private static final Logger log = LogManager.getLogger(GetInteractionTransportAction.class);
    private final Client client;
    private final ConversationalSearchService cmHandler;
    private volatile boolean featureIsEnabled;

    @Inject
    public GetInteractionTransportAction(TransportService transportService, ActionFilters actionFilters, ConversationalSearchService cmHandler, Client client, ClusterService clusterService) {
        super("cluster:admin/lucenia/ml/memory/interaction/get", transportService, actionFilters, GetInteractionRequest::new);
        this.client = client;
        this.cmHandler = cmHandler;
        this.featureIsEnabled = (Boolean)ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_ENABLED.get(clusterService.getSettings());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_ENABLED, it -> {
            this.featureIsEnabled = it;
        });
    }

    public void doExecute(Task task, GetInteractionRequest request, ActionListener<GetInteractionResponse> actionListener) {
        if (!this.featureIsEnabled) {
            actionListener.onFailure((Exception)new SkyliteException(ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_DISABLED_MESSAGE, new Object[0]));
            return;
        }
        String interactionId = request.getInteractionId();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().newStoredContext(true);){
            ActionListener internalListener = ActionListenerHelper.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore());
            ActionListener al = ActionListenerHelper.wrap(interaction -> internalListener.onResponse((Object)new GetInteractionResponse((Interaction)interaction)), arg_0 -> ((ActionListener)internalListener).onFailure(arg_0));
            this.cmHandler.getInteraction(interactionId, (ActionListener<Interaction>)al);
        }
        catch (Exception e) {
            log.error("Failed to get message {}", (Object)interactionId);
            actionListener.onFailure(e);
        }
    }
}

