/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.memory.conversation;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.rest.RestRequest;
import java.io.IOException;

public class GetInteractionsRequest
extends ActionRequest {
    private int maxResults = 10;
    private int from = 0;
    private String conversationId;

    public GetInteractionsRequest(String conversationId, int maxResults) {
        this.conversationId = conversationId;
        this.maxResults = maxResults;
    }

    public GetInteractionsRequest(String conversationId, int maxResults, int from) {
        this.conversationId = conversationId;
        this.maxResults = maxResults;
        this.from = from;
    }

    public GetInteractionsRequest(String conversationId) {
        this.conversationId = conversationId;
    }

    public GetInteractionsRequest(StreamInput in) throws IOException {
        super(in);
        this.conversationId = in.readString();
        this.maxResults = in.readInt();
        this.from = in.readInt();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.conversationId);
        out.writeInt(this.maxResults);
        out.writeInt(this.from);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException exception = null;
        if (this.conversationId == null) {
            exception = ValidateActions.addValidationError((String)"Interactions must be retrieved from a conversation", exception);
        }
        if (this.maxResults <= 0) {
            exception = ValidateActions.addValidationError((String)"The number of interactions to retrieve must be positive", (ActionRequestValidationException)exception);
        }
        if (this.from < 0) {
            exception = ValidateActions.addValidationError((String)"The starting position must be nonnegative", (ActionRequestValidationException)exception);
        }
        return exception;
    }

    public static GetInteractionsRequest fromRestRequest(RestRequest request) throws IOException {
        String cid = request.param("memory_id");
        if (request.hasParam("next_token")) {
            int from = Integer.parseInt(request.param("next_token"));
            if (request.hasParam("max_results")) {
                int maxResults = Integer.parseInt(request.param("max_results"));
                return new GetInteractionsRequest(cid, maxResults, from);
            }
            return new GetInteractionsRequest(cid, 10, from);
        }
        if (request.hasParam("max_results")) {
            int maxResults = Integer.parseInt(request.param("max_results"));
            return new GetInteractionsRequest(cid, maxResults);
        }
        return new GetInteractionsRequest(cid);
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public int getFrom() {
        return this.from;
    }

    public String getConversationId() {
        return this.conversationId;
    }
}

