/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.memory.conversation;

import io.skylite.core.action.ActionResponse;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.ml.common.conversation.Interaction;
import java.io.IOException;
import java.util.List;

public class GetInteractionsResponse
extends ActionResponse
implements ToXContentObject {
    private List<Interaction> interactions;
    private int nextToken;
    private boolean hasMoreTokens;

    public GetInteractionsResponse(List<Interaction> interactions, int nextToken, boolean hasMoreTokens) {
        this.interactions = interactions;
        this.nextToken = nextToken;
        this.hasMoreTokens = hasMoreTokens;
    }

    public GetInteractionsResponse(StreamInput in) throws IOException {
        super(in);
        this.interactions = in.readList(Interaction::fromStream);
        this.nextToken = in.readInt();
        this.hasMoreTokens = in.readBoolean();
    }

    public GetInteractionsResponse(StreamInput in, List<Interaction> interactions, int nextToken, boolean hasMoreTokens) throws IOException {
        super(in);
        this.interactions = interactions;
        this.nextToken = nextToken;
        this.hasMoreTokens = hasMoreTokens;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.interactions);
        out.writeInt(this.nextToken);
        out.writeBoolean(this.hasMoreTokens);
    }

    public boolean hasMorePages() {
        return this.hasMoreTokens;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("messages");
        for (Interaction inter : this.interactions) {
            inter.toXContent(builder, params);
        }
        builder.endArray();
        if (this.hasMoreTokens) {
            builder.field("next_token", this.nextToken);
        }
        builder.endObject();
        return builder;
    }

    public List<Interaction> getInteractions() {
        return this.interactions;
    }

    public int getNextToken() {
        return this.nextToken;
    }

    public boolean isHasMoreTokens() {
        return this.hasMoreTokens;
    }
}

