/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.memory.conversation;

import io.lucenia.ml.common.action.memory.conversation.GetTracesRequest;
import io.lucenia.ml.common.action.memory.conversation.GetTracesResponse;
import io.lucenia.ml.common.conversation.ConversationalSearchService;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.ml.common.conversation.Interaction;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GetTracesTransportAction
extends HandledTransportAction<GetTracesRequest, GetTracesResponse> {
    private static final Logger log = LogManager.getLogger(GetTracesTransportAction.class);
    private Client client;
    private ConversationalSearchService cmHandler;

    @Inject
    public GetTracesTransportAction(TransportService transportService, ActionFilters actionFilters, ConversationalSearchService cmHandler, Client client) {
        super("cluster:admin/lucenia/ml/memory/trace/get", transportService, actionFilters, GetTracesRequest::new);
        this.client = client;
        this.cmHandler = cmHandler;
    }

    public void doExecute(Task task, GetTracesRequest request, ActionListener<GetTracesResponse> actionListener) {
        int maxResults = request.getMaxResults();
        int from = request.getFrom();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().newStoredContext(true);){
            ActionListener internalListener = ActionListenerHelper.runBefore(actionListener, () -> context.restore());
            ActionListener al = ActionListenerHelper.wrap(tracesList -> internalListener.onResponse((Object)new GetTracesResponse((List<Interaction>)tracesList, from + maxResults, tracesList.size() == maxResults)), e -> internalListener.onFailure(e));
            this.cmHandler.getTraces(request.getInteractionId(), from, maxResults, (ActionListener<List<Interaction>>)al);
        }
        catch (Exception e2) {
            log.error("Failed to get traces for message " + request.getInteractionId(), (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }
}

