/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.memory.conversation;

import io.skylite.SkyliteParseException;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class UpdateInteractionRequest
extends ActionRequest {
    private String interactionId;
    private Map<String, Object> updateContent;
    private static final Set<String> allowedList = new HashSet<String>(Arrays.asList("additional_info", "response"));

    public UpdateInteractionRequest(String interactionId, Map<String, Object> updateContent) {
        this.interactionId = interactionId;
        this.updateContent = this.filterUpdateContent(updateContent);
    }

    public UpdateInteractionRequest(StreamInput in) throws IOException {
        super(in);
        this.interactionId = in.readString();
        this.updateContent = this.filterUpdateContent(in.readMap());
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.interactionId);
        out.writeMap(this.getUpdateContent());
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException exception = null;
        if (this.interactionId == null) {
            exception = ValidateActions.addValidationError((String)"interaction id can't be null", exception);
        }
        if (this.updateContent == null) {
            exception = ValidateActions.addValidationError((String)"Update Interaction content can't be null", (ActionRequestValidationException)exception);
        }
        return exception;
    }

    public static UpdateInteractionRequest parse(XContentParser parser, String interactionId) throws IOException {
        Map dataAsMap = null;
        dataAsMap = parser.map();
        if (dataAsMap == null) {
            throw new SkyliteParseException("Failed to parse UpdateInteractionRequest due to Null update content", new Object[0]);
        }
        return UpdateInteractionRequest.builder().interactionId(interactionId).updateContent(dataAsMap).build();
    }

    /*
     * Exception decompiling
     */
    public static UpdateInteractionRequest fromActionRequest(ActionRequest actionRequest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<String, Object> filterUpdateContent(Map<String, Object> updateContent) {
        if (updateContent == null) {
            return new HashMap<String, Object>();
        }
        return updateContent.entrySet().stream().filter(map -> allowedList.contains(map.getKey())).collect(Collectors.toMap(map -> (String)map.getKey(), map -> map.getValue()));
    }

    public String getInteractionId() {
        return this.interactionId;
    }

    public Map<String, Object> getUpdateContent() {
        return this.updateContent;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String interactionId;
        private Map<String, Object> updateContent;

        public Builder interactionId(String interactionId) {
            this.interactionId = interactionId;
            return this;
        }

        public Builder updateContent(Map<String, Object> updateContent) {
            this.updateContent = updateContent;
            return this;
        }

        public UpdateInteractionRequest build() {
            return new UpdateInteractionRequest(this.interactionId, this.updateContent);
        }
    }
}

