/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.model_group;

import io.lucenia.ml.common.model.ModelAccessControlHelper;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.delete.DeleteRequest;
import io.skylite.core.action.delete.DeleteResponse;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.client.metadata.DeleteDataObjectRequest;
import io.skylite.core.client.metadata.DeleteDataObjectResponse;
import io.skylite.core.client.metadata.MetadataClient;
import io.skylite.core.client.metadata.SearchDataObjectRequest;
import io.skylite.core.client.metadata.SearchDataObjectResponse;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.TermQueryBuilder;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.security.auth.User;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.exception.MLValidationException;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.model_group.MLModelGroupDeleteRequest;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeleteModelGroupTransportAction
extends HandledTransportAction<ActionRequest, DeleteResponse> {
    private static final Logger log = LogManager.getLogger(DeleteModelGroupTransportAction.class);
    private final Client client;
    private final MetadataClient sdkClient;
    private final NamedXContentRegistry xContentRegistry;
    private final ClusterService clusterService;
    private final ModelAccessControlHelper modelAccessControlHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public DeleteModelGroupTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, MetadataClient sdkClient, NamedXContentRegistry xContentRegistry, ClusterService clusterService, ModelAccessControlHelper modelAccessControlHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/lucenia/ml/model_groups/delete", transportService, actionFilters, MLModelGroupDeleteRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<DeleteResponse> actionListener) {
        MLModelGroupDeleteRequest deleteRequest = MLModelGroupDeleteRequest.fromActionRequest((ActionRequest)request);
        String modelGroupId = deleteRequest.getModelGroupId();
        String tenantId = deleteRequest.getTenantId();
        if (!TenantAwareHelper.validateTenantId((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, actionListener)) {
            return;
        }
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListenerHelper.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore());
            this.validateAndDeleteModelGroup(modelGroupId, tenantId, (ActionListener<DeleteResponse>)wrappedListener);
        }
    }

    private void validateAndDeleteModelGroup(String modelGroupId, String tenantId, ActionListener<DeleteResponse> listener) {
        User user = RestActionUtils.getUserContext(this.client);
        this.modelAccessControlHelper.validateModelGroupAccess(user, this.mlFeatureEnabledSetting, tenantId, modelGroupId, this.client, this.sdkClient, (ActionListener<Boolean>)ActionListenerHelper.wrap(hasAccess -> this.handleAccessValidation((boolean)hasAccess, modelGroupId, tenantId, listener), error -> this.handleValidationError((Exception)error, modelGroupId, listener)));
    }

    private void handleAccessValidation(boolean hasAccess, String modelGroupId, String tenantId, ActionListener<DeleteResponse> listener) {
        if (!hasAccess) {
            listener.onFailure((Exception)new MLValidationException("User doesn't have privilege to delete this model group"));
            return;
        }
        this.checkForAssociatedModels(modelGroupId, tenantId, listener);
    }

    private void checkForAssociatedModels(String modelGroupId, String tenantId, ActionListener<DeleteResponse> listener) {
        SearchDataObjectRequest searchRequest = this.buildModelSearchRequest(modelGroupId, tenantId);
        this.sdkClient.searchDataObjectAsync(searchRequest).whenComplete((searchResponse, throwable) -> this.handleModelSearchResponse((SearchDataObjectResponse)searchResponse, (Throwable)throwable, modelGroupId, tenantId, listener));
    }

    private SearchDataObjectRequest buildModelSearchRequest(String modelGroupId, String tenantId) {
        BoolQueryBuilder query = new BoolQueryBuilder().filter((QueryBuilder)new TermQueryBuilder("model_group_id", modelGroupId));
        SearchSourceBuilder searchSource = new SearchSourceBuilder().query((QueryBuilder)query);
        return SearchDataObjectRequest.builder().indices(new String[]{".plugins-ml-model"}).tenantId(tenantId).searchSourceBuilder(searchSource).build();
    }

    private void handleModelSearchResponse(SearchDataObjectResponse searchResponse, Throwable throwable, String modelGroupId, String tenantId, ActionListener<DeleteResponse> listener) {
        if (searchResponse == null) {
            Exception cause = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
            this.handleModelSearchFailure(modelGroupId, tenantId, cause, listener);
            return;
        }
        try {
            SearchResponse response = SearchResponse.fromXContent((XContentParser)searchResponse.parser());
            if (response.getHits().getHits().length == 0) {
                DeleteRequest deleteRequest = new DeleteRequest(".plugins-ml-model-group", modelGroupId);
                this.deleteModelGroup(deleteRequest, tenantId, listener);
            } else {
                listener.onFailure((Exception)new SkyliteStatusException("Cannot delete the model group when it has associated model versions", RestStatus.CONFLICT, new Object[0]));
            }
        }
        catch (Exception e) {
            log.error("Failed to parse search response", (Throwable)e);
            listener.onFailure((Exception)new SkyliteStatusException("Failed to parse search response", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
        }
    }

    private void deleteModelGroup(DeleteRequest deleteRequest, String tenantId, ActionListener<DeleteResponse> listener) {
        try {
            DeleteDataObjectRequest request = ((DeleteDataObjectRequest.Builder)((DeleteDataObjectRequest.Builder)((DeleteDataObjectRequest.Builder)DeleteDataObjectRequest.builder().index(deleteRequest.index())).id(deleteRequest.id())).tenantId(tenantId)).build();
            this.sdkClient.deleteDataObjectAsync(request).whenComplete((response, throwable) -> this.handleDeleteResponse((DeleteDataObjectResponse)response, (Throwable)throwable, deleteRequest.id(), listener));
        }
        catch (Exception e) {
            log.error("Failed to delete Model group : {}", (Object)deleteRequest.id());
            listener.onFailure(e);
        }
    }

    private void handleValidationError(Exception error, String modelGroupId, ActionListener<DeleteResponse> listener) {
        log.error("Failed to validate Access for Model Group {}", (Object)modelGroupId);
        listener.onFailure(error);
    }

    private void handleDeleteResponse(DeleteDataObjectResponse response, Throwable throwable, String modelGroupId, ActionListener<DeleteResponse> actionListener) {
        if (throwable != null) {
            Exception cause = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
            log.error("Failed to delete ML Model Group {}", (Object)modelGroupId);
            actionListener.onFailure(cause);
        } else {
            try {
                DeleteResponse deleteResponse = DeleteResponse.fromXContent((XContentParser)response.parser());
                log.debug("Completed Delete Model Group Request, model group id:{} deleted", (Object)response.id());
                actionListener.onResponse((Object)deleteResponse);
            }
            catch (IOException e) {
                actionListener.onFailure((Exception)e);
            }
        }
    }

    private void handleModelSearchFailure(String modelGroupId, String tenantId, Exception cause, ActionListener<DeleteResponse> actionListener) {
        if (SkyliteExceptionsHelper.unwrap((Throwable)cause, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
            DeleteRequest deleteRequest = new DeleteRequest(".plugins-ml-model-group", modelGroupId);
            this.deleteModelGroup(deleteRequest, tenantId, actionListener);
            return;
        }
        log.error("Failed to search for models using model group id: {}", (Object)modelGroupId);
        actionListener.onFailure(cause);
    }
}

