/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.model_group;

import io.lucenia.ml.common.model.ModelAccessControlHelper;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.client.metadata.GetDataObjectRequest;
import io.skylite.core.client.metadata.GetDataObjectResponse;
import io.skylite.core.client.metadata.MetadataClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.Strings;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import io.skylite.core.security.auth.User;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.model.MLModelGroup;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.model_group.MLModelGroupGetRequest;
import io.skylite.ml.common.transport.model_group.MLModelGroupGetResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GetModelGroupTransportAction
extends HandledTransportAction<ActionRequest, MLModelGroupGetResponse> {
    private static final Logger log = LogManager.getLogger(GetModelGroupTransportAction.class);
    private final Client client;
    private final MetadataClient sdkClient;
    private final NamedXContentRegistry xContentRegistry;
    private final ClusterService clusterService;
    private final ModelAccessControlHelper modelAccessControlHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public GetModelGroupTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, MetadataClient sdkClient, NamedXContentRegistry xContentRegistry, ClusterService clusterService, ModelAccessControlHelper modelAccessControlHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/lucenia/ml/model_groups/get", transportService, actionFilters, MLModelGroupGetRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLModelGroupGetResponse> actionListener) {
        MLModelGroupGetRequest mlModelGroupGetRequest = MLModelGroupGetRequest.fromActionRequest((ActionRequest)request);
        String modelGroupId = mlModelGroupGetRequest.getModelGroupId();
        String tenantId = mlModelGroupGetRequest.getTenantId();
        if (!TenantAwareHelper.validateTenantId((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, actionListener)) {
            return;
        }
        FetchSourceContext fetchSourceContext = new FetchSourceContext(true, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY);
        GetDataObjectRequest getDataObjectRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-model-group")).id(modelGroupId)).tenantId(tenantId)).fetchSourceContext(fetchSourceContext).build();
        User user = RestActionUtils.getUserContext(this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListenerHelper.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore());
            this.sdkClient.getDataObjectAsync(getDataObjectRequest).whenComplete((r, throwable) -> this.handleResponse((GetDataObjectResponse)r, (Throwable)throwable, modelGroupId, tenantId, user, (ActionListener<MLModelGroupGetResponse>)wrappedListener));
        }
        catch (Exception e) {
            log.error("Failed to get ML model group {}", (Object)modelGroupId);
            actionListener.onFailure(e);
        }
    }

    private void handleResponse(GetDataObjectResponse getDataObjectResponse, Throwable throwable, String modelGroupId, String tenantId, User user, ActionListener<MLModelGroupGetResponse> wrappedListener) {
        log.debug("Completed Get Model group Request, id:{}", (Object)modelGroupId);
        if (throwable != null) {
            this.handleThrowable(throwable, modelGroupId, wrappedListener);
        } else {
            this.processResponse(getDataObjectResponse, modelGroupId, tenantId, user, wrappedListener);
        }
    }

    private void handleThrowable(Throwable throwable, String modelGroupId, ActionListener<MLModelGroupGetResponse> wrappedListener) {
        Exception cause = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
        if (SkyliteExceptionsHelper.unwrap((Throwable)cause, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
            log.error("Failed to find model group index", (Throwable)cause);
            wrappedListener.onFailure((Exception)new SkyliteStatusException("Failed to find model group index", RestStatus.NOT_FOUND, new Object[0]));
        } else {
            log.error("Failed to get ML group {}", (Object)modelGroupId);
            wrappedListener.onFailure(cause);
        }
    }

    private void processResponse(GetDataObjectResponse getDataObjectResponse, String modelGroupId, String tenantId, User user, ActionListener<MLModelGroupGetResponse> wrappedListener) {
        block12: {
            try {
                GetResponse gr;
                GetResponse getResponse = gr = getDataObjectResponse.parser() == null ? null : GetResponse.fromXContent((XContentParser)getDataObjectResponse.parser());
                if (gr != null && gr.isExists()) {
                    try (XContentParser parser = MediaTypeRegistry.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, gr.getSourceAsString());){
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                        MLModelGroup mlModelGroup = MLModelGroup.parse((XContentParser)parser);
                        if (TenantAwareHelper.validateTenantResource((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, (String)mlModelGroup.getTenantId(), wrappedListener)) {
                            this.validateModelGroupAccess(user, modelGroupId, mlModelGroup, wrappedListener);
                        }
                        break block12;
                    }
                    catch (Exception e) {
                        log.error("Failed to parse ml connector {}", (Object)getDataObjectResponse.id());
                        wrappedListener.onFailure(e);
                    }
                    break block12;
                }
                wrappedListener.onFailure((Exception)new SkyliteStatusException("Failed to find model group with the provided model group id: " + modelGroupId, RestStatus.NOT_FOUND, new Object[0]));
            }
            catch (Exception e) {
                wrappedListener.onFailure(e);
            }
        }
    }

    private void validateModelGroupAccess(User user, String modelGroupId, MLModelGroup mlModelGroup, ActionListener<MLModelGroupGetResponse> wrappedListener) {
        this.modelAccessControlHelper.validateModelGroupAccess(user, modelGroupId, this.client, (ActionListener<Boolean>)ActionListenerHelper.wrap(access -> {
            if (!access.booleanValue()) {
                wrappedListener.onFailure((Exception)new SkyliteStatusException("User doesn't have privilege to perform this operation on this model group", RestStatus.FORBIDDEN, new Object[0]));
            } else {
                wrappedListener.onResponse((Object)MLModelGroupGetResponse.builder().mlModelGroup(mlModelGroup).build());
            }
        }, e -> {
            log.error("Failed to validate access for Model Group {}", (Object)modelGroupId);
            wrappedListener.onFailure(e);
        }));
    }
}

