/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.model_group;

import io.lucenia.ml.common.action.handler.MLSearchHandler;
import io.lucenia.ml.common.model.ModelAccessControlHelper;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.lucenia.ml.common.transport.search.MLSearchActionRequest;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.client.metadata.MetadataClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.security.auth.User;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.QueryBuilders;

public class SearchModelGroupTransportAction
extends HandledTransportAction<MLSearchActionRequest, SearchResponse> {
    private static final Logger log = LogManager.getLogger(SearchModelGroupTransportAction.class);
    private Client client;
    private MetadataClient sdkClient;
    private ClusterService clusterService;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;
    private ModelAccessControlHelper modelAccessControlHelper;

    @Inject
    public SearchModelGroupTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, MetadataClient sdkClient, ClusterService clusterService, ModelAccessControlHelper modelAccessControlHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/lucenia/ml/model_groups/search", transportService, actionFilters, MLSearchActionRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.clusterService = clusterService;
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, MLSearchActionRequest request, ActionListener<SearchResponse> actionListener) {
        User user = RestActionUtils.getUserContext(this.client);
        ActionListener<SearchResponse> listener = MLSearchHandler.wrapRestActionListener(actionListener, "Fail to search");
        String tenantId = request.getTenantId();
        if (!TenantAwareHelper.validateTenantId((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, actionListener)) {
            return;
        }
        this.preProcessRoleAndPerformSearch(request, tenantId, user, listener);
    }

    private void preProcessRoleAndPerformSearch(SearchRequest request, String tenantId, User user, ActionListener<SearchResponse> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListenerHelper.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
            ActionListener doubleWrappedListener = ActionListenerHelper.wrap(arg_0 -> ((ActionListener)wrappedListener).onResponse(arg_0), e -> MLSearchHandler.wrapListenerToHandleSearchIndexNotFound(e, (ActionListener<SearchResponse>)wrappedListener));
            if (tenantId != null) {
                BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
                if (request.source().query() != null) {
                    queryBuilder.must(request.source().query());
                }
                queryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"tenant_id", (String)tenantId));
                request.source().query((QueryBuilder)queryBuilder);
            }
            if (this.modelAccessControlHelper.skipModelAccessControl(user)) {
                this.client.search(request, doubleWrappedListener);
            } else {
                this.modelAccessControlHelper.addUserBackendRolesFilter(user, request.source());
                log.debug("Filtering result by {}", (Object)user.getBackendRoles());
                this.client.search(request, doubleWrappedListener);
            }
        }
        catch (Exception e2) {
            log.error("Failed to search", (Throwable)e2);
            listener.onFailure(e2);
        }
    }
}

