/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.models;

import io.lucenia.ml.common.model.AgentModelsSearcher;
import io.lucenia.ml.common.model.ModelAccessControlHelper;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.ResourceNotFoundException;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.common.collect.Tuple;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.action.delete.DeleteRequest;
import io.skylite.core.action.delete.DeleteResponse;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.ingest.GetPipelineAction;
import io.skylite.core.action.ingest.GetPipelineRequest;
import io.skylite.core.action.search.GetSearchPipelineAction;
import io.skylite.core.action.search.GetSearchPipelineRequest;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.client.metadata.DeleteDataObjectRequest;
import io.skylite.core.client.metadata.GetDataObjectRequest;
import io.skylite.core.client.metadata.MetadataClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.Strings;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.TermQueryBuilder;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.SearchHit;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContent;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.model.MLModel;
import io.skylite.ml.common.model.MLModelState;
import io.skylite.ml.common.settings.MLCommonsSettings;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.model.MLModelDeleteRequest;
import io.skylite.ml.common.transport.model.MLModelGetRequest;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.DeleteByQueryAction;
import org.opensearch.index.reindex.DeleteByQueryRequest;

public class DeleteModelTransportAction
extends HandledTransportAction<ActionRequest, DeleteResponse> {
    private static final Logger log = LogManager.getLogger(DeleteModelTransportAction.class);
    static final String TIMEOUT_MSG = "Timeout while deleting model of ";
    static final String BULK_FAILURE_MSG = "Bulk failure while deleting model of ";
    static final String SEARCH_FAILURE_MSG = "Search failure while deleting model of ";
    static final String OS_STATUS_EXCEPTION_MESSAGE = "Failed to delete all model chunks";
    static final String PIPELINE_TARGET_MODEL_KEY = "model_id";
    Boolean isSafeDelete;
    private final Client client;
    private final MetadataClient sdkClient;
    private final NamedXContentRegistry xContentRegistry;
    private final ClusterService clusterService;
    private Settings settings;
    private final ModelAccessControlHelper modelAccessControlHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;
    private final AgentModelsSearcher agentModelsSearcher;

    @Inject
    public DeleteModelTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, MetadataClient sdkClient, Settings settings, NamedXContentRegistry xContentRegistry, ClusterService clusterService, ModelAccessControlHelper modelAccessControlHelper, AgentModelsSearcher agentModelsSearcher, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/lucenia/ml/models/delete", transportService, actionFilters, MLModelDeleteRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.agentModelsSearcher = agentModelsSearcher;
        this.settings = settings;
        this.isSafeDelete = (Boolean)MLCommonsSettings.ML_COMMONS_SAFE_DELETE_WITH_USAGE_CHECK.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_SAFE_DELETE_WITH_USAGE_CHECK, it -> {
            this.isSafeDelete = it;
        });
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<DeleteResponse> actionListener) {
        MLModelDeleteRequest mlModelDeleteRequest = MLModelDeleteRequest.fromActionRequest((ActionRequest)request);
        String modelId = mlModelDeleteRequest.getModelId();
        String tenantId = mlModelDeleteRequest.getTenantId();
        if (!TenantAwareHelper.validateTenantId((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, actionListener)) {
            return;
        }
        MLModelGetRequest mlModelGetRequest = new MLModelGetRequest(modelId, false, false, tenantId);
        FetchSourceContext fetchSourceContext = RestActionUtils.getFetchSourceContext(mlModelGetRequest.isReturnContent());
        GetDataObjectRequest getDataObjectRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-model")).id(modelId)).tenantId(tenantId)).fetchSourceContext(fetchSourceContext).build();
        User user = RestActionUtils.getUserContext(this.client);
        boolean isSuperAdmin = this.isSuperAdminUserWrapper(this.clusterService, this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListenerHelper.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore());
            this.sdkClient.getDataObjectAsync(getDataObjectRequest).whenComplete((r, throwable) -> {
                block25: {
                    if (throwable == null) {
                        try {
                            GetResponse gr;
                            GetResponse getResponse = gr = r.parser() == null ? null : GetResponse.fromXContent((XContentParser)r.parser());
                            if (gr != null && gr.isExists()) {
                                try (XContentParser parser = MediaTypeRegistry.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, gr.getSourceAsString());){
                                    MLModel mlModel;
                                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                                    String algorithmName = "";
                                    Map source = r.source();
                                    if (source != null) {
                                        if (source.get("function_name") != null) {
                                            algorithmName = source.get("function_name").toString();
                                        } else if (source.get("algorithm") != null) {
                                            algorithmName = source.get("algorithm").toString();
                                        }
                                    }
                                    if (!TenantAwareHelper.validateTenantResource((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, (String)(mlModel = MLModel.parse((XContentParser)parser, (String)algorithmName)).getTenantId(), (ActionListener)actionListener)) {
                                        return;
                                    }
                                    Boolean isHidden = (Boolean)r.source().get("is_hidden");
                                    MLModelState mlModelState = mlModel.getModelState();
                                    if (isHidden != null && isHidden.booleanValue()) {
                                        if (!isSuperAdmin) {
                                            wrappedListener.onFailure((Exception)new SkyliteStatusException("User doesn't have privilege to perform this operation on this model", RestStatus.FORBIDDEN, new Object[0]));
                                        } else if (this.isModelNotDeployed(mlModelState).booleanValue()) {
                                            this.deleteModel(modelId, tenantId, algorithmName, isHidden, actionListener);
                                        } else {
                                            wrappedListener.onFailure((Exception)new SkyliteStatusException("Model cannot be deleted in deploying or deployed state. Try undeploy model first then delete", RestStatus.BAD_REQUEST, new Object[0]));
                                        }
                                    } else {
                                        this.modelAccessControlHelper.validateModelGroupAccess(user, mlModel.getModelGroupId(), this.client, (ActionListener<Boolean>)ActionListenerHelper.wrap(access -> {
                                            if (!access.booleanValue()) {
                                                wrappedListener.onFailure((Exception)new SkyliteStatusException("User doesn't have privilege to perform this operation on this model", RestStatus.FORBIDDEN, new Object[0]));
                                            } else if (this.isModelNotDeployed(mlModelState).booleanValue()) {
                                                if (this.isSafeDelete.booleanValue()) {
                                                    this.checkDownstreamTaskBeforeDeleteModel(modelId, tenantId, mlModel.getAlgorithm().name(), isHidden, actionListener);
                                                } else {
                                                    this.deleteModel(modelId, tenantId, mlModel.getAlgorithm().name(), isHidden, actionListener);
                                                }
                                            } else {
                                                wrappedListener.onFailure((Exception)new SkyliteStatusException("Model cannot be deleted in deploying or deployed state. Try undeploy model first then delete", RestStatus.BAD_REQUEST, new Object[0]));
                                            }
                                        }, e -> {
                                            log.error(Strings.getErrorMessage((String)"Failed to validate Access", (String)modelId, (boolean)isHidden), (Throwable)e);
                                            wrappedListener.onFailure(e);
                                        }));
                                    }
                                    break block25;
                                }
                                catch (Exception e2) {
                                    log.error("Failed to parse ml model {}", (Object)r.id());
                                    wrappedListener.onFailure(e2);
                                }
                                break block25;
                            }
                            this.deleteModelChunksAndController((ActionListener<DeleteResponse>)wrappedListener, modelId, null, false, null);
                        }
                        catch (Exception e3) {
                            wrappedListener.onFailure(e3);
                        }
                    } else {
                        wrappedListener.onFailure((Exception)new SkyliteStatusException("Failed to find model", RestStatus.NOT_FOUND, new Object[0]));
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to delete ML model {}", (Object)modelId);
            actionListener.onFailure(e);
        }
    }

    void deleteModelChunks(String modelId, Boolean isHidden, ActionListener<Boolean> actionListener) {
        DeleteByQueryRequest deleteModelsRequest = new DeleteByQueryRequest(new String[]{".plugins-ml-model"});
        deleteModelsRequest.setQuery((QueryBuilder)new BoolQueryBuilder().must((QueryBuilder)new TermsQueryBuilder(PIPELINE_TARGET_MODEL_KEY, new String[]{modelId})).mustNot((QueryBuilder)new TermQueryBuilder("_id", modelId)));
        this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteModelsRequest, ActionListenerHelper.wrap(r -> {
            if ((r.getBulkFailures() == null || r.getBulkFailures().isEmpty()) && (r.getSearchFailures() == null || r.getSearchFailures().isEmpty())) {
                log.debug(Strings.getErrorMessage((String)"All model chunks are deleted for the provided model.", (String)modelId, (boolean)isHidden));
                actionListener.onResponse((Object)true);
            } else {
                this.returnFailure((BulkByScrollResponse)r, modelId, actionListener);
            }
        }, e -> {
            log.error(Strings.getErrorMessage((String)"Failed to delete model chunks for the provided model", (String)modelId, (boolean)isHidden), (Throwable)e);
            actionListener.onFailure(e);
        }));
    }

    private void returnFailure(BulkByScrollResponse response, String modelId, ActionListener<Boolean> actionListener) {
        String errorMessage = response.isTimedOut() ? "Failed to delete all model chunks, Timeout while deleting model of " + modelId : (!response.getBulkFailures().isEmpty() ? "Failed to delete all model chunks, Bulk failure while deleting model of " + modelId : "Failed to delete all model chunks, Search failure while deleting model of " + modelId);
        log.debug(response.toString());
        actionListener.onFailure((Exception)new SkyliteStatusException(errorMessage, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
    }

    private void deleteModel(String modelId, String tenantId, String functionName, Boolean isHidden, ActionListener<DeleteResponse> actionListener) {
        DeleteDataObjectRequest deleteDataObjectRequest = ((DeleteDataObjectRequest.Builder)((DeleteDataObjectRequest.Builder)((DeleteDataObjectRequest.Builder)DeleteDataObjectRequest.builder().index(".plugins-ml-model")).id(modelId)).tenantId(tenantId)).build();
        this.sdkClient.deleteDataObjectAsync(deleteDataObjectRequest).whenComplete((r, throwable) -> {
            if (throwable == null) {
                try {
                    DeleteResponse deleteResponse = DeleteResponse.fromXContent((XContentParser)r.parser());
                    this.deleteModelChunksAndController(actionListener, modelId, functionName, isHidden, deleteResponse);
                }
                catch (Exception e) {
                    actionListener.onFailure(e);
                }
            } else {
                Exception e = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                if (SkyliteExceptionsHelper.unwrap((Throwable)e, (Class[])new Class[]{ResourceNotFoundException.class}) != null) {
                    this.deleteModelChunksAndController(actionListener, modelId, functionName, isHidden, null);
                } else {
                    log.error(Strings.getErrorMessage((String)"Model is not all cleaned up, please try again.", (String)modelId, (boolean)isHidden), (Throwable)e);
                    actionListener.onFailure(e);
                }
            }
        });
    }

    private void checkDownstreamTaskBeforeDeleteModel(String modelId, String tenantId, String algorithm, Boolean isHidden, ActionListener<DeleteResponse> actionListener) {
        CountDownLatch countDownLatch = new CountDownLatch(3);
        AtomicBoolean noneBlocked = new AtomicBoolean(true);
        ConcurrentLinkedQueue errorMessages = new ConcurrentLinkedQueue();
        ActionListener countDownActionListener = ActionListenerHelper.wrap(b -> {
            countDownLatch.countDown();
            noneBlocked.compareAndSet(true, (boolean)b);
            if (countDownLatch.getCount() == 0L && noneBlocked.get()) {
                this.deleteModel(modelId, tenantId, algorithm, isHidden, actionListener);
            }
        }, e -> {
            countDownLatch.countDown();
            noneBlocked.set(false);
            errorMessages.add(e.getMessage());
            actionListener.onFailure((Exception)new SkyliteStatusException(e.getMessage(), RestStatus.CONFLICT, new Object[0]));
        });
        this.checkAgentBeforeDeleteModel(modelId, (ActionListener<Boolean>)countDownActionListener);
        this.checkIngestPipelineBeforeDeleteModel(modelId, (ActionListener<Boolean>)countDownActionListener);
        this.checkSearchPipelineBeforeDeleteModel(modelId, (ActionListener<Boolean>)countDownActionListener);
    }

    private void checkAgentBeforeDeleteModel(String modelId, ActionListener<Boolean> actionListener) {
        SearchRequest searchAgentRequest = this.agentModelsSearcher.constructQueryRequestToSearchModelIdInsideAgent(modelId);
        this.client.search(searchAgentRequest, ActionListenerHelper.wrap(searchResponse -> {
            SearchHit[] searchHits = searchResponse.getHits().getHits();
            if (searchHits.length == 0) {
                actionListener.onResponse((Object)true);
            } else {
                String errorMessage = this.formatAgentErrorMessage(searchHits);
                actionListener.onFailure((Exception)new SkyliteStatusException(errorMessage, RestStatus.CONFLICT, new Object[0]));
            }
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                actionListener.onResponse((Object)true);
                return;
            }
            log.error("Failed to delete ML Model: " + modelId, (Throwable)e);
            actionListener.onFailure(e);
        }));
    }

    private void checkIngestPipelineBeforeDeleteModel(String modelId, ActionListener<Boolean> actionListener) {
        this.checkPipelineBeforeDeleteModel(modelId, actionListener, "ingest", () -> new GetPipelineRequest(new String[0]), (ActionType)GetPipelineAction.INSTANCE);
    }

    private void checkSearchPipelineBeforeDeleteModel(String modelId, ActionListener<Boolean> actionListener) {
        this.checkPipelineBeforeDeleteModel(modelId, actionListener, "search", GetSearchPipelineRequest::new, (ActionType)GetSearchPipelineAction.INSTANCE);
    }

    private void checkPipelineBeforeDeleteModel(String modelId, ActionListener<Boolean> actionListener, String pipelineType, Supplier<ActionRequest> requestSupplier, ActionType actionType) {
        ActionRequest request = requestSupplier.get();
        this.client.execute(actionType, request, ActionListenerHelper.wrap(pipelineResponse -> {
            Map allConfigMap = XContentHelper.convertToMap((XContent)MediaTypeRegistry.JSON.xContent(), (String)pipelineResponse.toString(), (boolean)true);
            List<String> allDependentPipelineIds = this.findDependentPipelinesEasy(allConfigMap, modelId);
            if (allDependentPipelineIds.isEmpty()) {
                actionListener.onResponse((Object)true);
            } else {
                actionListener.onFailure((Exception)new SkyliteStatusException(String.format(Locale.ROOT, "%d %s pipelines are still using this model, please delete or update the pipelines first: %s", allDependentPipelineIds.size(), pipelineType, Arrays.toString(allDependentPipelineIds.toArray(new String[0]))), RestStatus.CONFLICT, new Object[0]));
            }
        }, e -> {
            log.error("Failed to delete ML Model: " + modelId, (Throwable)e);
            actionListener.onFailure(e);
        }));
    }

    private void deleteModelChunksAndController(ActionListener<DeleteResponse> actionListener, String modelId, String functionName, Boolean isHidden, DeleteResponse deleteResponse) {
        CountDownLatch countDownLatch = new CountDownLatch(2);
        AtomicBoolean bothDeleted = new AtomicBoolean(true);
        ActionListener countDownActionListener = ActionListenerHelper.wrap(b -> {
            countDownLatch.countDown();
            bothDeleted.compareAndSet(true, (boolean)b);
            if (countDownLatch.getCount() == 0L) {
                if (bothDeleted.get()) {
                    log.debug(Strings.getErrorMessage((String)"model chunks and model controller for the provided model deleted successfully", (String)modelId, (boolean)isHidden));
                    if (deleteResponse != null) {
                        actionListener.onResponse((Object)deleteResponse);
                    } else {
                        actionListener.onFailure((Exception)new SkyliteStatusException("Failed to find model", RestStatus.NOT_FOUND, new Object[0]));
                    }
                } else {
                    actionListener.onFailure((Exception)new IllegalStateException(Strings.getErrorMessage((String)"Model is not all cleaned up, please try again.", (String)modelId, (boolean)isHidden)));
                }
            }
        }, e -> {
            countDownLatch.countDown();
            bothDeleted.compareAndSet(true, false);
            if (countDownLatch.getCount() == 0L) {
                actionListener.onFailure((Exception)new IllegalStateException(Strings.getErrorMessage((String)"Model is not all cleaned up, please try again.", (String)modelId, (boolean)isHidden), (Throwable)e));
            }
        });
        if (!Objects.equals(functionName, FunctionName.REMOTE.name())) {
            this.deleteModelChunks(modelId, isHidden, (ActionListener<Boolean>)countDownActionListener);
        } else {
            countDownLatch.countDown();
        }
        this.deleteController(modelId, isHidden, (ActionListener<Boolean>)countDownActionListener);
    }

    private void deleteController(final String modelId, Boolean isHidden, final ActionListener<Boolean> actionListener) {
        DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(".plugins-ml-controller", modelId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        this.client.delete(deleteRequest, (ActionListener)new ActionListener<DeleteResponse>(this){

            public void onResponse(DeleteResponse deleteResponse) {
                log.info("Model controller for the provided model successfully deleted from index, result: {}. Model ID: {}", (Object)deleteResponse.getResult(), (Object)modelId);
                actionListener.onResponse((Object)true);
            }

            public void onFailure(Exception e) {
                if (e instanceof ResourceNotFoundException) {
                    log.info("Model controller not deleted due to no model controller found for the given model. Model ID: {}", (Object)modelId);
                    actionListener.onResponse((Object)true);
                } else {
                    log.error("Failed to delete model controller for the given model. Model ID: {}", (Object)modelId);
                    actionListener.onFailure(e);
                }
            }
        });
    }

    private Boolean isModelNotDeployed(MLModelState mlModelState) {
        return !mlModelState.equals((Object)MLModelState.LOADED) && !mlModelState.equals((Object)MLModelState.LOADING) && !mlModelState.equals((Object)MLModelState.PARTIALLY_LOADED) && !mlModelState.equals((Object)MLModelState.DEPLOYED) && !mlModelState.equals((Object)MLModelState.DEPLOYING) && !mlModelState.equals((Object)MLModelState.PARTIALLY_DEPLOYED);
    }

    private List<String> findDependentPipelinesEasy(Map<String, Object> allConfigMap, String candidateModelId) {
        ArrayList<String> dependentPipelineConfigurations = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : allConfigMap.entrySet()) {
            String id = entry.getKey();
            Map config = (Map)entry.getValue();
            if (!this.searchThroughConfig(config, candidateModelId).booleanValue()) continue;
            dependentPipelineConfigurations.add(id);
        }
        return dependentPipelineConfigurations;
    }

    private Boolean searchThroughConfig(Object searchCandidate, String candidateId) {
        ArrayDeque<Tuple> stack = new ArrayDeque<Tuple>();
        stack.push(Tuple.of((Object)"", (Object)searchCandidate));
        while (!stack.isEmpty()) {
            Tuple current = (Tuple)stack.pop();
            String currentKey = (String)current.v1();
            Object currentCandidate = current.v2();
            if (currentCandidate instanceof String && candidateId.equals(currentCandidate)) {
                if (!PIPELINE_TARGET_MODEL_KEY.equals(currentKey)) continue;
                return true;
            }
            if (currentCandidate instanceof List) {
                for (Object e : (List)currentCandidate) {
                    stack.push(Tuple.of((Object)currentKey, e));
                }
                continue;
            }
            if (!(currentCandidate instanceof Map)) continue;
            for (Map.Entry entry : ((Map)currentCandidate).entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                stack.push(Tuple.of((Object)key, value));
            }
        }
        return false;
    }

    private String formatAgentErrorMessage(SearchHit[] hits) {
        ArrayList<String> agentIds = new ArrayList<String>();
        for (SearchHit hit : hits) {
            Map sourceAsMap = hit.getSourceAsMap();
            agentIds.add(hit.getId());
        }
        return String.format(Locale.ROOT, "%d agents are still using this model, please delete or update the agents first, all visible agents are: %s", hits.length, Arrays.toString(agentIds.toArray(new String[0])));
    }

    boolean isSuperAdminUserWrapper(ClusterService clusterService, Client client) {
        return RestActionUtils.isSuperAdminUser(clusterService, client);
    }
}

