/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.models;

import io.lucenia.ml.common.helpers.ConnectorAccessControlHelper;
import io.lucenia.ml.common.model.MLModelGroupManager;
import io.lucenia.ml.common.model.MLModelManager;
import io.lucenia.ml.common.model.ModelAccessControlHelper;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.DocWriteResponse;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.update.UpdateRequest;
import io.skylite.core.action.update.UpdateResponse;
import io.skylite.core.client.Client;
import io.skylite.core.client.metadata.MetadataClient;
import io.skylite.core.client.metadata.UpdateDataObjectRequest;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.Strings;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.connector.Connector;
import io.skylite.ml.common.controller.MLRateLimiter;
import io.skylite.ml.common.engine.MLEngine;
import io.skylite.ml.common.model.MLModel;
import io.skylite.ml.common.model.MLModelState;
import io.skylite.ml.common.settings.MLCommonsSettings;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.model.MLUpdateModelInput;
import io.skylite.ml.common.transport.model.MLUpdateModelRequest;
import io.skylite.ml.common.transport.update_cache.MLUpdateModelCacheAction;
import io.skylite.ml.common.transport.update_cache.MLUpdateModelCacheNodesRequest;
import io.skylite.ml.common.transport.update_cache.MLUpdateModelCacheNodesResponse;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdateModelTransportAction
extends HandledTransportAction<ActionRequest, UpdateResponse> {
    private static final Logger log = LogManager.getLogger(UpdateModelTransportAction.class);
    private final Client client;
    private final MetadataClient sdkClient;
    private final Settings settings;
    private final ClusterService clusterService;
    private final ModelAccessControlHelper modelAccessControlHelper;
    private final ConnectorAccessControlHelper connectorAccessControlHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;
    private final MLModelManager mlModelManager;
    private final MLModelGroupManager mlModelGroupManager;
    private final MLEngine mlEngine;
    private volatile List<String> trustedConnectorEndpointsRegex;

    @Inject
    public UpdateModelTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, MetadataClient sdkClient, ConnectorAccessControlHelper connectorAccessControlHelper, ModelAccessControlHelper modelAccessControlHelper, MLModelManager mlModelManager, MLModelGroupManager mlModelGroupManager, Settings settings, ClusterService clusterService, MLEngine mlEngine, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/lucenia/ml/models/update", transportService, actionFilters, MLUpdateModelRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.connectorAccessControlHelper = connectorAccessControlHelper;
        this.mlModelManager = mlModelManager;
        this.mlModelGroupManager = mlModelGroupManager;
        this.clusterService = clusterService;
        this.mlEngine = mlEngine;
        this.settings = settings;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        this.trustedConnectorEndpointsRegex = (List)MLCommonsSettings.ML_COMMONS_TRUSTED_CONNECTOR_ENDPOINTS_REGEX.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_TRUSTED_CONNECTOR_ENDPOINTS_REGEX, it -> {
            this.trustedConnectorEndpointsRegex = it;
        });
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<UpdateResponse> actionListener) {
        MLUpdateModelRequest updateModelRequest = MLUpdateModelRequest.fromActionRequest((ActionRequest)request);
        MLUpdateModelInput updateModelInput = updateModelRequest.getUpdateModelInput();
        String modelId = updateModelInput.getModelId();
        String tenantId = updateModelInput.getTenantId();
        if (!TenantAwareHelper.validateTenantId((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, actionListener)) {
            return;
        }
        User user = RestActionUtils.getUserContext(this.client);
        boolean isSuperAdmin = this.isSuperAdminUserWrapper(this.clusterService, this.client);
        String[] excludes = new String[]{"model_content", "content"};
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListenerHelper.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore());
            this.mlModelManager.getModel(modelId, tenantId, null, excludes, (ActionListener<MLModel>)ActionListenerHelper.wrap(mlModel -> {
                if (TenantAwareHelper.validateTenantResource((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, (String)mlModel.getTenantId(), (ActionListener)actionListener)) {
                    if (!this.isModelDeploying(mlModel.getModelState()).booleanValue()) {
                        FunctionName functionName = mlModel.getAlgorithm();
                        if (functionName == FunctionName.TEXT_EMBEDDING || functionName == FunctionName.REMOTE) {
                            if (mlModel.getIsHidden() != null && mlModel.getIsHidden().booleanValue()) {
                                if (isSuperAdmin) {
                                    this.updateRemoteOrTextEmbeddingModel(modelId, tenantId, updateModelInput, (MLModel)mlModel, user, (ActionListener<UpdateResponse>)wrappedListener);
                                } else {
                                    wrappedListener.onFailure((Exception)new SkyliteStatusException("User doesn't have privilege to perform this operation on this model", RestStatus.FORBIDDEN, new Object[0]));
                                }
                            } else {
                                this.modelAccessControlHelper.validateModelGroupAccess(user, this.mlFeatureEnabledSetting, tenantId, mlModel.getModelGroupId(), this.client, this.sdkClient, (ActionListener<Boolean>)ActionListenerHelper.wrap(hasPermission -> {
                                    if (hasPermission.booleanValue()) {
                                        this.updateRemoteOrTextEmbeddingModel(modelId, tenantId, updateModelInput, (MLModel)mlModel, user, (ActionListener<UpdateResponse>)wrappedListener);
                                    } else {
                                        wrappedListener.onFailure((Exception)new SkyliteStatusException("User doesn't have privilege to perform this operation on this model, model ID " + modelId, RestStatus.FORBIDDEN, new Object[0]));
                                    }
                                }, exception -> {
                                    log.error("Permission denied: Unable to update the model with ID {}. Details: {}", (Object)modelId, exception);
                                    wrappedListener.onFailure(exception);
                                }));
                            }
                        } else {
                            wrappedListener.onFailure((Exception)new SkyliteStatusException("The function category " + functionName.toString() + " is not supported at this time.", RestStatus.FORBIDDEN, new Object[0]));
                        }
                    } else {
                        wrappedListener.onFailure((Exception)new SkyliteStatusException("Model is deploying. Please wait for the model to complete deployment. model ID " + modelId, RestStatus.CONFLICT, new Object[0]));
                    }
                }
            }, e -> wrappedListener.onFailure((Exception)new SkyliteStatusException("Failed to find model to update with the provided model id: " + modelId, RestStatus.NOT_FOUND, new Object[0]))));
        }
        catch (Exception e2) {
            log.error("Failed to update ML model for {}", (Object)modelId);
            actionListener.onFailure(e2);
        }
    }

    private void updateRemoteOrTextEmbeddingModel(String modelId, String tenantId, MLUpdateModelInput updateModelInput, MLModel mlModel, User user, ActionListener<UpdateResponse> wrappedListener) throws IOException {
        boolean isUpdateModelCache;
        boolean isPredictorUpdate;
        String newModelGroupId = Strings.hasLength((String)updateModelInput.getModelGroupId()) && !Objects.equals(updateModelInput.getModelGroupId(), mlModel.getModelGroupId()) ? updateModelInput.getModelGroupId() : null;
        String newConnectorId = Strings.hasLength((String)updateModelInput.getConnectorId()) ? updateModelInput.getConnectorId() : null;
        boolean isModelDeployed = this.isModelDeployed(mlModel.getModelState());
        boolean bl = isPredictorUpdate = updateModelInput.getConnector() != null || newConnectorId != null || !Objects.equals(updateModelInput.getIsEnabled(), mlModel.getIsEnabled()) || updateModelInput.getGuardrails() != null || updateModelInput.getModelInterface() != null;
        if (MLRateLimiter.updateValidityPreCheck((MLRateLimiter)mlModel.getRateLimiter(), (MLRateLimiter)updateModelInput.getRateLimiter())) {
            MLRateLimiter updatedRateLimiterConfig = MLRateLimiter.update((MLRateLimiter)mlModel.getRateLimiter(), (MLRateLimiter)updateModelInput.getRateLimiter());
            updateModelInput.setRateLimiter(updatedRateLimiterConfig);
            isPredictorUpdate = isPredictorUpdate || updatedRateLimiterConfig.isValid();
        }
        boolean bl2 = isUpdateModelCache = isPredictorUpdate && isModelDeployed;
        if (mlModel.getAlgorithm() == FunctionName.TEXT_EMBEDDING) {
            if (newConnectorId == null && updateModelInput.getConnector() == null) {
                this.updateModelWithRegisteringToAnotherModelGroup(modelId, newModelGroupId, tenantId, user, updateModelInput, wrappedListener, isUpdateModelCache);
            } else {
                wrappedListener.onFailure((Exception)new SkyliteStatusException("Trying to update the connector or connector_id field on a local model.", RestStatus.BAD_REQUEST, new Object[0]));
            }
        } else if (newConnectorId == null) {
            if (updateModelInput.getConnector() != null) {
                Connector connector = mlModel.getConnector();
                connector.update(updateModelInput.getConnector(), (arg_0, arg_1) -> ((MLEngine)this.mlEngine).encrypt(arg_0, arg_1));
                connector.validateConnectorURL(this.trustedConnectorEndpointsRegex);
                updateModelInput.setUpdatedConnector(connector);
                updateModelInput.setConnector(null);
            }
            this.updateModelWithRegisteringToAnotherModelGroup(modelId, newModelGroupId, tenantId, user, updateModelInput, wrappedListener, isUpdateModelCache);
        } else {
            this.updateModelWithNewStandAloneConnector(modelId, newModelGroupId, newConnectorId, tenantId, mlModel, user, updateModelInput, wrappedListener, isUpdateModelCache);
        }
    }

    private void updateModelWithNewStandAloneConnector(String modelId, String newModelGroupId, String newConnectorId, String tenantId, MLModel mlModel, User user, MLUpdateModelInput updateModelInput, ActionListener<UpdateResponse> wrappedListener, boolean isUpdateModelCache) {
        if (Strings.hasLength((String)mlModel.getConnectorId())) {
            this.connectorAccessControlHelper.validateConnectorAccess(this.sdkClient, this.client, newConnectorId, tenantId, this.mlFeatureEnabledSetting, (ActionListener<Boolean>)ActionListenerHelper.wrap(hasNewConnectorPermission -> {
                if (hasNewConnectorPermission.booleanValue()) {
                    this.updateModelWithRegisteringToAnotherModelGroup(modelId, newModelGroupId, tenantId, user, updateModelInput, wrappedListener, isUpdateModelCache);
                } else {
                    wrappedListener.onFailure((Exception)new SkyliteStatusException("You don't have permission to update the connector, connector id: " + newConnectorId, RestStatus.FORBIDDEN, new Object[0]));
                }
            }, exception -> {
                log.error("Permission denied: Unable to update the connector with ID {}. Details: {}", (Object)newConnectorId, exception);
                wrappedListener.onFailure(exception);
            }));
        } else {
            wrappedListener.onFailure((Exception)new SkyliteStatusException("This remote does not have a connector_id field, maybe it uses an internal connector.", RestStatus.BAD_REQUEST, new Object[0]));
        }
    }

    private void updateModelWithRegisteringToAnotherModelGroup(String modelId, String newModelGroupId, String tenantId, User user, MLUpdateModelInput updateModelInput, ActionListener<UpdateResponse> wrappedListener, boolean isUpdateModelCache) {
        UpdateRequest updateRequest = new UpdateRequest(".plugins-ml-model", modelId);
        if (newModelGroupId != null) {
            this.modelAccessControlHelper.validateModelGroupAccess(user, newModelGroupId, this.client, (ActionListener<Boolean>)ActionListenerHelper.wrap(hasNewModelGroupPermission -> {
                if (hasNewModelGroupPermission.booleanValue()) {
                    this.mlModelGroupManager.getModelGroupResponse(this.sdkClient, newModelGroupId, (ActionListener<GetResponse>)ActionListenerHelper.wrap(newModelGroupResponse -> this.buildUpdateRequest(modelId, newModelGroupId, updateRequest, updateModelInput, (GetResponse)newModelGroupResponse, wrappedListener, isUpdateModelCache), exception -> wrappedListener.onFailure((Exception)new SkyliteStatusException("Failed to find the model group with the provided model group id in the update model input, MODEL_GROUP_ID: " + newModelGroupId, RestStatus.NOT_FOUND, new Object[0]))));
                } else {
                    wrappedListener.onFailure((Exception)new SkyliteStatusException("User Doesn't have privilege to re-link this model to the target model group due to no access to the target model group with model group ID " + newModelGroupId, RestStatus.FORBIDDEN, new Object[0]));
                }
            }, exception -> {
                log.error("Permission denied: Unable to update the model with ID {}. Details: {}", (Object)modelId, exception);
                wrappedListener.onFailure(exception);
            }));
        } else {
            this.buildUpdateRequest(modelId, tenantId, updateRequest, updateModelInput, wrappedListener, isUpdateModelCache);
        }
    }

    private void buildUpdateRequest(String modelId, String tenantId, UpdateRequest updateRequest, MLUpdateModelInput updateModelInput, ActionListener<UpdateResponse> wrappedListener, boolean isUpdateModelCache) {
        ActionListener<UpdateResponse> updateListener;
        updateModelInput.setLastUpdateTime(Instant.now());
        UpdateDataObjectRequest updateDataObjectRequest = ((UpdateDataObjectRequest.Builder)((UpdateDataObjectRequest.Builder)((UpdateDataObjectRequest.Builder)UpdateDataObjectRequest.builder().index(updateRequest.index())).id(updateRequest.id())).tenantId(tenantId)).dataObject((ToXContentObject)updateModelInput).build();
        if (isUpdateModelCache) {
            String[] targetNodeIds = this.getAllNodes();
            MLUpdateModelCacheNodesRequest mlUpdateModelCacheNodesRequest = new MLUpdateModelCacheNodesRequest(targetNodeIds, modelId);
            updateListener = this.getUpdateResponseListenerWithUpdateModelCache(modelId, wrappedListener, mlUpdateModelCacheNodesRequest);
        } else {
            updateListener = this.getUpdateResponseListener(modelId, wrappedListener);
        }
        this.sdkClient.updateDataObjectAsync(updateDataObjectRequest).whenComplete((ur, ut) -> {
            if (ut == null) {
                try {
                    UpdateResponse updateResponse = ur.parser() == null ? null : UpdateResponse.fromXContent((XContentParser)ur.parser());
                    updateListener.onResponse((Object)updateResponse);
                }
                catch (Exception e) {
                    updateListener.onFailure(e);
                }
            } else {
                Exception e = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)ut, (Class[])new Class[0]);
                updateListener.onFailure(e);
            }
        });
    }

    private void buildUpdateRequest(String modelId, String newModelGroupId, UpdateRequest updateRequest, MLUpdateModelInput updateModelInput, GetResponse newModelGroupResponse, ActionListener<UpdateResponse> wrappedListener, boolean isUpdateModelCache) {
        ActionListener<UpdateResponse> updateListener;
        Map newModelGroupSourceMap = newModelGroupResponse.getSourceAsMap();
        String updatedVersion = this.incrementLatestVersion(newModelGroupSourceMap);
        updateModelInput.setVersion(updatedVersion);
        updateModelInput.setLastUpdateTime(Instant.now());
        UpdateDataObjectRequest updateModelGroupRequest = this.createUpdateModelGroupRequest(newModelGroupSourceMap, newModelGroupId, newModelGroupResponse.getSeqNo(), newModelGroupResponse.getPrimaryTerm(), Integer.parseInt(updatedVersion));
        UpdateDataObjectRequest updateDataObjectRequest = ((UpdateDataObjectRequest.Builder)((UpdateDataObjectRequest.Builder)UpdateDataObjectRequest.builder().index(updateRequest.index())).id(updateRequest.id())).dataObject((ToXContentObject)updateModelInput).build();
        if (isUpdateModelCache) {
            String[] targetNodeIds = this.getAllNodes();
            MLUpdateModelCacheNodesRequest mlUpdateModelCacheNodesRequest = new MLUpdateModelCacheNodesRequest(targetNodeIds, modelId);
            updateListener = this.getUpdateResponseListenerWithUpdateModelCache(modelId, wrappedListener, mlUpdateModelCacheNodesRequest);
        } else {
            updateListener = this.getUpdateResponseListener(modelId, wrappedListener);
        }
        this.sdkClient.updateDataObjectAsync(updateModelGroupRequest).whenComplete((r, throwable) -> {
            if (throwable == null) {
                this.sdkClient.updateDataObjectAsync(updateDataObjectRequest).whenComplete((ur, ut) -> {
                    if (ut == null) {
                        try {
                            UpdateResponse updateResponse = ur.parser() == null ? null : UpdateResponse.fromXContent((XContentParser)ur.parser());
                            updateListener.onResponse((Object)updateResponse);
                        }
                        catch (Exception e) {
                            updateListener.onFailure(e);
                        }
                    } else {
                        Exception e = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)ut, (Class[])new Class[0]);
                        updateListener.onFailure(e);
                    }
                });
            } else {
                Exception e = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                log.error("Failed to register ML model with model ID {} to the new model group with model group ID {}", (Object)modelId, (Object)newModelGroupId);
                wrappedListener.onFailure(e);
            }
        });
    }

    private ActionListener<UpdateResponse> getUpdateResponseListenerWithUpdateModelCache(String modelId, ActionListener<UpdateResponse> wrappedListener, MLUpdateModelCacheNodesRequest mlUpdateModelCacheNodesRequest) {
        return ActionListenerHelper.wrap(updateResponse -> {
            if (updateResponse != null && updateResponse.getResult() == DocWriteResponse.Result.UPDATED) {
                this.client.execute((ActionType)MLUpdateModelCacheAction.INSTANCE, (ActionRequest)mlUpdateModelCacheNodesRequest, ActionListenerHelper.wrap(r -> {
                    if (r != null && this.isUpdateModelCacheSuccessOnAllNodes((MLUpdateModelCacheNodesResponse)r)) {
                        log.info("Successfully updated ML model cache with model ID {}", (Object)modelId);
                        wrappedListener.onResponse(updateResponse);
                    } else {
                        Object[] nodeIds = this.getUpdateModelCacheFailedNodesList((MLUpdateModelCacheNodesResponse)r);
                        log.error("Successfully update ML model index with model ID {} but update model cache was failed on following nodes {}, please retry or redeploy model manually.", (Object)modelId, (Object)Arrays.toString(nodeIds));
                        wrappedListener.onFailure((Exception)new RuntimeException("Successfully update ML model index with model ID " + modelId + " but update model cache was failed on following nodes " + Arrays.toString(nodeIds) + ", please retry or redeploy model manually."));
                    }
                }, e -> {
                    log.error("Failed to update ML model cache for model: " + modelId, (Throwable)e);
                    wrappedListener.onFailure(e);
                }));
            } else if (updateResponse != null && updateResponse.getResult() != DocWriteResponse.Result.UPDATED) {
                log.warn("Update model for model {} got a result status other than update, result status: {}", (Object)modelId, (Object)updateResponse.getResult());
                wrappedListener.onResponse(updateResponse);
            } else {
                log.error("Failed to update ML model: " + modelId);
                wrappedListener.onFailure((Exception)new RuntimeException("Failed to update ML model: " + modelId));
            }
        }, exception -> {
            log.error("Failed to update ML model: " + modelId, (Throwable)exception);
            wrappedListener.onFailure(exception);
        });
    }

    private ActionListener<UpdateResponse> getUpdateResponseListener(String modelId, ActionListener<UpdateResponse> wrappedListener) {
        return ActionListenerHelper.wrap(updateResponse -> {
            if (updateResponse != null && updateResponse.getResult() == DocWriteResponse.Result.UPDATED) {
                log.info("Successfully update ML model with model ID {}", (Object)modelId);
                wrappedListener.onResponse(updateResponse);
            } else if (updateResponse != null && updateResponse.getResult() != DocWriteResponse.Result.UPDATED) {
                log.warn("Update model for model {} got a result status other than update, result status: {}", (Object)modelId, (Object)updateResponse.getResult());
                wrappedListener.onResponse(updateResponse);
            } else {
                log.error("Failed to update ML model: " + modelId);
                wrappedListener.onFailure((Exception)new RuntimeException("Failed to update ML model: " + modelId));
            }
        }, exception -> {
            log.error("Failed to update ML model: " + modelId, (Throwable)exception);
            wrappedListener.onFailure(exception);
        });
    }

    private String incrementLatestVersion(Map<String, Object> modelGroupSourceMap) {
        return Integer.toString((Integer)modelGroupSourceMap.get("latest_version") + 1);
    }

    private UpdateDataObjectRequest createUpdateModelGroupRequest(Map<String, Object> modelGroupSourceMap, String modelGroupId, long seqNo, long primaryTerm, int updatedVersion) {
        modelGroupSourceMap.put("latest_version", updatedVersion);
        modelGroupSourceMap.put("last_updated_time", Instant.now().toEpochMilli());
        ToXContentObject dataObject = (builder, params) -> {
            builder.startObject();
            for (Map.Entry e : modelGroupSourceMap.entrySet()) {
                builder.field((String)e.getKey(), e.getValue());
            }
            return builder.endObject();
        };
        return ((UpdateDataObjectRequest.Builder)((UpdateDataObjectRequest.Builder)UpdateDataObjectRequest.builder().index(".plugins-ml-model-group")).id(modelGroupId)).ifSeqNo(seqNo).ifPrimaryTerm(primaryTerm).dataObject(dataObject).build();
    }

    private Boolean isModelDeployed(MLModelState mlModelState) {
        return mlModelState.equals((Object)MLModelState.LOADED) || mlModelState.equals((Object)MLModelState.PARTIALLY_LOADED) || mlModelState.equals((Object)MLModelState.DEPLOYED) || mlModelState.equals((Object)MLModelState.PARTIALLY_DEPLOYED);
    }

    private Boolean isModelDeploying(MLModelState mlModelState) {
        return mlModelState.equals((Object)MLModelState.LOADING) || mlModelState.equals((Object)MLModelState.DEPLOYING);
    }

    private String[] getAllNodes() {
        Iterator iterator = this.clusterService.state().nodes().iterator();
        ArrayList<String> nodeIds = new ArrayList<String>();
        while (iterator.hasNext()) {
            nodeIds.add(((DiscoveryNode)iterator.next()).getId());
        }
        return nodeIds.toArray(new String[0]);
    }

    private boolean isUpdateModelCacheSuccessOnAllNodes(MLUpdateModelCacheNodesResponse updateModelCacheNodesResponse) {
        return updateModelCacheNodesResponse.failures() == null || updateModelCacheNodesResponse.failures().isEmpty();
    }

    private String[] getUpdateModelCacheFailedNodesList(MLUpdateModelCacheNodesResponse updateModelCacheNodesResponse) {
        if (updateModelCacheNodesResponse == null) {
            return this.getAllNodes();
        }
        ArrayList<String> nodeIds = new ArrayList<String>();
        for (FailedNodeException failedNodeException : updateModelCacheNodesResponse.failures()) {
            nodeIds.add(failedNodeException.nodeId());
        }
        return nodeIds.toArray(new String[0]);
    }

    boolean isSuperAdminUserWrapper(ClusterService clusterService, Client client) {
        return RestActionUtils.isSuperAdminUser(clusterService, client);
    }
}

