/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.profile;

import io.lucenia.action.support.nodes.TransportNodesAction;
import io.lucenia.ml.common.action.profile.MLProfileAction;
import io.lucenia.ml.common.action.profile.MLProfileNodeRequest;
import io.lucenia.ml.common.action.profile.MLProfileNodeResponse;
import io.lucenia.ml.common.action.profile.MLProfileRequest;
import io.lucenia.ml.common.action.profile.MLProfileResponse;
import io.lucenia.ml.common.model.MLModelManager;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.lucenia.ml.common.task.MLTaskManager;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.env.Environment;
import io.skylite.core.monitor.jvm.JvmService;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import io.skylite.ml.common.profile.MLModelProfile;
import io.skylite.ml.common.profile.MLProfileInput;
import io.skylite.ml.common.task.MLTask;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MLProfileTransportAction
extends TransportNodesAction<MLProfileRequest, MLProfileResponse, MLProfileNodeRequest, MLProfileNodeResponse> {
    private static final Logger log = LogManager.getLogger(MLProfileTransportAction.class);
    private MLTaskManager mlTaskManager;
    private final JvmService jvmService;
    private final MLModelManager mlModelManager;
    private final Client client;

    @Inject
    public MLProfileTransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, MLTaskManager mlTaskManager, Environment environment, MLModelManager mlModelManager, Client client) {
        super(MLProfileAction.NAME, threadPool, clusterService, transportService, actionFilters, MLProfileRequest::new, MLProfileNodeRequest::new, "management", MLProfileNodeResponse.class);
        this.mlTaskManager = mlTaskManager;
        this.jvmService = new JvmService(environment.settings());
        this.mlModelManager = mlModelManager;
        this.client = client;
    }

    protected MLProfileResponse newResponse(MLProfileRequest request, List<MLProfileNodeResponse> responses, List<FailedNodeException> failures) {
        return new MLProfileResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected MLProfileNodeRequest newNodeRequest(MLProfileRequest request) {
        return new MLProfileNodeRequest(request);
    }

    protected MLProfileNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new MLProfileNodeResponse(in);
    }

    protected MLProfileNodeResponse nodeOperation(MLProfileNodeRequest request) {
        return this.createMLProfileNodeResponse(request.getMlProfileRequest());
    }

    private MLProfileNodeResponse createMLProfileNodeResponse(MLProfileRequest mlProfileRequest) {
        MLProfileInput profileInput = mlProfileRequest.getMlProfileInput();
        boolean isSuperAdmin = this.isSuperAdminUserWrapper(this.clusterService, this.client);
        Set<String> hiddenModels = Optional.ofNullable(mlProfileRequest.getHiddenModelIds()).orElse(Collections.emptySet());
        Map<String, MLTask> tasks = this.getTasks(profileInput, isSuperAdmin, hiddenModels);
        Map<String, MLModelProfile> models = this.getModels(profileInput, isSuperAdmin, hiddenModels);
        return new MLProfileNodeResponse(this.clusterService.localNode(), tasks, models);
    }

    private Map<String, MLTask> getTasks(MLProfileInput profileInput, boolean isSuperAdmin, Set<String> hiddenModels) {
        HashMap<String, MLTask> tasks = new HashMap<String, MLTask>();
        Arrays.stream(this.mlTaskManager.getAllTaskIds()).forEach(taskId -> {
            MLTask task = this.mlTaskManager.getMLTask((String)taskId);
            if (task != null && (isSuperAdmin || !hiddenModels.contains(task.getModelId())) && (profileInput.isReturnAllTasks() || profileInput.getTaskIds().contains(taskId))) {
                tasks.put((String)taskId, task);
            }
        });
        return tasks;
    }

    private Map<String, MLModelProfile> getModels(MLProfileInput profileInput, boolean isSuperAdmin, Set<String> hiddenModels) {
        HashMap<String, MLModelProfile> models = new HashMap<String, MLModelProfile>();
        Arrays.stream(this.mlModelManager.getAllModelIds()).forEach(modelId -> {
            MLModelProfile modelProfile;
            if ((isSuperAdmin || !hiddenModels.contains(modelId)) && (profileInput.isReturnAllModels() || profileInput.getModelIds().contains(modelId)) && (modelProfile = this.mlModelManager.getModelProfile((String)modelId)) != null) {
                modelProfile.setIsHidden(Boolean.valueOf(hiddenModels.contains(modelId)));
                models.put((String)modelId, modelProfile);
            }
        });
        return models;
    }

    boolean isSuperAdminUserWrapper(ClusterService clusterService, Client client) {
        return RestActionUtils.isSuperAdminUser(clusterService, client);
    }
}

