/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.stats;

import io.lucenia.action.support.nodes.TransportNodesAction;
import io.lucenia.ml.common.action.stats.MLStatsNodeRequest;
import io.lucenia.ml.common.action.stats.MLStatsNodeResponse;
import io.lucenia.ml.common.action.stats.MLStatsNodesAction;
import io.lucenia.ml.common.action.stats.MLStatsNodesRequest;
import io.lucenia.ml.common.action.stats.MLStatsNodesResponse;
import io.lucenia.ml.common.model.MLModelManager;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.env.Environment;
import io.skylite.core.monitor.jvm.JvmService;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.stats.ActionName;
import io.skylite.ml.common.stats.MLActionStats;
import io.skylite.ml.common.stats.MLAlgoStats;
import io.skylite.ml.common.stats.MLModelStats;
import io.skylite.ml.common.stats.MLNodeLevelStat;
import io.skylite.ml.common.stats.MLStatLevel;
import io.skylite.ml.common.stats.MLStats;
import io.skylite.ml.common.stats.MLStatsInput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MLStatsNodesTransportAction
extends TransportNodesAction<MLStatsNodesRequest, MLStatsNodesResponse, MLStatsNodeRequest, MLStatsNodeResponse> {
    private static final Logger logger = LogManager.getLogger(MLStatsNodesTransportAction.class);
    private MLStats mlStats;
    private final JvmService jvmService;
    private final Client client;
    private final MLModelManager mlModelManager;

    @Inject
    public MLStatsNodesTransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, MLStats mlStats, Environment environment, Client client, MLModelManager mlModelManager) {
        super(MLStatsNodesAction.NAME, threadPool, clusterService, transportService, actionFilters, MLStatsNodesRequest::new, MLStatsNodeRequest::new, "management", MLStatsNodeResponse.class);
        this.mlStats = mlStats;
        this.jvmService = new JvmService(environment.settings());
        this.client = client;
        this.mlModelManager = mlModelManager;
    }

    protected MLStatsNodesResponse newResponse(MLStatsNodesRequest request, List<MLStatsNodeResponse> responses, List<FailedNodeException> failures) {
        return new MLStatsNodesResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected MLStatsNodeRequest newNodeRequest(MLStatsNodesRequest request) {
        return new MLStatsNodeRequest(request);
    }

    protected MLStatsNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new MLStatsNodeResponse(in);
    }

    protected MLStatsNodeResponse nodeOperation(MLStatsNodeRequest request) {
        return this.createMLStatsNodeResponse(request.getMlStatsNodesRequest());
    }

    private MLStatsNodeResponse createMLStatsNodeResponse(MLStatsNodesRequest request) {
        Map<MLNodeLevelStat, Object> nodeLevelStats = this.getNodeLevelStats(request.getMlStatsInput());
        Map<FunctionName, MLAlgoStats> algoStats = this.getAlgorithmStats(request.getMlStatsInput());
        Map<String, MLModelStats> modelStats = this.getModelStats(request);
        return new MLStatsNodeResponse(this.clusterService.localNode(), nodeLevelStats, algoStats, modelStats);
    }

    private Map<MLNodeLevelStat, Object> getNodeLevelStats(MLStatsInput input) {
        HashMap<MLNodeLevelStat, Object> stats = new HashMap<MLNodeLevelStat, Object>();
        if (input.getTargetStatLevels().contains(MLStatLevel.NODE)) {
            if (input.retrieveStat((Enum)MLNodeLevelStat.ML_JVM_HEAP_USAGE)) {
                long heapUsedPercent = this.jvmService.stats().getMem().getHeapUsedPercent();
                stats.put(MLNodeLevelStat.ML_JVM_HEAP_USAGE, heapUsedPercent);
            }
            this.mlStats.getNodeStats().forEach((statName, stat) -> {
                if (input.retrieveStat(statName)) {
                    stats.put((MLNodeLevelStat)statName, stat.getValue());
                }
            });
        }
        return stats;
    }

    private Map<FunctionName, MLAlgoStats> getAlgorithmStats(MLStatsInput input) {
        HashMap<FunctionName, MLAlgoStats> stats = new HashMap<FunctionName, MLAlgoStats>();
        if (input.includeAlgoStats()) {
            for (FunctionName algo : this.mlStats.getAllAlgorithms()) {
                if (!input.retrieveStatsForAlgo(algo)) continue;
                Map<ActionName, MLActionStats> actionStats = this.collectActionStats(this.mlStats.getAlgorithmStats(algo), input);
                stats.put(algo, new MLAlgoStats(actionStats));
            }
        }
        return stats;
    }

    private Map<ActionName, MLActionStats> collectActionStats(Map<ActionName, MLActionStats> stats, MLStatsInput input) {
        HashMap<ActionName, MLActionStats> filteredStats = new HashMap<ActionName, MLActionStats>();
        stats.forEach((action, stat) -> {
            if (input.retrieveStatsForAction(action)) {
                filteredStats.put((ActionName)action, (MLActionStats)stat);
            }
        });
        return filteredStats;
    }

    private Map<String, MLModelStats> getModelStats(MLStatsNodesRequest request) {
        HashMap<String, MLModelStats> stats = new HashMap<String, MLModelStats>();
        boolean isSuperAdmin = this.isSuperAdminUserWrapper(this.clusterService, this.client);
        Set hiddenModels = Optional.ofNullable(request.getHiddenModelIds()).orElse(Collections.emptySet());
        for (String modelId : this.mlStats.getAllModels()) {
            if (!isSuperAdmin && hiddenModels.contains(modelId) || !request.getMlStatsInput().retrieveStatsForModel(modelId)) continue;
            Map<ActionName, MLActionStats> actionStats = this.collectActionStats(this.mlStats.getModelStats(modelId), request.getMlStatsInput());
            boolean isHidden = hiddenModels.contains(modelId);
            stats.put(modelId, new MLModelStats(actionStats, Boolean.valueOf(isHidden)));
        }
        return stats;
    }

    boolean isSuperAdminUserWrapper(ClusterService clusterService, Client client) {
        return RestActionUtils.isSuperAdminUser(clusterService, client);
    }
}

