/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.syncup;

import io.lucenia.action.support.nodes.TransportNodesAction;
import io.lucenia.ml.common.model.MLModelManager;
import io.lucenia.ml.common.task.MLTaskManager;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.ml.common.engine.MLEngine;
import io.skylite.ml.common.engine.ModelDownloader;
import io.skylite.ml.common.model.MLModelCacheHelper;
import io.skylite.ml.common.settings.MLCommonsSettings;
import io.skylite.ml.common.task.MLTask;
import io.skylite.ml.common.task.MLTaskCache;
import io.skylite.ml.common.task.MLTaskState;
import io.skylite.ml.common.task.MLTaskType;
import io.skylite.ml.common.transport.sync.MLSyncUpInput;
import io.skylite.ml.common.transport.sync.MLSyncUpNodeRequest;
import io.skylite.ml.common.transport.sync.MLSyncUpNodeResponse;
import io.skylite.ml.common.transport.sync.MLSyncUpNodesRequest;
import io.skylite.ml.common.transport.sync.MLSyncUpNodesResponse;
import io.skylite.ml.common.utils.FileUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportSyncUpOnNodeAction
extends TransportNodesAction<MLSyncUpNodesRequest, MLSyncUpNodesResponse, MLSyncUpNodeRequest, MLSyncUpNodeResponse> {
    private static final Logger log = LogManager.getLogger(TransportSyncUpOnNodeAction.class);
    TransportService transportService;
    ModelDownloader modelHelper;
    MLTaskManager mlTaskManager;
    MLModelManager mlModelManager;
    ClusterService clusterService;
    ThreadPool threadPool;
    Client client;
    NamedXContentRegistry xContentRegistry;
    MLEngine mlEngine;
    private volatile Integer mlTaskTimeout;
    private final MLModelCacheHelper mlModelCacheHelper;

    @Inject
    public TransportSyncUpOnNodeAction(TransportService transportService, Settings settings, ActionFilters actionFilters, ModelDownloader modelHelper, MLTaskManager mlTaskManager, MLModelManager mlModelManager, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry, MLEngine mlEngine, MLModelCacheHelper mlModelCacheHelper) {
        super("cluster:admin/opensearch/mlinternal/syncup", threadPool, clusterService, transportService, actionFilters, MLSyncUpNodesRequest::new, MLSyncUpNodeRequest::new, "management", MLSyncUpNodeResponse.class);
        this.transportService = transportService;
        this.modelHelper = modelHelper;
        this.mlTaskManager = mlTaskManager;
        this.mlModelManager = mlModelManager;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.mlEngine = mlEngine;
        this.mlModelCacheHelper = mlModelCacheHelper;
        this.mlTaskTimeout = (Integer)MLCommonsSettings.ML_COMMONS_ML_TASK_TIMEOUT_IN_SECONDS.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_ML_TASK_TIMEOUT_IN_SECONDS, it -> {
            this.mlTaskTimeout = it;
        });
    }

    protected MLSyncUpNodesResponse newResponse(MLSyncUpNodesRequest nodesRequest, List<MLSyncUpNodeResponse> responses, List<FailedNodeException> failures) {
        return new MLSyncUpNodesResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected MLSyncUpNodeRequest newNodeRequest(MLSyncUpNodesRequest request) {
        return new MLSyncUpNodeRequest(request);
    }

    protected MLSyncUpNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new MLSyncUpNodeResponse(in);
    }

    protected MLSyncUpNodeResponse nodeOperation(MLSyncUpNodeRequest request) {
        return this.createSyncUpNodeResponse(request.getSyncUpNodesRequest());
    }

    private MLSyncUpNodeResponse createSyncUpNodeResponse(MLSyncUpNodesRequest syncUpNodesRequest) {
        MLSyncUpInput syncUpInput = syncUpNodesRequest.getSyncUpInput();
        Map addedWorkerNodes = syncUpInput.getAddedWorkerNodes();
        Map removedWorkerNodes = syncUpInput.getRemovedWorkerNodes();
        Map modelRoutingTable = syncUpInput.getModelRoutingTable();
        Map runningDeployModelTasks = syncUpInput.getRunningDeployModelTasks();
        Map deployToAllNodes = syncUpInput.getDeployToAllNodes();
        if (addedWorkerNodes != null && addedWorkerNodes.size() > 0) {
            for (Map.Entry entry : addedWorkerNodes.entrySet()) {
                this.mlModelManager.addModelWorkerNode((String)entry.getKey(), (String[])entry.getValue());
            }
        }
        if (removedWorkerNodes != null && removedWorkerNodes.size() > 0) {
            for (Map.Entry entry : removedWorkerNodes.entrySet()) {
                this.mlModelManager.removeModelWorkerNode((String)entry.getKey(), Optional.ofNullable(deployToAllNodes).orElse(Map.of()).containsKey(entry.getKey()), (String[])entry.getValue());
            }
        }
        String[] deployedModelIds = null;
        String[] runningDeployModelTaskIds = null;
        String[] runningDeployModelIds = null;
        String[] expiredModelIds = null;
        if (syncUpInput.isGetDeployedModels()) {
            deployedModelIds = this.mlModelManager.getLocalDeployedModels();
            List<String[]> localRunningDeployModel = this.mlTaskManager.getLocalRunningDeployModelTasks();
            runningDeployModelTaskIds = localRunningDeployModel.get(0);
            runningDeployModelIds = localRunningDeployModel.get(1);
            expiredModelIds = this.mlModelManager.getExpiredModels();
        }
        if (syncUpInput.isClearRoutingTable()) {
            this.mlModelManager.clearRoutingTable();
        } else if (modelRoutingTable != null) {
            for (Map.Entry entry : modelRoutingTable.entrySet()) {
                log.debug("latest routing table for model: {}:  {}", entry.getKey(), (Object)((Set)entry.getValue()).toArray(new String[0]));
            }
            this.mlModelManager.syncModelWorkerNodes(modelRoutingTable);
        }
        this.cleanUpLocalCache(runningDeployModelTasks);
        this.cleanUpLocalCacheFiles();
        return new MLSyncUpNodeResponse(this.clusterService.localNode(), "ok", deployedModelIds, runningDeployModelIds, runningDeployModelTaskIds, expiredModelIds);
    }

    void cleanUpLocalCache(Map<String, Set<String>> runningDeployModelTasks) {
        String[] allTaskIds = this.mlTaskManager.getAllTaskIds();
        if (allTaskIds == null) {
            return;
        }
        for (String taskId : allTaskIds) {
            MLTaskCache mlTaskCache;
            if (taskId == null || (mlTaskCache = this.mlTaskManager.getMLTaskCache(taskId)) == null) continue;
            MLTask mlTask = mlTaskCache.getMlTask();
            Instant lastUpdateTime = mlTask.getLastUpdateTime();
            Instant now = Instant.now();
            if (!now.isAfter(lastUpdateTime.plusSeconds(this.mlTaskTimeout.intValue()))) continue;
            log.info("ML task timeout. task id: {}, task type: {}", (Object)taskId, (Object)mlTask.getTaskType());
            if (mlTask.getTaskType() == MLTaskType.DEPLOY_MODEL && mlTask.getState() == MLTaskState.CREATED && runningDeployModelTasks != null && runningDeployModelTasks.containsKey(taskId)) continue;
            this.mlTaskManager.updateMLTask(taskId, null, Map.of("state", MLTaskState.FAILED, "error", "timeout after " + this.mlTaskTimeout + " seconds"), 10000L, true);
        }
    }

    private void cleanUpLocalCacheFiles() {
        Path modelCacheRootPath;
        Path deployModelRootPath;
        Path registerModelRootPath = this.mlEngine.getRegisterModelRootPath();
        Set modelsInCacheFolder = FileUtils.getFileNames((Path[])new Path[]{registerModelRootPath, deployModelRootPath = this.mlEngine.getDeployModelRootPath(), modelCacheRootPath = this.mlEngine.getModelCacheRootPath()});
        if (!modelsInCacheFolder.isEmpty()) {
            log.debug("Found {} models in cache folder: {}", (Object)modelsInCacheFolder.size(), (Object)Arrays.toString(modelsInCacheFolder.toArray(new String[0])));
            for (String modelId : modelsInCacheFolder) {
                if (this.mlTaskManager.contains(modelId) || this.mlTaskManager.containsModel(modelId) || this.mlModelManager.isModelRunningOnNode(modelId)) continue;
                log.info("ML model not in cache. Remove all of its cache files. model id: {}", (Object)modelId);
                this.deleteFileCache(modelId);
            }
        }
    }

    private void deleteFileCache(String modelId) {
        FileUtils.deleteFileQuietly((Path)this.mlEngine.getModelCachePath(modelId));
        FileUtils.deleteFileQuietly((Path)this.mlEngine.getDeployModelPath(modelId));
        FileUtils.deleteFileQuietly((Path)this.mlEngine.getRegisterModelPath(modelId));
    }
}

