/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.tasks;

import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.delete.DeleteRequest;
import io.skylite.core.action.delete.DeleteResponse;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.client.metadata.DeleteDataObjectRequest;
import io.skylite.core.client.metadata.DeleteDataObjectResponse;
import io.skylite.core.client.metadata.GetDataObjectRequest;
import io.skylite.core.client.metadata.GetDataObjectResponse;
import io.skylite.core.client.metadata.MetadataClient;
import io.skylite.core.common.Strings;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.task.MLTask;
import io.skylite.ml.common.task.MLTaskState;
import io.skylite.ml.common.transport.task.MLTaskDeleteRequest;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeleteTaskTransportAction
extends HandledTransportAction<ActionRequest, DeleteResponse> {
    private static final Logger log = LogManager.getLogger(DeleteTaskTransportAction.class);
    private final Client client;
    private final MetadataClient sdkClient;
    private final NamedXContentRegistry xContentRegistry;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public DeleteTaskTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, MetadataClient sdkClient, NamedXContentRegistry xContentRegistry, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/lucenia/ml/tasks/delete", transportService, actionFilters, MLTaskDeleteRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.xContentRegistry = xContentRegistry;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<DeleteResponse> actionListener) {
        MLTaskDeleteRequest mlTaskDeleteRequest = MLTaskDeleteRequest.fromActionRequest((ActionRequest)request);
        String taskId = mlTaskDeleteRequest.getTaskId();
        String tenantId = mlTaskDeleteRequest.getTenantId();
        if (!TenantAwareHelper.validateTenantId((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, actionListener)) {
            return;
        }
        FetchSourceContext fetchSourceContext = new FetchSourceContext(true, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY);
        GetDataObjectRequest getDataObjectRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-task")).id(taskId)).fetchSourceContext(fetchSourceContext).tenantId(tenantId)).build();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListenerHelper.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore());
            this.sdkClient.getDataObjectAsync(getDataObjectRequest).whenComplete((getDataObjectResponse, throwable) -> {
                if (throwable != null) {
                    this.handleGetError((Throwable)throwable, taskId, (ActionListener<DeleteResponse>)wrappedListener);
                    return;
                }
                this.processGetDataObjectResponse((GetDataObjectResponse)getDataObjectResponse, taskId, tenantId, (ActionListener<DeleteResponse>)wrappedListener);
            });
        }
        catch (Exception e) {
            log.error("Failed to delete ML task {}", (Object)taskId);
            actionListener.onFailure(e);
        }
    }

    private void handleGetError(Throwable throwable, String taskId, ActionListener<DeleteResponse> actionListener) {
        Exception rootCause = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
        if (SkyliteExceptionsHelper.unwrap((Throwable)rootCause, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
            log.error("Failed to find task index", (Throwable)rootCause);
            actionListener.onFailure((Exception)new SkyliteStatusException("Failed to find task", RestStatus.NOT_FOUND, (Throwable)rootCause, new Object[0]));
        } else {
            log.error("Failed to get ML task {}", (Object)taskId);
            actionListener.onFailure(rootCause);
        }
    }

    private void processGetDataObjectResponse(GetDataObjectResponse getDataObjectResponse, String taskId, String tenantId, ActionListener<DeleteResponse> actionListener) {
        try {
            GetResponse getResponse;
            GetResponse getResponse2 = getResponse = getDataObjectResponse.parser() == null ? null : GetResponse.fromXContent((XContentParser)getDataObjectResponse.parser());
            if (getResponse == null || !getResponse.isExists()) {
                actionListener.onFailure((Exception)new SkyliteStatusException("Failed to find task", RestStatus.NOT_FOUND, new Object[0]));
                return;
            }
            this.processTask(getResponse, taskId, tenantId, actionListener);
        }
        catch (Exception e) {
            log.error("Failed to parse GetDataObjectResponse for task {}", (Object)taskId);
            actionListener.onFailure(e);
        }
    }

    private void processTask(GetResponse getResponse, String taskId, String tenantId, ActionListener<DeleteResponse> actionListener) {
        try (XContentParser parser = MediaTypeRegistry.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, getResponse.getSourceAsString());){
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            MLTask mlTask = MLTask.parse((XContentParser)parser);
            if (!TenantAwareHelper.validateTenantResource((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, (String)mlTask.getTenantId(), actionListener)) {
                return;
            }
            if (mlTask.getState() == MLTaskState.RUNNING) {
                actionListener.onFailure(new Exception("Task cannot be deleted in running state. Try after some time."));
            } else {
                this.executeDelete(taskId, tenantId, actionListener);
            }
        }
        catch (Exception e) {
            log.error("Failed to parse ML task {}", (Object)taskId);
            actionListener.onFailure(e);
        }
    }

    private void executeDelete(String taskId, String tenantId, ActionListener<DeleteResponse> actionListener) {
        DeleteRequest deleteRequest = new DeleteRequest(".plugins-ml-task", taskId);
        try {
            this.sdkClient.deleteDataObjectAsync(((DeleteDataObjectRequest.Builder)((DeleteDataObjectRequest.Builder)((DeleteDataObjectRequest.Builder)DeleteDataObjectRequest.builder().index(deleteRequest.index())).id(deleteRequest.id())).tenantId(tenantId)).build()).whenComplete((deleteDataObjectResponse, throwable) -> {
                if (throwable != null) {
                    this.handleDeleteError((Throwable)throwable, taskId, actionListener);
                    return;
                }
                this.processDeleteResponse((DeleteDataObjectResponse)deleteDataObjectResponse, actionListener);
            });
        }
        catch (Exception e) {
            log.error("Failed to delete ML task: {}", (Object)taskId);
            actionListener.onFailure(e);
        }
    }

    private void handleDeleteError(Throwable throwable, String taskId, ActionListener<DeleteResponse> actionListener) {
        Exception cause = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
        log.error("Failed to delete ML task: {}", (Object)taskId);
        actionListener.onFailure(cause);
    }

    private void processDeleteResponse(DeleteDataObjectResponse deleteDataObjectResponse, ActionListener<DeleteResponse> actionListener) {
        try {
            DeleteResponse deleteResponse = DeleteResponse.fromXContent((XContentParser)deleteDataObjectResponse.parser());
            log.info("Task deletion result: {}, task id: {}", (Object)deleteResponse.getResult(), (Object)deleteResponse.getId());
            actionListener.onResponse((Object)deleteResponse);
        }
        catch (IOException e) {
            actionListener.onFailure((Exception)e);
        }
    }
}

