/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.tasks;

import io.lucenia.ml.common.engine.encryptors.AWSEncryptorImpl;
import io.lucenia.ml.common.helpers.ConnectorAccessControlHelper;
import io.lucenia.ml.common.model.MLModelManager;
import io.lucenia.ml.common.model.ModelAccessControlHelper;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.lucenia.ml.common.task.MLTaskManager;
import io.skylite.ResourceNotFoundException;
import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.update.UpdateResponse;
import io.skylite.core.client.Client;
import io.skylite.core.client.ReleasableSkyliteClient;
import io.skylite.core.client.metadata.GetDataObjectRequest;
import io.skylite.core.client.metadata.GetDataObjectResponse;
import io.skylite.core.client.metadata.MetadataClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.Strings;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.script.ScriptService;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.connector.Connector;
import io.skylite.ml.common.connector.ConnectorAction;
import io.skylite.ml.common.dataset.MLInputDataset;
import io.skylite.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import io.skylite.ml.common.engine.MLEngine;
import io.skylite.ml.common.engine.MLEngineClassLoader;
import io.skylite.ml.common.exception.MLExceptionUtils;
import io.skylite.ml.common.exception.MLValidationException;
import io.skylite.ml.common.input.MLInput;
import io.skylite.ml.common.model.MLModel;
import io.skylite.ml.common.output.model.ModelTensor;
import io.skylite.ml.common.output.model.ModelTensorOutput;
import io.skylite.ml.common.output.model.ModelTensors;
import io.skylite.ml.common.remote.ConnectorUtils;
import io.skylite.ml.common.remote.RemoteConnectorExecutor;
import io.skylite.ml.common.settings.MLCommonsSettings;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.task.MLTask;
import io.skylite.ml.common.task.MLTaskState;
import io.skylite.ml.common.task.MLTaskType;
import io.skylite.ml.common.transport.MLTaskResponse;
import io.skylite.ml.common.transport.task.MLTaskGetRequest;
import io.skylite.ml.common.transport.task.MLTaskGetResponse;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GetTaskTransportAction
extends HandledTransportAction<ActionRequest, MLTaskGetResponse> {
    private static final Logger log = LogManager.getLogger(GetTaskTransportAction.class);
    Client client;
    MetadataClient sdkClient;
    NamedXContentRegistry xContentRegistry;
    ClusterService clusterService;
    ScriptService scriptService;
    ConnectorAccessControlHelper connectorAccessControlHelper;
    ModelAccessControlHelper modelAccessControlHelper;
    AWSEncryptorImpl encryptor;
    MLModelManager mlModelManager;
    MLTaskManager mlTaskManager;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;
    volatile List<String> remoteJobStatusFields;
    volatile Pattern remoteJobCompletedStatusRegexPattern;
    volatile Pattern remoteJobCancelledStatusRegexPattern;
    volatile Pattern remoteJobCancellingStatusRegexPattern;
    volatile Pattern remoteJobExpiredStatusRegexPattern;
    volatile Pattern remoteJobFailedStatusRegexPattern;
    private final MLEngine mlEngine;

    @Inject
    public GetTaskTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, MetadataClient sdkClient, NamedXContentRegistry xContentRegistry, ClusterService clusterService, ScriptService scriptService, ConnectorAccessControlHelper connectorAccessControlHelper, ModelAccessControlHelper modelAccessControlHelper, AWSEncryptorImpl encryptor, MLTaskManager mlTaskManager, MLModelManager mlModelManager, MLFeatureEnabledSetting mlFeatureEnabledSetting, Settings settings, MLEngine mlEngine) {
        super("cluster:admin/lucenia/ml/tasks/get", transportService, actionFilters, MLTaskGetRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.scriptService = scriptService;
        this.connectorAccessControlHelper = connectorAccessControlHelper;
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.encryptor = encryptor;
        this.mlTaskManager = mlTaskManager;
        this.mlModelManager = mlModelManager;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        this.mlEngine = mlEngine;
        this.remoteJobStatusFields = (List)MLCommonsSettings.ML_COMMONS_REMOTE_JOB_STATUS_FIELD.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_REMOTE_JOB_STATUS_FIELD, it -> {
            this.remoteJobStatusFields = it;
        });
        this.initializeRegexPattern((Setting<String>)MLCommonsSettings.ML_COMMONS_REMOTE_JOB_STATUS_COMPLETED_REGEX, settings, clusterService, regex -> {
            this.remoteJobCompletedStatusRegexPattern = Pattern.compile(regex, 2);
        });
        this.initializeRegexPattern((Setting<String>)MLCommonsSettings.ML_COMMONS_REMOTE_JOB_STATUS_CANCELLED_REGEX, settings, clusterService, regex -> {
            this.remoteJobCancelledStatusRegexPattern = Pattern.compile(regex, 2);
        });
        this.initializeRegexPattern((Setting<String>)MLCommonsSettings.ML_COMMONS_REMOTE_JOB_STATUS_CANCELLING_REGEX, settings, clusterService, regex -> {
            this.remoteJobCancellingStatusRegexPattern = Pattern.compile(regex, 2);
        });
        this.initializeRegexPattern((Setting<String>)MLCommonsSettings.ML_COMMONS_REMOTE_JOB_STATUS_EXPIRED_REGEX, settings, clusterService, regex -> {
            this.remoteJobExpiredStatusRegexPattern = Pattern.compile(regex, 2);
        });
        this.initializeRegexPattern((Setting<String>)MLCommonsSettings.ML_COMMONS_REMOTE_JOB_STATUS_FAILED_REGEX, settings, clusterService, regex -> {
            this.remoteJobFailedStatusRegexPattern = Pattern.compile(regex, 2);
        });
    }

    private void initializeRegexPattern(Setting<String> setting, Settings settings, ClusterService clusterService, Consumer<String> patternInitializer) {
        String regex = (String)setting.get(settings);
        patternInitializer.accept(regex);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(setting, it -> patternInitializer.accept((String)it));
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLTaskGetResponse> actionListener) {
        MLTaskGetRequest mlTaskGetRequest = MLTaskGetRequest.fromActionRequest((ActionRequest)request);
        String taskId = mlTaskGetRequest.getTaskId();
        Boolean isUserInitiatedGetTaskRequest = mlTaskGetRequest.isUserInitiatedGetTaskRequest();
        String tenantId = mlTaskGetRequest.getTenantId();
        if (!TenantAwareHelper.validateTenantId((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, actionListener)) {
            return;
        }
        FetchSourceContext fetchSourceContext = new FetchSourceContext(true, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY);
        GetDataObjectRequest getDataObjectRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-task")).id(taskId)).tenantId(tenantId)).fetchSourceContext(fetchSourceContext).build();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.sdkClient.getDataObjectAsync(getDataObjectRequest).whenComplete((r, throwable) -> {
                context.restore();
                this.handleAsyncResponse((GetDataObjectResponse)r, (Throwable)throwable, taskId, isUserInitiatedGetTaskRequest, tenantId, actionListener);
            });
        }
        catch (Exception e) {
            log.error("Failed to get ML task {}", (Object)taskId);
            actionListener.onFailure(e);
        }
    }

    private void handleAsyncResponse(GetDataObjectResponse response, Throwable throwable, String taskId, Boolean isUserInitiatedGetTaskRequest, String tenantId, ActionListener<MLTaskGetResponse> actionListener) {
        log.debug("Completed Get task Request, id:{}", (Object)taskId);
        if (throwable != null) {
            this.handleThrowable(throwable, taskId, actionListener);
            return;
        }
        this.processResponse(response, taskId, isUserInitiatedGetTaskRequest, tenantId, actionListener);
    }

    private void handleThrowable(Throwable throwable, String taskId, ActionListener<MLTaskGetResponse> actionListener) {
        Exception cause = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
        if (SkyliteExceptionsHelper.unwrap((Throwable)cause, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
            log.error("Failed to get task index", (Throwable)cause);
            actionListener.onFailure((Exception)new SkyliteStatusException("Failed to find task", RestStatus.NOT_FOUND, new Object[0]));
        } else {
            log.error("Failed to get ML task {}", (Object)taskId);
            actionListener.onFailure(cause);
        }
    }

    private void processResponse(GetDataObjectResponse response, String taskId, Boolean isUserInitiatedGetTaskRequest, String tenantId, ActionListener<MLTaskGetResponse> actionListener) {
        try {
            GetResponse gr;
            GetResponse getResponse = gr = response.parser() == null ? null : GetResponse.fromXContent((XContentParser)response.parser());
            if (gr == null || !gr.isExists()) {
                actionListener.onFailure((Exception)new SkyliteStatusException("Failed to find task", RestStatus.NOT_FOUND, new Object[0]));
                return;
            }
            this.parseAndHandleTask(gr, taskId, isUserInitiatedGetTaskRequest, tenantId, actionListener);
        }
        catch (Exception e) {
            log.error("Failed to parse GetDataObjectResponse for task {}", (Object)taskId);
            actionListener.onFailure(e);
        }
    }

    private void parseAndHandleTask(GetResponse gr, String taskId, Boolean isUserInitiatedGetTaskRequest, String tenantId, ActionListener<MLTaskGetResponse> actionListener) {
        try (XContentParser parser = MediaTypeRegistry.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, gr.getSourceAsString());){
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            MLTask mlTask = MLTask.parse((XContentParser)parser);
            if (!TenantAwareHelper.validateTenantResource((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, (String)mlTask.getTenantId(), actionListener)) {
                return;
            }
            if (mlTask.getTaskType() == MLTaskType.BATCH_PREDICTION && !this.mlFeatureEnabledSetting.isOfflineBatchInferenceEnabled().booleanValue()) {
                throw new IllegalStateException("Offline Batch Inference is currently disabled. To enable it, update the setting \"plugins.ml_commons.offline_batch_inference_enabled\" to true.");
            }
            if (mlTask.getTaskType() == MLTaskType.BATCH_PREDICTION && mlTask.getFunctionName() == FunctionName.REMOTE) {
                this.processRemoteBatchPrediction(mlTask, taskId, isUserInitiatedGetTaskRequest, tenantId, actionListener);
            } else {
                actionListener.onResponse((Object)MLTaskGetResponse.builder().mlTask(mlTask).build());
            }
        }
        catch (Exception e) {
            log.error("Failed to parse ML task {}", (Object)taskId);
            actionListener.onFailure(e);
        }
    }

    private void processRemoteBatchPrediction(MLTask mlTask, String taskId, Boolean isUserInitiatedGetTaskRequest, String tenantId, ActionListener<MLTaskGetResponse> actionListener) {
        Map remoteJob = mlTask.getRemoteJob();
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (Map.Entry entry : remoteJob.entrySet()) {
            if (entry.getValue() instanceof String) {
                parameters.put((String)entry.getKey(), (String)entry.getValue());
                continue;
            }
            log.debug("Value for key {} is not a String", entry.getKey());
        }
        parameters.computeIfAbsent("TransformJobName", key -> Optional.ofNullable((String)parameters.get("TransformJobArn")).map(jobArn -> jobArn.substring(jobArn.lastIndexOf("/") + 1)).orElse(null));
        RemoteInferenceInputDataSet inferenceInputDataSet = new RemoteInferenceInputDataSet(parameters, ConnectorAction.ActionType.BATCH_PREDICT_STATUS, null);
        MLInput mlInput = MLInput.builder().algorithm(FunctionName.REMOTE).inputDataset((MLInputDataset)inferenceInputDataSet).build();
        String modelId = mlTask.getModelId();
        User user = RestActionUtils.getUserContext(this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener getModelListener = ActionListenerHelper.wrap(model -> this.modelAccessControlHelper.validateModelGroupAccess(user, this.mlFeatureEnabledSetting, tenantId, model.getModelGroupId(), this.client, this.sdkClient, (ActionListener<Boolean>)ActionListenerHelper.wrap(access -> {
                if (!access.booleanValue()) {
                    actionListener.onFailure((Exception)new MLValidationException("You don't have permission to access this batch job"));
                } else if (model.getConnector() != null) {
                    Connector connector2 = model.getConnector();
                    this.executeConnector(connector2, mlInput, taskId, isUserInitiatedGetTaskRequest, mlTask, remoteJob, actionListener);
                } else if (this.clusterService.state().metadata().hasIndex(".plugins-ml-connector")) {
                    ActionListener listener = ActionListenerHelper.wrap(connector -> this.executeConnector((Connector)connector, mlInput, taskId, isUserInitiatedGetTaskRequest, mlTask, remoteJob, actionListener), e -> {
                        log.error("Failed to get connector {}", (Object)model.getConnectorId());
                        actionListener.onFailure(e);
                    });
                    try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
                        this.connectorAccessControlHelper.getConnector(this.client, model.getConnectorId(), (ActionListener<Connector>)ActionListenerHelper.runBefore((ActionListener)listener, () -> ((ThreadContext.StoredContext)threadContext).restore()));
                    }
                } else {
                    actionListener.onFailure((Exception)new ResourceNotFoundException("Can't find connector " + model.getConnectorId(), new Object[0]));
                }
            }, e -> {
                log.error("Failed to validate Access for Model Group {}", (Object)model.getModelGroupId());
                actionListener.onFailure(e);
            })), e -> {
                log.error("Failed to retrieve the ML model for the given task ID", (Throwable)e);
                actionListener.onFailure((Exception)new SkyliteStatusException("Failed to retrieve the ML model for the given task ID", RestStatus.NOT_FOUND, new Object[0]));
            });
            this.mlModelManager.getModel(modelId, null, null, (ActionListener<MLModel>)ActionListenerHelper.runBefore((ActionListener)getModelListener, () -> ((ThreadContext.StoredContext)context).restore()));
        }
        catch (Exception e2) {
            log.error("Unable to fetch status for ml task ", (Throwable)e2);
            throw new SkyliteException("Unable to fetch status for ml task " + e2.getMessage(), new Object[0]);
        }
    }

    private void executeConnector(Connector connector, MLInput mlInput, String taskId, Boolean isUserInitiatedGetTaskRequest, MLTask mlTask, Map<String, Object> remoteJob, ActionListener<MLTaskGetResponse> actionListener) {
        Optional batchPredictStatusAction = connector.findAction(ConnectorAction.ActionType.BATCH_PREDICT_STATUS.name());
        if (batchPredictStatusAction.isEmpty() || ((ConnectorAction)batchPredictStatusAction.get()).getRequestBody() == null) {
            ConnectorAction connectorAction = ConnectorUtils.createConnectorAction((Connector)connector, (ConnectorAction.ActionType)ConnectorAction.ActionType.BATCH_PREDICT_STATUS);
            connector.addAction(connectorAction);
        }
        Map decryptedCredential = connector.getDecryptedCredential() != null && !connector.getDecryptedCredential().isEmpty() ? this.mlEngine.getConnectorCredential(connector) : connector.getDecryptedCredential();
        RemoteConnectorExecutor connectorExecutor = (RemoteConnectorExecutor)MLEngineClassLoader.initInstance((Object)connector.getProtocol(), (Object)connector, Connector.class);
        connectorExecutor.setScriptService(this.scriptService);
        connectorExecutor.setClusterService(this.clusterService);
        connectorExecutor.setClient((ReleasableSkyliteClient)this.client);
        connectorExecutor.setXContentRegistry(this.xContentRegistry);
        connectorExecutor.executeAction(ConnectorAction.ActionType.BATCH_PREDICT_STATUS.name(), mlInput, ActionListenerHelper.wrap(taskResponse -> this.processTaskResponse(mlTask, taskId, isUserInitiatedGetTaskRequest, (MLTaskResponse)taskResponse, remoteJob, decryptedCredential, actionListener), e -> {
            if (!isUserInitiatedGetTaskRequest.booleanValue()) {
                HashMap<String, Object> updatedTask = new HashMap<String, Object>();
                Integer numberOfRetries = remoteJob.getOrDefault("num_of_retries", 0);
                numberOfRetries = numberOfRetries + 1;
                remoteJob.put("num_of_retries", numberOfRetries);
                if (numberOfRetries > 10) {
                    log.debug("Limit exceeded trying to reach the task {} . Marking as UNREACHABLE in task index and removing from further execution", (Object)taskId);
                    updatedTask.put("state", MLTaskState.UNREACHABLE);
                    mlTask.setState(MLTaskState.UNREACHABLE);
                    mlTask.setError(e.getMessage());
                    this.updateDLQ(mlTask, decryptedCredential);
                }
                updatedTask.put("remote_job", remoteJob);
                this.mlTaskManager.updateMLTaskDirectly(taskId, updatedTask);
            }
            actionListener.onFailure(e);
        }));
    }

    protected void processTaskResponse(MLTask mlTask, String taskId, Boolean isUserInitiatedGetTaskRequest, MLTaskResponse taskResponse, Map<String, Object> remoteJob, Map<String, String> decryptedCredential, ActionListener<MLTaskGetResponse> actionListener) {
        try {
            ModelTensorOutput tensorOutput = (ModelTensorOutput)taskResponse.getOutput();
            if (tensorOutput != null && tensorOutput.getMlModelOutputs() != null && !tensorOutput.getMlModelOutputs().isEmpty()) {
                ModelTensors modelOutput = (ModelTensors)tensorOutput.getMlModelOutputs().get(0);
                if (modelOutput.getMlModelTensors() != null && !modelOutput.getMlModelTensors().isEmpty()) {
                    Map remoteJobStatus = ((ModelTensor)modelOutput.getMlModelTensors().get(0)).getDataAsMap();
                    if (remoteJobStatus != null) {
                        remoteJob.putAll(remoteJobStatus);
                        HashMap<String, Object> updatedTask = new HashMap<String, Object>();
                        updatedTask.put("remote_job", remoteJob);
                        mlTask.setRemoteJob(remoteJob);
                        for (String statusField : this.remoteJobStatusFields) {
                            String statusValue = String.valueOf(remoteJob.get(statusField));
                            if (!remoteJob.containsKey(statusField)) continue;
                            this.updateTaskState(updatedTask, mlTask, statusValue);
                        }
                        this.mlTaskManager.updateMLTaskDirectly(taskId, updatedTask, (ActionListener<UpdateResponse>)ActionListenerHelper.wrap(response -> {
                            if (mlTask.getState().equals((Object)MLTaskState.FAILED) && !isUserInitiatedGetTaskRequest.booleanValue()) {
                                this.updateDLQ(mlTask, decryptedCredential);
                            }
                            actionListener.onResponse((Object)MLTaskGetResponse.builder().mlTask(mlTask).build());
                        }, e -> {
                            MLExceptionUtils.logException((String)"Failed to update task for batch predict model", (Exception)e, (Logger)log);
                            actionListener.onFailure(e);
                        }));
                    } else {
                        log.debug("Transform job status is null.");
                        actionListener.onFailure((Exception)new ResourceNotFoundException("Couldn't fetch status of the transform job", new Object[0]));
                    }
                } else {
                    log.debug("ML Model Tensors are null or empty.");
                    actionListener.onFailure((Exception)new ResourceNotFoundException("Couldn't fetch status of the transform job", new Object[0]));
                }
            } else {
                log.debug("ML Model Outputs are null or empty.");
                actionListener.onFailure((Exception)new ResourceNotFoundException("Couldn't fetch status of the transform job", new Object[0]));
            }
        }
        catch (Exception e2) {
            log.error("Unable to fetch status for ml task ", (Throwable)e2);
        }
    }

    protected void updateDLQ(MLTask mlTask, Map<String, String> decryptedCredential) {
        Map remoteJob = mlTask.getRemoteJob();
        Map dlq = (Map)remoteJob.get("dlq");
        if (dlq != null && !dlq.isEmpty()) {
            String taskId = mlTask.getTaskId();
            try {
                Map remoteJobDetails = mlTask.getRemoteJob();
                String accessKey = decryptedCredential.get("access_key");
                String secretKey = decryptedCredential.get("secret_key");
                String sessionToken = decryptedCredential.get("session_token");
                String bucketName = (String)dlq.get("bucket");
                String region = (String)dlq.get("region");
                if (bucketName == null || region == null) {
                    log.error("Failed to get the bucket name and region from batch predict request");
                }
                remoteJobDetails.remove("dlq");
                String jobName = (String)remoteJobDetails.getOrDefault("TransformJobName", remoteJob.get("job_name"));
                String s3ObjectKey = "BatchJobFailure_" + jobName;
                String content = mlTask.getState().equals((Object)MLTaskState.UNREACHABLE) ? String.format(Locale.ROOT, "Unable to reach the Job: %s. Error Message: %s", jobName, mlTask.getError()) : remoteJobDetails.toString();
                log.debug("Task status successfully uploaded to S3 for task ID: {} at {}", (Object)taskId, (Object)Instant.now());
            }
            catch (Exception e) {
                log.error("Failed to update task status for task: " + taskId, (Throwable)e);
            }
        }
    }

    private void updateTaskState(Map<String, Object> updatedTask, MLTask mlTask, String statusValue) {
        if (this.matchesPattern(this.remoteJobCancellingStatusRegexPattern, statusValue)) {
            updatedTask.put("state", MLTaskState.CANCELLING);
            mlTask.setState(MLTaskState.CANCELLING);
        } else if (this.matchesPattern(this.remoteJobCancelledStatusRegexPattern, statusValue)) {
            updatedTask.put("state", MLTaskState.CANCELLED);
            mlTask.setState(MLTaskState.CANCELLED);
        } else if (this.matchesPattern(this.remoteJobCompletedStatusRegexPattern, statusValue)) {
            updatedTask.put("state", MLTaskState.COMPLETED);
            mlTask.setState(MLTaskState.COMPLETED);
        } else if (this.matchesPattern(this.remoteJobExpiredStatusRegexPattern, statusValue)) {
            updatedTask.put("state", MLTaskState.EXPIRED);
            mlTask.setState(MLTaskState.EXPIRED);
        } else if (this.matchesPattern(this.remoteJobFailedStatusRegexPattern, statusValue)) {
            updatedTask.put("state", MLTaskState.FAILED);
            mlTask.setState(MLTaskState.FAILED);
        }
    }

    private boolean matchesPattern(Pattern pattern, String input) {
        Matcher matcher = pattern.matcher(input);
        return matcher.find();
    }
}

