/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.undeploy;

import io.lucenia.ml.common.model.MLModelManager;
import io.lucenia.ml.common.model.ModelAccessControlHelper;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.lucenia.ml.common.task.MLTaskDispatcher;
import io.lucenia.ml.common.task.MLTaskManager;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.action.bulk.BulkRequest;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.update.UpdateRequest;
import io.skylite.core.client.Client;
import io.skylite.core.client.metadata.MetadataClient;
import io.skylite.core.client.metadata.SearchDataObjectRequest;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.TermQueryBuilder;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.SearchHit;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.ml.common.cluster.DiscoveryNodeHelper;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.engine.ModelDownloader;
import io.skylite.ml.common.model.MLModel;
import io.skylite.ml.common.model.MLModelState;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.deploy.MLDeployModelRequest;
import io.skylite.ml.common.transport.undeploy.MLUndeployModelAction;
import io.skylite.ml.common.transport.undeploy.MLUndeployModelNodesRequest;
import io.skylite.ml.common.transport.undeploy.MLUndeployModelNodesResponse;
import io.skylite.ml.common.transport.undeploy.MLUndeployModelsRequest;
import io.skylite.ml.common.transport.undeploy.MLUndeployModelsResponse;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.TermsQueryBuilder;

public class TransportUndeployModelsAction
extends HandledTransportAction<ActionRequest, MLUndeployModelsResponse> {
    private static final Logger log = LogManager.getLogger(TransportUndeployModelsAction.class);
    TransportService transportService;
    ModelDownloader modelHelper;
    MLTaskManager mlTaskManager;
    ClusterService clusterService;
    ThreadPool threadPool;
    Client client;
    MetadataClient sdkClient;
    Settings settings;
    NamedXContentRegistry xContentRegistry;
    DiscoveryNodeHelper nodeFilter;
    MLTaskDispatcher mlTaskDispatcher;
    MLModelManager mlModelManager;
    ModelAccessControlHelper modelAccessControlHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public TransportUndeployModelsAction(TransportService transportService, ActionFilters actionFilters, ModelDownloader modelHelper, MLTaskManager mlTaskManager, ClusterService clusterService, ThreadPool threadPool, Client client, MetadataClient sdkClient, Settings settings, NamedXContentRegistry xContentRegistry, DiscoveryNodeHelper nodeFilter, MLTaskDispatcher mlTaskDispatcher, MLModelManager mlModelManager, ModelAccessControlHelper modelAccessControlHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/lucenia/ml/undeploy_models", transportService, actionFilters, MLDeployModelRequest::new);
        this.transportService = transportService;
        this.modelHelper = modelHelper;
        this.mlTaskManager = mlTaskManager;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.client = client;
        this.sdkClient = sdkClient;
        this.xContentRegistry = xContentRegistry;
        this.nodeFilter = nodeFilter;
        this.mlTaskDispatcher = mlTaskDispatcher;
        this.mlModelManager = mlModelManager;
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.settings = settings;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLUndeployModelsResponse> listener) {
        MLUndeployModelsRequest undeployModelsRequest = MLUndeployModelsRequest.fromActionRequest((ActionRequest)request);
        String[] modelIds = undeployModelsRequest.getModelIds();
        String tenantId = undeployModelsRequest.getTenantId();
        String[] targetNodeIds = undeployModelsRequest.getNodeIds();
        if (!TenantAwareHelper.validateTenantId((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, listener)) {
            return;
        }
        if (modelIds == null) {
            listener.onFailure((Exception)new IllegalArgumentException("Must set specific model ids to undeploy"));
            return;
        }
        if (modelIds.length == 1) {
            String modelId = modelIds[0];
            this.validateAccess(modelId, tenantId, (ActionListener<Boolean>)ActionListenerHelper.wrap(hasPermissionToUndeploy -> {
                if (hasPermissionToUndeploy.booleanValue()) {
                    this.undeployModels(targetNodeIds, modelIds, tenantId, listener);
                } else {
                    listener.onFailure((Exception)new IllegalArgumentException("No permission to undeploy model " + modelId));
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        } else {
            if (this.modelAccessControlHelper.isModelAccessControlEnabled()) {
                throw new IllegalArgumentException("only support undeploy one model");
            }
            this.searchHiddenModels(modelIds, (ActionListener<SearchResponse>)ActionListenerHelper.wrap(hiddenModels -> {
                if (hiddenModels != null && hiddenModels.getHits().getTotalHits() != null && hiddenModels.getHits().getTotalHits().value() != 0L && !this.isSuperAdminUserWrapper(this.clusterService, this.client)) {
                    List hiddenModelIds = Arrays.stream(hiddenModels.getHits().getHits()).map(SearchHit::getId).collect(Collectors.toList());
                    String[] modelsIDsToUndeploy = (String[])Arrays.stream(modelIds).filter(modelId -> !hiddenModelIds.contains(modelId)).toArray(String[]::new);
                    this.undeployModels(targetNodeIds, modelsIDsToUndeploy, tenantId, listener);
                } else {
                    this.undeployModels(targetNodeIds, modelIds, tenantId, listener);
                }
            }, e -> {
                log.error("Failed to search model index", (Throwable)e);
                listener.onFailure(e);
            }));
        }
    }

    private void undeployModels(String[] targetNodeIds, String[] modelIds, String tenantId, ActionListener<MLUndeployModelsResponse> listener) {
        MLUndeployModelNodesRequest mlUndeployModelNodesRequest = new MLUndeployModelNodesRequest(targetNodeIds, modelIds);
        mlUndeployModelNodesRequest.setTenantId(tenantId);
        this.client.execute((ActionType)MLUndeployModelAction.INSTANCE, (ActionRequest)mlUndeployModelNodesRequest, ActionListenerHelper.wrap(response -> {
            if (response.getNodes().isEmpty()) {
                this.bulkSetModelIndexToUndeploy(modelIds, listener, (MLUndeployModelNodesResponse)response);
                return;
            }
            listener.onResponse((Object)new MLUndeployModelsResponse(response));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void bulkSetModelIndexToUndeploy(String[] modelIds, ActionListener<MLUndeployModelsResponse> listener, MLUndeployModelNodesResponse response) {
        BulkRequest bulkUpdateRequest = new BulkRequest();
        for (String modelId : modelIds) {
            UpdateRequest updateRequest = new UpdateRequest();
            HashMap<String, Object> builder = new HashMap<String, Object>();
            builder.put("model_state", MLModelState.UNDEPLOYED.name());
            builder.put("planning_worker_nodes", List.of());
            builder.put("planning_worker_node_count", 0);
            builder.put("last_updated_time", Instant.now().toEpochMilli());
            builder.put("current_worker_node_count", 0);
            ((UpdateRequest)updateRequest.index(".plugins-ml-model")).id(modelId).doc(Map.copyOf(builder));
            bulkUpdateRequest.add(updateRequest);
        }
        bulkUpdateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        log.info("No nodes running these models: {}", (Object)Arrays.toString(modelIds));
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener listenerWithContextRestoration = ActionListenerHelper.runBefore(listener, () -> threadContext.restore());
            ActionListener bulkResponseListener = ActionListenerHelper.wrap(br -> {
                log.debug("Successfully set the following modelId(s) to UNDEPLOY in index: {}", (Object)Arrays.toString(modelIds));
                listenerWithContextRestoration.onResponse((Object)new MLUndeployModelsResponse(response));
            }, e -> {
                String modelsNotFoundMessage = String.format(Locale.ROOT, "Failed to set the following modelId(s) to UNDEPLOY in index: %s", Arrays.toString(modelIds));
                log.error(modelsNotFoundMessage, (Throwable)e);
                SkyliteStatusException exception = new SkyliteStatusException(modelsNotFoundMessage + e.getMessage(), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
                listenerWithContextRestoration.onFailure((Exception)exception);
            });
            this.client.bulk(bulkUpdateRequest, bulkResponseListener);
        }
        catch (Exception e2) {
            log.error("Unexpected error while setting the following modelId(s) to UNDEPLOY in index: {}", (Object)Arrays.toString(modelIds));
            listener.onFailure(e2);
        }
    }

    private void validateAccess(String modelId, String tenantId, ActionListener<Boolean> listener) {
        User user = RestActionUtils.getUserContext(this.client);
        boolean isSuperAdmin = this.isSuperAdminUserWrapper(this.clusterService, this.client);
        String[] excludes = new String[]{"model_content", "content"};
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.mlModelManager.getModel(modelId, tenantId, null, excludes, (ActionListener<MLModel>)ActionListenerHelper.runBefore((ActionListener)ActionListenerHelper.wrap(mlModel -> {
                if (!TenantAwareHelper.validateTenantResource((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, (String)mlModel.getTenantId(), (ActionListener)listener)) {
                    return;
                }
                Boolean isHidden = mlModel.getIsHidden();
                if (isHidden != null && isHidden.booleanValue()) {
                    if (isSuperAdmin) {
                        listener.onResponse((Object)true);
                    } else {
                        listener.onFailure((Exception)new SkyliteStatusException("User doesn't have privilege to perform this operation on this model", RestStatus.FORBIDDEN, new Object[0]));
                    }
                } else {
                    this.modelAccessControlHelper.validateModelGroupAccess(user, this.mlFeatureEnabledSetting, tenantId, mlModel.getModelGroupId(), this.client, this.sdkClient, listener);
                }
            }, e -> {
                log.error("Failed to find Model", (Throwable)e);
                listener.onFailure(e);
            }), () -> ((ThreadContext.StoredContext)context).restore()));
        }
        catch (Exception e2) {
            log.error("Failed to undeploy ML model");
            listener.onFailure(e2);
        }
    }

    public void searchHiddenModels(String[] modelIds, ActionListener<SearchResponse> listener) throws IllegalArgumentException {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            TermsQueryBuilder termsQuery = QueryBuilders.termsQuery((String)"_id", (String[])modelIds);
            TermQueryBuilder isHiddenQuery = QueryBuilders.termQuery((String)"is_hidden", (boolean)true);
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)termsQuery).must((QueryBuilder)isHiddenQuery).mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"chunk_number")));
            SearchRequest searchRequest = new SearchRequest(new String[]{".plugins-ml-model"}).source(searchSourceBuilder);
            SearchDataObjectRequest searchDataObjectRequest = SearchDataObjectRequest.builder().indices(searchRequest.indices()).searchSourceBuilder(searchRequest.source()).build();
            this.sdkClient.searchDataObjectAsync(searchDataObjectRequest).whenComplete((r, throwable) -> {
                context.restore();
                if (throwable != null) {
                    Exception cause = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                    log.error("Failed to search model index", (Throwable)cause);
                    if (SkyliteExceptionsHelper.unwrap((Throwable)cause, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
                        listener.onResponse(null);
                    } else {
                        listener.onFailure(cause);
                    }
                } else {
                    try {
                        SearchResponse searchResponse = SearchResponse.fromXContent((XContentParser)r.parser());
                        log.info("Model Index search complete: {}", (Object)searchResponse.getHits().getTotalHits());
                        listener.onResponse((Object)searchResponse);
                    }
                    catch (Exception e) {
                        log.error("Failed to parse search response", (Throwable)e);
                        listener.onFailure((Exception)new SkyliteStatusException("Failed to parse search response", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to search model index", (Throwable)e);
            listener.onFailure(e);
        }
    }

    boolean isSuperAdminUserWrapper(ClusterService clusterService, Client client) {
        return RestActionUtils.isSuperAdminUser(clusterService, client);
    }
}

