/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.update_cache;

import io.lucenia.action.support.nodes.TransportNodesAction;
import io.lucenia.ml.common.model.MLModelManager;
import io.lucenia.ml.common.model.ModelAccessControlHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.ml.common.cluster.DiscoveryNodeHelper;
import io.skylite.ml.common.stats.MLStats;
import io.skylite.ml.common.transport.update_cache.MLUpdateModelCacheNodeRequest;
import io.skylite.ml.common.transport.update_cache.MLUpdateModelCacheNodeResponse;
import io.skylite.ml.common.transport.update_cache.MLUpdateModelCacheNodesRequest;
import io.skylite.ml.common.transport.update_cache.MLUpdateModelCacheNodesResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdateModelCacheTransportAction
extends TransportNodesAction<MLUpdateModelCacheNodesRequest, MLUpdateModelCacheNodesResponse, MLUpdateModelCacheNodeRequest, MLUpdateModelCacheNodeResponse> {
    private static final Logger log = LogManager.getLogger(UpdateModelCacheTransportAction.class);
    private final MLModelManager mlModelManager;
    private final ClusterService clusterService;
    private final Client client;
    private DiscoveryNodeHelper nodeFilter;
    private final MLStats mlStats;
    private NamedXContentRegistry xContentRegistry;
    private ModelAccessControlHelper modelAccessControlHelper;

    @Inject
    public UpdateModelCacheTransportAction(TransportService transportService, ActionFilters actionFilters, MLModelManager mlModelManager, ClusterService clusterService, ThreadPool threadPool, Client client, DiscoveryNodeHelper nodeFilter, MLStats mlStats, NamedXContentRegistry xContentRegistry, ModelAccessControlHelper modelAccessControlHelper) {
        super("cluster:admin/lucenia/ml/models/update_cache", threadPool, clusterService, transportService, actionFilters, MLUpdateModelCacheNodesRequest::new, MLUpdateModelCacheNodeRequest::new, "management", MLUpdateModelCacheNodeResponse.class);
        this.mlModelManager = mlModelManager;
        this.clusterService = clusterService;
        this.client = client;
        this.nodeFilter = nodeFilter;
        this.mlStats = mlStats;
        this.xContentRegistry = xContentRegistry;
        this.modelAccessControlHelper = modelAccessControlHelper;
    }

    protected MLUpdateModelCacheNodesResponse newResponse(MLUpdateModelCacheNodesRequest nodesRequest, List<MLUpdateModelCacheNodeResponse> responses, List<FailedNodeException> failures) {
        return new MLUpdateModelCacheNodesResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected MLUpdateModelCacheNodeRequest newNodeRequest(MLUpdateModelCacheNodesRequest request) {
        return new MLUpdateModelCacheNodeRequest(request);
    }

    protected MLUpdateModelCacheNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new MLUpdateModelCacheNodeResponse(in);
    }

    protected MLUpdateModelCacheNodeResponse nodeOperation(MLUpdateModelCacheNodeRequest request) {
        return this.createUpdateModelCacheNodeResponse(request.getUpdateModelCacheNodesRequest());
    }

    private MLUpdateModelCacheNodeResponse createUpdateModelCacheNodeResponse(MLUpdateModelCacheNodesRequest mlUpdateModelCacheNodesRequest) {
        String modelId = mlUpdateModelCacheNodesRequest.getModelId();
        HashMap<String, String> modelUpdateStatus = new HashMap<String, String>();
        modelUpdateStatus.put(modelId, "received");
        String localNodeId = this.clusterService.localNode().getId();
        this.mlModelManager.updateModelCache(modelId, (ActionListener<String>)ActionListenerHelper.wrap(r -> log.info("Successfully performing in-place update model {} on node {}", (Object)modelId, (Object)localNodeId), e -> log.error("Failed to perform in-place update model for model {} on node {}", (Object)modelId, (Object)localNodeId)));
        return new MLUpdateModelCacheNodeResponse(this.clusterService.localNode(), modelUpdateStatus);
    }
}

