/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.autoredeploy;

import io.lucenia.ml.common.model.MLModelManager;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.search.SearchAction;
import io.skylite.core.action.search.SearchRequestBuilder;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.client.Client;
import io.skylite.core.client.SkyliteClient;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.Strings;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.search.SearchHit;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import io.skylite.core.search.sort.BaseSortBuilder;
import io.skylite.core.search.sort.FieldSortBuilder;
import io.skylite.core.search.sort.SortBuilders;
import io.skylite.core.search.sort.SortOrder;
import io.skylite.core.settings.Settings;
import io.skylite.ml.common.model.MLModelState;
import io.skylite.ml.common.settings.MLCommonsSettings;
import io.skylite.ml.common.transport.deploy.MLDeployModelAction;
import io.skylite.ml.common.transport.deploy.MLDeployModelRequest;
import io.skylite.ml.common.transport.undeploy.MLUndeployModelAction;
import io.skylite.ml.common.transport.undeploy.MLUndeployModelNodesRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.TermsQueryBuilder;

public class MLModelAutoReDeployer {
    private static final Logger log = LogManager.getLogger(MLModelAutoReDeployer.class);
    private final long nodeStartTimeMillis = System.currentTimeMillis();
    private final ClusterService clusterService;
    private final Client client;
    private final Settings settings;
    private boolean enableAutoReDeployModel;
    private boolean onlyRunOnMlNode;
    private int autoDeployMaxRetryTimes;
    private boolean allowCustomDeploymentPlan;
    private final MLModelManager mlModelManager;
    private final Queue<ModelAutoRedeployArrangement> modelAutoRedeployArrangements = new ConcurrentLinkedQueue<ModelAutoRedeployArrangement>();
    private final SearchRequestBuilderFactory searchRequestBuilderFactory;
    private ActionListener<Boolean> startCronJobListener;

    public MLModelAutoReDeployer(ClusterService clusterService, Client client, Settings settings, MLModelManager mlModelManager, SearchRequestBuilderFactory searchRequestBuilderFactory) {
        this.clusterService = clusterService;
        this.client = client;
        this.settings = settings;
        this.mlModelManager = mlModelManager;
        this.searchRequestBuilderFactory = searchRequestBuilderFactory;
        this.enableAutoReDeployModel = (Boolean)MLCommonsSettings.ML_COMMONS_MODEL_AUTO_REDEPLOY_ENABLE.get(settings);
        this.onlyRunOnMlNode = (Boolean)MLCommonsSettings.ML_COMMONS_ONLY_RUN_ON_ML_NODE.get(settings);
        this.autoDeployMaxRetryTimes = (Integer)MLCommonsSettings.ML_COMMONS_MODEL_AUTO_REDEPLOY_LIFETIME_RETRY_TIMES.get(settings);
        this.allowCustomDeploymentPlan = (Boolean)MLCommonsSettings.ML_COMMONS_ALLOW_CUSTOM_DEPLOYMENT_PLAN.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_MODEL_AUTO_REDEPLOY_ENABLE, it -> {
            this.enableAutoReDeployModel = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_ONLY_RUN_ON_ML_NODE, this.undeployModelsOnDataNodesConsumer());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_MODEL_AUTO_REDEPLOY_LIFETIME_RETRY_TIMES, it -> {
            this.autoDeployMaxRetryTimes = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_ALLOW_CUSTOM_DEPLOYMENT_PLAN, it -> {
            this.allowCustomDeploymentPlan = it;
        });
    }

    private void undeployModelsOnDataNodes() {
        ArrayList<String> dataNodeIds = new ArrayList<String>();
        this.clusterService.state().nodes().getDataNodes().values().iterator().forEachRemaining(x -> dataNodeIds.add(x.getId()));
        if (!dataNodeIds.isEmpty()) {
            this.triggerUndeployModelsOnDataNodes(dataNodeIds);
        }
    }

    Consumer<Boolean> undeployModelsOnDataNodesConsumer() {
        return x -> {
            this.onlyRunOnMlNode = x;
            if (this.onlyRunOnMlNode) {
                this.undeployModelsOnDataNodes();
            }
        };
    }

    public void buildAutoReloadArrangement(List<String> addedNodes, String clusterManagerNodeId) {
        if (!this.enableAutoReDeployModel) {
            log.info("Model auto reload configuration is false, not performing auto reloading!");
            this.startCronjobAndClearListener();
            return;
        }
        String localNodeId = this.clusterService.localNode().getId();
        if (Strings.isNullOrEmpty((String)localNodeId) || !localNodeId.equals(clusterManagerNodeId)) {
            log.info("model auto reloading should be initialized by cluster manager node only, current node id is empty or current node not cluster manager!");
            return;
        }
        this.triggerAutoDeployModels(addedNodes);
    }

    public void redeployAModel() {
        if (!this.enableAutoReDeployModel) {
            log.info("Model auto reload configuration is false, not performing auto reloading!");
            this.startCronjobAndClearListener();
            return;
        }
        if (this.modelAutoRedeployArrangements.isEmpty()) {
            log.info("No models needs to be auto redeployed!");
            this.startCronjobAndClearListener();
            return;
        }
        ModelAutoRedeployArrangement modelAutoRedeployArrangement = this.modelAutoRedeployArrangements.poll();
        this.triggerModelRedeploy(modelAutoRedeployArrangement);
    }

    private void triggerAutoDeployModels(List<String> addedNodes) {
        ActionListener listener = ActionListenerHelper.wrap(res -> {
            if (res != null && res.getHits() != null && res.getHits().getTotalHits() != null && res.getHits().getTotalHits().value() > 0L) {
                Arrays.stream(res.getHits().getHits()).filter(x -> x != null && x.getSourceAsMap() != null && Optional.ofNullable(x.getSourceAsMap().get("auto_redeploy_retry_times")).orElse(0) < this.autoDeployMaxRetryTimes).forEach(x -> {
                    ModelAutoRedeployArrangement modelAutoRedeployArrangement = ModelAutoRedeployArrangement.builder().addedNodes(addedNodes).searchResponse((SearchHit)x).build();
                    boolean notExist = this.modelAutoRedeployArrangements.stream().noneMatch(y -> y.equals(modelAutoRedeployArrangement));
                    if (notExist) {
                        this.modelAutoRedeployArrangements.add(modelAutoRedeployArrangement);
                    }
                });
                this.redeployAModel();
            } else {
                log.info("Could not find any models in the index, not performing auto reloading!");
                this.startCronjobAndClearListener();
            }
        }, e -> {
            boolean indexMissing = e instanceof IndexNotFoundException;
            if (indexMissing && System.currentTimeMillis() - this.nodeStartTimeMillis < TimeUnit.SECONDS.toMillis(60L)) {
                log.debug("Model index not ready during auto-redeploy bootstrap, not performing auto reloading yet");
            } else if (indexMissing) {
                log.error("Model index missing after bootstrap \u2014 potential corruption or manual deletion, not performing auto reloading!");
            } else if (e instanceof ClusterBlockException) {
                log.info("Cluster status not ready, not performing auto reloading now!");
            } else {
                log.error("Failed to query need auto redeploy models, no action will be performed, addedNodes are: {}", (Object)addedNodes);
            }
            this.startCronjobAndClearListener();
        });
        this.queryRunningModels((ActionListener<SearchResponse>)listener);
    }

    private void triggerUndeployModelsOnDataNodes(List<String> dataNodeIds) {
        ArrayList modelIds = new ArrayList();
        ActionListener listener = ActionListenerHelper.wrap(res -> {
            if (res != null && res.getHits() != null && res.getHits().getTotalHits() != null && res.getHits().getTotalHits().value() > 0L) {
                Arrays.stream(res.getHits().getHits()).forEach(x -> modelIds.add(x.getId()));
                if (!modelIds.isEmpty()) {
                    ActionListener undeployModelListener = ActionListenerHelper.wrap(r -> log.info("Undeploy models on data nodes successfully!"), e -> log.error("Failed to undeploy models on data nodes, error is: {}", (Object)e.getMessage()));
                    MLUndeployModelNodesRequest undeployModelNodesRequest = new MLUndeployModelNodesRequest(dataNodeIds.toArray(new String[0]), modelIds.toArray(new String[0]));
                    this.client.execute((ActionType)MLUndeployModelAction.INSTANCE, (ActionRequest)undeployModelNodesRequest, undeployModelListener);
                }
            }
        }, e -> {
            boolean indexMissing;
            boolean bl = indexMissing = SkyliteExceptionsHelper.unwrap((Throwable)e, (Class[])new Class[]{IndexNotFoundException.class}) != null;
            if (indexMissing && System.currentTimeMillis() - this.nodeStartTimeMillis < TimeUnit.SECONDS.toMillis(60L)) {
                log.debug("Model index not ready during auto-redeploy bootstrap, will retry on next cycle");
                return;
            }
            if (indexMissing) {
                log.error("Model index missing after bootstrap \u2014 no redeploy performed", (Throwable)e);
                return;
            }
            log.error("Failed to query need-undeploy models \u2014 no action will be performed", (Throwable)e);
        });
        this.queryRunningModels((ActionListener<SearchResponse>)listener);
    }

    private void queryRunningModels(ActionListener<SearchResponse> listener) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        TermsQueryBuilder builder = new TermsQueryBuilder("model_state", Arrays.asList(MLModelState.LOADING.name(), MLModelState.PARTIALLY_LOADED.name(), MLModelState.LOADED.name(), MLModelState.DEPLOYING.name(), MLModelState.PARTIALLY_DEPLOYED.name(), MLModelState.DEPLOYED.name()));
        FieldSortBuilder sortBuilder = (FieldSortBuilder)SortBuilders.fieldSort((String)"last_deployed_time").order(SortOrder.ASC);
        String[] includes = new String[]{"auto_redeploy_retry_times", "planning_worker_nodes", "deploy_to_all_nodes"};
        String[] excludes = new String[]{"model_content", "content"};
        FetchSourceContext fetchContext = new FetchSourceContext(true, includes, excludes);
        searchSourceBuilder.query((QueryBuilder)builder).sort((BaseSortBuilder)sortBuilder).fetchSource(fetchContext);
        SearchRequestBuilder searchRequestBuilder = this.searchRequestBuilderFactory.getSearchRequestBuilder((SkyliteClient)this.client, SearchAction.INSTANCE).setIndices(new String[]{".plugins-ml-model"}).setSource(searchSourceBuilder).setSize(10000);
        searchRequestBuilder.execute(listener);
    }

    private void triggerModelRedeploy(ModelAutoRedeployArrangement modelAutoRedeployArrangement) {
        if (modelAutoRedeployArrangement == null) {
            log.info("No more models in arrangement, skipping the redeployment");
            this.startCronjobAndClearListener();
            return;
        }
        String modelId = modelAutoRedeployArrangement.getSearchResponse().getId();
        List<String> addedNodes = modelAutoRedeployArrangement.getAddedNodes();
        List planningWorkerNodes = (List)modelAutoRedeployArrangement.getSearchResponse().getSourceAsMap().get("planning_worker_nodes");
        Integer autoRedeployRetryTimes = (Integer)modelAutoRedeployArrangement.getSearchResponse().getSourceAsMap().get("auto_redeploy_retry_times");
        Boolean deployToAllNodes = Optional.ofNullable(modelAutoRedeployArrangement.getSearchResponse().getSourceAsMap().get("deploy_to_all_nodes")).orElse(false);
        String[] nodeIds = null;
        if (deployToAllNodes.booleanValue() || !this.allowCustomDeploymentPlan) {
            nodeIds = new String[]{};
        } else if (planningWorkerNodes != null && !planningWorkerNodes.isEmpty()) {
            List needRedeployPlanningWorkerNodes = Arrays.stream(planningWorkerNodes.toArray(new String[0])).filter(addedNodes::contains).collect(Collectors.toList());
            String[] stringArray = nodeIds = !needRedeployPlanningWorkerNodes.isEmpty() ? planningWorkerNodes.toArray(new String[0]) : null;
        }
        if (nodeIds == null) {
            log.info("Allow custom deployment plan is true and deploy to all nodes is false and added nodes are not in planning worker nodes list, not to auto redeploy the model to the new nodes!");
            this.redeployAModel();
            return;
        }
        ActionListener listener = ActionListenerHelper.wrap(res -> log.info("Triggered model auto redeploy, task id is: {}, task status is: {}", (Object)res.getTaskId(), (Object)res.getStatus()), e -> {
            log.error("Exception occurred when auto redeploying the model, model id is: {}, exception is: {}, skipping current model auto redeploy and starting next model redeploy!", (Object)modelId, (Object)e.getMessage());
            this.redeployAModel();
        });
        this.mlModelManager.updateModel(modelId, null, false, Map.of("auto_redeploy_retry_times", Optional.ofNullable(autoRedeployRetryTimes).orElse(0) + 1));
        MLDeployModelRequest deployModelRequest = new MLDeployModelRequest(modelId, null, nodeIds, false, true, false);
        this.client.execute((ActionType)MLDeployModelAction.INSTANCE, (ActionRequest)deployModelRequest, listener);
    }

    private void startCronjobAndClearListener() {
        boolean managerNode = this.clusterService.localNode().isClusterManagerNode();
        if (managerNode && this.startCronJobListener != null) {
            this.startCronJobListener.onResponse((Object)true);
            this.startCronJobListener = null;
        }
    }

    public void setStartCronJobListener(ActionListener<Boolean> startCronJobListener) {
        this.startCronJobListener = startCronJobListener;
    }

    public static class SearchRequestBuilderFactory {
        public SearchRequestBuilder getSearchRequestBuilder(SkyliteClient client, SearchAction action) {
            return new SearchRequestBuilder(client, action);
        }
    }

    static class ModelAutoRedeployArrangement {
        private List<String> addedNodes;
        private SearchHit searchResponse;

        ModelAutoRedeployArrangement(List<String> addedNodes, SearchHit searchResponse) {
            this.addedNodes = addedNodes;
            this.searchResponse = searchResponse;
        }

        public List<String> getAddedNodes() {
            return this.addedNodes;
        }

        public void setAddedNodes(List<String> addedNodes) {
            this.addedNodes = addedNodes;
        }

        public SearchHit getSearchResponse() {
            return this.searchResponse;
        }

        public void setSearchResponse(SearchHit searchResponse) {
            this.searchResponse = searchResponse;
        }

        public static Builder builder() {
            return new Builder();
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModelAutoRedeployArrangement that = (ModelAutoRedeployArrangement)o;
            return Objects.equals(this.addedNodes, that.addedNodes) && Objects.equals(this.searchResponse, that.searchResponse);
        }

        public int hashCode() {
            return Objects.hash(this.addedNodes, this.searchResponse);
        }

        public String toString() {
            return "ModelAutoRedeployArrangement{addedNodes=" + String.valueOf(this.addedNodes) + ", searchResponse=" + String.valueOf(this.searchResponse) + "}";
        }

        public static class Builder {
            private List<String> addedNodes;
            private SearchHit searchResponse;

            public Builder addedNodes(List<String> addedNodes) {
                this.addedNodes = addedNodes;
                return this;
            }

            public Builder searchResponse(SearchHit searchResponse) {
                this.searchResponse = searchResponse;
                return this;
            }

            public ModelAutoRedeployArrangement build() {
                return new ModelAutoRedeployArrangement(this.addedNodes, this.searchResponse);
            }
        }
    }
}

