/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.cluster;

import io.lucenia.ml.common.autoredeploy.MLModelAutoReDeployer;
import io.lucenia.ml.common.cluster.MLSyncUpCron;
import io.lucenia.ml.common.engine.systemindices.MLIndicesHandler;
import io.skylite.common.action.ActionListener;
import io.skylite.common.lifecycle.LifecycleListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.client.Client;
import io.skylite.core.client.metadata.MetadataClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.service.LocalNodeClusterManagerListener;
import io.skylite.core.cluster.state.ClusterStateListener;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.Scheduler;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.ml.common.cluster.DiscoveryNodeHelper;
import io.skylite.ml.common.engine.Encryptor;
import io.skylite.ml.common.settings.MLCommonsSettings;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MLCommonsClusterManagerEventListener
implements LocalNodeClusterManagerListener {
    private static final Logger log = LogManager.getLogger(MLCommonsClusterManagerEventListener.class);
    private final ClusterService clusterService;
    private Client client;
    private final MetadataClient metadataClient;
    private ThreadPool threadPool;
    private Scheduler.Cancellable syncModelRoutingCron;
    private DiscoveryNodeHelper nodeHelper;
    private final MLIndicesHandler mlIndicesHandler;
    private final Encryptor encryptor;
    private volatile Integer jobInterval;
    private final MLModelAutoReDeployer mlModelAutoReDeployer;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public MLCommonsClusterManagerEventListener(ClusterService clusterService, Client client, MetadataClient metadataClient, Settings settings, ThreadPool threadPool, DiscoveryNodeHelper nodeHelper, MLIndicesHandler mlIndicesHandler, Encryptor encryptor, MLModelAutoReDeployer modelAutoReDeployer, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.clusterService = clusterService;
        this.client = client;
        this.metadataClient = metadataClient;
        this.threadPool = threadPool;
        this.clusterService.addListener((ClusterStateListener)this);
        this.nodeHelper = nodeHelper;
        this.mlIndicesHandler = mlIndicesHandler;
        this.encryptor = encryptor;
        this.mlModelAutoReDeployer = modelAutoReDeployer;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        this.jobInterval = (Integer)MLCommonsSettings.ML_COMMONS_SYNC_UP_JOB_INTERVAL_IN_SECONDS.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_SYNC_UP_JOB_INTERVAL_IN_SECONDS, it -> {
            this.jobInterval = it;
            this.cancel(this.syncModelRoutingCron);
            this.startSyncModelRoutingCron();
        });
    }

    public void onClusterManager() {
        ActionListener listener = ActionListenerHelper.wrap(r -> {
            if (this.syncModelRoutingCron == null) {
                this.startSyncModelRoutingCron();
            }
        }, e -> {
            if (this.syncModelRoutingCron == null) {
                this.startSyncModelRoutingCron();
            }
        });
        this.mlModelAutoReDeployer.setStartCronJobListener((ActionListener<Boolean>)listener);
        String localNodeId = this.clusterService.localNode().getId();
        this.threadPool.schedule(() -> this.mlModelAutoReDeployer.buildAutoReloadArrangement(List.of(localNodeId), localNodeId), TimeValue.timeValueSeconds((long)this.jobInterval.intValue()), "lucenia_ml_general");
    }

    private void startSyncModelRoutingCron() {
        if (this.jobInterval > 0) {
            log.info("Starting ML sync up job...");
            this.syncModelRoutingCron = this.threadPool.scheduleWithFixedDelay((Runnable)new MLSyncUpCron(this.client, this.metadataClient, this.clusterService, this.nodeHelper, this.mlIndicesHandler, this.encryptor, this.mlFeatureEnabledSetting), TimeValue.timeValueSeconds((long)this.jobInterval.intValue()), "lucenia_ml_general");
        } else {
            log.debug("Stop ML syncup job as its interval is: {}", (Object)this.jobInterval);
        }
        this.clusterService.addLifecycleListener(new LifecycleListener(){

            public void beforeStop() {
                MLCommonsClusterManagerEventListener.this.cancel(MLCommonsClusterManagerEventListener.this.syncModelRoutingCron);
                MLCommonsClusterManagerEventListener.this.syncModelRoutingCron = null;
            }
        });
    }

    public void offClusterManager() {
        this.cancel(this.syncModelRoutingCron);
        this.syncModelRoutingCron = null;
    }

    private void cancel(Scheduler.Cancellable cron) {
        if (cron != null) {
            cron.cancel();
        }
    }
}

