/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.conversation;

import io.lucenia.ml.common.conversation.ConversationMetaIndex;
import io.skylite.ResourceAlreadyExistsException;
import io.skylite.ResourceNotFoundException;
import io.skylite.SkyliteStatusException;
import io.skylite.SkyliteWrapperException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.action.admin.indices.create.CreateIndexRequest;
import io.skylite.core.action.admin.indices.create.CreateIndexResponse;
import io.skylite.core.action.admin.indices.refresh.RefreshRequest;
import io.skylite.core.action.bulk.BulkRequest;
import io.skylite.core.action.delete.DeleteRequest;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.update.UpdateRequest;
import io.skylite.core.action.update.UpdateResponse;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.ExistsQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.TermQueryBuilder;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.SearchHit;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.sort.SortOrder;
import io.skylite.core.security.auth.User;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.ml.common.conversation.ConversationalIndexConstants;
import io.skylite.ml.common.conversation.Interaction;
import io.skylite.ml.common.utils.IndexUtils;
import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.QueryBuilders;

public class InteractionsIndex {
    private static final Logger log = LogManager.getLogger(InteractionsIndex.class);
    private Client client;
    private ClusterService clusterService;
    private ConversationMetaIndex conversationMetaIndex;
    private final int resultsAtATime = 300;

    public InteractionsIndex(Client client, ClusterService clusterService, ConversationMetaIndex conversationMetaIndex) {
        this.client = client;
        this.clusterService = clusterService;
        this.conversationMetaIndex = conversationMetaIndex;
    }

    public void initInteractionsIndexIfAbsent(ActionListener<Boolean> listener) {
        block11: {
            if (!this.clusterService.state().metadata().hasIndex(ConversationalIndexConstants.INTERACTIONS_INDEX_NAME)) {
                log.debug("No messages index found. Adding it");
                CreateIndexRequest request = new CreateIndexRequest(ConversationalIndexConstants.INTERACTIONS_INDEX_NAME).mapping(ConversationalIndexConstants.INTERACTIONS_MAPPINGS, MediaTypeRegistry.JSON).settings(IndexUtils.DEFAULT_INDEX_SETTINGS);
                try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
                    ActionListener internalListener = ActionListenerHelper.runBefore(listener, () -> threadContext.restore());
                    ActionListener al = ActionListenerHelper.wrap(r -> {
                        if (r.equals((Object)new CreateIndexResponse(true, true, ConversationalIndexConstants.INTERACTIONS_INDEX_NAME))) {
                            log.info("created index [" + ConversationalIndexConstants.INTERACTIONS_INDEX_NAME + "]");
                            internalListener.onResponse((Object)true);
                        } else {
                            internalListener.onResponse((Object)false);
                        }
                    }, e -> {
                        if (e instanceof ResourceAlreadyExistsException || e instanceof SkyliteWrapperException && e.getCause() instanceof ResourceAlreadyExistsException) {
                            internalListener.onResponse((Object)true);
                        } else {
                            log.error("Failed to create index [" + ConversationalIndexConstants.INTERACTIONS_INDEX_NAME + "]", (Throwable)e);
                            internalListener.onFailure(e);
                        }
                    });
                    this.client.admin().indices().create(request, al);
                }
                catch (Exception e2) {
                    if (e2 instanceof ResourceAlreadyExistsException || e2 instanceof SkyliteWrapperException && e2.getCause() instanceof ResourceAlreadyExistsException) {
                        listener.onResponse((Object)true);
                        break block11;
                    }
                    log.error("Failed to create index [" + ConversationalIndexConstants.INTERACTIONS_INDEX_NAME + "]", (Throwable)e2);
                    listener.onFailure(e2);
                }
            } else {
                listener.onResponse((Object)true);
            }
        }
    }

    public void createInteraction(String conversationId, String input, String promptTemplate, String response, String origin, Map<String, String> additionalInfo, Instant timestamp, ActionListener<String> listener, String parentId, Integer traceNumber) {
        this.initInteractionsIndexIfAbsent((ActionListener<Boolean>)ActionListenerHelper.wrap(indexExists -> {
            String user;
            String userStr = (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
            String string = user = User.parse((String)userStr) == null ? "BAD_USER" : User.parse((String)userStr).getName();
            if (indexExists.booleanValue()) {
                this.conversationMetaIndex.checkAccess(conversationId, (ActionListener<Boolean>)ActionListenerHelper.wrap(access -> {
                    if (access.booleanValue()) {
                        HashMap<String, Object> sourceMap = new HashMap<String, Object>();
                        sourceMap.put("memory_id", conversationId);
                        sourceMap.put("create_time", timestamp);
                        sourceMap.put("parent_message_id", parentId);
                        sourceMap.put("trace_number", traceNumber);
                        if (input != null && !input.trim().isEmpty()) {
                            sourceMap.put("input", input);
                        }
                        if (promptTemplate != null && !promptTemplate.trim().isEmpty()) {
                            sourceMap.put("prompt_template", promptTemplate);
                        }
                        if (response != null && !response.trim().isEmpty()) {
                            sourceMap.put("response", response);
                        }
                        if (origin != null && !origin.trim().isEmpty()) {
                            sourceMap.put("origin", origin);
                        }
                        if (additionalInfo != null && !additionalInfo.isEmpty()) {
                            sourceMap.put("additional_info", additionalInfo);
                        }
                        IndexRequest request = new IndexRequest(ConversationalIndexConstants.INTERACTIONS_INDEX_NAME).source(sourceMap);
                        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
                            ActionListener internalListener = ActionListenerHelper.runBefore((ActionListener)listener, () -> threadContext.restore());
                            ActionListener al = ActionListenerHelper.wrap(resp -> {
                                if (resp.status() == RestStatus.CREATED) {
                                    internalListener.onResponse((Object)resp.getId());
                                    log.info("Successfully created the message with id : {}", (Object)resp.getId());
                                } else {
                                    internalListener.onFailure((Exception)new IOException("Failed to create message"));
                                }
                            }, e -> internalListener.onFailure(e));
                            this.client.index(request, al);
                        }
                        catch (Exception e2) {
                            listener.onFailure(e2);
                        }
                    } else {
                        throw new SkyliteStatusException("User [" + user + "] does not have access to memory " + conversationId, RestStatus.UNAUTHORIZED, new Object[0]);
                    }
                }, e -> listener.onFailure(e)));
            } else {
                listener.onFailure((Exception)new IOException("no index to add memory to"));
            }
        }, e -> listener.onFailure(e)));
    }

    public void createInteraction(String conversationId, String input, String promptTemplate, String response, String origin, Map<String, String> additionalInfo, Instant timestamp, ActionListener<String> listener) {
        this.createInteraction(conversationId, input, promptTemplate, response, origin, additionalInfo, timestamp, listener, null, null);
    }

    public void createInteraction(String conversationId, String input, String promptTemplate, String response, String origin, Map<String, String> additionalInfo, ActionListener<String> listener) {
        this.createInteraction(conversationId, input, promptTemplate, response, origin, additionalInfo, Instant.now(), listener, null, null);
    }

    public void getInteractions(String conversationId, int from, int maxResults, ActionListener<List<Interaction>> listener) {
        if (!this.clusterService.state().metadata().hasIndex(ConversationalIndexConstants.INTERACTIONS_INDEX_NAME)) {
            listener.onResponse(List.of());
            return;
        }
        ActionListener accessListener = ActionListenerHelper.wrap(access -> {
            if (!access.booleanValue()) {
                String userStr = (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
                String user = User.parse((String)userStr) == null ? "BAD_USER" : User.parse((String)userStr).getName();
                throw new SkyliteStatusException("User [" + user + "] does not have access to memory " + conversationId, RestStatus.UNAUTHORIZED, new Object[0]);
            }
            this.innerGetInteractions(conversationId, from, maxResults, listener);
        }, e -> listener.onFailure(e));
        this.conversationMetaIndex.checkAccess(conversationId, (ActionListener<Boolean>)accessListener);
    }

    public void innerGetInteractions(String conversationId, int from, int maxResults, ActionListener<List<Interaction>> listener) {
        SearchRequest request = new SearchRequest(new String[]{ConversationalIndexConstants.INTERACTIONS_INDEX_NAME});
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        ExistsQueryBuilder existsQueryBuilder = QueryBuilders.existsQuery((String)"trace_number");
        boolQueryBuilder.mustNot((QueryBuilder)existsQueryBuilder);
        TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery((String)"memory_id", (String)conversationId);
        boolQueryBuilder.must((QueryBuilder)termQueryBuilder);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        request.source(searchSourceBuilder);
        request.source().from(from).size(maxResults);
        request.source().sort("create_time", SortOrder.ASC);
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListenerHelper.runBefore(listener, () -> threadContext.restore());
            ActionListener al = ActionListenerHelper.wrap(response -> {
                LinkedList<Interaction> result = new LinkedList<Interaction>();
                for (SearchHit hit : response.getHits()) {
                    result.add(Interaction.fromSearchHit((SearchHit)hit));
                }
                internalListener.onResponse(result);
                log.info("Successfully get the messages for memory {}", (Object)conversationId);
            }, e -> {
                internalListener.onFailure(e);
                log.error("Failed to get the messages for memory {}", (Object)conversationId);
            });
            this.client.admin().indices().refresh(new RefreshRequest(new String[]{ConversationalIndexConstants.INTERACTIONS_INDEX_NAME}), ActionListenerHelper.wrap(r -> this.client.search(request, al), e -> internalListener.onFailure(e)));
        }
        catch (Exception e2) {
            listener.onFailure(e2);
        }
    }

    public void getTraces(String interactionId, int from, int maxResults, ActionListener<List<Interaction>> listener) {
        if (!this.clusterService.state().metadata().hasIndex(ConversationalIndexConstants.INTERACTIONS_INDEX_NAME)) {
            listener.onResponse(List.of());
            return;
        }
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListenerHelper.runBefore(listener, () -> threadContext.restore());
            GetRequest request = new GetRequest(ConversationalIndexConstants.INTERACTIONS_INDEX_NAME).id(interactionId);
            ActionListener al = ActionListenerHelper.wrap(getResponse -> {
                if (!getResponse.isExists() || !getResponse.getId().equals(interactionId)) {
                    throw new ResourceNotFoundException("Message [" + interactionId + "] not found", new Object[0]);
                }
                Interaction interaction = Interaction.fromMap((String)interactionId, (Map)getResponse.getSourceAsMap());
                String conversationId = interaction.getConversationId();
                ActionListener accessListener = ActionListenerHelper.wrap(access -> {
                    if (!access.booleanValue()) {
                        String userStr = (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
                        String user = User.parse((String)userStr) == null ? "BAD_USER" : User.parse((String)userStr).getName();
                        throw new SkyliteStatusException("User [" + user + "] does not have access to message " + interactionId, RestStatus.UNAUTHORIZED, new Object[0]);
                    }
                    this.innerGetTraces(interactionId, from, maxResults, listener);
                }, e -> listener.onFailure(e));
                this.conversationMetaIndex.checkAccess(conversationId, (ActionListener<Boolean>)accessListener);
            }, e -> internalListener.onFailure(e));
            this.client.admin().indices().refresh(new RefreshRequest(new String[]{ConversationalIndexConstants.INTERACTIONS_INDEX_NAME}), ActionListenerHelper.wrap(refreshResponse -> this.client.get(request, ActionListenerHelper.runBefore((ActionListener)al, () -> threadContext.restore())), e -> {
                log.error("Failed to refresh message index during get message ", (Throwable)e);
                internalListener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            listener.onFailure(e2);
        }
    }

    public void innerGetTraces(String interactionId, int from, int maxResults, ActionListener<List<Interaction>> listener) {
        SearchRequest request = new SearchRequest(new String[]{ConversationalIndexConstants.INTERACTIONS_INDEX_NAME});
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        ExistsQueryBuilder existsQueryBuilder = QueryBuilders.existsQuery((String)"trace_number");
        boolQueryBuilder.must((QueryBuilder)existsQueryBuilder);
        TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery((String)"parent_message_id", (String)interactionId);
        boolQueryBuilder.must((QueryBuilder)termQueryBuilder);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        request.source(searchSourceBuilder);
        request.source().from(from).size(maxResults);
        request.source().sort("trace_number", SortOrder.ASC);
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListenerHelper.runBefore(listener, () -> threadContext.restore());
            ActionListener al = ActionListenerHelper.wrap(response -> {
                LinkedList<Interaction> result = new LinkedList<Interaction>();
                for (SearchHit hit : response.getHits()) {
                    result.add(Interaction.fromSearchHit((SearchHit)hit));
                }
                internalListener.onResponse(result);
                log.info("Successfully get traces for the message {}", (Object)interactionId);
            }, e -> {
                internalListener.onFailure(e);
                log.error("Failed to get traces for the message {}", (Object)interactionId);
            });
            this.client.search(request, al);
        }
        catch (Exception e2) {
            listener.onFailure(e2);
        }
    }

    public void getAllInteractions(String conversationId, int maxResults, ActionListener<List<Interaction>> listener) {
        ActionListener<List<Interaction>> al = this.nextGetListener(conversationId, 0, maxResults, listener, new LinkedList<Interaction>());
        this.innerGetInteractions(conversationId, 0, maxResults, al);
    }

    public ActionListener<List<Interaction>> nextGetListener(String conversationId, int from, int maxResults, ActionListener<List<Interaction>> mainListener, List<Interaction> result) {
        if (maxResults < 1) {
            mainListener.onFailure((Exception)new IllegalArgumentException("maxResults must be positive"));
            return null;
        }
        return ActionListenerHelper.wrap(interactions -> {
            result.addAll((Collection<Interaction>)interactions);
            if (interactions.size() < maxResults) {
                mainListener.onResponse((Object)result);
            } else {
                ActionListener<List<Interaction>> al = this.nextGetListener(conversationId, from + maxResults, maxResults, mainListener, result);
                this.innerGetInteractions(conversationId, from + maxResults, maxResults, al);
            }
        }, e -> mainListener.onFailure(e));
    }

    public void deleteConversation(String conversationId, ActionListener<Boolean> listener) {
        if (!this.clusterService.state().metadata().hasIndex(ConversationalIndexConstants.INTERACTIONS_INDEX_NAME)) {
            listener.onResponse((Object)true);
            return;
        }
        String userStr = (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
        String user = User.parse((String)userStr) == null ? "BAD_USER" : User.parse((String)userStr).getName();
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListenerHelper.runBefore(listener, () -> threadContext.restore());
            ActionListener searchListener = ActionListenerHelper.wrap(interactions -> {
                if (interactions.size() == 0) {
                    internalListener.onResponse((Object)true);
                    return;
                }
                BulkRequest request = new BulkRequest().setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                for (Interaction interaction : interactions) {
                    DeleteRequest delRequest = new DeleteRequest(ConversationalIndexConstants.INTERACTIONS_INDEX_NAME).id(interaction.getId());
                    request.add(delRequest);
                }
                this.client.bulk(request, ActionListenerHelper.wrap(bulkResponse -> internalListener.onResponse((Object)(!bulkResponse.hasFailures() ? 1 : 0)), e -> internalListener.onFailure(e)));
            }, e -> internalListener.onFailure(e));
            ActionListener accessListener = ActionListenerHelper.wrap(access -> {
                if (!access.booleanValue()) {
                    throw new SkyliteStatusException("User [" + user + "] does not have access to memory " + conversationId, RestStatus.UNAUTHORIZED, new Object[0]);
                }
                this.getAllInteractions(conversationId, 300, (ActionListener<List<Interaction>>)searchListener);
            }, e -> listener.onFailure(e));
            this.conversationMetaIndex.checkAccess(conversationId, (ActionListener<Boolean>)accessListener);
        }
        catch (Exception e2) {
            log.error("Failure while deleting messages associated with memory id=" + conversationId, (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    public void searchInteractions(String conversationId, SearchRequest request, ActionListener<SearchResponse> listener) {
        this.conversationMetaIndex.checkAccess(conversationId, (ActionListener<Boolean>)ActionListenerHelper.wrap(access -> {
            if (access.booleanValue()) {
                try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
                    ActionListener internalListener = ActionListenerHelper.runBefore((ActionListener)listener, () -> threadContext.restore());
                    request.indices(new String[]{ConversationalIndexConstants.INTERACTIONS_INDEX_NAME});
                    QueryBuilder originalQuery = request.source().query();
                    BoolQueryBuilder newQuery = new BoolQueryBuilder();
                    newQuery.must(originalQuery);
                    newQuery.must((QueryBuilder)new TermQueryBuilder("memory_id", conversationId));
                    request.source().query((QueryBuilder)newQuery);
                    this.client.admin().indices().refresh(new RefreshRequest(new String[]{ConversationalIndexConstants.INTERACTIONS_INDEX_NAME}), ActionListenerHelper.wrap(refreshResponse -> this.client.search(request, internalListener), e -> {
                        log.error("Failed to refresh messages index during search messages ", (Throwable)e);
                        internalListener.onFailure(e);
                    }));
                }
                catch (Exception e2) {
                    listener.onFailure(e2);
                }
            } else {
                String userStr = (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
                String user = User.parse((String)userStr) == null ? "BAD_USER" : User.parse((String)userStr).getName();
                throw new SkyliteStatusException("User [" + user + "] does not have access to memory " + conversationId, RestStatus.UNAUTHORIZED, new Object[0]);
            }
        }, e -> listener.onFailure(e)));
    }

    public void getInteraction(String interactionId, ActionListener<Interaction> listener) {
        if (!this.clusterService.state().metadata().hasIndex(ConversationalIndexConstants.INTERACTIONS_INDEX_NAME)) {
            listener.onFailure((Exception)new IndexNotFoundException("cannot get message since the messages index does not exist", ConversationalIndexConstants.INTERACTIONS_INDEX_NAME));
            return;
        }
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListenerHelper.runBefore(listener, () -> threadContext.restore());
            GetRequest request = new GetRequest(ConversationalIndexConstants.INTERACTIONS_INDEX_NAME).id(interactionId);
            ActionListener al = ActionListenerHelper.wrap(getResponse -> {
                if (!(getResponse.isExists() && getResponse.getId().equals(interactionId))) {
                    throw new ResourceNotFoundException("Message [" + interactionId + "] not found", new Object[0]);
                }
                Interaction interaction = Interaction.fromMap((String)interactionId, (Map)getResponse.getSourceAsMap());
                this.checkInteractionPermission(interactionId, interaction, (ActionListener<Interaction>)internalListener);
            }, e -> internalListener.onFailure(e));
            this.client.admin().indices().refresh(new RefreshRequest(new String[]{ConversationalIndexConstants.INTERACTIONS_INDEX_NAME}), ActionListenerHelper.wrap(refreshResponse -> this.client.get(request, ActionListenerHelper.runBefore((ActionListener)al, () -> threadContext.restore())), e -> {
                log.error("Failed to refresh message index during get message ", (Throwable)e);
                internalListener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            listener.onFailure(e2);
        }
    }

    public void updateInteraction(String interactionId, UpdateRequest updateRequest, ActionListener<UpdateResponse> listener) {
        if (!this.clusterService.state().metadata().hasIndex(ConversationalIndexConstants.INTERACTIONS_INDEX_NAME)) {
            listener.onFailure((Exception)new IndexNotFoundException("cannot update message since the message index does not exist", ConversationalIndexConstants.INTERACTIONS_INDEX_NAME));
            return;
        }
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListenerHelper.runBefore(listener, () -> threadContext.restore());
            GetRequest request = new GetRequest(ConversationalIndexConstants.INTERACTIONS_INDEX_NAME).id(interactionId);
            ActionListener al = ActionListenerHelper.wrap(getResponse -> {
                if (!getResponse.isExists() || !getResponse.getId().equals(interactionId)) {
                    throw new ResourceNotFoundException("message [" + interactionId + "] not found", new Object[0]);
                }
                Interaction interaction = Interaction.fromMap((String)interactionId, (Map)getResponse.getSourceAsMap());
                String conversationId = interaction.getConversationId();
                ActionListener accessListener = ActionListenerHelper.wrap(access -> {
                    if (!access.booleanValue()) {
                        String userStr = (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
                        String user = User.parse((String)userStr) == null ? "BAD_USER" : User.parse((String)userStr).getName();
                        throw new SkyliteStatusException("User [" + user + "] does not have access to message " + interactionId, RestStatus.UNAUTHORIZED, new Object[0]);
                    }
                    this.innerUpdateInteraction(updateRequest, (ActionListener<UpdateResponse>)internalListener);
                }, e -> listener.onFailure(e));
                this.conversationMetaIndex.checkAccess(conversationId, (ActionListener<Boolean>)accessListener);
            }, e -> internalListener.onFailure(e));
            this.client.admin().indices().refresh(new RefreshRequest(new String[]{ConversationalIndexConstants.INTERACTIONS_INDEX_NAME}), ActionListenerHelper.wrap(refreshResponse -> this.client.get(request, ActionListenerHelper.runBefore((ActionListener)al, () -> threadContext.restore())), e -> {
                log.error("Failed to refresh messages index during get message ", (Throwable)e);
                internalListener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            listener.onFailure(e2);
        }
    }

    private void innerUpdateInteraction(UpdateRequest updateRequest, ActionListener<UpdateResponse> listener) {
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListenerHelper.runBefore(listener, () -> threadContext.restore());
            this.client.update(updateRequest, internalListener);
        }
        catch (Exception e) {
            log.error("Failed to update message");
            listener.onFailure(e);
        }
    }

    private void checkInteractionPermission(String interactionId, Interaction interaction, ActionListener<Interaction> internalListener) {
        String conversationId = interaction.getConversationId();
        ActionListener accessListener = ActionListenerHelper.wrap(access -> {
            if (!access.booleanValue()) {
                String userStr = (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
                String user = User.parse((String)userStr) == null ? "BAD_USER" : User.parse((String)userStr).getName();
                throw new SkyliteStatusException("User [" + user + "] does not have access to message " + interactionId, RestStatus.UNAUTHORIZED, new Object[0]);
            }
            internalListener.onResponse((Object)interaction);
            log.info("Successfully get the message : {}", (Object)interactionId);
        }, e -> internalListener.onFailure(e));
        this.conversationMetaIndex.checkAccess(conversationId, (ActionListener<Boolean>)accessListener);
    }
}

