/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.dataset;

import io.skylite.common.xcontent.XContentType;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.settings.Settings;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.ml.common.annotation.InputDataSet;
import io.skylite.ml.common.dataset.MLInputDataType;
import io.skylite.ml.common.dataset.MLInputDataset;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opensearch.search.SearchModule;

@InputDataSet(value=MLInputDataType.SEARCH_QUERY)
public class SearchQueryInputDataset
extends MLInputDataset {
    private final SearchSourceBuilder searchSourceBuilder;
    private final List<String> indices;
    private static NamedXContentRegistry xContentRegistry;

    public SearchQueryInputDataset(List<String> indices, SearchSourceBuilder searchSourceBuilder) {
        super(MLInputDataType.SEARCH_QUERY);
        if (indices.isEmpty()) {
            throw new IllegalArgumentException("indices can't be empty");
        }
        this.indices = Objects.requireNonNull(indices);
        this.searchSourceBuilder = Objects.requireNonNull(searchSourceBuilder);
    }

    public SearchQueryInputDataset(StreamInput streaminput) throws IOException {
        super(MLInputDataType.SEARCH_QUERY);
        String searchString = streaminput.readString();
        XContentParser parser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, searchString);
        this.searchSourceBuilder = SearchSourceBuilder.fromXContent((XContentParser)parser);
        this.indices = streaminput.readStringList();
    }

    public SearchSourceBuilder getSearchSourceBuilder() {
        return this.searchSourceBuilder;
    }

    public List<String> getIndices() {
        return this.indices;
    }

    public static NamedXContentRegistry getxContentRegistry() {
        return xContentRegistry;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void writeTo(StreamOutput streamOutput) throws IOException {
        super.writeTo(streamOutput);
        streamOutput.writeString(this.searchSourceBuilder.toString());
        streamOutput.writeStringCollection(this.indices);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("input_index", (Object)this.getIndices().toArray(new String[0]));
        builder.field("input_query", (ToXContent)this.getSearchSourceBuilder());
        return builder;
    }

    static {
        SearchModule searchModule = new SearchModule(Settings.EMPTY, Collections.emptyList());
        xContentRegistry = new NamedXContentRegistry(searchModule.getNamedXContents());
    }

    public static class Builder {
        private SearchSourceBuilder searchSourceBuilder;
        private List<String> indices;

        public Builder searchSourceBuilder(SearchSourceBuilder searchSourceBuilder) {
            this.searchSourceBuilder = searchSourceBuilder;
            return this;
        }

        public Builder indices(List<String> indices) {
            this.indices = indices;
            return this;
        }

        public SearchQueryInputDataset build() {
            return new SearchQueryInputDataset(this.indices, this.searchSourceBuilder);
        }
    }
}

