/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.engine.algorithms.agent;

import io.lucenia.ml.common.engine.algorithms.agent.AgentUtils;
import io.lucenia.ml.common.engine.memory.ConversationIndexMemory;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.StepListener;
import io.skylite.core.action.update.UpdateResponse;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.Strings;
import io.skylite.core.settings.Settings;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.ml.common.agent.MLAgent;
import io.skylite.ml.common.agent.MLMemorySpec;
import io.skylite.ml.common.agent.MLToolSpec;
import io.skylite.ml.common.algorithms.agent.MLAgentRunner;
import io.skylite.ml.common.conversation.Interaction;
import io.skylite.ml.common.engine.memory.ConversationIndexMessage;
import io.skylite.ml.common.engine.memory.Memory;
import io.skylite.ml.common.engine.memory.Message;
import io.skylite.ml.common.engine.tools.Tool;
import io.skylite.ml.common.output.model.ModelTensor;
import io.skylite.ml.common.output.model.ModelTensorOutput;
import io.skylite.ml.common.output.model.ModelTensors;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MLConversationalFlowAgentRunner
implements MLAgentRunner {
    private static final Logger log = LogManager.getLogger(MLConversationalFlowAgentRunner.class);
    public static final String CHAT_HISTORY = "chat_history";
    private Client client;
    private Settings settings;
    private ClusterService clusterService;
    private NamedXContentRegistry xContentRegistry;
    private Map<String, Tool.Factory<?>> toolFactories;
    private Map<String, Memory.Factory> memoryFactoryMap;

    public MLConversationalFlowAgentRunner() {
    }

    public MLConversationalFlowAgentRunner(Client client, Settings settings, ClusterService clusterService, NamedXContentRegistry xContentRegistry, Map<String, Tool.Factory<?>> toolFactories, Map<String, Memory.Factory> memoryFactoryMap) {
        this.client = client;
        this.settings = settings;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.toolFactories = toolFactories;
        this.memoryFactoryMap = memoryFactoryMap;
    }

    public void run(MLAgent mlAgent, Map<String, String> params, ActionListener<Object> listener) {
        String appType = mlAgent.getAppType();
        String memoryId = params.get("memory_id");
        String parentInteractionId = params.get("parent_interaction_id");
        if (appType == null || mlAgent.getMemory() == null) {
            this.runAgent(mlAgent, params, listener, null, memoryId, parentInteractionId);
            return;
        }
        String memoryType = mlAgent.getMemory().getType();
        String title = params.get("question");
        int messageHistoryLimit = AgentUtils.getMessageHistoryLimit(params);
        ConversationIndexMemory.Factory conversationIndexMemoryFactory = (ConversationIndexMemory.Factory)this.memoryFactoryMap.get(memoryType);
        conversationIndexMemoryFactory.create(title, memoryId, appType, (ActionListener<ConversationIndexMemory>)ActionListenerHelper.wrap(memory -> memory.getMessages(ActionListenerHelper.wrap(r -> {
            ArrayList<ConversationIndexMessage> messageList = new ArrayList<ConversationIndexMessage>();
            for (Interaction next : r) {
                String string = next.getInput();
                String response = next.getResponse();
                if (Strings.isNullOrEmpty((String)response)) continue;
                messageList.add(ConversationIndexMessage.conversationIndexMessageBuilder().sessionId(memory.getConversationId()).question(string).response(response).build());
            }
            StringBuilder chatHistoryBuilder = new StringBuilder();
            if (!messageList.isEmpty()) {
                chatHistoryBuilder.append("Below is Chat History between Human and AI which sorted by time with asc order:\n");
                for (Message message : messageList) {
                    chatHistoryBuilder.append(message.toString()).append("\n");
                }
                params.put(CHAT_HISTORY, chatHistoryBuilder.toString());
            }
            this.runAgent(mlAgent, params, listener, (ConversationIndexMemory)memory, memory.getConversationId(), parentInteractionId);
        }, e -> {
            log.error("Failed to get chat history", (Throwable)e);
            listener.onFailure(e);
        }), messageHistoryLimit), arg_0 -> listener.onFailure(arg_0)));
    }

    private void runAgent(MLAgent mlAgent, Map<String, String> params, ActionListener<Object> listener, ConversationIndexMemory memory, String memoryId, String parentInteractionId) {
        StepListener firstStepListener = null;
        Tool firstTool = null;
        ArrayList<ModelTensor> flowAgentOutput = new ArrayList<ModelTensor>();
        Map<String, String> firstToolExecuteParams = null;
        StepListener previousStepListener = null;
        ConcurrentHashMap additionalInfo = new ConcurrentHashMap();
        List<MLToolSpec> toolSpecs = AgentUtils.getMlToolSpecs(mlAgent, params);
        if (toolSpecs == null || toolSpecs.isEmpty()) {
            listener.onFailure((Exception)new IllegalArgumentException("no tool configured"));
            return;
        }
        AtomicInteger traceNumber = new AtomicInteger(0);
        if (memory != null) {
            flowAgentOutput.add(ModelTensor.builder().name("memory_id").result(memoryId).build());
            flowAgentOutput.add(ModelTensor.builder().name("parent_message_id").result(parentInteractionId).build());
        }
        MLMemorySpec memorySpec = mlAgent.getMemory();
        for (int i = 0; i <= toolSpecs.size(); ++i) {
            if (i == 0) {
                MLToolSpec toolSpec = toolSpecs.get(i);
                Tool tool = AgentUtils.createTool(this.toolFactories, params, toolSpec, mlAgent.getTenantId());
                previousStepListener = firstStepListener = new StepListener();
                firstTool = tool;
                firstToolExecuteParams = this.getToolExecuteParams(toolSpec, params, mlAgent.getTenantId());
                continue;
            }
            MLToolSpec previousToolSpec = toolSpecs.get(i - 1);
            StepListener nextStepListener = new StepListener();
            int finalI = i;
            previousStepListener.whenComplete(output -> this.processOutput(params, listener, memory, memoryId, parentInteractionId, toolSpecs, flowAgentOutput, additionalInfo, traceNumber, memorySpec, previousToolSpec, finalI, output, mlAgent.getTenantId(), (StepListener<Object>)nextStepListener), e -> {
                log.error("Failed to run flow agent", (Throwable)e);
                listener.onFailure(e);
            });
            previousStepListener = nextStepListener;
        }
        if (toolSpecs.size() == 1) {
            firstTool.run(firstToolExecuteParams, ActionListenerHelper.wrap(output -> {
                MLToolSpec toolSpec = (MLToolSpec)toolSpecs.get(0);
                this.processOutput(params, listener, memory, memoryId, parentInteractionId, toolSpecs, flowAgentOutput, additionalInfo, traceNumber, memorySpec, toolSpec, 1, output, mlAgent.getTenantId(), null);
            }, e -> listener.onFailure(e)));
        } else {
            firstTool.run(firstToolExecuteParams, firstStepListener);
        }
    }

    private void processOutput(Map<String, String> params, ActionListener<Object> listener, ConversationIndexMemory memory, String memoryId, String parentInteractionId, List<MLToolSpec> toolSpecs, List<ModelTensor> flowAgentOutput, Map<String, Object> additionalInfo, AtomicInteger traceNumber, MLMemorySpec memorySpec, MLToolSpec previousToolSpec, int finalI, Object output, String tenantId, StepListener<Object> nextStepListener) throws IOException, PrivilegedActionException {
        boolean traceDisabled;
        String toolName = AgentUtils.getToolName(previousToolSpec);
        String outputKey = toolName + ".output";
        String outputResponse = this.parseResponse(output);
        params.put(outputKey, StringEscapeUtils.escapeJson((String)outputResponse));
        boolean bl = traceDisabled = params.containsKey("disable_trace") && Boolean.parseBoolean(params.get("disable_trace"));
        if (previousToolSpec.isIncludeOutputInAgentResponse() || finalI == toolSpecs.size()) {
            if (output instanceof ModelTensorOutput) {
                flowAgentOutput.addAll(((ModelTensors)((ModelTensorOutput)output).getMlModelOutputs().get(0)).getMlModelTensors());
            } else {
                String result = output instanceof String ? (String)output : AccessController.doPrivileged(() -> Strings.toJson((Object)output));
                ModelTensor stepOutput = ModelTensor.builder().name(toolName).result(result).build();
                flowAgentOutput.add(stepOutput);
            }
            if (memory == null) {
                additionalInfo.put(outputKey, outputResponse);
            }
        }
        if (finalI == toolSpecs.size()) {
            ActionListener updateListener = ActionListenerHelper.wrap(r -> {
                log.info("Updated additional info for interaction {} of flow agent.", (Object)r.getId());
                listener.onResponse((Object)flowAgentOutput);
            }, e -> {
                log.error("Failed to update root interaction", (Throwable)e);
                listener.onResponse((Object)flowAgentOutput);
            });
            if (memory == null) {
                if (memoryId == null || parentInteractionId == null || memorySpec == null || memorySpec.getType() == null) {
                    listener.onResponse(flowAgentOutput);
                } else {
                    this.updateMemoryWithListener(additionalInfo, memorySpec, memoryId, parentInteractionId, updateListener);
                }
            } else {
                this.saveMessage(params, memory, outputResponse, memoryId, parentInteractionId, toolName, traceNumber, traceDisabled, ActionListenerHelper.wrap(r -> {
                    log.info("saved last trace for interaction " + parentInteractionId + " of flow agent");
                    Map<String, Object> updateContent = Map.of("response", outputResponse, "additional_info", additionalInfo);
                    memory.update(parentInteractionId, updateContent, (ActionListener<UpdateResponse>)updateListener);
                }, e -> {
                    log.error("Failed to update root interaction ", (Throwable)e);
                    listener.onFailure(e);
                }));
            }
        } else if (memory == null) {
            this.runNextStep(params, toolSpecs, finalI, tenantId, nextStepListener);
        } else {
            this.saveMessage(params, memory, outputResponse, memoryId, parentInteractionId, toolName, traceNumber, traceDisabled, ActionListenerHelper.wrap(r -> this.runNextStep(params, toolSpecs, finalI, tenantId, nextStepListener), e -> {
                log.error("Failed to update root interaction ", (Throwable)e);
                listener.onFailure(e);
            }));
        }
    }

    private void runNextStep(Map<String, String> params, List<MLToolSpec> toolSpecs, int finalI, String tenantId, StepListener<Object> nextStepListener) {
        MLToolSpec toolSpec = toolSpecs.get(finalI);
        Tool tool = AgentUtils.createTool(this.toolFactories, params, toolSpec, tenantId);
        if (finalI < toolSpecs.size()) {
            tool.run(this.getToolExecuteParams(toolSpec, params, tenantId), nextStepListener);
        }
    }

    private void saveMessage(Map<String, String> params, ConversationIndexMemory memory, String outputResponse, String memoryId, String parentInteractionId, String toolName, AtomicInteger traceNumber, boolean traceDisabled, ActionListener listener) {
        ConversationIndexMessage finalMessage = ConversationIndexMessage.conversationIndexMessageBuilder().type(memory.getType()).question(params.get("question")).response(outputResponse).finalAnswer(Boolean.valueOf(true)).sessionId(memoryId).build();
        if (traceDisabled) {
            listener.onResponse((Object)true);
        } else {
            memory.save((Message)finalMessage, parentInteractionId, traceNumber.addAndGet(1), toolName, listener);
        }
    }

    void updateMemoryWithListener(Map<String, Object> additionalInfo, MLMemorySpec memorySpec, String memoryId, String interactionId, ActionListener listener) {
        if (memoryId == null || interactionId == null || memorySpec == null || memorySpec.getType() == null) {
            return;
        }
        ConversationIndexMemory.Factory conversationIndexMemoryFactory = (ConversationIndexMemory.Factory)this.memoryFactoryMap.get(memorySpec.getType());
        conversationIndexMemoryFactory.create(memoryId, (ActionListener<ConversationIndexMemory>)ActionListenerHelper.wrap(memory -> memory.update(interactionId, Map.of("additional_info", additionalInfo), (ActionListener<UpdateResponse>)listener), e -> log.error("Failed create memory from id: " + memoryId, (Throwable)e)));
    }

    String parseResponse(Object output) throws IOException {
        if (output instanceof List && !((List)output).isEmpty() && ((List)output).get(0) instanceof ModelTensors) {
            ModelTensors tensors = (ModelTensors)((List)output).get(0);
            return tensors.toXContent(MediaTypeRegistry.JSON.contentBuilder(), null).toString();
        }
        if (output instanceof ModelTensor) {
            return ((ModelTensor)output).toXContent(MediaTypeRegistry.JSON.contentBuilder(), null).toString();
        }
        if (output instanceof ModelTensorOutput) {
            return ((ModelTensorOutput)output).toXContent(MediaTypeRegistry.JSON.contentBuilder(), null).toString();
        }
        if (output instanceof String) {
            return (String)output;
        }
        return Strings.toJson((Object)output);
    }

    Map<String, String> getToolExecuteParams(MLToolSpec toolSpec, Map<String, String> params, String tenantId) {
        HashMap<String, String> executeParams = new HashMap<String, String>();
        if (toolSpec.getParameters() != null) {
            executeParams.putAll(toolSpec.getParameters());
        }
        executeParams.put("tenant_id", tenantId);
        for (String key : params.keySet()) {
            String toBeReplaced = null;
            if (key.startsWith(toolSpec.getType() + ".")) {
                toBeReplaced = toolSpec.getType() + ".";
            }
            if (toolSpec.getName() != null && key.startsWith(toolSpec.getName() + ".")) {
                toBeReplaced = toolSpec.getName() + ".";
            }
            if (toBeReplaced != null) {
                executeParams.put(key.replace(toBeReplaced, ""), params.get(key));
                continue;
            }
            executeParams.put(key, params.get(key));
        }
        if (toolSpec.getConfigMap() != null && !toolSpec.getConfigMap().isEmpty()) {
            executeParams.putAll(toolSpec.getConfigMap());
        }
        if (executeParams.containsKey("input")) {
            String input = (String)executeParams.get("input");
            StringSubstitutor substitutor = new StringSubstitutor(executeParams, "${parameters.", "}");
            input = substitutor.replace(input);
            executeParams.put("input", input);
        }
        return executeParams;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public ClusterService getClusterService() {
        return this.clusterService;
    }

    public void setClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public NamedXContentRegistry getxContentRegistry() {
        return this.xContentRegistry;
    }

    public void setxContentRegistry(NamedXContentRegistry xContentRegistry) {
        this.xContentRegistry = xContentRegistry;
    }

    public Map<String, Tool.Factory<?>> getToolFactories() {
        return this.toolFactories;
    }

    public void setToolFactories(Map<String, Tool.Factory<?>> toolFactories) {
        this.toolFactories = toolFactories;
    }

    public Map<String, Memory.Factory> getMemoryFactoryMap() {
        return this.memoryFactoryMap;
    }

    public void setMemoryFactoryMap(Map<String, Memory.Factory> memoryFactoryMap) {
        this.memoryFactoryMap = memoryFactoryMap;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MLConversationalFlowAgentRunner that = (MLConversationalFlowAgentRunner)o;
        return Objects.equals(this.client, that.client) && Objects.equals(this.settings, that.settings) && Objects.equals(this.clusterService, that.clusterService) && Objects.equals(this.xContentRegistry, that.xContentRegistry) && Objects.equals(this.toolFactories, that.toolFactories) && Objects.equals(this.memoryFactoryMap, that.memoryFactoryMap);
    }

    public int hashCode() {
        return Objects.hash(this.client, this.settings, this.clusterService, this.xContentRegistry, this.toolFactories, this.memoryFactoryMap);
    }

    public String toString() {
        return "MLConversationalFlowAgentRunner{client=" + String.valueOf(this.client) + ", settings=" + String.valueOf(this.settings) + ", clusterService=" + String.valueOf(this.clusterService) + ", xContentRegistry=" + String.valueOf(this.xContentRegistry) + ", toolFactories=" + String.valueOf(this.toolFactories) + ", memoryFactoryMap=" + String.valueOf(this.memoryFactoryMap) + "}";
    }
}

