/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.engine.algorithms.anomalylocalization;

import io.skylite.common.action.ActionListener;
import io.skylite.common.action.NotifyOnceListener;
import io.skylite.common.util.Counter;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.search.MultiSearchRequest;
import io.skylite.core.action.search.MultiSearchResponse;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.aggregations.MultiBucketConsumerService;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.RangeQueryBuilder;
import io.skylite.core.index.query.TermQueryBuilder;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.settings.Settings;
import io.skylite.ml.common.algorithms.anomalylocalization.AnomalyLocalizer;
import io.skylite.ml.common.algorithms.anomalylocalization.HybridCounter;
import io.skylite.ml.common.engine.Executable;
import io.skylite.ml.common.input.Input;
import io.skylite.ml.common.input.execute.anomalylocalization.AnomalyLocalizationInput;
import io.skylite.ml.common.output.Output;
import io.skylite.ml.common.output.execute.anomalylocalization.AnomalyLocalizationOutput;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.opensearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.filter.Filters;
import org.opensearch.search.aggregations.bucket.filter.FiltersAggregationBuilder;
import org.opensearch.search.aggregations.bucket.filter.FiltersAggregator;
import org.opensearch.search.aggregations.metrics.NumericMetricsAggregation;

public class AnomalyLocalizerImpl
implements AnomalyLocalizer,
Executable {
    private static final Logger log = LogManager.getLogger(AnomalyLocalizerImpl.class);
    protected static final double MIN_DIFF_PCT = 0.01;
    protected static final int MAX_TIME_BUCKETS = 8;
    protected static final int MIN_CONTRIBUTOR_CANDIDATE = 100;
    private final Client client;
    private final Settings settings;
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    public AnomalyLocalizerImpl(Client client, Settings settings, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver) {
        this.client = client;
        this.settings = settings;
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    public void getLocalizationResults(AnomalyLocalizationInput input, ActionListener<AnomalyLocalizationOutput> listener) {
        AnomalyLocalizationOutput output = new AnomalyLocalizationOutput();
        input.getAggregations().stream().forEach(agg -> this.localizeByBuckets(input, (AggregationBuilder)agg, output, (ActionListener<AnomalyLocalizationOutput>)this.notifyOnce(listener)));
    }

    private void localizeByBuckets(AnomalyLocalizationInput input, AggregationBuilder agg, AnomalyLocalizationOutput output, ActionListener<AnomalyLocalizationOutput> listener) {
        LocalizationTimeBuckets timeBuckets = this.getTimeBuckets(input);
        this.getOverallAggregates(input, timeBuckets, agg, output, listener);
    }

    private void getOverallAggregates(AnomalyLocalizationInput input, LocalizationTimeBuckets timeBuckets, AggregationBuilder agg, AnomalyLocalizationOutput output, ActionListener<AnomalyLocalizationOutput> listener) {
        MultiSearchRequest searchRequest = this.newSearchRequestForOverallAggregates(input, agg, timeBuckets);
        this.client.multiSearch(searchRequest, ActionListenerHelper.wrap(r -> this.onOverallAggregatesResponse((MultiSearchResponse)r, input, agg, output, timeBuckets, listener), arg_0 -> listener.onFailure(arg_0)));
    }

    private void onOverallAggregatesResponse(MultiSearchResponse response, AnomalyLocalizationInput input, AggregationBuilder agg, AnomalyLocalizationOutput output, LocalizationTimeBuckets timeBuckets, ActionListener<AnomalyLocalizationOutput> listener) {
        AnomalyLocalizationOutput.Result result = new AnomalyLocalizationOutput.Result();
        List<Map.Entry<Long, Long>> intervals = timeBuckets.getAllIntervals();
        if (this.isIndexExist(input.getIndexName())) {
            for (int i = 0; i < intervals.size(); ++i) {
                double value = this.getDoubleValue((NumericMetricsAggregation.SingleValue)response.getResponses()[i].getResponse().getAggregations().get(agg.getName()));
                AnomalyLocalizationOutput.Bucket bucket = new AnomalyLocalizationOutput.Bucket();
                bucket.setStartTime(intervals.get(i).getKey().longValue());
                bucket.setEndTime(intervals.get(i).getValue().longValue());
                bucket.setOverallAggValue(value);
                result.getBuckets().add(bucket);
            }
            output.getResults().put(agg.getName(), result);
            this.getLocalizedEntities(input, agg, result, output, listener);
        } else {
            log.info("index: {} does not exist", (Object)input.getIndexName());
            listener.onFailure((Exception)new IndexNotFoundException("Failed to find index: " + input.getIndexName()));
        }
    }

    private boolean isIndexExist(String indexName) {
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(this.clusterService.state(), IndicesOptions.lenientExpandOpen(), new String[]{indexName});
        if (concreteIndices == null || concreteIndices.length == 0) {
            return false;
        }
        return Arrays.stream(concreteIndices).anyMatch(index -> this.clusterService.state().metadata().hasIndex(index));
    }

    private void getLocalizedEntities(AnomalyLocalizationInput input, AggregationBuilder agg, AnomalyLocalizationOutput.Result result, AnomalyLocalizationOutput output, ActionListener<AnomalyLocalizationOutput> listener) {
        if (this.setBase(result, input)) {
            HybridCounter counter = new HybridCounter();
            result.getBuckets().stream().filter(e -> e.getBase().isPresent() && ((AnomalyLocalizationOutput.Bucket)e.getBase().get()).equals(e)).forEach(arg_0 -> this.lambda$getLocalizedEntities$4(input, agg, result, (Counter)counter, output, listener, arg_0));
        }
        this.outputIfResultsAreComplete(output, listener);
    }

    private void outputIfResultsAreComplete(AnomalyLocalizationOutput output, ActionListener<AnomalyLocalizationOutput> listener) {
        if (output.getResults().values().stream().allMatch(this::isResultComplete)) {
            listener.onResponse((Object)output);
        }
    }

    private boolean isResultComplete(AnomalyLocalizationOutput.Result result) {
        return result.getBuckets().stream().allMatch(e -> e.getCompleted() == null || e.getCompleted().get());
    }

    private void processBaseEntry(AnomalyLocalizationInput input, AggregationBuilder agg, AnomalyLocalizationOutput.Result result, AnomalyLocalizationOutput.Bucket bucket, Counter counter, Optional<Map<String, Object>> afterKey, AnomalyLocalizationOutput output, ActionListener<AnomalyLocalizationOutput> listener) {
        SearchRequest request = this.newSearchRequestForEntry(input, agg, bucket, afterKey);
        this.client.search(request, ActionListenerHelper.wrap(r -> this.onBaseEntryResponse((SearchResponse)r, input, agg, result, bucket, counter, output, listener), arg_0 -> listener.onFailure(arg_0)));
    }

    private void onBaseEntryResponse(SearchResponse response, AnomalyLocalizationInput input, AggregationBuilder agg, AnomalyLocalizationOutput.Result result, AnomalyLocalizationOutput.Bucket bucket, Counter counter, AnomalyLocalizationOutput output, ActionListener<AnomalyLocalizationOutput> listener) {
        Optional<CompositeAggregation> respAgg = Optional.ofNullable(response.getAggregations()).map(aggs -> (CompositeAggregation)aggs.get(agg.getName()));
        respAgg.map(a -> a.getBuckets()).orElse(Collections.emptyList()).stream().forEach(b -> counter.increment(this.toStringKey(b.getKey(), input), this.getDoubleValue((NumericMetricsAggregation.SingleValue)b.getAggregations().get(agg.getName()))));
        Optional<Map<String, Object>> afterKey = respAgg.map(r -> r.afterKey());
        if (afterKey.isPresent()) {
            this.processBaseEntry(input, agg, result, bucket, counter, afterKey, output, listener);
        } else {
            bucket.setCounter(Optional.of(counter));
            result.getBuckets().stream().filter(e -> e.getCompleted() != null && !e.getCompleted().get()).forEach(e -> {
                int queueSize = Math.max(input.getNumOutputs(), 100);
                PriorityQueue<Object> queue = e.getOverallAggValue() > 0.0 ? new PriorityQueue<AnomalyLocalizationOutput.Entity>(queueSize, (a, b) -> (int)Math.signum(a.getContributionValue() - b.getContributionValue())) : new PriorityQueue(queueSize, (a, b) -> (int)Math.signum(b.getContributionValue() - a.getContributionValue()));
                this.processNewEntry(input, agg, result, (AnomalyLocalizationOutput.Bucket)e, Optional.empty(), (PriorityQueue<AnomalyLocalizationOutput.Entity>)queue, output, listener);
            });
        }
    }

    private void processNewEntry(AnomalyLocalizationInput input, AggregationBuilder agg, AnomalyLocalizationOutput.Result result, AnomalyLocalizationOutput.Bucket bucket, Optional<Map<String, Object>> afterKey, PriorityQueue<AnomalyLocalizationOutput.Entity> queue, AnomalyLocalizationOutput output, ActionListener<AnomalyLocalizationOutput> listener) {
        SearchRequest request = this.newSearchRequestForEntry(input, agg, bucket, afterKey);
        this.client.search(request, ActionListenerHelper.wrap(r -> this.onNewEntryResponse((SearchResponse)r, input, agg, result, bucket, queue, output, listener), arg_0 -> listener.onFailure(arg_0)));
    }

    private void onNewEntryResponse(SearchResponse response, AnomalyLocalizationInput input, AggregationBuilder agg, AnomalyLocalizationOutput.Result result, AnomalyLocalizationOutput.Bucket outputBucket, PriorityQueue<AnomalyLocalizationOutput.Entity> queue, AnomalyLocalizationOutput output, ActionListener<AnomalyLocalizationOutput> listener) {
        Optional<CompositeAggregation> respAgg = Optional.ofNullable(response.getAggregations()).map(aggs -> (CompositeAggregation)aggs.get(agg.getName()));
        for (CompositeAggregation.Bucket bucket : respAgg.map(a -> a.getBuckets()).orElse(Collections.emptyList())) {
            List<String> key = this.toStringKey(bucket.getKey(), input);
            AnomalyLocalizationOutput.Entity entity = new AnomalyLocalizationOutput.Entity();
            entity.setKey(key);
            entity.setNewValue(this.getDoubleValue((NumericMetricsAggregation.SingleValue)bucket.getAggregations().get(agg.getName())));
            entity.setBaseValue(((Counter)((AnomalyLocalizationOutput.Bucket)outputBucket.getBase().get()).getCounter().get()).estimate(key));
            entity.setContributionValue(entity.getNewValue() - entity.getBaseValue());
            if (queue.size() < input.getNumOutputs()) {
                queue.add(entity);
                continue;
            }
            if (queue.comparator().compare(queue.peek(), entity) >= 0) continue;
            queue.poll();
            queue.add(entity);
        }
        Optional<Map<String, Object>> afterKey = respAgg.map(r -> r.afterKey());
        if (afterKey.isPresent()) {
            this.processNewEntry(input, agg, result, outputBucket, afterKey, queue, output, listener);
        } else {
            List<List<String>> keys = queue.stream().map(AnomalyLocalizationOutput.Entity::getKey).collect(Collectors.toList());
            SearchRequest request = this.newSearchRequestForEntityKeys(input, agg, outputBucket, keys);
            this.client.search(request, ActionListenerHelper.wrap(r -> this.onEntityKeysResponse((SearchResponse)r, input, agg, result, outputBucket, queue, output, listener), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private void onEntityKeysResponse(SearchResponse response, AnomalyLocalizationInput input, AggregationBuilder agg, AnomalyLocalizationOutput.Result result, AnomalyLocalizationOutput.Bucket bucket, PriorityQueue<AnomalyLocalizationOutput.Entity> queue, AnomalyLocalizationOutput output, ActionListener<AnomalyLocalizationOutput> listener) {
        List<Object> entities = new ArrayList<AnomalyLocalizationOutput.Entity>(queue);
        Optional<Filters> respAgg = Optional.ofNullable(response.getAggregations()).map(aggs -> (Filters)aggs.get(agg.getName()));
        for (Filters.Bucket respBucket : respAgg.map(a -> a.getBuckets()).orElse(Collections.emptyList())) {
            int entityIndex = Integer.parseInt(respBucket.getKeyAsString());
            double aggValue = this.getDoubleValue((NumericMetricsAggregation.SingleValue)respBucket.getAggregations().get(agg.getName()));
            AnomalyLocalizationOutput.Entity entity2 = (AnomalyLocalizationOutput.Entity)entities.get(entityIndex);
            entity2.setBaseValue(aggValue);
            entity2.setContributionValue(entity2.getNewValue() - entity2.getBaseValue());
        }
        double newChangeSign = Math.signum(bucket.getOverallAggValue() - ((AnomalyLocalizationOutput.Bucket)bucket.getBase().get()).getOverallAggValue());
        entities = entities.stream().filter(entity -> Math.signum(entity.getContributionValue()) == newChangeSign).sorted(queue.comparator().reversed()).collect(Collectors.toList());
        bucket.setEntities(entities);
        bucket.getCompleted().set(true);
        this.outputIfResultsAreComplete(output, listener);
    }

    private SearchRequest newSearchRequestForEntityKeys(AnomalyLocalizationInput input, AggregationBuilder agg, AnomalyLocalizationOutput.Bucket bucket, List<List<String>> keys) {
        RangeQueryBuilder timeRangeFilter = new RangeQueryBuilder(input.getTimeFieldName()).from((Object)((AnomalyLocalizationOutput.Bucket)bucket.getBase().get()).getStartTime(), true).to((Object)((AnomalyLocalizationOutput.Bucket)bucket.getBase().get()).getEndTime(), true);
        BoolQueryBuilder filter = QueryBuilders.boolQuery().filter((QueryBuilder)timeRangeFilter);
        input.getFilterQuery().ifPresent(q -> filter.filter(q));
        FiltersAggregator.KeyedFilter[] filters = (FiltersAggregator.KeyedFilter[])IntStream.range(0, keys.size()).mapToObj(i -> new FiltersAggregator.KeyedFilter(Integer.toString(i), (QueryBuilder)this.newQueryByKey((List)keys.get(i), input))).toArray(FiltersAggregator.KeyedFilter[]::new);
        FiltersAggregationBuilder filtersAgg = AggregationBuilders.filters((String)agg.getName(), (FiltersAggregator.KeyedFilter[])filters);
        filtersAgg.subAggregation(agg);
        SearchSourceBuilder search = new SearchSourceBuilder().size(0).query((QueryBuilder)filter).aggregation((AggregationBuilder)filtersAgg);
        SearchRequest searchRequest = new SearchRequest(new String[]{input.getIndexName()}, search);
        return searchRequest;
    }

    private BoolQueryBuilder newQueryByKey(List<String> key, AnomalyLocalizationInput input) {
        BoolQueryBuilder bool = new BoolQueryBuilder();
        IntStream.range(0, key.size()).forEach(i -> bool.filter((QueryBuilder)new TermQueryBuilder((String)input.getAttributeFieldNames().get(i), (String)key.get(i))));
        return bool;
    }

    private List<String> toStringKey(Map<String, Object> key, AnomalyLocalizationInput input) {
        return input.getAttributeFieldNames().stream().map(name -> key.get(name).toString()).collect(Collectors.toList());
    }

    private SearchRequest newSearchRequestForEntry(AnomalyLocalizationInput input, AggregationBuilder agg, AnomalyLocalizationOutput.Bucket bucket, Optional<Map<String, Object>> afterKey) {
        RangeQueryBuilder timeRangeFilter = new RangeQueryBuilder(input.getTimeFieldName()).from((Object)bucket.getStartTime(), true).to((Object)bucket.getEndTime(), true);
        BoolQueryBuilder filter = QueryBuilders.boolQuery().filter((QueryBuilder)timeRangeFilter);
        input.getFilterQuery().ifPresent(q -> filter.filter(q));
        CompositeAggregationBuilder compositeAgg = new CompositeAggregationBuilder(agg.getName(), input.getAttributeFieldNames().stream().map(name -> (TermsValuesSourceBuilder)new TermsValuesSourceBuilder(name).field(name)).collect(Collectors.toList())).size(((Integer)MultiBucketConsumerService.MAX_BUCKET_SETTING.get(this.settings)).intValue());
        compositeAgg.subAggregation(agg);
        if (afterKey.isPresent()) {
            compositeAgg.aggregateAfter(afterKey.get());
        }
        SearchSourceBuilder search = new SearchSourceBuilder().size(0).query((QueryBuilder)filter).aggregation((AggregationBuilder)compositeAgg);
        SearchRequest searchRequest = new SearchRequest(new String[]{input.getIndexName()}, search);
        return searchRequest;
    }

    private boolean setBase(AnomalyLocalizationOutput.Result result, AnomalyLocalizationInput input) {
        boolean newEntry = false;
        List entries = result.getBuckets();
        int baseEntryIndex = 0;
        AnomalyLocalizationOutput.Bucket baseEntry = (AnomalyLocalizationOutput.Bucket)entries.get(baseEntryIndex);
        baseEntry.setBase(Optional.of(baseEntry));
        for (int i = 1; i < entries.size(); ++i) {
            AnomalyLocalizationOutput.Bucket currentEntry = (AnomalyLocalizationOutput.Bucket)entries.get(i);
            if (input.getAnomalyStartTime().isPresent()) {
                if (currentEntry.getEndTime() <= (Long)input.getAnomalyStartTime().get()) continue;
                currentEntry.setBase(Optional.of(baseEntry));
                currentEntry.setCompleted(new AtomicBoolean(false));
                newEntry = true;
                continue;
            }
            if (!(Math.abs(1.0 - currentEntry.getOverallAggValue() / baseEntry.getOverallAggValue()) > 0.01)) continue;
            currentEntry.setBase(Optional.of(baseEntry));
            currentEntry.setCompleted(new AtomicBoolean(false));
            newEntry = true;
        }
        return newEntry;
    }

    private MultiSearchRequest newSearchRequestForOverallAggregates(AnomalyLocalizationInput input, AggregationBuilder agg, LocalizationTimeBuckets timeBuckets) {
        MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
        timeBuckets.getAllIntervals().stream().map(i -> {
            RangeQueryBuilder timeRangeFilter = new RangeQueryBuilder(input.getTimeFieldName()).from(i.getKey(), true).to(i.getValue(), true);
            BoolQueryBuilder filter = QueryBuilders.boolQuery().filter((QueryBuilder)timeRangeFilter);
            input.getFilterQuery().ifPresent(q -> filter.filter(q));
            SearchSourceBuilder search = new SearchSourceBuilder().size(0).query((QueryBuilder)filter).aggregation(agg);
            SearchRequest searchRequest = new SearchRequest(new String[]{input.getIndexName()}, search);
            return searchRequest;
        }).forEach(arg_0 -> ((MultiSearchRequest)multiSearchRequest).add(arg_0));
        return multiSearchRequest;
    }

    private LocalizationTimeBuckets getTimeBuckets(AnomalyLocalizationInput input) {
        LocalizationTimeBuckets buckets;
        if (input.getEndTime() - input.getStartTime() < 2L * input.getMinTimeInterval()) {
            throw new IllegalArgumentException("Time range is too short");
        }
        if (input.getAnomalyStartTime().isPresent()) {
            long anomalyStart = (Long)input.getAnomalyStartTime().get();
            long end = Math.max(input.getEndTime(), anomalyStart + input.getMinTimeInterval());
            int numBuckets = Math.min((int)((end - anomalyStart) / input.getMinTimeInterval()), 7);
            long bucketInterval = (end - anomalyStart) / (long)numBuckets;
            long start = Math.min(input.getStartTime(), anomalyStart - bucketInterval);
            buckets = new LocalizationTimeBuckets(bucketInterval, start, IntStream.range(0, numBuckets).mapToLong(i -> anomalyStart + (long)i * bucketInterval).toArray());
        } else {
            int numBuckets = Math.min((int)((input.getEndTime() - input.getStartTime()) / input.getMinTimeInterval()), 8);
            long bucketIntervalMillis = (input.getEndTime() - input.getStartTime()) / (long)numBuckets;
            buckets = new LocalizationTimeBuckets(bucketIntervalMillis, input.getStartTime(), IntStream.rangeClosed(1, numBuckets - 1).mapToLong(i -> input.getStartTime() + (long)i * bucketIntervalMillis).toArray());
        }
        return buckets;
    }

    private <R> ActionListener<R> notifyOnce(final ActionListener<R> listener) {
        return new NotifyOnceListener<R>(this){

            public void innerOnResponse(R r) {
                listener.onResponse(r);
            }

            public void innerOnFailure(Exception e) {
                listener.onFailure(e);
            }
        };
    }

    private double getDoubleValue(NumericMetricsAggregation.SingleValue singleValue) {
        double value = singleValue.value();
        return Double.isFinite(value) ? value : 0.0;
    }

    public void execute(Input input, ActionListener<Output> listener) {
        this.getLocalizationResults((AnomalyLocalizationInput)input, (ActionListener<AnomalyLocalizationOutput>)ActionListenerHelper.wrap(arg_0 -> listener.onResponse(arg_0), arg_0 -> listener.onFailure(arg_0)));
    }

    private /* synthetic */ void lambda$getLocalizedEntities$4(AnomalyLocalizationInput input, AggregationBuilder agg, AnomalyLocalizationOutput.Result result, Counter counter, AnomalyLocalizationOutput output, ActionListener listener, AnomalyLocalizationOutput.Bucket e) {
        this.processBaseEntry(input, agg, result, e, counter, Optional.empty(), output, (ActionListener<AnomalyLocalizationOutput>)listener);
    }

    protected static class LocalizationTimeBuckets {
        private final long interval;
        private final long baseBucket;
        private final long[] newBuckets;

        public LocalizationTimeBuckets(long interval, long baseBucket, long[] newBuckets) {
            this.interval = interval;
            this.baseBucket = baseBucket;
            this.newBuckets = newBuckets;
        }

        protected List<Map.Entry<Long, Long>> getAllIntervals() {
            ArrayList<Map.Entry<Long, Long>> intervals = new ArrayList<Map.Entry<Long, Long>>(this.newBuckets.length + 1);
            intervals.add(new AbstractMap.SimpleEntry<Long, Long>(this.baseBucket, this.baseBucket + this.interval));
            Arrays.stream(this.newBuckets).forEach(t -> intervals.add(new AbstractMap.SimpleEntry<Long, Long>(t, t + this.interval)));
            return intervals;
        }

        public long getInterval() {
            return this.interval;
        }

        public long getBaseBucket() {
            return this.baseBucket;
        }

        public long[] getNewBuckets() {
            return this.newBuckets;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocalizationTimeBuckets that = (LocalizationTimeBuckets)o;
            return this.interval == that.interval && this.baseBucket == that.baseBucket && Objects.deepEquals(this.newBuckets, that.newBuckets);
        }

        public int hashCode() {
            return Objects.hash(this.interval, this.baseBucket, Arrays.hashCode(this.newBuckets));
        }

        public String toString() {
            return "LocalizationTimeBuckets{interval=" + this.interval + ", baseBucket=" + this.baseBucket + ", newBuckets=" + Arrays.toString(this.newBuckets) + "}";
        }
    }
}

