/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.engine.algorithms.rcf;

import com.amazon.randomcutforest.parkservices.state.ThresholdedRandomCutForestState;
import com.amazon.randomcutforest.state.RandomCutForestState;
import io.protostuff.LinkedBuffer;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import io.skylite.ml.common.algorithms.util.ModelSerDeSer;
import io.skylite.ml.common.model.MLModel;
import java.security.AccessController;

public final class RCFModelSerDeSer {
    private static final int SERIALIZATION_BUFFER_BYTES = 512;
    private static final Schema<RandomCutForestState> rcfSchema = AccessController.doPrivileged(() -> RuntimeSchema.getSchema(RandomCutForestState.class));
    private static final Schema<ThresholdedRandomCutForestState> trcfSchema = AccessController.doPrivileged(() -> RuntimeSchema.getSchema(ThresholdedRandomCutForestState.class));

    public static byte[] serializeRCF(RandomCutForestState model) {
        return RCFModelSerDeSer.serialize(model, rcfSchema);
    }

    public static byte[] serializeTRCF(ThresholdedRandomCutForestState model) {
        return RCFModelSerDeSer.serialize(model, trcfSchema);
    }

    public static RandomCutForestState deserializeRCF(MLModel model) {
        return RCFModelSerDeSer.deserializeRCF(ModelSerDeSer.decodeBase64((String)model.getContent()));
    }

    public static RandomCutForestState deserializeRCF(byte[] bytes) {
        return RCFModelSerDeSer.deserialize(bytes, rcfSchema);
    }

    public static ThresholdedRandomCutForestState deserializeTRCF(MLModel model) {
        return RCFModelSerDeSer.deserializeTRCF(ModelSerDeSer.decodeBase64((String)model.getContent()));
    }

    public static ThresholdedRandomCutForestState deserializeTRCF(byte[] bytes) {
        return RCFModelSerDeSer.deserialize(bytes, trcfSchema);
    }

    private static <T> byte[] serialize(T model, Schema<T> schema) {
        LinkedBuffer buffer = LinkedBuffer.allocate((int)512);
        byte[] bytes = AccessController.doPrivileged(() -> ProtostuffIOUtil.toByteArray((Object)model, (Schema)schema, (LinkedBuffer)buffer));
        return bytes;
    }

    private static <T> T deserialize(byte[] bytes, Schema<T> schema) {
        Object model = schema.newMessage();
        AccessController.doPrivileged(() -> {
            ProtostuffIOUtil.mergeFrom((byte[])bytes, (Object)model, (Schema)schema);
            return null;
        });
        return (T)model;
    }
}

