/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.engine.algorithms.sample;

import io.skylite.common.action.ActionListener;
import io.skylite.core.client.Client;
import io.skylite.core.settings.Settings;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.annotation.Function;
import io.skylite.ml.common.engine.Executable;
import io.skylite.ml.common.input.Input;
import io.skylite.ml.common.input.execute.samplecalculator.LocalSampleCalculatorInput;
import io.skylite.ml.common.output.Output;
import io.skylite.ml.common.output.execute.samplecalculator.LocalSampleCalculatorOutput;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

@Function(value=FunctionName.LOCAL_SAMPLE_CALCULATOR)
public class LocalSampleCalculator
implements Executable {
    private Client client;
    private Settings settings;

    public LocalSampleCalculator() {
    }

    public LocalSampleCalculator(Client client, Settings settings) {
        this.client = client;
        this.settings = settings;
    }

    public void execute(Input input, ActionListener<Output> listener) {
        if (!(input instanceof LocalSampleCalculatorInput)) {
            throw new IllegalArgumentException("wrong input");
        }
        LocalSampleCalculatorInput sampleCalculatorInput = (LocalSampleCalculatorInput)input;
        String operation = sampleCalculatorInput.getOperation();
        List inputData = sampleCalculatorInput.getInputData();
        switch (operation) {
            case "sum": {
                double sum = inputData.stream().mapToDouble(f -> f).sum();
                listener.onResponse((Object)new LocalSampleCalculatorOutput(Double.valueOf(sum)));
                return;
            }
            case "max": {
                double max = (Double)inputData.stream().max(Comparator.naturalOrder()).get();
                listener.onResponse((Object)new LocalSampleCalculatorOutput(Double.valueOf(max)));
                return;
            }
            case "min": {
                double min = (Double)inputData.stream().min(Comparator.naturalOrder()).get();
                listener.onResponse((Object)new LocalSampleCalculatorOutput(Double.valueOf(min)));
                return;
            }
        }
        throw new IllegalArgumentException("can't support this operation");
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalSampleCalculator that = (LocalSampleCalculator)o;
        return Objects.equals(this.client, that.client) && Objects.equals(this.settings, that.settings);
    }

    public int hashCode() {
        return Objects.hash(this.client, this.settings);
    }

    public String toString() {
        return "LocalSampleCalculator{client=" + String.valueOf(this.client) + ", settings=" + String.valueOf(this.settings) + "}";
    }
}

