/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.engine.algorithms.text_similarity;

import ai.djl.modality.Input;
import ai.djl.modality.Output;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorFactory;
import io.lucenia.ml.common.engine.algorithms.text_similarity.TextSimilarityTranslator;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.algorithms.DLModel;
import io.skylite.ml.common.annotation.Function;
import io.skylite.ml.common.dataset.MLInputDataset;
import io.skylite.ml.common.dataset.TextSimilarityInputDataSet;
import io.skylite.ml.common.input.MLInput;
import io.skylite.ml.common.model.MLModelConfig;
import io.skylite.ml.common.output.model.ModelTensorOutput;
import io.skylite.ml.common.output.model.ModelTensors;
import java.util.ArrayList;

@Function(value=FunctionName.TEXT_SIMILARITY)
public class TextSimilarityCrossEncoderModel
extends DLModel {
    public ModelTensorOutput predict(String modelId, MLInput mlInput) throws TranslateException {
        MLInputDataset inputDataSet = mlInput.getInputDataset();
        ArrayList<ModelTensors> tensorOutputs = new ArrayList<ModelTensors>();
        TextSimilarityInputDataSet textSimInput = (TextSimilarityInputDataSet)inputDataSet;
        String queryText = textSimInput.getQueryText();
        for (String doc : textSimInput.getTextDocs()) {
            Input input = new Input();
            input.add(queryText);
            input.add(doc);
            Output output = (Output)this.getPredictor().predict((Object)input);
            ModelTensors outputTensors = ModelTensors.fromBytes((byte[])output.getData().getAsBytes());
            tensorOutputs.add(outputTensors);
        }
        return new ModelTensorOutput(tensorOutputs);
    }

    public Translator<Input, Output> getTranslator(String engine, MLModelConfig modelConfig) throws IllegalArgumentException {
        return new TextSimilarityTranslator();
    }

    public TranslatorFactory getTranslatorFactory(String engine, MLModelConfig modelConfig) {
        return null;
    }
}

