/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.engine.encryptors;

import com.amazonaws.encryptionsdk.AwsCrypto;
import com.amazonaws.encryptionsdk.CommitmentPolicy;
import com.amazonaws.encryptionsdk.CryptoResult;
import com.amazonaws.encryptionsdk.MasterKeyProvider;
import com.amazonaws.encryptionsdk.jce.JceMasterKey;
import io.lucenia.ml.common.engine.systemindices.MLIndicesHandler;
import io.skylite.ResourceNotFoundException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.DocWriteRequest;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.Strings;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.index.engine.VersionConflictEngineException;
import io.skylite.ml.common.engine.Encryptor;
import io.skylite.ml.common.exception.MLException;
import io.skylite.ml.common.exception.MLExceptionUtils;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AWSEncryptorImpl
implements Encryptor {
    private static final Logger log = LogManager.getLogger(AWSEncryptorImpl.class);
    public static final String MASTER_KEY_NOT_READY_ERROR = "The ML encryption master key has not been initialized yet. Please retry after waiting for 10 seconds.";
    private ClusterService clusterService;
    private Client client;
    private final Map<String, String> tenantMasterKeys = new ConcurrentHashMap<String, String>();
    private MLIndicesHandler mlIndicesHandler;
    public static final String DEFAULT_TENANT_ID = "03000200-0400-0500-0006-000700080009";

    public AWSEncryptorImpl(ClusterService clusterService, Client client, MLIndicesHandler mlIndicesHandler) {
        this.clusterService = clusterService;
        this.client = client;
        this.mlIndicesHandler = mlIndicesHandler;
    }

    public AWSEncryptorImpl(String tenantId, String masterKey) {
        this.tenantMasterKeys.put(Objects.requireNonNullElse(tenantId, DEFAULT_TENANT_ID), masterKey);
    }

    public void setMasterKey(String tenantId, String masterKey) {
        this.tenantMasterKeys.put(Objects.requireNonNullElse(tenantId, DEFAULT_TENANT_ID), masterKey);
    }

    public String getMasterKey(String tenantId) {
        return this.tenantMasterKeys.get(Objects.requireNonNullElse(tenantId, DEFAULT_TENANT_ID));
    }

    public String encrypt(String plainText, String tenantId) {
        this.initMasterKey(tenantId);
        AwsCrypto crypto = AwsCrypto.builder().withCommitmentPolicy(CommitmentPolicy.RequireEncryptRequireDecrypt).build();
        JceMasterKey jceMasterKey = this.createJceMasterKey(tenantId);
        CryptoResult encryptResult = crypto.encryptData((MasterKeyProvider)jceMasterKey, plainText.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString((byte[])encryptResult.getResult());
    }

    public String decrypt(String encryptedText, String tenantId) {
        this.initMasterKey(tenantId);
        AwsCrypto crypto = AwsCrypto.builder().withCommitmentPolicy(CommitmentPolicy.RequireEncryptRequireDecrypt).build();
        JceMasterKey jceMasterKey = this.createJceMasterKey(tenantId);
        CryptoResult decryptedResult = crypto.decryptData((MasterKeyProvider)jceMasterKey, Base64.getDecoder().decode(encryptedText));
        return new String((byte[])decryptedResult.getResult(), StandardCharsets.UTF_8);
    }

    public String generateMasterKey() {
        byte[] keyBytes = new byte[32];
        new SecureRandom().nextBytes(keyBytes);
        return Base64.getEncoder().encodeToString(keyBytes);
    }

    private JceMasterKey createJceMasterKey(String tenantId) {
        byte[] bytes = Base64.getDecoder().decode(this.tenantMasterKeys.get(Objects.requireNonNullElse(tenantId, DEFAULT_TENANT_ID)));
        return JceMasterKey.getInstance((SecretKey)new SecretKeySpec(bytes, "AES"), (String)"Custom", (String)"", (String)"AES/GCM/NOPADDING");
    }

    private void initMasterKey(String tenantId) {
        if (this.tenantMasterKeys.containsKey(Objects.requireNonNullElse(tenantId, DEFAULT_TENANT_ID))) {
            return;
        }
        AtomicReference exceptionRef = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        this.mlIndicesHandler.initMLConfigIndex((ActionListener<Boolean>)ActionListenerHelper.wrap(r -> {
            if (!r.booleanValue()) {
                exceptionRef.set(new RuntimeException("No response to create ML Config index"));
                latch.countDown();
            } else {
                Object masterKeyId = "master_key";
                if (tenantId != null) {
                    masterKeyId = "master_key_" + Strings.hashString((String)tenantId);
                }
                String MASTER_KEY_ID = masterKeyId;
                GetRequest getRequest = new GetRequest(".plugins-ml-config").id(MASTER_KEY_ID);
                try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                    this.client.get(getRequest, ActionListenerHelper.wrap(getResponse -> {
                        if (getResponse == null || !getResponse.isExists()) {
                            IndexRequest indexRequest = new IndexRequest(".plugins-ml-config").id(MASTER_KEY_ID);
                            String generatedMasterKey = this.generateMasterKey();
                            HashMap<String, Object> sourceMap = new HashMap<String, Object>();
                            sourceMap.put(MASTER_KEY_ID, generatedMasterKey);
                            sourceMap.put("create_time", Instant.now().toEpochMilli());
                            if (tenantId != null) {
                                sourceMap.put("tenant_id", tenantId);
                            }
                            indexRequest.source(sourceMap);
                            indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                            indexRequest.opType(DocWriteRequest.OpType.CREATE);
                            this.client.index(indexRequest, ActionListenerHelper.wrap(indexResponse -> {
                                this.tenantMasterKeys.put(Objects.requireNonNullElse(tenantId, DEFAULT_TENANT_ID), generatedMasterKey);
                                log.info("ML encryption master key initialized successfully");
                                latch.countDown();
                            }, e -> {
                                if (MLExceptionUtils.getRootCause((Throwable)e) instanceof VersionConflictEngineException) {
                                    GetRequest getMasterKeyRequest = new GetRequest(".plugins-ml-config").id(MASTER_KEY_ID);
                                    try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
                                        this.client.get(getMasterKeyRequest, ActionListenerHelper.wrap(getMasterKeyResponse -> {
                                            if (getMasterKeyResponse != null && getMasterKeyResponse.isExists()) {
                                                this.tenantMasterKeys.put(Objects.requireNonNullElse(tenantId, DEFAULT_TENANT_ID), (String)getMasterKeyResponse.getSourceAsMap().get(MASTER_KEY_ID));
                                                log.info("ML encryption master key already initialized, no action needed");
                                                latch.countDown();
                                            } else {
                                                exceptionRef.set(new ResourceNotFoundException(MASTER_KEY_NOT_READY_ERROR, new Object[0]));
                                                latch.countDown();
                                            }
                                        }, error -> {
                                            log.debug("Failed to get ML encryption master key", (Throwable)e);
                                            exceptionRef.set(error);
                                            latch.countDown();
                                        }));
                                    }
                                } else {
                                    log.debug("Failed to index ML encryption master key", (Throwable)e);
                                    exceptionRef.set(e);
                                    latch.countDown();
                                }
                            }));
                        } else {
                            String masterKey = (String)getResponse.getSourceAsMap().get(MASTER_KEY_ID);
                            this.tenantMasterKeys.put(Objects.requireNonNullElse(tenantId, DEFAULT_TENANT_ID), masterKey);
                            log.info("ML encryption master key already initialized, no action needed");
                            latch.countDown();
                        }
                    }, e -> {
                        log.debug("Failed to get ML encryption master key from config index", (Throwable)e);
                        exceptionRef.set(e);
                        latch.countDown();
                    }));
                }
            }
        }, e -> {
            log.debug("Failed to init ML config index", (Throwable)e);
            exceptionRef.set(e);
            latch.countDown();
        }));
        try {
            boolean completed = latch.await(3L, TimeUnit.SECONDS);
            if (!completed) {
                throw new MLException("Fetching master key timed out.");
            }
        }
        catch (InterruptedException e2) {
            throw new IllegalStateException(e2);
        }
        if (exceptionRef.get() != null) {
            log.debug("Failed to init master key", (Throwable)exceptionRef.get());
            if (exceptionRef.get() instanceof RuntimeException) {
                throw (RuntimeException)exceptionRef.get();
            }
            throw new MLException((Throwable)exceptionRef.get());
        }
        if (this.tenantMasterKeys.get(Objects.requireNonNullElse(tenantId, DEFAULT_TENANT_ID)) == null) {
            throw new ResourceNotFoundException(MASTER_KEY_NOT_READY_ERROR, new Object[0]);
        }
    }
}

