/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.engine.indices;

import io.lucenia.ml.common.dataset.SearchQueryInputDataset;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.client.Client;
import io.skylite.core.search.SearchHit;
import io.skylite.core.search.SearchHits;
import io.skylite.core.search.SearchRequest;
import io.skylite.ml.common.dataframe.DataFrame;
import io.skylite.ml.common.dataframe.DataFrameBuilder;
import io.skylite.ml.common.dataset.DataFrameInputDataset;
import io.skylite.ml.common.dataset.MLInputDataType;
import io.skylite.ml.common.dataset.MLInputDataset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MLInputDatasetHandler {
    private static final Logger log = LogManager.getLogger(MLInputDatasetHandler.class);
    private Client client;

    public MLInputDatasetHandler(Client client) {
        this.client = client;
    }

    public void parseSearchQueryInput(MLInputDataset mlInputDataset, ActionListener<MLInputDataset> listener) {
        if (!mlInputDataset.getInputDataType().equals((Object)MLInputDataType.SEARCH_QUERY)) {
            throw new IllegalArgumentException("Input dataset is not SEARCH_QUERY type.");
        }
        SearchQueryInputDataset inputDataset = (SearchQueryInputDataset)mlInputDataset;
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.source(inputDataset.getSearchSourceBuilder());
        List<String> indicesList = inputDataset.getIndices();
        String[] indices = new String[indicesList.size()];
        indices = indicesList.toArray(indices);
        searchRequest.indices(indices);
        this.client.search(searchRequest, ActionListenerHelper.wrap(r -> {
            SearchHit[] searchHits;
            if (r == null || r.getHits() == null || r.getHits().getTotalHits() == null || r.getHits().getTotalHits().value() == 0L) {
                listener.onFailure((Exception)new IllegalArgumentException("No document found"));
                return;
            }
            SearchHits hits = r.getHits();
            ArrayList<Map> input = new ArrayList<Map>();
            for (SearchHit hit : searchHits = hits.getHits()) {
                input.add(hit.getSourceAsMap());
            }
            DataFrame dataFrame = DataFrameBuilder.load(input);
            DataFrameInputDataset dfInputDataset = new DataFrameInputDataset(dataFrame);
            listener.onResponse((Object)dfInputDataset);
        }, e -> {
            log.error("Failed to search");
            listener.onFailure(e);
        }));
    }
}

