/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.engine.systemindices;

import io.skylite.ResourceAlreadyExistsException;
import io.skylite.SkyliteWrapperException;
import io.skylite.common.action.ActionListener;
import io.skylite.common.xcontent.XContentType;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.admin.indices.create.CreateIndexRequest;
import io.skylite.core.action.admin.indices.mapping.put.PutMappingRequest;
import io.skylite.core.action.admin.indices.settings.put.UpdateSettingsRequest;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.xcontent.MediaType;
import io.skylite.ml.common.CommonValue;
import io.skylite.ml.common.exception.MLException;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.systemindices.MLIndex;
import io.skylite.ml.common.utils.IndexUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import reactor.util.annotation.NonNull;

public class MLIndicesHandler {
    private static final Logger log = LogManager.getLogger(MLIndicesHandler.class);
    private static final Map<String, AtomicBoolean> indexMappingUpdated = new HashMap<String, AtomicBoolean>();
    private final ClusterService clusterService;
    private final Client client;
    @NonNull
    MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public MLIndicesHandler(ClusterService clusterService, Client client) {
        this.clusterService = clusterService;
        this.client = client;
    }

    public void initModelGroupIndexIfAbsent(ActionListener<Boolean> listener) {
        this.initMLIndexIfAbsent(MLIndex.MODEL_GROUP, listener);
    }

    public void initModelIndexIfAbsent(ActionListener<Boolean> listener) {
        this.initMLIndexIfAbsent(MLIndex.MODEL, listener);
    }

    public void initMLTaskIndex(ActionListener<Boolean> listener) {
        this.initMLIndexIfAbsent(MLIndex.TASK, listener);
    }

    public void initMLConnectorIndex(ActionListener<Boolean> listener) {
        this.initMLIndexIfAbsent(MLIndex.CONNECTOR, listener);
    }

    public void initMLMcpSessionManagementIndex(ActionListener<Boolean> listener) {
        this.initMLIndexIfAbsent(MLIndex.MCP_SESSION_MANAGEMENT, listener);
    }

    public void initMLMcpToolsIndex(ActionListener<Boolean> listener) {
        this.initMLIndexIfAbsent(MLIndex.MCP_TOOLS, listener);
    }

    public void initMemoryMetaIndex(ActionListener<Boolean> listener) {
        this.initMLIndexIfAbsent(MLIndex.MEMORY_META, listener);
    }

    public void initMemoryMessageIndex(ActionListener<Boolean> listener) {
        this.initMLIndexIfAbsent(MLIndex.MEMORY_MESSAGE, listener);
    }

    public void initMLConfigIndex(ActionListener<Boolean> listener) {
        this.initMLIndexIfAbsent(MLIndex.CONFIG, listener);
    }

    public void initMLControllerIndex(ActionListener<Boolean> listener) {
        this.initMLIndexIfAbsent(MLIndex.CONTROLLER, listener);
    }

    public void initMLAgentIndex(ActionListener<Boolean> listener) {
        this.initMLIndexIfAbsent(MLIndex.AGENT, listener);
    }

    public void initMLIndexIfAbsent(MLIndex index, ActionListener<Boolean> listener) {
        String indexName = index.getIndexName();
        String mapping = index.getMapping();
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListenerHelper.runBefore(listener, () -> threadContext.restore());
            if (!this.clusterService.state().metadata().hasIndex(indexName)) {
                ActionListener actionListener = ActionListenerHelper.wrap(r -> {
                    if (r.isAcknowledged()) {
                        log.info("create index:{}", (Object)indexName);
                        internalListener.onResponse((Object)true);
                    } else {
                        internalListener.onResponse((Object)false);
                    }
                }, e -> {
                    if (e instanceof ResourceAlreadyExistsException || e instanceof SkyliteWrapperException && e.getCause() instanceof ResourceAlreadyExistsException) {
                        log.info("Skip creating the Index:{} that is already created by another parallel request", (Object)indexName);
                        internalListener.onResponse((Object)true);
                    } else {
                        log.error("Failed to create index {}", (Object)indexName);
                        internalListener.onFailure(e);
                    }
                });
                CreateIndexRequest request = new CreateIndexRequest(indexName).mapping(mapping, (MediaType)XContentType.JSON).settings(indexName.equals(MLIndex.CONFIG.getIndexName()) ? IndexUtils.ALL_NODES_REPLICA_INDEX_SETTINGS : IndexUtils.DEFAULT_INDEX_SETTINGS);
                this.client.admin().indices().create(request, actionListener);
            } else {
                log.debug("index:{} is already created", (Object)indexName);
                if (indexMappingUpdated.containsKey(indexName) && !indexMappingUpdated.get(indexName).get()) {
                    this.shouldUpdateIndex(indexName, index.getVersion(), (ActionListener<Boolean>)ActionListenerHelper.wrap(r -> {
                        if (r.booleanValue()) {
                            this.client.admin().indices().putMapping(new PutMappingRequest().indices(new String[]{indexName}).source(mapping, (MediaType)XContentType.JSON), ActionListenerHelper.wrap(response -> {
                                if (response.isAcknowledged()) {
                                    UpdateSettingsRequest updateSettingRequest = new UpdateSettingsRequest();
                                    updateSettingRequest.indices(new String[]{indexName}).settings(indexName.equals(MLIndex.CONFIG.getIndexName()) ? IndexUtils.UPDATED_ALL_NODES_REPLICA_INDEX_SETTINGS : IndexUtils.UPDATED_DEFAULT_INDEX_SETTINGS);
                                    this.client.admin().indices().updateSettings(updateSettingRequest, ActionListenerHelper.wrap(updateResponse -> {
                                        if (response.isAcknowledged()) {
                                            indexMappingUpdated.get(indexName).set(true);
                                            internalListener.onResponse((Object)true);
                                        } else {
                                            internalListener.onFailure((Exception)new MLException("Failed to update index setting for: " + indexName));
                                        }
                                    }, exception -> {
                                        log.error("Failed to update index setting for: {}", (Object)indexName);
                                        internalListener.onFailure(exception);
                                    }));
                                } else {
                                    internalListener.onFailure((Exception)new MLException("Failed to update index: " + indexName));
                                }
                            }, exception -> {
                                log.error("Failed to update index {}", (Object)indexName);
                                internalListener.onFailure(exception);
                            }));
                        } else {
                            indexMappingUpdated.get(indexName).set(true);
                            internalListener.onResponse((Object)true);
                        }
                    }, e -> {
                        log.error("Failed to update index mapping", (Throwable)e);
                        internalListener.onFailure(e);
                    }));
                } else {
                    internalListener.onResponse((Object)true);
                }
            }
        }
        catch (Exception e2) {
            log.error("Failed to init index {}", (Object)indexName);
            listener.onFailure(e2);
        }
    }

    public void shouldUpdateIndex(String indexName, Integer newVersion, ActionListener<Boolean> listener) {
        Map metaMapping;
        Object schemaVersion;
        IndexMetadata indexMetaData = (IndexMetadata)this.clusterService.state().getMetadata().indices().get(indexName);
        if (indexMetaData == null || indexMetaData.mapping() == null) {
            listener.onResponse((Object)Boolean.FALSE);
            return;
        }
        Integer oldVersion = CommonValue.NO_SCHEMA_VERSION;
        Map indexMapping = indexMetaData.mapping().getSourceAsMap();
        Object meta = indexMapping.get("_meta");
        if (meta instanceof Map && (schemaVersion = (metaMapping = (Map)meta).get("schema_version")) instanceof Integer) {
            oldVersion = (Integer)schemaVersion;
        }
        listener.onResponse((Object)(newVersion > oldVersion ? 1 : 0));
    }

    static {
        for (MLIndex mlIndex : MLIndex.values()) {
            indexMappingUpdated.put(mlIndex.getIndexName(), new AtomicBoolean(false));
        }
    }
}

