/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.engine.tools;

import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.admin.indices.get.GetIndexRequest;
import io.skylite.core.action.admin.indices.get.GetIndexResponse;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.metadata.MappingMetadata;
import io.skylite.core.common.Strings;
import io.skylite.core.settings.Settings;
import io.skylite.ml.common.engine.tools.Parser;
import io.skylite.ml.common.engine.tools.Tool;
import io.skylite.ml.common.engine.tools.ToolAnnotation;
import io.skylite.ml.common.output.model.ModelTensor;
import io.skylite.ml.common.output.model.ModelTensors;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ToolAnnotation(value="IndexMappingTool")
public class IndexMappingTool
implements Tool {
    private static final Logger log = LogManager.getLogger(IndexMappingTool.class);
    public static final String TYPE = "IndexMappingTool";
    private static final String DEFAULT_DESCRIPTION = String.join((CharSequence)" ", "This tool gets index mapping information from a certain index.", "It takes 1 required argument named 'index' which is a comma-delimited list of one or more indices to get mapping information from, which expands wildcards.", "It takes 1 optional argument named 'local' which means whether to return information from the local node only instead of the cluster manager node (Default is false).", "The tool returns a list of index mappings and settings for each index.", "The mappings are in JSON format under the key 'properties' which includes the field name as a key and a JSON object with field type under the key 'type'.", "The settings are in flattened map with 'index' as the top element and key-value pairs for each setting.");
    private String name = "IndexMappingTool";
    private Map<String, Object> attributes;
    private String description = DEFAULT_DESCRIPTION;
    private String version;
    private Client client;
    private Parser<?, ?> inputParser;
    private Parser<?, ?> outputParser;

    public IndexMappingTool(Client client) {
        this.client = client;
        this.attributes = new HashMap<String, Object>();
        this.attributes.put("input_schema", "{\"type\":\"object\",\"properties\":{\"index\":{\"type\":\"string\",\"description\":\"OpenSearch index name. for example: index1\"},\"query\":{\"type\":\"object\",\"description\":\"OpenSearch search index query. You need to get index mapping to write correct search query. It must be a valid OpenSearch query. Valid value:\\n{\\\"query\\\":{\\\"match\\\":{\\\"population_description\\\":\\\"seattle 2023 population\\\"}},\\\"size\\\":2,\\\"_source\\\":\\\"population_description\\\"}\\nInvalid value: \\n{\\\"match\\\":{\\\"population_description\\\":\\\"seattle 2023 population\\\"}}\\nThe value is invalid because the match not wrapped by \\\"query\\\".\",\"additionalProperties\":false}},\"required\":[\"index\",\"query\"],\"additionalProperties\":false}");
        this.attributes.put("strict", true);
        this.outputParser = new Parser<Object, Object>(this){

            public Object parse(Object o) {
                List mlModelOutputs = (List)o;
                return ((ModelTensor)((ModelTensors)mlModelOutputs.get(0)).getMlModelTensors().get(0)).getDataAsMap().get("response");
            }
        };
    }

    public <T> void run(final Map<String, String> parameters, final ActionListener<T> listener) {
        List indexList;
        List list = indexList = parameters.containsKey("index") ? (List)Strings.fromJson((String)parameters.get("index"), List.class) : Collections.emptyList();
        if (indexList.isEmpty()) {
            String empty = "There were no results searching the index parameter [" + parameters.get("index") + "].";
            listener.onResponse((Object)empty);
            return;
        }
        String[] indices = indexList.toArray(Strings.EMPTY_ARRAY);
        IndicesOptions indicesOptions = IndicesOptions.strictExpand();
        boolean local = Boolean.parseBoolean(parameters.get("local"));
        TimeValue clusterManagerNodeTimeout = ClusterManagerNodeRequest.DEFAULT_CLUSTER_MANAGER_NODE_TIMEOUT;
        ActionListener<GetIndexResponse> internalListener = new ActionListener<GetIndexResponse>(){

            public void onResponse(GetIndexResponse getIndexResponse) {
                try {
                    if (getIndexResponse.indices().length == 0) {
                        String empty = "There were no results searching the index parameter [" + (String)parameters.get("index") + "].";
                        listener.onResponse((Object)empty);
                        return;
                    }
                    StringBuilder sb = new StringBuilder();
                    for (String index : getIndexResponse.indices()) {
                        Settings settings;
                        sb.append("index: ").append(index).append("\n\n");
                        MappingMetadata mapping = (MappingMetadata)getIndexResponse.mappings().get(index);
                        if (mapping != null) {
                            sb.append("mappings:\n");
                            for (Map.Entry entry : mapping.sourceAsMap().entrySet()) {
                                sb.append((String)entry.getKey()).append("=").append(entry.getValue()).append('\n');
                            }
                            sb.append("\n\n");
                        }
                        if ((settings = (Settings)getIndexResponse.settings().get(index)) == null) continue;
                        sb.append("settings:\n").append(settings.toDelimitedString('\n')).append("\n\n");
                    }
                    String response = sb.toString();
                    listener.onResponse((Object)response);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        };
        GetIndexRequest getIndexRequest = (GetIndexRequest)((GetIndexRequest)((GetIndexRequest)((GetIndexRequest)new GetIndexRequest().indices(indices)).indicesOptions(indicesOptions)).local(local)).clusterManagerNodeTimeout(clusterManagerNodeTimeout);
        this.client.admin().indices().getIndex(getIndexRequest, (ActionListener)internalListener);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public String getType() {
        return TYPE;
    }

    public boolean validate(Map<String, String> parameters) {
        return parameters != null && parameters.containsKey("index");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setOutputParser(Parser<?, ?> outputParser) {
        this.outputParser = outputParser;
    }

    public void setInputParser(Parser<?, ?> inputParser) {
        this.inputParser = inputParser;
    }

    public String getVersion() {
        return this.version;
    }

    public static class Factory
    implements Tool.Factory<IndexMappingTool> {
        private Client client;
        private static Factory INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Factory getInstance() {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            Class<IndexMappingTool> clazz = IndexMappingTool.class;
            synchronized (IndexMappingTool.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return INSTANCE;
                }
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public void init(Client client) {
            this.client = client;
        }

        public IndexMappingTool create(Map<String, Object> map) {
            return new IndexMappingTool(this.client);
        }

        public String getDefaultDescription() {
            return DEFAULT_DESCRIPTION;
        }

        public String getDefaultType() {
            return IndexMappingTool.TYPE;
        }

        public String getDefaultVersion() {
            return null;
        }
    }
}

