/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.engine.tools;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.Client;
import io.skylite.core.common.Strings;
import io.skylite.core.search.SearchHit;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.ml.common.engine.tools.Tool;
import io.skylite.ml.common.engine.tools.ToolAnnotation;
import io.skylite.ml.common.transport.connector.MLConnectorSearchAction;
import io.skylite.ml.common.transport.model.MLModelSearchAction;
import io.skylite.ml.common.transport.model_group.MLModelGroupSearchAction;
import java.io.IOException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ToolAnnotation(value="SearchIndexTool")
public class SearchIndexTool
implements Tool {
    private static final Logger log = LogManager.getLogger(SearchIndexTool.class);
    public static final String INPUT_FIELD = "input";
    public static final String INDEX_FIELD = "index";
    public static final String QUERY_FIELD = "query";
    public static final String INPUT_SCHEMA_FIELD = "input_schema";
    public static final String STRICT_FIELD = "strict";
    public static final String TYPE = "SearchIndexTool";
    private static final String DEFAULT_DESCRIPTION = "Use this tool to search an index by providing two parameters: 'index' for the index name, and 'query' for the OpenSearch DSL formatted query. Only use this tool when both index name and DSL query is available.";
    public static final String DEFAULT_INPUT_SCHEMA = "{\"type\":\"object\",\"properties\":{\"index\":{\"type\":\"string\",\"description\":\"OpenSearch index name. for example: index1\"},\"query\":{\"type\":\"object\",\"description\":\"OpenSearch search index query. You need to get index mapping to write correct search query. It must be a valid OpenSearch query. Valid value:\\n{\\\"query\\\":{\\\"match\\\":{\\\"population_description\\\":\\\"seattle 2023 population\\\"}},\\\"size\\\":2,\\\"_source\\\":\\\"population_description\\\"}\\nInvalid value: \\n{\\\"match\\\":{\\\"population_description\\\":\\\"seattle 2023 population\\\"}}\\nThe value is invalid because the match not wrapped by \\\"query\\\".\",\"additionalProperties\":false}},\"required\":[\"index\",\"query\"],\"additionalProperties\":false}";
    public static final Map<String, Object> DEFAULT_ATTRIBUTES = Map.of("input_schema", "{\"type\":\"object\",\"properties\":{\"index\":{\"type\":\"string\",\"description\":\"OpenSearch index name. for example: index1\"},\"query\":{\"type\":\"object\",\"description\":\"OpenSearch search index query. You need to get index mapping to write correct search query. It must be a valid OpenSearch query. Valid value:\\n{\\\"query\\\":{\\\"match\\\":{\\\"population_description\\\":\\\"seattle 2023 population\\\"}},\\\"size\\\":2,\\\"_source\\\":\\\"population_description\\\"}\\nInvalid value: \\n{\\\"match\\\":{\\\"population_description\\\":\\\"seattle 2023 population\\\"}}\\nThe value is invalid because the match not wrapped by \\\"query\\\".\",\"additionalProperties\":false}},\"required\":[\"index\",\"query\"],\"additionalProperties\":false}", "strict", false);
    private String name = "SearchIndexTool";
    private Map<String, Object> attributes;
    private String description = "Use this tool to search an index by providing two parameters: 'index' for the index name, and 'query' for the OpenSearch DSL formatted query. Only use this tool when both index name and DSL query is available.";
    private Client client;
    private NamedXContentRegistry xContentRegistry;

    public SearchIndexTool(Client client, NamedXContentRegistry xContentRegistry) {
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.attributes = new HashMap<String, Object>();
        this.attributes.put(INPUT_SCHEMA_FIELD, DEFAULT_INPUT_SCHEMA);
        this.attributes.put(STRICT_FIELD, false);
    }

    public String getType() {
        return TYPE;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public String getVersion() {
        return null;
    }

    public boolean validate(Map<String, String> parameters) {
        return parameters != null && parameters.containsKey(INPUT_FIELD) && parameters.get(INPUT_FIELD) != null;
    }

    private SearchRequest getSearchRequest(String index, String query) throws IOException {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        XContentParser queryParser = MediaTypeRegistry.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, query);
        searchSourceBuilder.parseXContent(queryParser);
        return new SearchRequest().source(searchSourceBuilder).indices(new String[]{index});
    }

    private static Map<String, Object> processResponse(SearchHit hit) {
        HashMap<String, Object> docContent = new HashMap<String, Object>();
        docContent.put("_index", hit.getIndex());
        docContent.put("_id", hit.getId());
        docContent.put("_score", Float.valueOf(hit.getScore()));
        docContent.put("_source", hit.getSourceAsMap());
        return docContent;
    }

    public <T> void run(Map<String, String> parameters, ActionListener<T> listener) {
        try {
            String input = parameters.get(INPUT_FIELD);
            Map jsonObject = (Map)Strings.fromJson((String)input, Map.class);
            String index = Optional.ofNullable(jsonObject).map(x -> x.get(INDEX_FIELD)).map(Object::toString).orElse(null);
            String query = Optional.ofNullable(jsonObject).map(x -> x.get(QUERY_FIELD)).map(Object::toString).orElse(null);
            if (index == null || query == null) {
                listener.onFailure((Exception)new IllegalArgumentException("SearchIndexTool's two parameter: index and query are required!"));
                return;
            }
            SearchRequest searchRequest = this.getSearchRequest(index, query);
            ActionListener actionListener = ActionListenerHelper.wrap(r -> {
                SearchHit[] hits = r.getHits().getHits();
                if (hits != null && hits.length > 0) {
                    StringBuilder contextBuilder = new StringBuilder();
                    for (SearchHit hit : hits) {
                        String doc = AccessController.doPrivileged(() -> {
                            Map<String, Object> docContent = SearchIndexTool.processResponse(hit);
                            return Strings.toJson(docContent);
                        });
                        contextBuilder.append(doc).append("\n");
                    }
                    listener.onResponse((Object)contextBuilder.toString());
                } else {
                    listener.onResponse((Object)"");
                }
            }, e -> {
                log.error("Failed to search index", (Throwable)e);
                listener.onFailure(e);
            });
            if (Objects.equals(index, ".plugins-ml-connector")) {
                this.client.execute((ActionType)MLConnectorSearchAction.INSTANCE, (ActionRequest)searchRequest, actionListener);
            } else if (Objects.equals(index, ".plugins-ml-model")) {
                this.client.execute((ActionType)MLModelSearchAction.INSTANCE, (ActionRequest)searchRequest, actionListener);
            } else if (Objects.equals(index, ".plugins-ml-model-group")) {
                this.client.execute((ActionType)MLModelGroupSearchAction.INSTANCE, (ActionRequest)searchRequest, actionListener);
            } else {
                this.client.search(searchRequest, actionListener);
            }
        }
        catch (Exception e2) {
            log.error("Failed to search index", (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public NamedXContentRegistry getxContentRegistry() {
        return this.xContentRegistry;
    }

    public void setxContentRegistry(NamedXContentRegistry xContentRegistry) {
        this.xContentRegistry = xContentRegistry;
    }

    public static class Factory
    implements Tool.Factory<SearchIndexTool> {
        private Client client;
        private static Factory INSTANCE;
        private NamedXContentRegistry xContentRegistry;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Factory getInstance() {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            Class<SearchIndexTool> clazz = SearchIndexTool.class;
            synchronized (SearchIndexTool.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return INSTANCE;
                }
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public void init(Client client, NamedXContentRegistry xContentRegistry) {
            this.client = client;
            this.xContentRegistry = xContentRegistry;
        }

        public SearchIndexTool create(Map<String, Object> params) {
            return new SearchIndexTool(this.client, this.xContentRegistry);
        }

        public String getDefaultDescription() {
            return SearchIndexTool.DEFAULT_DESCRIPTION;
        }

        public String getDefaultType() {
            return SearchIndexTool.TYPE;
        }

        public String getDefaultVersion() {
            return null;
        }

        public Map<String, Object> getDefaultAttributes() {
            return DEFAULT_ATTRIBUTES;
        }
    }
}

