/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.engine.tools;

import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.client.Client;
import io.skylite.core.common.Strings;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.search.SearchHits;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.ml.common.engine.tools.Tool;
import io.skylite.ml.common.engine.tools.ToolAnnotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.QueryBuilders;

@ToolAnnotation(value="VisualizationTool")
public class VisualizationsTool
implements Tool {
    private static final Logger log = LogManager.getLogger(VisualizationsTool.class);
    public static final String NAME = "FindVisualizations";
    public static final String TYPE = "VisualizationTool";
    public static final String VERSION = "v1.0";
    public static final String SAVED_OBJECT_TYPE = "visualization";
    public static final String STRICT_FIELD = "strict";
    private static final int DEFAULT_SIZE = 3;
    private static final String DEFAULT_DESCRIPTION = "Use this tool to find user created visualizations. This tool takes the visualization name as input and returns matching visualizations";
    public static final String DEFAULT_INPUT_SCHEMA = "{\"type\":\"object\",\"properties\":{\"input\":{\"type\":\"string\",\"description\":\"Visualization name to search for\"}},\"required\":[\"input\"]}";
    public static final Map<String, Object> DEFAULT_ATTRIBUTES = Map.of("input_schema", "{\"type\":\"object\",\"properties\":{\"input\":{\"type\":\"string\",\"description\":\"Visualization name to search for\"}},\"required\":[\"input\"]}", "strict", false);
    private String description = "Use this tool to find user created visualizations. This tool takes the visualization name as input and returns matching visualizations";
    private String name = "FindVisualizations";
    private String type = "VisualizationTool";
    private final String version = "v1.0";
    private final Client client;
    private final String index;
    private final int size;
    private Map<String, Object> attributes;

    public VisualizationsTool(Client client, String index, int size) {
        this.client = client;
        this.index = index;
        this.size = size;
        this.attributes = new HashMap<String, Object>();
        this.attributes.put("input_schema", DEFAULT_INPUT_SCHEMA);
        this.attributes.put(STRICT_FIELD, true);
    }

    public <T> void run(Map<String, String> parameters, final ActionListener<T> listener) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"type", (String)SAVED_OBJECT_TYPE));
        boolQueryBuilder.must().add(QueryBuilders.matchQuery((String)"visualization.title", (Object)parameters.get("input")));
        SearchSourceBuilder searchSourceBuilder = SearchSourceBuilder.searchSource().query((QueryBuilder)boolQueryBuilder);
        searchSourceBuilder.from(0).size(this.size);
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index}).source(searchSourceBuilder);
        this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse searchResponse) {
                SearchHits hits = searchResponse.getHits();
                StringBuilder visBuilder = new StringBuilder();
                visBuilder.append("Title,Id\n");
                if (hits.getTotalHits().value() > 0L) {
                    Arrays.stream(hits.getHits()).forEach(h -> {
                        String id = VisualizationsTool.this.trimIdPrefix(h.getId());
                        Map visMap = (Map)h.getSourceAsMap().get(VisualizationsTool.SAVED_OBJECT_TYPE);
                        String title = (String)visMap.get("title");
                        visBuilder.append(String.format(Locale.ROOT, "%s,%s\n", title, id));
                    });
                    listener.onResponse((Object)visBuilder.toString());
                } else {
                    listener.onResponse((Object)"No Visualization found");
                }
            }

            public void onFailure(Exception e) {
                if (SkyliteExceptionsHelper.unwrapCause((Throwable)e) instanceof IndexNotFoundException || SkyliteExceptionsHelper.unwrap((Throwable)e, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
                    listener.onResponse((Object)"No Visualization found");
                } else {
                    listener.onFailure(e);
                }
            }
        });
    }

    String trimIdPrefix(String id) {
        if ((id = Optional.ofNullable(id).orElse("")).startsWith(SAVED_OBJECT_TYPE)) {
            String prefix = String.format(Locale.ROOT, "%s:", SAVED_OBJECT_TYPE);
            return id.substring(prefix.length());
        }
        return id;
    }

    public boolean validate(Map<String, String> parameters) {
        return parameters.containsKey("input") && !Strings.isNullOrEmpty((String)parameters.get("input"));
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getVersion() {
        return VERSION;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public String getIndex() {
        return this.index;
    }

    public int getSize() {
        return this.size;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Client client;
        private String index;
        private int size;

        public Builder client(Client client) {
            this.client = client;
            return this;
        }

        public Builder index(String index) {
            this.index = index;
            return this;
        }

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        public VisualizationsTool build() {
            return new VisualizationsTool(this.client, this.index, this.size);
        }
    }

    public static class Factory
    implements Tool.Factory<VisualizationsTool> {
        private Client client;
        private static Factory INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Factory getInstance() {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            Class<VisualizationsTool> clazz = VisualizationsTool.class;
            synchronized (VisualizationsTool.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return INSTANCE;
                }
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public void init(Client client) {
            this.client = client;
        }

        public VisualizationsTool create(Map<String, Object> params) {
            int size;
            String index = params.get("index") == null ? ".kibana" : (String)params.get("index");
            String sizeStr = params.get("size") == null ? "3" : (String)params.get("size");
            try {
                size = Integer.parseInt(sizeStr);
            }
            catch (NumberFormatException ignored) {
                size = 3;
            }
            return VisualizationsTool.builder().client(this.client).index(index).size(size).build();
        }

        public String getDefaultDescription() {
            return VisualizationsTool.DEFAULT_DESCRIPTION;
        }

        public String getDefaultType() {
            return VisualizationsTool.TYPE;
        }

        public String getDefaultVersion() {
            return null;
        }
    }
}

