/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.input;

import io.lucenia.ml.common.dataset.SearchQueryInputDataset;
import io.skylite.core.ParseField;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.xcontent.ObjectParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.MLCommonsClassLoader;
import io.skylite.ml.common.connector.ConnectorAction;
import io.skylite.ml.common.dataset.MLInputDataset;
import io.skylite.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import io.skylite.ml.common.input.MLInput;
import io.skylite.ml.common.input.parameter.MLAlgoParams;
import java.io.IOException;
import java.util.Locale;

public class TransportMLInput
extends MLInput {
    public static final ObjectParser<TransportMLInputBuilder, String> PARSER = TransportMLInput.createParser((String)TransportMLInputBuilder.class.getSimpleName(), algorithm -> new TransportMLInputBuilder((String)algorithm));

    public TransportMLInput(FunctionName algorithm, MLAlgoParams parameters, MLInputDataset inputDataset) {
        super(algorithm, parameters, inputDataset);
    }

    public static MLInput parse(XContentParser parser, String inputAlgoName, ConnectorAction.ActionType actionType) throws IOException {
        RemoteInferenceInputDataSet remoteInferenceInputDataSet;
        MLInput mlInput = TransportMLInput.parse(parser, inputAlgoName);
        if (mlInput.getInputDataset() instanceof RemoteInferenceInputDataSet && (remoteInferenceInputDataSet = (RemoteInferenceInputDataSet)mlInput.getInputDataset()).getActionType() == null) {
            remoteInferenceInputDataSet.setActionType(actionType);
        }
        return mlInput;
    }

    public static MLInput parse(XContentParser parser, String inputAlgoName) throws IOException {
        String algorithmName = inputAlgoName.toUpperCase(Locale.ROOT);
        FunctionName algorithm = FunctionName.from((String)algorithmName);
        if (MLCommonsClassLoader.canInitMLInput((FunctionName)algorithm)) {
            MLInput mlInput = (MLInput)MLCommonsClassLoader.initMLInput((Enum)algorithm, (Object[])new Object[]{parser, algorithm}, (Class[])new Class[]{XContentParser.class, FunctionName.class});
            mlInput.setAlgorithm(algorithm);
            return mlInput;
        }
        return ((TransportMLInputBuilder)((Object)PARSER.parse(parser, (Object)inputAlgoName))).build();
    }

    public XContentBuilder extendedXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        switch (this.inputDataset.getInputDataType()) {
            case SEARCH_QUERY: {
                builder.field("input_index", (Object)((SearchQueryInputDataset)this.inputDataset).getIndices().toArray(new String[0]));
                builder.field("input_query", (ToXContent)((SearchQueryInputDataset)this.inputDataset).getSearchSourceBuilder());
                break;
            }
        }
        return builder;
    }

    static {
        PARSER.declareObject(TransportMLInputBuilder::searchSourceBuilder, (p, c) -> SearchSourceBuilder.fromXContent((XContentParser)p, (boolean)false), new ParseField("input_query", new String[0]));
    }

    public static class TransportMLInputBuilder
    extends MLInput.MLInputBuilder {
        SearchSourceBuilder searchSourceBuilder;

        public TransportMLInputBuilder(String algorithm) {
            super(algorithm);
        }

        public TransportMLInputBuilder searchSourceBuilder(SearchSourceBuilder searchSourceBuilder) {
            this.searchSourceBuilder = searchSourceBuilder;
            return this;
        }

        protected MLInputDataset createInputDataset() {
            MLInputDataset inputDataSet = super.createInputDataset();
            if (inputDataSet == null && this.sourceIndices != null && this.searchSourceBuilder != null) {
                inputDataSet = new SearchQueryInputDataset(this.sourceIndices, this.searchSourceBuilder);
            }
            return inputDataSet;
        }

        public TransportMLInput build() {
            MLInputDataset inputDataset = this.createInputDataset();
            return new TransportMLInput(this.algorithm, this.mlParameters, inputDataset);
        }
    }
}

