/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.jobs;

import io.lucenia.ml.common.task.MLTaskManager;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.search.SearchHit;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.jobs.JobExecutionContext;
import io.skylite.jobs.ScheduledJobParameter;
import io.skylite.jobs.ScheduledJobRunner;
import io.skylite.jobs.utils.LockServiceInterface;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.task.MLTaskState;
import io.skylite.ml.common.task.MLTaskType;
import io.skylite.ml.common.transport.task.MLTaskGetAction;
import io.skylite.ml.common.transport.task.MLTaskGetRequest;
import java.time.Instant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.QueryBuilders;

public class MLBatchTaskUpdateJobRunner
implements ScheduledJobRunner {
    private static final Logger log = LogManager.getLogger(ScheduledJobRunner.class);
    private static MLBatchTaskUpdateJobRunner INSTANCE;
    private ClusterService clusterService;
    private ThreadPool threadPool;
    private Client client;
    private MLTaskManager taskManager;
    private boolean initialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MLBatchTaskUpdateJobRunner getJobRunnerInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        Class<MLBatchTaskUpdateJobRunner> clazz = MLBatchTaskUpdateJobRunner.class;
        synchronized (MLBatchTaskUpdateJobRunner.class) {
            if (INSTANCE != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
            INSTANCE = new MLBatchTaskUpdateJobRunner();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private MLBatchTaskUpdateJobRunner() {
    }

    public void setClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public void initialize(ClusterService clusterService, ThreadPool threadPool, Client client) {
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.client = client;
        this.initialized = true;
    }

    public void runJob(ScheduledJobParameter scheduledJobParameter, JobExecutionContext jobExecutionContext) {
        if (!this.initialized) {
            throw new AssertionError((Object)"this instance is not initialized");
        }
        LockServiceInterface lockService = jobExecutionContext.getLockService();
        Runnable runnable = () -> lockService.acquireLock(scheduledJobParameter, jobExecutionContext, ActionListenerHelper.wrap(lock -> {
            if (lock == null) {
                return;
            }
            try {
                String jobName = scheduledJobParameter.getName();
                log.info("Starting job execution for job ID: {} at {}", (Object)jobName, (Object)Instant.now());
                log.debug("Running batch task polling job");
                SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
                BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"task_type", (Object)MLTaskType.BATCH_PREDICTION)).must((QueryBuilder)QueryBuilders.termQuery((String)"function_name", (Object)FunctionName.REMOTE)).must((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termQuery((String)"state", (Object)MLTaskState.RUNNING)).should((QueryBuilder)QueryBuilders.termQuery((String)"state", (Object)MLTaskState.CANCELLING)));
                sourceBuilder.query((QueryBuilder)boolQuery);
                sourceBuilder.size(100);
                sourceBuilder.fetchSource(new String[]{"_id"}, null);
                SearchRequest searchRequest = new SearchRequest(new String[]{".plugins-ml-task"});
                searchRequest.source(sourceBuilder);
                this.client.search(searchRequest, ActionListenerHelper.wrap(response -> {
                    SearchHit[] searchHits;
                    if (response == null || response.getHits() == null || response.getHits().getHits().length == 0) {
                        log.info("No pending tasks found to be polled by the job");
                        return;
                    }
                    for (SearchHit searchHit : searchHits = response.getHits().getHits()) {
                        String taskId = searchHit.getId();
                        log.debug("Starting polling for task: {} at {}", (Object)taskId, (Object)Instant.now());
                        MLTaskGetRequest mlTaskGetRequest = MLTaskGetRequest.builder().taskId(taskId).userInitiatedGetTaskRequest(false).build();
                        this.client.execute((ActionType)MLTaskGetAction.INSTANCE, (ActionRequest)mlTaskGetRequest, ActionListenerHelper.wrap(taskResponse -> log.info("Updated Task status for taskId: {} at {}", (Object)taskId, (Object)Instant.now()), exception -> log.error("Failed to get task status for task: " + taskId, (Throwable)exception)));
                    }
                }, e -> {
                    if (e instanceof IndexNotFoundException) {
                        log.info("No tasks found to be polled by the job");
                    } else {
                        log.error("Failed to search for tasks to be polled by the job ", (Throwable)e);
                    }
                }));
                log.info("Completed job execution for job ID: {} at {}", (Object)jobName, (Object)Instant.now());
            }
            finally {
                lockService.release(lock, ActionListenerHelper.wrap(released -> log.debug("Released lock for job {}", (Object)scheduledJobParameter.getName()), exception -> {
                    throw new IllegalStateException("Failed to release lock.");
                }));
            }
        }, exception -> {
            throw new IllegalStateException("Failed to acquire lock.");
        }));
        this.threadPool.generic().submit(runnable);
    }
}

