/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.model;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.LatchedActionListener;
import io.skylite.core.client.Client;
import io.skylite.core.client.ReleasableSkyliteClient;
import io.skylite.core.common.Strings;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.CommonValue;
import io.skylite.ml.common.model.Guardrail;
import io.skylite.ml.common.model.GuardrailFactory;
import io.skylite.ml.common.model.StopWords;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocalRegexGuardrail
implements Guardrail {
    private static final Logger log = LogManager.getLogger(LocalRegexGuardrail.class);
    public static final String NAME = "local_regex";
    public static final String STOP_WORDS_FIELD = "stop_words";
    public static final String REGEX_FIELD = "regex";
    private List<StopWords> stopWords;
    private String[] regex;
    private List<Pattern> regexPattern;
    private Map<String, List<String>> stopWordsIndicesInput;
    private NamedXContentRegistry xContentRegistry;
    private Client client;

    public LocalRegexGuardrail(List<StopWords> stopWords, String[] regex) {
        this.stopWords = stopWords;
        this.regex = regex;
    }

    public LocalRegexGuardrail(Map<String, Object> params) {
        List regexes;
        List words = (List)params.get(STOP_WORDS_FIELD);
        this.stopWords = new ArrayList<StopWords>();
        if (words != null && !words.isEmpty()) {
            for (Map e : words) {
                this.stopWords.add(new StopWords(e));
            }
        }
        if ((regexes = (List)params.get(REGEX_FIELD)) != null && !regexes.isEmpty()) {
            this.regex = regexes.toArray(new String[0]);
        }
    }

    public LocalRegexGuardrail(StreamInput input) throws IOException {
        if (input.readBoolean()) {
            this.stopWords = new ArrayList<StopWords>();
            int size = input.readInt();
            for (int i = 0; i < size; ++i) {
                this.stopWords.add(new StopWords(input));
            }
        }
        this.regex = input.readOptionalStringArray();
    }

    public String typeName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.stopWords != null && this.stopWords.size() > 0) {
            out.writeBoolean(true);
            out.writeInt(this.stopWords.size());
            for (StopWords e : this.stopWords) {
                e.writeTo(out);
            }
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalStringArray(this.regex);
    }

    public Boolean validate(String input, Map<String, String> parameters) {
        return this.validateRegexList(input, this.regexPattern) != false && this.validateStopWords(input, this.stopWordsIndicesInput) != false;
    }

    public void init(NamedXContentRegistry xContentRegistry, ReleasableSkyliteClient client) {
        this.xContentRegistry = xContentRegistry;
        assert (client instanceof Client);
        this.client = (Client)client;
        this.init();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.stopWords != null && this.stopWords.size() > 0) {
            builder.field(STOP_WORDS_FIELD, this.stopWords);
        }
        if (this.regex != null) {
            builder.field(REGEX_FIELD, (Object)this.regex);
        }
        builder.endObject();
        return builder;
    }

    public static LocalRegexGuardrail parse(XContentParser parser) throws IOException {
        ArrayList<StopWords> stopWords = null;
        String[] regex = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "stop_words": {
                    stopWords = new ArrayList<StopWords>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        stopWords.add(StopWords.parse((XContentParser)parser));
                    }
                    continue block8;
                }
                case "regex": {
                    regex = parser.list().toArray(new String[0]);
                    continue block8;
                }
            }
            parser.skipChildren();
        }
        return LocalRegexGuardrail.builder().stopWords(stopWords).regex(regex).build();
    }

    private void init() {
        this.stopWordsIndicesInput = this.stopWordsToMap();
        List<Object> regexList = this.regex == null ? new ArrayList() : Arrays.asList(this.regex);
        this.regexPattern = regexList.stream().map(reg -> Pattern.compile(reg)).collect(Collectors.toList());
    }

    private Map<String, List<String>> stopWordsToMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (this.stopWords != null && !this.stopWords.isEmpty()) {
            for (StopWords e : this.stopWords) {
                if (e.getIndex() == null || e.getSourceFields() == null) continue;
                map.put(e.getIndex(), Arrays.asList(e.getSourceFields()));
            }
        }
        return map;
    }

    public Boolean validateRegexList(String input, List<Pattern> regexPatterns) {
        if (regexPatterns == null || regexPatterns.isEmpty()) {
            return true;
        }
        for (Pattern pattern : regexPatterns) {
            if (this.validateRegex(input, pattern).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public Boolean validateRegex(String input, Pattern pattern) {
        Matcher matcher = pattern.matcher(input);
        return !matcher.matches();
    }

    public Boolean validateStopWords(String input, Map<String, List<String>> stopWordsIndices) {
        if (stopWordsIndices == null || stopWordsIndices.isEmpty()) {
            return true;
        }
        for (Map.Entry<String, List<String>> entry : stopWordsIndices.entrySet()) {
            if (this.validateStopWordsSingleIndex(input, entry.getKey(), entry.getValue()).booleanValue()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean validateStopWordsSingleIndex(String input, String indexName, List<String> fieldNames) {
        AtomicBoolean hitStopWords = new AtomicBoolean(false);
        HashMap<String, String> documentMap = new HashMap<String, String>();
        for (String field : fieldNames) {
            documentMap.put(field, input);
        }
        Map queryBodyMap = Map.of("query", Map.of("percolate", Map.of("field", "query", "document", documentMap)));
        CountDownLatch latch = new CountDownLatch(1);
        try (ThreadContext.StoredContext context = null;){
            String queryBody = Strings.toJson(queryBodyMap);
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            XContentParser queryParser = MediaTypeRegistry.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, queryBody);
            searchSourceBuilder.parseXContent(queryParser);
            searchSourceBuilder.size(1);
            SearchRequest searchRequest = new SearchRequest().source(searchSourceBuilder).indices(new String[]{indexName});
            if (this.isStopWordsSystemIndex(indexName)) {
                ThreadContext.StoredContext finalContext = context = this.client.threadPool().getThreadContext().stashContext();
                this.client.search(searchRequest, ActionListenerHelper.runBefore((ActionListener)new LatchedActionListener(ActionListenerHelper.wrap(r -> {
                    if (r == null || r.getHits() == null || r.getHits().getTotalHits() == null || r.getHits().getTotalHits().value() == 0L) {
                        hitStopWords.set(true);
                    }
                }, e -> {
                    log.error("Failed to search stop words index {}", (Object)indexName);
                    hitStopWords.set(true);
                }), latch), () -> finalContext.restore()));
            } else {
                this.client.search(searchRequest, (ActionListener)new LatchedActionListener(ActionListenerHelper.wrap(r -> {
                    if (r == null || r.getHits() == null || r.getHits().getTotalHits() == null || r.getHits().getTotalHits().value() == 0L) {
                        hitStopWords.set(true);
                    }
                }, e -> {
                    log.error("Failed to search stop words index {}", (Object)indexName);
                    hitStopWords.set(true);
                }), latch));
            }
        }
        try {
            latch.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e2) {
            log.error("[validateStopWords] Searching stop words index was timeout.");
            throw new IllegalStateException(e2);
        }
        return hitStopWords.get();
    }

    private boolean isStopWordsSystemIndex(String index) {
        return CommonValue.stopWordsIndices.contains(index);
    }

    public List<StopWords> getStopWords() {
        return this.stopWords;
    }

    public String[] getRegex() {
        return this.regex;
    }

    public List<Pattern> getRegexPattern() {
        return this.regexPattern;
    }

    public Map<String, List<String>> getStopWordsIndicesInput() {
        return this.stopWordsIndicesInput;
    }

    public NamedXContentRegistry getxContentRegistry() {
        return this.xContentRegistry;
    }

    public Client getClient() {
        return this.client;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalRegexGuardrail that = (LocalRegexGuardrail)o;
        return Objects.equals(this.stopWords, that.stopWords) && Objects.deepEquals(this.regex, that.regex) && Objects.equals(this.regexPattern, that.regexPattern) && Objects.equals(this.stopWordsIndicesInput, that.stopWordsIndicesInput) && Objects.equals(this.xContentRegistry, that.xContentRegistry) && Objects.equals(this.client, that.client);
    }

    public int hashCode() {
        return Objects.hash(this.stopWords, Arrays.hashCode(this.regex), this.regexPattern, this.stopWordsIndicesInput, this.xContentRegistry, this.client);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<StopWords> stopWords;
        private String[] regex;

        public Builder stopWords(List<StopWords> stopWords) {
            this.stopWords = stopWords;
            return this;
        }

        public Builder regex(String[] regex) {
            this.regex = regex;
            return this;
        }

        public LocalRegexGuardrail build() {
            return new LocalRegexGuardrail(this.stopWords, this.regex);
        }
    }

    public static class LocalRegexGuardrailFactory
    implements GuardrailFactory {
        public String typeName() {
            return LocalRegexGuardrail.NAME;
        }

        public Guardrail newInstance(Map<String, Object> parameters) {
            return new LocalRegexGuardrail(parameters);
        }

        public Guardrail newInstance(StreamInput input) throws IOException {
            return new LocalRegexGuardrail(input);
        }
    }
}

