/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.model;

import io.lucenia.ml.common.engine.systemindices.MLIndicesHandler;
import io.lucenia.ml.common.task.MLTaskManager;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteStatusException;
import io.skylite.common.SuppressForbidden;
import io.skylite.common.TokenBucket;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.DocWriteResponse;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.action.delete.DeleteRequest;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.index.IndexResponse;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.action.support.ThreadedActionListener;
import io.skylite.core.action.update.UpdateRequest;
import io.skylite.core.action.update.UpdateResponse;
import io.skylite.core.client.Client;
import io.skylite.core.client.ReleasableSkyliteClient;
import io.skylite.core.client.metadata.GetDataObjectRequest;
import io.skylite.core.client.metadata.GetDataObjectResponse;
import io.skylite.core.client.metadata.MetadataClient;
import io.skylite.core.client.metadata.PutDataObjectRequest;
import io.skylite.core.client.metadata.UpdateDataObjectRequest;
import io.skylite.core.client.metadata.UpdateDataObjectResponse;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.Strings;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.TermQueryBuilder;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.script.ScriptService;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.breaker.MLCircuitBreakerService;
import io.skylite.ml.common.cluster.DiscoveryNodeHelper;
import io.skylite.ml.common.cluster.MLNodeUtils;
import io.skylite.ml.common.connector.Connector;
import io.skylite.ml.common.controller.MLController;
import io.skylite.ml.common.controller.MLRateLimiter;
import io.skylite.ml.common.engine.MLEngine;
import io.skylite.ml.common.engine.MLExecutable;
import io.skylite.ml.common.engine.ModelDownloader;
import io.skylite.ml.common.engine.Predictable;
import io.skylite.ml.common.exception.MLException;
import io.skylite.ml.common.exception.MLExceptionUtils;
import io.skylite.ml.common.exception.MLLimitExceededException;
import io.skylite.ml.common.exception.MLResourceNotFoundException;
import io.skylite.ml.common.exception.MLValidationException;
import io.skylite.ml.common.model.Guardrails;
import io.skylite.ml.common.model.MLGuard;
import io.skylite.ml.common.model.MLModel;
import io.skylite.ml.common.model.MLModelCacheHelper;
import io.skylite.ml.common.model.MLModelState;
import io.skylite.ml.common.profile.MLModelProfile;
import io.skylite.ml.common.settings.MLCommonsSettings;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.stats.ActionName;
import io.skylite.ml.common.stats.MLActionLevelStat;
import io.skylite.ml.common.stats.MLNodeLevelStat;
import io.skylite.ml.common.stats.MLStats;
import io.skylite.ml.common.task.MLTask;
import io.skylite.ml.common.task.MLTaskState;
import io.skylite.ml.common.task.MLTaskType;
import io.skylite.ml.common.transport.deploy.MLDeployModelAction;
import io.skylite.ml.common.transport.deploy.MLDeployModelRequest;
import io.skylite.ml.common.transport.register.MLRegisterModelInput;
import io.skylite.ml.common.transport.register.MLRegisterModelResponse;
import io.skylite.ml.common.transport.upload_chunk.MLRegisterModelMetaInput;
import io.skylite.ml.common.utils.FileUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.reindex.DeleteByQueryAction;
import org.opensearch.index.reindex.DeleteByQueryRequest;

public class MLModelManager {
    private static final Logger log = LogManager.getLogger(MLModelManager.class);
    public static final int TIMEOUT_IN_MILLIS = 5000;
    public static final long MODEL_FILE_SIZE_LIMIT = 0x100000000L;
    private final Client client;
    private final MetadataClient sdkClient;
    private final ClusterService clusterService;
    private final ScriptService scriptService;
    private final ThreadPool threadPool;
    private final NamedXContentRegistry xContentRegistry;
    private final ModelDownloader modelDownloader;
    private final MLModelCacheHelper modelCacheHelper;
    private final MLStats mlStats;
    private final MLCircuitBreakerService mlCircuitBreakerService;
    private final MLIndicesHandler mlIndicesHandler;
    private final MLTaskManager mlTaskManager;
    private final MLEngine mlEngine;
    private final DiscoveryNodeHelper nodeHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;
    private volatile Integer maxModelPerNode;
    private volatile Integer maxRegisterTasksPerNode;
    private volatile Integer maxDeployTasksPerNode;
    private volatile Integer maxBatchInferenceTasks;
    private volatile Integer maxBatchIngestionTasks;
    public static final Set<MLModelState> MODEL_DONE_STATES = Set.of(MLModelState.TRAINED, MLModelState.REGISTERED, MLModelState.DEPLOYED, MLModelState.PARTIALLY_DEPLOYED, MLModelState.DEPLOY_FAILED, MLModelState.UNDEPLOYED);

    public MLModelManager(ClusterService clusterService, ScriptService scriptService, Client client, MetadataClient sdkClient, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, ModelDownloader modelDownloader, Settings settings, MLStats mlStats, MLCircuitBreakerService mlCircuitBreakerService, MLIndicesHandler mlIndicesHandler, MLTaskManager mlTaskManager, MLModelCacheHelper modelCacheHelper, MLEngine mlEngine, DiscoveryNodeHelper nodeHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.client = client;
        this.sdkClient = sdkClient;
        this.threadPool = threadPool;
        this.xContentRegistry = xContentRegistry;
        this.modelDownloader = modelDownloader;
        this.clusterService = clusterService;
        this.scriptService = scriptService;
        this.modelCacheHelper = modelCacheHelper;
        this.mlStats = mlStats;
        this.mlCircuitBreakerService = mlCircuitBreakerService;
        this.mlIndicesHandler = mlIndicesHandler;
        this.mlTaskManager = mlTaskManager;
        this.mlEngine = mlEngine;
        this.nodeHelper = nodeHelper;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        this.maxModelPerNode = (Integer)MLCommonsSettings.ML_COMMONS_MAX_MODELS_PER_NODE.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_MAX_MODELS_PER_NODE, it -> {
            this.maxModelPerNode = it;
        });
        this.maxRegisterTasksPerNode = (Integer)MLCommonsSettings.ML_COMMONS_MAX_REGISTER_MODEL_TASKS_PER_NODE.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_MAX_REGISTER_MODEL_TASKS_PER_NODE, it -> {
            this.maxRegisterTasksPerNode = it;
        });
        this.maxDeployTasksPerNode = (Integer)MLCommonsSettings.ML_COMMONS_MAX_DEPLOY_MODEL_TASKS_PER_NODE.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_MAX_DEPLOY_MODEL_TASKS_PER_NODE, it -> {
            this.maxDeployTasksPerNode = it;
        });
        this.maxBatchInferenceTasks = (Integer)MLCommonsSettings.ML_COMMONS_MAX_BATCH_INFERENCE_TASKS.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_MAX_BATCH_INFERENCE_TASKS, it -> {
            this.maxBatchInferenceTasks = it;
        });
        this.maxBatchIngestionTasks = (Integer)MLCommonsSettings.ML_COMMONS_MAX_BATCH_INGESTION_TASKS.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_MAX_BATCH_INGESTION_TASKS, it -> {
            this.maxBatchIngestionTasks = it;
        });
    }

    public void registerModelMeta(MLRegisterModelMetaInput mlRegisterModelMetaInput, ActionListener<String> listener) {
        block11: {
            try {
                FunctionName functionName = mlRegisterModelMetaInput.getFunctionName();
                this.mlStats.getStat((Enum)MLNodeLevelStat.ML_REQUEST_COUNT).increment();
                this.mlStats.createCounterStatIfAbsent(functionName, ActionName.REGISTER, MLActionLevelStat.ML_ACTION_REQUEST_COUNT).increment();
                String modelGroupId = mlRegisterModelMetaInput.getModelGroupId();
                if (org.apache.logging.log4j.util.Strings.isBlank((String)modelGroupId)) {
                    this.uploadMLModelMeta(mlRegisterModelMetaInput, "1", listener);
                    break block11;
                }
                try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                    ActionListener wrappedListener = ActionListenerHelper.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
                    GetRequest getModelGroupRequest = new GetRequest(".plugins-ml-model-group").id(modelGroupId);
                    this.client.get(getModelGroupRequest, ActionListenerHelper.wrap(modelGroup -> {
                        if (modelGroup.isExists()) {
                            Map modelGroupSource = modelGroup.getSourceAsMap();
                            int updatedVersion = this.incrementLatestVersion(modelGroupSource);
                            UpdateRequest updateModelGroupRequest = this.createUpdateModelGroupRequest(modelGroupSource, modelGroupId, modelGroup.getSeqNo(), modelGroup.getPrimaryTerm(), updatedVersion);
                            this.client.update(updateModelGroupRequest, ActionListenerHelper.wrap(r -> this.uploadMLModelMeta(mlRegisterModelMetaInput, "" + updatedVersion, (ActionListener<String>)wrappedListener), e -> {
                                log.error("Failed to update model group");
                                wrappedListener.onFailure(e);
                            }));
                        } else {
                            log.error("Model group not found");
                            wrappedListener.onFailure((Exception)new MLResourceNotFoundException("Fail to find model group"));
                        }
                    }, e -> {
                        if (e instanceof IndexNotFoundException) {
                            wrappedListener.onFailure((Exception)new MLResourceNotFoundException("Fail to find model group"));
                        } else {
                            log.error("Failed to get model group");
                            wrappedListener.onFailure((Exception)new MLValidationException("Failed to get model group"));
                        }
                    }));
                }
                catch (Exception e2) {
                    log.error("Failed to register model");
                    listener.onFailure(e2);
                }
            }
            catch (Exception e3) {
                log.error("Failed to init model index");
                listener.onFailure(e3);
            }
        }
    }

    private void uploadMLModelMeta(MLRegisterModelMetaInput mlRegisterModelMetaInput, String version, ActionListener<String> listener) {
        FunctionName functionName = mlRegisterModelMetaInput.getFunctionName();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListenerHelper.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
            String modelName = mlRegisterModelMetaInput.getName();
            this.mlIndicesHandler.initModelIndexIfAbsent((ActionListener<Boolean>)ActionListenerHelper.wrap(res -> {
                if (!res.booleanValue()) {
                    wrappedListener.onFailure((Exception)new RuntimeException("No response to create ML Model index"));
                    return;
                }
                Instant now = Instant.now();
                MLModel mlModelMeta = MLModel.builder().name(modelName).algorithm(functionName).version(version).modelGroupId(mlRegisterModelMetaInput.getModelGroupId()).description(mlRegisterModelMetaInput.getDescription()).isEnabled(mlRegisterModelMetaInput.getIsEnabled()).rateLimiter(mlRegisterModelMetaInput.getRateLimiter()).modelFormat(mlRegisterModelMetaInput.getModelFormat()).modelState(MLModelState.REGISTERING).modelConfig(mlRegisterModelMetaInput.getModelConfig()).deploySetting(mlRegisterModelMetaInput.getDeploySetting()).totalChunks(mlRegisterModelMetaInput.getTotalChunks()).modelContentHash(mlRegisterModelMetaInput.getModelContentHashValue()).modelContentSizeInBytes(mlRegisterModelMetaInput.getModelContentSizeInBytes()).isHidden(mlRegisterModelMetaInput.getIsHidden()).modelInterface(mlRegisterModelMetaInput.getModelInterface()).createdTime(now).lastUpdateTime(now).build();
                IndexRequest indexRequest = new IndexRequest(".plugins-ml-model");
                if (mlRegisterModelMetaInput.getIsHidden() != null && mlRegisterModelMetaInput.getIsHidden().booleanValue()) {
                    indexRequest.id(modelName);
                }
                indexRequest.source(mlModelMeta.toXContent(XContentBuilder.builder((XContent)MediaTypeRegistry.JSON.xContent()), ToXContent.EMPTY_PARAMS));
                indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                this.client.index(indexRequest, ActionListenerHelper.wrap(response -> {
                    log.debug("Index model meta doc successfully {}", (Object)modelName);
                    wrappedListener.onResponse((Object)response.getId());
                }, e -> {
                    this.deleteOrUpdateModelGroup(mlRegisterModelMetaInput.getModelGroupId(), mlRegisterModelMetaInput.getDoesVersionCreateModelGroup(), version);
                    log.error("Failed to index model meta doc");
                    wrappedListener.onFailure(e);
                }));
            }, ex -> {
                log.error("Failed to init model index", (Throwable)ex);
                wrappedListener.onFailure(ex);
            }));
        }
        catch (Exception e) {
            log.error("Failed to register model");
            listener.onFailure(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMLRemoteModel(MetadataClient sdkClient, MLRegisterModelInput mlRegisterModelInput, MLTask mlTask, ActionListener<MLRegisterModelResponse> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.checkAndAddRunningTask(mlTask, this.maxRegisterTasksPerNode);
            this.mlStats.getStat((Enum)MLNodeLevelStat.ML_REQUEST_COUNT).increment();
            this.mlStats.createCounterStatIfAbsent(mlTask.getFunctionName(), ActionName.REGISTER, MLActionLevelStat.ML_ACTION_REQUEST_COUNT).increment();
            this.mlStats.getStat((Enum)MLNodeLevelStat.ML_EXECUTING_TASK_COUNT).increment();
            String modelGroupId = mlRegisterModelInput.getModelGroupId();
            GetDataObjectRequest getModelGroupRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-model-group")).tenantId(mlRegisterModelInput.getTenantId())).id(modelGroupId)).build();
            sdkClient.getDataObjectAsync(getModelGroupRequest).whenComplete((r, throwable) -> {
                block13: {
                    if (throwable == null) {
                        try {
                            GetResponse getModelGroupResponse = GetResponse.fromXContent((XContentParser)r.parser());
                            if (getModelGroupResponse.isExists()) {
                                Map modelGroupSourceMap = getModelGroupResponse.getSourceAsMap();
                                int updatedVersion = this.incrementLatestVersion(modelGroupSourceMap);
                                modelGroupSourceMap.put("latest_version", updatedVersion);
                                modelGroupSourceMap.put("last_updated_time", Instant.now().toEpochMilli());
                                UpdateDataObjectRequest updateDataObjectRequest = ((UpdateDataObjectRequest.Builder)((UpdateDataObjectRequest.Builder)((UpdateDataObjectRequest.Builder)UpdateDataObjectRequest.builder().index(".plugins-ml-model-group")).id(modelGroupId)).tenantId(mlRegisterModelInput.getTenantId())).ifSeqNo(getModelGroupResponse.getSeqNo()).ifPrimaryTerm(getModelGroupResponse.getPrimaryTerm()).dataObject(modelGroupSourceMap).build();
                                try (ThreadContext.StoredContext innerContext = this.client.threadPool().getThreadContext().stashContext();){
                                    sdkClient.updateDataObjectAsync(updateDataObjectRequest).whenComplete((ur, ut) -> {
                                        if (ut == null) {
                                            this.indexRemoteModel(sdkClient, mlRegisterModelInput, mlTask, "" + updatedVersion, listener);
                                        } else {
                                            Exception e = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)ut, (Class[])new Class[0]);
                                            log.error("Failed to update model group {}", (Object)modelGroupId);
                                            this.handleException(mlRegisterModelInput.getFunctionName(), mlTask.getTaskId(), mlRegisterModelInput.getTenantId(), e);
                                            listener.onFailure(e);
                                        }
                                    });
                                    break block13;
                                }
                            }
                            log.error("Model group response is empty");
                            this.handleException(mlRegisterModelInput.getFunctionName(), mlTask.getTaskId(), mlRegisterModelInput.getTenantId(), (Exception)new MLValidationException("Model group not found"));
                            listener.onFailure((Exception)new MLResourceNotFoundException("Model Group Response is empty for " + modelGroupId));
                        }
                        catch (Exception e) {
                            listener.onFailure(e);
                        }
                    } else {
                        Exception e = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                        if (SkyliteExceptionsHelper.unwrap((Throwable)e, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
                            log.error("Model group Index is missing");
                            this.handleException(mlRegisterModelInput.getFunctionName(), mlTask.getTaskId(), mlRegisterModelInput.getTenantId(), (Exception)new MLResourceNotFoundException("Failed to get model group due to index missing"));
                            listener.onFailure((Exception)new SkyliteStatusException("Model group not found", RestStatus.NOT_FOUND, new Object[0]));
                        } else {
                            log.error("Failed to get model group");
                            this.handleException(mlRegisterModelInput.getFunctionName(), mlTask.getTaskId(), mlRegisterModelInput.getTenantId(), e);
                            listener.onFailure(e);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to register remote model");
            this.handleException(mlRegisterModelInput.getFunctionName(), mlTask.getTaskId(), mlRegisterModelInput.getTenantId(), e);
            listener.onFailure(e);
        }
        finally {
            this.mlStats.getStat((Enum)MLNodeLevelStat.ML_EXECUTING_TASK_COUNT).decrement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMLModel(MLRegisterModelInput registerModelInput, MLTask mlTask) {
        this.checkAndAddRunningTask(mlTask, this.maxRegisterTasksPerNode);
        try {
            this.mlStats.getStat((Enum)MLNodeLevelStat.ML_REQUEST_COUNT).increment();
            this.mlStats.createCounterStatIfAbsent(mlTask.getFunctionName(), ActionName.REGISTER, MLActionLevelStat.ML_ACTION_REQUEST_COUNT).increment();
            this.mlStats.getStat((Enum)MLNodeLevelStat.ML_EXECUTING_TASK_COUNT).increment();
            String modelGroupId = registerModelInput.getModelGroupId();
            GetRequest getModelGroupRequest = new GetRequest(".plugins-ml-model-group").id(modelGroupId);
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                this.client.get(getModelGroupRequest, ActionListenerHelper.runBefore((ActionListener)ActionListenerHelper.wrap(modelGroup -> {
                    if (modelGroup.isExists()) {
                        Map modelGroupSourceMap = modelGroup.getSourceAsMap();
                        int updatedVersion = this.incrementLatestVersion(modelGroupSourceMap);
                        UpdateRequest updateModelGroupRequest = this.createUpdateModelGroupRequest(modelGroupSourceMap, modelGroupId, modelGroup.getSeqNo(), modelGroup.getPrimaryTerm(), updatedVersion);
                        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
                            this.client.update(updateModelGroupRequest, ActionListenerHelper.wrap(r -> this.uploadModel(registerModelInput, mlTask, "" + updatedVersion), e -> {
                                log.error("Failed to update model group");
                                this.handleException(registerModelInput.getFunctionName(), mlTask.getTaskId(), registerModelInput.getTenantId(), (Exception)e);
                            }));
                        }
                    } else {
                        log.error("Model group not found");
                        this.handleException(registerModelInput.getFunctionName(), mlTask.getTaskId(), registerModelInput.getTenantId(), (Exception)new MLValidationException("Model group not found"));
                    }
                }, e -> {
                    if (e instanceof IndexNotFoundException) {
                        this.handleException(registerModelInput.getFunctionName(), mlTask.getTaskId(), registerModelInput.getTenantId(), (Exception)new MLResourceNotFoundException("Failed to get model group"));
                    } else {
                        log.error("Failed to get model group");
                        this.handleException(registerModelInput.getFunctionName(), mlTask.getTaskId(), registerModelInput.getTenantId(), (Exception)e);
                    }
                }), () -> ((ThreadContext.StoredContext)context).restore()));
            }
            catch (Exception e2) {
                log.error("Failed to register model");
                this.handleException(registerModelInput.getFunctionName(), mlTask.getTaskId(), registerModelInput.getTenantId(), e2);
            }
        }
        catch (Exception e3) {
            this.handleException(registerModelInput.getFunctionName(), mlTask.getTaskId(), registerModelInput.getTenantId(), e3);
        }
        finally {
            this.mlStats.getStat((Enum)MLNodeLevelStat.ML_EXECUTING_TASK_COUNT).decrement();
        }
    }

    private UpdateRequest createUpdateModelGroupRequest(Map<String, Object> modelGroupSourceMap, String modelGroupId, long seqNo, long primaryTerm, int updatedVersion) {
        modelGroupSourceMap.put("latest_version", updatedVersion);
        modelGroupSourceMap.put("last_updated_time", Instant.now().toEpochMilli());
        UpdateRequest updateModelGroupRequest = new UpdateRequest();
        ((UpdateRequest)updateModelGroupRequest.index(".plugins-ml-model-group")).id(modelGroupId).setIfSeqNo(seqNo).setIfPrimaryTerm(primaryTerm).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).doc(modelGroupSourceMap);
        return updateModelGroupRequest;
    }

    private int incrementLatestVersion(Map<String, Object> modelGroupSourceMap) {
        return Integer.parseInt(modelGroupSourceMap.get("latest_version").toString()) + 1;
    }

    private void indexRemoteModel(MetadataClient sdkClient, MLRegisterModelInput registerModelInput, MLTask mlTask, String modelVersion, ActionListener<MLRegisterModelResponse> listener) {
        String taskId = mlTask.getTaskId();
        FunctionName functionName = mlTask.getFunctionName();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            String modelName = registerModelInput.getModelName();
            String version = modelVersion == null ? registerModelInput.getVersion() : modelVersion;
            Instant now = Instant.now();
            if (registerModelInput.getConnector() != null) {
                registerModelInput.getConnector().encrypt((arg_0, arg_1) -> ((MLEngine)this.mlEngine).encrypt(arg_0, arg_1), registerModelInput.getTenantId());
            }
            this.mlIndicesHandler.initModelIndexIfAbsent((ActionListener<Boolean>)ActionListenerHelper.wrap(boolResponse -> {
                if (!boolResponse.booleanValue()) {
                    listener.onFailure((Exception)new RuntimeException("No response to create ML Model index"));
                    return;
                }
                MLModel mlModelMeta = MLModel.builder().name(modelName).algorithm(functionName).modelGroupId(registerModelInput.getModelGroupId()).version(version).description(registerModelInput.getDescription()).rateLimiter(registerModelInput.getRateLimiter()).isEnabled(registerModelInput.getIsEnabled()).modelFormat(registerModelInput.getModelFormat()).modelState(MLModelState.REGISTERED).connector(registerModelInput.getConnector()).connectorId(registerModelInput.getConnectorId()).modelConfig(registerModelInput.getModelConfig()).deploySetting(registerModelInput.getDeploySetting()).createdTime(now).lastUpdateTime(now).isHidden(registerModelInput.getIsHidden()).guardrails(registerModelInput.getGuardrails()).modelInterface(registerModelInput.getModelInterface()).tenantId(registerModelInput.getTenantId()).build();
                PutDataObjectRequest putModelMetaRequest = ((PutDataObjectRequest.Builder)((PutDataObjectRequest.Builder)((PutDataObjectRequest.Builder)PutDataObjectRequest.builder().index(".plugins-ml-model")).id(Boolean.TRUE.equals(registerModelInput.getIsHidden()) ? modelName : null)).tenantId(registerModelInput.getTenantId())).dataObject((ToXContentObject)mlModelMeta).build();
                ActionListener indexListener = ActionListenerHelper.wrap(modelMetaRes -> {
                    String modelId = modelMetaRes.getId();
                    mlTask.setModelId(modelId);
                    log.info("create new model meta doc {} for upload task {}", (Object)modelId, (Object)taskId);
                    this.mlTaskManager.updateMLTask(taskId, registerModelInput.getTenantId(), Map.of("model_id", modelId, "state", MLTaskState.COMPLETED), 5000L, true);
                    if (registerModelInput.isDeployModel()) {
                        this.deployModelAfterRegistering(registerModelInput, modelId);
                    }
                    listener.onResponse((Object)new MLRegisterModelResponse(taskId, MLTaskState.CREATED.name(), modelId));
                }, e -> {
                    log.error("Failed to index model meta doc");
                    this.handleException(functionName, taskId, registerModelInput.getTenantId(), (Exception)e);
                    listener.onFailure(e);
                });
                ThreadedActionListener putListener = this.threadedActionListener("lucenia_ml_register", indexListener);
                sdkClient.putDataObjectAsync(putModelMetaRequest).whenComplete((r, throwable) -> {
                    if (throwable == null) {
                        try {
                            IndexResponse ir = IndexResponse.fromXContent((XContentParser)r.parser());
                            putListener.onResponse((Object)ir);
                        }
                        catch (Exception e) {
                            putListener.onFailure(e);
                        }
                    } else {
                        Exception e = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                        putListener.onFailure(e);
                    }
                });
            }, error -> {
                log.error("Failed to init model index", (Throwable)error);
                this.handleException(functionName, taskId, registerModelInput.getTenantId(), (Exception)error);
                listener.onFailure(error);
            }));
        }
    }

    void indexRemoteModel(MLRegisterModelInput registerModelInput, MLTask mlTask, String modelVersion) {
        String taskId = mlTask.getTaskId();
        FunctionName functionName = mlTask.getFunctionName();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            String modelName = registerModelInput.getModelName();
            String version = modelVersion == null ? registerModelInput.getVersion() : modelVersion;
            Instant now = Instant.now();
            if (registerModelInput.getConnector() != null) {
                registerModelInput.getConnector().encrypt((arg_0, arg_1) -> ((MLEngine)this.mlEngine).encrypt(arg_0, arg_1), registerModelInput.getTenantId());
            }
            this.mlIndicesHandler.initModelIndexIfAbsent((ActionListener<Boolean>)ActionListenerHelper.runBefore((ActionListener)ActionListenerHelper.wrap(res -> {
                if (!res.booleanValue()) {
                    this.handleException(functionName, taskId, registerModelInput.getTenantId(), new RuntimeException("No response to create ML Model index"));
                    return;
                }
                MLModel mlModelMeta = MLModel.builder().name(modelName).algorithm(functionName).modelGroupId(registerModelInput.getModelGroupId()).version(version).description(registerModelInput.getDescription()).rateLimiter(registerModelInput.getRateLimiter()).isEnabled(registerModelInput.getIsEnabled()).modelFormat(registerModelInput.getModelFormat()).modelState(MLModelState.REGISTERED).connector(registerModelInput.getConnector()).connectorId(registerModelInput.getConnectorId()).modelConfig(registerModelInput.getModelConfig()).deploySetting(registerModelInput.getDeploySetting()).createdTime(now).lastUpdateTime(now).isHidden(registerModelInput.getIsHidden()).guardrails(registerModelInput.getGuardrails()).modelInterface(registerModelInput.getModelInterface()).tenantId(registerModelInput.getTenantId()).build();
                PutDataObjectRequest putModelMetaRequest = ((PutDataObjectRequest.Builder)((PutDataObjectRequest.Builder)((PutDataObjectRequest.Builder)PutDataObjectRequest.builder().index(".plugins-ml-model")).id(Boolean.TRUE.equals(registerModelInput.getIsHidden()) ? modelName : null)).tenantId(registerModelInput.getTenantId())).dataObject((ToXContentObject)mlModelMeta).build();
                IndexRequest indexModelMetaRequest = new IndexRequest(".plugins-ml-model");
                if (registerModelInput.getIsHidden() != null && registerModelInput.getIsHidden().booleanValue()) {
                    indexModelMetaRequest.id(modelName);
                }
                indexModelMetaRequest.source(mlModelMeta.toXContent(XContentBuilder.builder((XContent)MediaTypeRegistry.JSON.xContent()), ToXContent.EMPTY_PARAMS));
                indexModelMetaRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                ActionListener indexListener = ActionListenerHelper.wrap(modelMetaRes -> {
                    String modelId = modelMetaRes.getId();
                    mlTask.setModelId(modelId);
                    log.info("create new model meta doc {} for upload task {}", (Object)modelId, (Object)taskId);
                    this.mlTaskManager.updateMLTask(taskId, registerModelInput.getTenantId(), Map.of("model_id", modelId, "state", MLTaskState.COMPLETED), 5000L, true);
                    if (registerModelInput.isDeployModel()) {
                        this.deployModelAfterRegistering(registerModelInput, modelId);
                    }
                }, e -> {
                    log.error("Failed to index model meta doc");
                    this.handleException(functionName, taskId, registerModelInput.getTenantId(), (Exception)e);
                });
                ThreadedActionListener putListener = this.threadedActionListener("lucenia_ml_register", indexListener);
                this.sdkClient.putDataObjectAsync(putModelMetaRequest).whenComplete((r, throwable) -> {
                    if (throwable == null) {
                        try {
                            IndexResponse ir = IndexResponse.fromXContent((XContentParser)r.parser());
                            putListener.onResponse((Object)ir);
                        }
                        catch (Exception e) {
                            putListener.onFailure(e);
                        }
                    } else {
                        Exception e = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                        putListener.onFailure(e);
                    }
                });
            }, e -> {
                log.error("Failed to init model index");
                this.handleException(functionName, taskId, registerModelInput.getTenantId(), (Exception)e);
            }), () -> ((ThreadContext.StoredContext)context).restore()));
        }
        catch (Exception e2) {
            MLExceptionUtils.logException((String)"Failed to upload model", (Exception)e2, (Logger)log);
            this.handleException(functionName, taskId, registerModelInput.getTenantId(), e2);
        }
    }

    private void uploadModel(MLRegisterModelInput registerModelInput, MLTask mlTask, String modelVersion) throws PrivilegedActionException {
        if (registerModelInput.getUrl() != null) {
            this.registerModelFromUrl(registerModelInput, mlTask, modelVersion);
        } else if (registerModelInput.getFunctionName() == FunctionName.REMOTE || registerModelInput.getConnectorId() != null) {
            this.indexRemoteModel(registerModelInput, mlTask, modelVersion);
        } else {
            this.registerPrebuiltModel(registerModelInput, mlTask, modelVersion);
        }
    }

    private void registerModelFromUrl(MLRegisterModelInput registerModelInput, MLTask mlTask, String modelVersion) {
        String taskId = mlTask.getTaskId();
        FunctionName functionName = mlTask.getFunctionName();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            String modelName = registerModelInput.getModelName();
            String version = modelVersion == null ? registerModelInput.getVersion() : modelVersion;
            String modelGroupId = registerModelInput.getModelGroupId();
            Instant now = Instant.now();
            this.mlIndicesHandler.initModelIndexIfAbsent((ActionListener<Boolean>)ActionListenerHelper.runBefore((ActionListener)ActionListenerHelper.wrap(res -> {
                if (!res.booleanValue()) {
                    this.handleException(functionName, taskId, registerModelInput.getTenantId(), new RuntimeException("No response to create ML Model index"));
                    return;
                }
                MLModel mlModelMeta = MLModel.builder().name(modelName).modelGroupId(modelGroupId).algorithm(functionName).version(version).description(registerModelInput.getDescription()).rateLimiter(registerModelInput.getRateLimiter()).isEnabled(registerModelInput.getIsEnabled()).modelFormat(registerModelInput.getModelFormat()).modelState(MLModelState.REGISTERING).modelConfig(registerModelInput.getModelConfig()).deploySetting(registerModelInput.getDeploySetting()).createdTime(now).lastUpdateTime(now).isHidden(registerModelInput.getIsHidden()).guardrails(registerModelInput.getGuardrails()).modelInterface(registerModelInput.getModelInterface()).build();
                IndexRequest indexModelMetaRequest = new IndexRequest(".plugins-ml-model");
                if (functionName == FunctionName.METRICS_CORRELATION) {
                    indexModelMetaRequest.id(functionName.name());
                }
                if (registerModelInput.getIsHidden() != null && registerModelInput.getIsHidden().booleanValue()) {
                    indexModelMetaRequest.id(modelName);
                }
                indexModelMetaRequest.source(mlModelMeta.toXContent(XContentBuilder.builder((XContent)MediaTypeRegistry.JSON.xContent()), ToXContent.EMPTY_PARAMS));
                indexModelMetaRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                ActionListener listener = ActionListenerHelper.wrap(modelMetaRes -> {
                    String modelId = modelMetaRes.getId();
                    mlTask.setModelId(modelId);
                    log.info("create new model meta doc {} for register model task {}", (Object)modelId, (Object)taskId);
                    this.registerModel(registerModelInput, taskId, functionName, modelName, version, modelId);
                }, e -> {
                    log.error("Failed to index model meta doc");
                    this.handleException(functionName, taskId, registerModelInput.getTenantId(), (Exception)e);
                });
                this.client.index(indexModelMetaRequest, this.threadedActionListener("lucenia_ml_register", listener));
            }, e -> {
                log.error("Failed to init model index");
                this.handleException(functionName, taskId, registerModelInput.getTenantId(), (Exception)e);
            }), () -> ((ThreadContext.StoredContext)context).restore()));
        }
        catch (Exception e2) {
            MLExceptionUtils.logException((String)"Failed to register model", (Exception)e2, (Logger)log);
            this.handleException(functionName, taskId, registerModelInput.getTenantId(), e2);
        }
    }

    @SuppressForbidden(reason="Dependency injection removal")
    private void registerModel(MLRegisterModelInput registerModelInput, String taskId, FunctionName functionName, String modelName, String version, String modelId) {
        this.modelDownloader.downloadAndSplit(this.mlEngine, registerModelInput.getModelFormat(), modelId, modelName, version, registerModelInput.getUrl(), registerModelInput.getHashValue(), functionName, ActionListenerHelper.wrap(result -> {
            Long modelSizeInBytes = (Long)result.get("model_size_in_bytes");
            if (modelSizeInBytes >= 0x100000000L) {
                throw new MLException("Model file size exceeds the limit of 4GB: " + modelSizeInBytes);
            }
            List chunkFiles = (List)result.get("chunk_files");
            String hashValue = (String)result.get("model_file_hash");
            Semaphore semaphore = new Semaphore(1);
            AtomicInteger uploaded = new AtomicInteger(0);
            AtomicBoolean failedToUploadChunk = new AtomicBoolean(false);
            for (String name : chunkFiles) {
                semaphore.tryAcquire(10L, TimeUnit.SECONDS);
                if (failedToUploadChunk.get()) {
                    throw new MLException("Failed to save model chunk");
                }
                Path path = Paths.get(name, new String[0]);
                byte[] bytes = Files.readAllBytes(path);
                int chunkNum = Integer.parseInt(path.getFileName().toString());
                Instant now = Instant.now();
                MLModel mlModel = MLModel.builder().modelId(modelId).name(modelName).algorithm(functionName).version(version).modelFormat(registerModelInput.getModelFormat()).rateLimiter(registerModelInput.getRateLimiter()).isEnabled(registerModelInput.getIsEnabled()).chunkNumber(Integer.valueOf(chunkNum)).totalChunks(Integer.valueOf(chunkFiles.size())).content(Base64.getEncoder().encodeToString(bytes)).createdTime(now).lastUpdateTime(now).isHidden(registerModelInput.getIsHidden()).guardrails(registerModelInput.getGuardrails()).modelInterface(registerModelInput.getModelInterface()).build();
                IndexRequest indexRequest = new IndexRequest(".plugins-ml-model");
                if (registerModelInput.getIsHidden() != null && registerModelInput.getIsHidden().booleanValue()) {
                    indexRequest.id(modelName);
                }
                String chunkId = this.getModelChunkId(modelId, chunkNum);
                indexRequest.id(chunkId);
                indexRequest.source(mlModel.toXContent(XContentBuilder.builder((XContent)MediaTypeRegistry.JSON.xContent()), ToXContent.EMPTY_PARAMS));
                indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                this.client.index(indexRequest, ActionListenerHelper.wrap(r -> {
                    uploaded.getAndIncrement();
                    if (uploaded.get() == chunkFiles.size()) {
                        this.updateModelRegisterStateAsDone(registerModelInput, taskId, modelId, modelSizeInBytes, chunkFiles, hashValue, version);
                    } else {
                        FileUtils.deleteFileQuietly((Path)path);
                    }
                    semaphore.release();
                }, e -> {
                    log.error("Failed to index model chunk {}", (Object)chunkId);
                    failedToUploadChunk.set(true);
                    this.handleException(functionName, taskId, registerModelInput.getTenantId(), (Exception)e);
                    FileUtils.deleteFileQuietly((Path)path);
                    this.deleteModel(modelId, registerModelInput, version);
                    semaphore.release();
                    FileUtils.deleteFileQuietly((Path)this.mlEngine.getRegisterModelPath(modelId));
                }));
            }
        }, e -> {
            log.error("Failed to index chunk file");
            FileUtils.deleteFileQuietly((Path)this.mlEngine.getRegisterModelPath(modelId));
            this.deleteModel(modelId, registerModelInput, version);
            this.handleException(functionName, taskId, registerModelInput.getTenantId(), (Exception)e);
        }));
    }

    private void registerPrebuiltModel(MLRegisterModelInput registerModelInput, MLTask mlTask, String modelVersion) throws PrivilegedActionException {
        String taskId = mlTask.getTaskId();
        List modelMetaList = this.modelDownloader.downloadPrebuiltModelMetaList(this.mlEngine, taskId, registerModelInput);
        if (!this.modelDownloader.isModelAllowed(registerModelInput, modelMetaList)) {
            throw new IllegalArgumentException("This model is not in the pre-trained model list, please check your parameters.");
        }
        this.modelDownloader.downloadPrebuiltModelConfig(this.mlEngine, taskId, registerModelInput, ActionListenerHelper.wrap(mlRegisterModelInput -> {
            mlTask.setFunctionName(mlRegisterModelInput.getFunctionName());
            this.mlTaskManager.updateMLTask(taskId, registerModelInput.getTenantId(), Map.of("function_name", mlRegisterModelInput.getFunctionName()), 5000L, false);
            this.registerModelFromUrl((MLRegisterModelInput)mlRegisterModelInput, mlTask, modelVersion);
        }, e -> {
            log.error("Failed to register prebuilt model");
            this.handleException(registerModelInput.getFunctionName(), taskId, registerModelInput.getTenantId(), (Exception)e);
        }));
    }

    private <T> ThreadedActionListener<T> threadedActionListener(String threadPoolName, ActionListener<T> listener) {
        return new ThreadedActionListener(log, this.threadPool, threadPoolName, listener, false);
    }

    public void checkAndAddRunningTask(MLTask mlTask, Integer runningTaskLimit) {
        if (Objects.nonNull(mlTask) && mlTask.getFunctionName() != FunctionName.REMOTE) {
            MLNodeUtils.checkOpenCircuitBreaker((MLCircuitBreakerService)this.mlCircuitBreakerService, (MLStats)this.mlStats);
        }
        this.mlTaskManager.checkLimitAndAddRunningTask(mlTask, runningTaskLimit);
    }

    public void checkMaxBatchJobTask(MLTask mlTask, ActionListener<Boolean> listener) {
        MLTaskType taskType = mlTask.getTaskType();
        int maxLimit = taskType.equals((Object)MLTaskType.BATCH_PREDICTION) ? this.maxBatchInferenceTasks : this.maxBatchIngestionTasks;
        this.mlTaskManager.checkMaxBatchJobTask(taskType, maxLimit, listener);
    }

    private void updateModelRegisterStateAsDone(MLRegisterModelInput registerModelInput, String taskId, String modelId, Long modelSizeInBytes, List<String> chunkFiles, String hashValue, String version) {
        FunctionName functionName = registerModelInput.getFunctionName();
        FileUtils.deleteFileQuietly((Path)this.mlEngine.getRegisterModelPath(modelId));
        Map<String, Object> updatedFields = Map.of("model_state", MLModelState.REGISTERED, "last_registered_time", Instant.now().toEpochMilli(), "total_chunks", chunkFiles.size(), "model_content_hash_value", hashValue, "model_content_size_in_bytes", modelSizeInBytes);
        log.info("Model registered successfully, model id: {}, task id: {}", (Object)modelId, (Object)taskId);
        log.debug("Calling updateModel to mark model {} as REGISTERED", (Object)modelId);
        this.updateModel(modelId, null, updatedFields, (ActionListener<UpdateResponse>)ActionListenerHelper.wrap(updateResponse -> {
            log.info("Successfully updated model {} to REGISTERED state, now updating task {} to COMPLETED", (Object)modelId, (Object)taskId);
            this.mlTaskManager.updateMLTask(taskId, registerModelInput.getTenantId(), Map.of("state", MLTaskState.COMPLETED, "model_id", modelId), 5000L, true);
            if (registerModelInput.isDeployModel()) {
                this.deployModelAfterRegistering(registerModelInput, modelId);
            }
        }, e -> {
            log.error("Failed to update model {} to REGISTERED state, error: {}", (Object)modelId, (Object)e.getMessage());
            this.handleException(functionName, taskId, registerModelInput.getTenantId(), (Exception)e);
            this.deleteModel(modelId, registerModelInput, version);
        }));
    }

    void deployModelAfterRegistering(MLRegisterModelInput registerModelInput, String modelId) {
        Object[] modelNodeIds = registerModelInput.getModelNodeIds();
        log.debug("start deploying model after registering, modelId: {} on nodes: {}", (Object)modelId, (Object)Arrays.toString(modelNodeIds));
        MLDeployModelRequest request = new MLDeployModelRequest(modelId, registerModelInput.getTenantId(), (String[])modelNodeIds, false, true, true);
        ActionListener listener = ActionListenerHelper.wrap(r -> log.debug("model deployed, response {}", r), e -> log.error("Failed to deploy model"));
        this.client.execute((ActionType)MLDeployModelAction.INSTANCE, (ActionRequest)request, listener);
    }

    private void deleteModel(String modelId, MLRegisterModelInput registerModelInput, String modelVersion) {
        DeleteRequest deleteRequest = new DeleteRequest();
        ((DeleteRequest)deleteRequest.index(".plugins-ml-model")).id(modelId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        this.client.delete(deleteRequest);
        DeleteByQueryRequest deleteChunksRequest = (DeleteByQueryRequest)new DeleteByQueryRequest(new String[]{".plugins-ml-model"}).setQuery((QueryBuilder)new TermQueryBuilder("model_id", modelId)).setIndicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN).setAbortOnVersionConflict(false);
        this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteChunksRequest);
        this.deleteOrUpdateModelGroup(registerModelInput.getModelGroupId(), registerModelInput.getDoesVersionCreateModelGroup(), modelVersion);
    }

    private void deleteOrUpdateModelGroup(String modelGroupID, Boolean doesVersionCreateModelGroup, String modelVersion) {
        if (Boolean.TRUE.equals(doesVersionCreateModelGroup)) {
            DeleteRequest deleteModelGroupRequest = new DeleteRequest();
            ((DeleteRequest)deleteModelGroupRequest.index(".plugins-ml-model-group")).id(modelGroupID).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            this.client.delete(deleteModelGroupRequest);
        } else {
            this.updateLatestVersionInModelGroup(modelGroupID, Integer.parseInt(modelVersion) - 1, (ActionListener<UpdateResponse>)ActionListenerHelper.wrap(r -> log.debug("model group updated, response {}", r), e -> log.error("Failed to update model group")));
        }
    }

    private void updateLatestVersionInModelGroup(String modelGroupID, Integer latestVersion, ActionListener<UpdateResponse> listener) {
        HashMap<String, Number> updatedFields = new HashMap<String, Number>();
        updatedFields.put("latest_version", latestVersion);
        updatedFields.put("last_updated_time", Instant.now().toEpochMilli());
        UpdateRequest updateRequest = new UpdateRequest(".plugins-ml-model-group", modelGroupID);
        updateRequest.doc(updatedFields);
        updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.client.update(updateRequest, ActionListenerHelper.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore()));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private void handleException(FunctionName functionName, String taskId, String tenantId, Exception e) {
        if (!(e instanceof MLLimitExceededException || e instanceof MLResourceNotFoundException || e instanceof IllegalArgumentException)) {
            this.mlStats.createCounterStatIfAbsent(functionName, ActionName.REGISTER, MLActionLevelStat.ML_ACTION_FAILURE_COUNT).increment();
            this.mlStats.getStat((Enum)MLNodeLevelStat.ML_FAILURE_COUNT).increment();
        }
        Map<String, MLTaskState> updated = Map.of("error", MLExceptionUtils.getRootCauseMessage((Throwable)e), "state", MLTaskState.FAILED);
        this.mlTaskManager.updateMLTask(taskId, tenantId, updated, 5000L, true);
    }

    public void getConnectorCredential(String connectorId, ActionListener<Map<String, String>> connectorCredentialListener) {
        this.getConnector(connectorId, null, (ActionListener<Connector>)ActionListenerHelper.wrap(connector -> {
            Map credential = this.mlEngine.getConnectorCredential(connector);
            connectorCredentialListener.onResponse((Object)credential);
            log.info("Completed loading credential in the connector {}", (Object)connectorId);
        }, arg_0 -> connectorCredentialListener.onFailure(arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployModel(String modelId, String tenantId, String modelContentHash, FunctionName functionName, boolean deployToAllNodes, boolean autoDeployModel, MLTask mlTask, ActionListener<String> listener) {
        this.mlStats.createCounterStatIfAbsent(functionName, ActionName.DEPLOY, MLActionLevelStat.ML_ACTION_REQUEST_COUNT).increment();
        this.mlStats.getStat((Enum)MLNodeLevelStat.ML_EXECUTING_TASK_COUNT).increment();
        this.mlStats.getStat((Enum)MLNodeLevelStat.ML_REQUEST_COUNT).increment();
        this.mlStats.createModelCounterStatIfAbsent(modelId, ActionName.DEPLOY, MLActionLevelStat.ML_ACTION_REQUEST_COUNT).increment();
        List workerNodes = mlTask.getWorkerNodes();
        if (this.modelCacheHelper.isModelDeployed(modelId)) {
            if (!autoDeployModel && workerNodes != null && !workerNodes.isEmpty()) {
                log.info("Set new target node ids {} for model {}", (Object)Arrays.toString(workerNodes.toArray(new String[0])), (Object)modelId);
                this.modelCacheHelper.setDeployToAllNodes(modelId, Boolean.valueOf(deployToAllNodes));
                this.modelCacheHelper.setTargetWorkerNodes(modelId, workerNodes);
                this.modelCacheHelper.refreshLastAccessTime(modelId);
            }
            listener.onResponse((Object)"successful");
            return;
        }
        if (functionName != FunctionName.REMOTE && this.modelCacheHelper.getLocalDeployedModels().length >= this.maxModelPerNode) {
            listener.onFailure((Exception)new IllegalArgumentException("Exceed max local model per node limit"));
            return;
        }
        int eligibleNodeCount = workerNodes.size();
        if (!autoDeployModel) {
            this.modelCacheHelper.initModelState(modelId, MLModelState.DEPLOYING, functionName, workerNodes, deployToAllNodes);
        } else {
            this.modelCacheHelper.initModelStateAutoDeploy(modelId, MLModelState.DEPLOYING, functionName, workerNodes);
        }
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListenerHelper.runBefore(listener, () -> {
                context.restore();
                this.modelCacheHelper.removeAutoDeployModel(modelId);
                this.modelCacheHelper.setIsAutoDeploying(modelId, Boolean.valueOf(false));
            });
            if (!autoDeployModel) {
                this.checkAndAddRunningTask(mlTask, this.maxDeployTasksPerNode);
            }
            this.getModel(modelId, tenantId, (ActionListener<MLModel>)this.threadedActionListener("lucenia_ml_deploy", ActionListenerHelper.wrap(mlModel -> {
                this.modelCacheHelper.setIsModelEnabled(modelId, mlModel.getIsEnabled());
                this.modelCacheHelper.setModelInfo(modelId, mlModel);
                if (FunctionName.REMOTE == mlModel.getAlgorithm() || !FunctionName.isDLModel((FunctionName)mlModel.getAlgorithm()) && mlModel.getAlgorithm() != FunctionName.METRICS_CORRELATION) {
                    if (mlModel.getIsControllerEnabled().booleanValue()) {
                        this.getController(modelId, (ActionListener<MLController>)ActionListenerHelper.wrap(controller -> {
                            this.setupUserRateLimiterMap(modelId, eligibleNodeCount, controller.getUserRateLimiter());
                            log.info("Successfully redeployed model controller for model " + modelId);
                            log.info("Trying to deploy remote model with model controller configured.");
                            this.deployRemoteOrBuiltInModel((MLModel)mlModel, eligibleNodeCount, (ActionListener<String>)wrappedListener);
                        }, e -> {
                            log.error("Trying to deploy remote model with exceptions in re-deploying its model controller. Model ID: {}", (Object)modelId);
                            this.deployRemoteOrBuiltInModel((MLModel)mlModel, eligibleNodeCount, (ActionListener<String>)wrappedListener);
                        }));
                        return;
                    }
                    log.info("Trying to deploy remote or built-in model without model controller configured.");
                    this.deployRemoteOrBuiltInModel((MLModel)mlModel, eligibleNodeCount, (ActionListener<String>)wrappedListener);
                    return;
                }
                this.setupRateLimiter(modelId, eligibleNodeCount, mlModel.getRateLimiter());
                this.setupMLGuard(modelId, mlModel.getGuardrails());
                this.setupModelInterface(modelId, mlModel.getModelInterface());
                if (mlModel.getIsControllerEnabled().booleanValue()) {
                    this.deployControllerWithDeployingModel((MLModel)mlModel, eligibleNodeCount);
                }
                MLNodeUtils.checkOpenCircuitBreaker((MLCircuitBreakerService)this.mlCircuitBreakerService, (MLStats)this.mlStats);
                this.retrieveModelChunks((MLModel)mlModel, (ActionListener<Path>)ActionListenerHelper.wrap(modelZipPath -> {
                    String hash = FileUtils.calculateFileHash((Path)modelZipPath);
                    if (modelContentHash != null && !modelContentHash.equals(hash)) {
                        log.error("Model content hash can't match original hash value");
                        this.removeModel(modelId);
                        wrappedListener.onFailure((Exception)new IllegalArgumentException("model content changed"));
                        return;
                    }
                    log.debug("Model content matches original hash value, continue deploying");
                    Map<String, MLEngine> params = Map.of("model_zip_file", modelZipPath, "model_helper", this.modelDownloader, "ml_engine", this.mlEngine);
                    if (FunctionName.METRICS_CORRELATION.equals((Object)mlModel.getAlgorithm())) {
                        MLExecutable mlExecutable = this.mlEngine.deployExecute(mlModel, params);
                        try {
                            this.modelCacheHelper.setMLExecutor(modelId, mlExecutable);
                            this.mlStats.getStat((Enum)MLNodeLevelStat.ML_DEPLOYED_MODEL_COUNT).increment();
                            this.modelCacheHelper.setModelState(modelId, MLModelState.DEPLOYED);
                            this.modelCacheHelper.refreshLastAccessTime(modelId);
                            wrappedListener.onResponse((Object)"successful");
                        }
                        catch (Exception e) {
                            log.error("Failed to add predictor to cache");
                            mlExecutable.close();
                            wrappedListener.onFailure(e);
                        }
                    } else {
                        Predictable predictable;
                        try {
                            predictable = AccessController.doPrivileged(() -> this.mlEngine.deploy(mlModel, params));
                        }
                        catch (PrivilegedActionException e) {
                            Exception cause = e.getException();
                            log.error("Failed to deploy model {} with privileged action {}", (Object)modelId, (Object)cause);
                            if (cause instanceof RuntimeException) {
                                throw (RuntimeException)cause;
                            }
                            throw new RuntimeException("Failed to deploy model", cause);
                        }
                        try {
                            this.modelCacheHelper.setPredictor(modelId, predictable);
                            this.mlStats.getStat((Enum)MLNodeLevelStat.ML_DEPLOYED_MODEL_COUNT).increment();
                            this.modelCacheHelper.setModelState(modelId, MLModelState.DEPLOYED);
                            this.modelCacheHelper.refreshLastAccessTime(modelId);
                            Long modelContentSizeInBytes = mlModel.getModelContentSizeInBytes();
                            long contentSize = modelContentSizeInBytes == null ? (long)(mlModel.getTotalChunks() * 10000000) : modelContentSizeInBytes;
                            this.modelCacheHelper.setMemSizeEstimation(modelId, mlModel.getModelFormat(), Long.valueOf(contentSize));
                            wrappedListener.onResponse((Object)"successful");
                        }
                        catch (Exception e) {
                            log.error("Failed to add predictor to cache");
                            predictable.close();
                            wrappedListener.onFailure(e);
                        }
                    }
                }, e -> {
                    log.error("Failed to retrieve model {}", (Object)modelId);
                    this.handleDeployModelException(modelId, functionName, (ActionListener<String>)wrappedListener, (Exception)e);
                }));
            }, e -> {
                log.error("Failed to deploy model {}", (Object)modelId);
                this.handleDeployModelException(modelId, functionName, (ActionListener<String>)wrappedListener, (Exception)e);
            })));
        }
        catch (Exception e2) {
            this.handleDeployModelException(modelId, functionName, listener, e2);
        }
        finally {
            this.mlStats.getStat((Enum)MLNodeLevelStat.ML_EXECUTING_TASK_COUNT).decrement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployModel(String modelId, String modelContentHash, FunctionName functionName, boolean deployToAllNodes, boolean autoDeployModel, MLTask mlTask, ActionListener<String> listener) {
        this.mlStats.createCounterStatIfAbsent(functionName, ActionName.DEPLOY, MLActionLevelStat.ML_ACTION_REQUEST_COUNT).increment();
        this.mlStats.getStat((Enum)MLNodeLevelStat.ML_EXECUTING_TASK_COUNT).increment();
        this.mlStats.getStat((Enum)MLNodeLevelStat.ML_REQUEST_COUNT).increment();
        this.mlStats.createModelCounterStatIfAbsent(modelId, ActionName.DEPLOY, MLActionLevelStat.ML_ACTION_REQUEST_COUNT).increment();
        List workerNodes = mlTask.getWorkerNodes();
        if (this.modelCacheHelper.isModelDeployed(modelId)) {
            if (!autoDeployModel && workerNodes != null && !workerNodes.isEmpty()) {
                log.info("Set new target node ids {} for model {}", (Object)Arrays.toString(workerNodes.toArray(new String[0])), (Object)modelId);
                this.modelCacheHelper.setDeployToAllNodes(modelId, Boolean.valueOf(deployToAllNodes));
                this.modelCacheHelper.setTargetWorkerNodes(modelId, workerNodes);
                this.modelCacheHelper.refreshLastAccessTime(modelId);
            }
            listener.onResponse((Object)"successful");
            return;
        }
        if (functionName != FunctionName.REMOTE && this.modelCacheHelper.getLocalDeployedModels().length >= this.maxModelPerNode) {
            listener.onFailure((Exception)new IllegalArgumentException("Exceed max local model per node limit"));
            return;
        }
        int eligibleNodeCount = workerNodes.size();
        if (!autoDeployModel) {
            this.modelCacheHelper.initModelState(modelId, MLModelState.DEPLOYING, functionName, workerNodes, deployToAllNodes);
        } else {
            this.modelCacheHelper.initModelStateAutoDeploy(modelId, MLModelState.DEPLOYING, functionName, workerNodes);
        }
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListenerHelper.runBefore(listener, () -> {
                context.restore();
                this.modelCacheHelper.removeAutoDeployModel(modelId);
                this.modelCacheHelper.setIsAutoDeploying(modelId, Boolean.valueOf(false));
            });
            if (!autoDeployModel) {
                this.checkAndAddRunningTask(mlTask, this.maxDeployTasksPerNode);
            }
            this.getModel(modelId, (ActionListener<MLModel>)this.threadedActionListener("lucenia_ml_deploy", ActionListenerHelper.wrap(mlModel -> {
                this.modelCacheHelper.setIsModelEnabled(modelId, mlModel.getIsEnabled());
                this.modelCacheHelper.setModelInfo(modelId, mlModel);
                if (FunctionName.REMOTE == mlModel.getAlgorithm() || !FunctionName.isDLModel((FunctionName)mlModel.getAlgorithm()) && mlModel.getAlgorithm() != FunctionName.METRICS_CORRELATION) {
                    if (mlModel.getIsControllerEnabled().booleanValue()) {
                        this.getController(modelId, (ActionListener<MLController>)ActionListenerHelper.wrap(controller -> {
                            this.setupUserRateLimiterMap(modelId, eligibleNodeCount, controller.getUserRateLimiter());
                            log.info("Successfully redeployed model controller for model " + modelId);
                            log.info("Trying to deploy remote model with model controller configured.");
                            this.deployRemoteOrBuiltInModel((MLModel)mlModel, eligibleNodeCount, (ActionListener<String>)wrappedListener);
                        }, e -> {
                            log.error("Trying to deploy remote model with exceptions in re-deploying its model controller. Model ID: " + modelId);
                            this.deployRemoteOrBuiltInModel((MLModel)mlModel, eligibleNodeCount, (ActionListener<String>)wrappedListener);
                        }));
                        return;
                    }
                    log.info("Trying to deploy remote or built-in model without model controller configured.");
                    this.deployRemoteOrBuiltInModel((MLModel)mlModel, eligibleNodeCount, (ActionListener<String>)wrappedListener);
                    return;
                }
                this.setupRateLimiter(modelId, eligibleNodeCount, mlModel.getRateLimiter());
                this.setupMLGuard(modelId, mlModel.getGuardrails());
                this.setupModelInterface(modelId, mlModel.getModelInterface());
                if (mlModel.getIsControllerEnabled().booleanValue()) {
                    this.deployControllerWithDeployingModel((MLModel)mlModel, eligibleNodeCount);
                }
                MLNodeUtils.checkOpenCircuitBreaker((MLCircuitBreakerService)this.mlCircuitBreakerService, (MLStats)this.mlStats);
                this.retrieveModelChunks((MLModel)mlModel, (ActionListener<Path>)ActionListenerHelper.wrap(modelZipFile -> {
                    String hash = FileUtils.calculateFileHash((Path)modelZipFile);
                    if (modelContentHash != null && !modelContentHash.equals(hash)) {
                        log.error("Model content hash can't match original hash value");
                        this.removeModel(modelId);
                        wrappedListener.onFailure((Exception)new IllegalArgumentException("model content changed"));
                        return;
                    }
                    log.debug("Model content matches original hash value, continue deploying");
                    Map<String, MLEngine> params = Map.of("model_zip_file", modelZipFile, "model_helper", this.modelDownloader, "ml_engine", this.mlEngine);
                    if (FunctionName.METRICS_CORRELATION.equals((Object)mlModel.getAlgorithm())) {
                        MLExecutable mlExecutable = this.mlEngine.deployExecute(mlModel, params);
                        try {
                            this.modelCacheHelper.setMLExecutor(modelId, mlExecutable);
                            this.mlStats.getStat((Enum)MLNodeLevelStat.ML_DEPLOYED_MODEL_COUNT).increment();
                            this.modelCacheHelper.setModelState(modelId, MLModelState.DEPLOYED);
                            this.modelCacheHelper.refreshLastAccessTime(modelId);
                            wrappedListener.onResponse((Object)"successful");
                        }
                        catch (Exception e) {
                            log.error("Failed to add predictor to cache");
                            mlExecutable.close();
                            wrappedListener.onFailure(e);
                        }
                    } else {
                        Predictable predictable;
                        try {
                            predictable = AccessController.doPrivileged(() -> this.mlEngine.deploy(mlModel, params));
                        }
                        catch (PrivilegedActionException e) {
                            Exception cause = e.getException();
                            log.error("Failed to deploy model {} with privileged action {}", (Object)modelId, (Object)cause);
                            if (cause instanceof RuntimeException) {
                                throw (RuntimeException)cause;
                            }
                            throw new RuntimeException("Failed to deploy model", cause);
                        }
                        try {
                            this.modelCacheHelper.setPredictor(modelId, predictable);
                            this.mlStats.getStat((Enum)MLNodeLevelStat.ML_DEPLOYED_MODEL_COUNT).increment();
                            this.modelCacheHelper.setModelState(modelId, MLModelState.DEPLOYED);
                            this.modelCacheHelper.refreshLastAccessTime(modelId);
                            Long modelContentSizeInBytes = mlModel.getModelContentSizeInBytes();
                            long contentSize = modelContentSizeInBytes == null ? (long)(mlModel.getTotalChunks() * 10000000) : modelContentSizeInBytes;
                            this.modelCacheHelper.setMemSizeEstimation(modelId, mlModel.getModelFormat(), Long.valueOf(contentSize));
                            wrappedListener.onResponse((Object)"successful");
                        }
                        catch (Exception e) {
                            log.error("Failed to add predictor to cache");
                            predictable.close();
                            wrappedListener.onFailure(e);
                        }
                    }
                }, e -> {
                    log.error("Failed to retrieve model " + modelId);
                    this.handleDeployModelException(modelId, functionName, (ActionListener<String>)wrappedListener, (Exception)e);
                }));
            }, e -> {
                log.error("Failed to deploy model " + modelId);
                this.handleDeployModelException(modelId, functionName, (ActionListener<String>)wrappedListener, (Exception)e);
            })));
        }
        catch (Exception e2) {
            this.handleDeployModelException(modelId, functionName, listener, e2);
        }
        finally {
            this.mlStats.getStat((Enum)MLNodeLevelStat.ML_EXECUTING_TASK_COUNT).decrement();
        }
    }

    private void deployRemoteOrBuiltInModel(MLModel mlModel, Integer eligibleNodeCount, ActionListener<String> wrappedListener) {
        String modelId = mlModel.getModelId();
        this.setupRateLimiter(modelId, eligibleNodeCount, mlModel.getRateLimiter());
        this.setupMLGuard(modelId, mlModel.getGuardrails());
        this.setupModelInterface(modelId, mlModel.getModelInterface());
        if (mlModel.getConnector() != null || FunctionName.REMOTE != mlModel.getAlgorithm()) {
            this.setupParamsAndPredictable(modelId, mlModel);
            this.mlStats.getStat((Enum)MLNodeLevelStat.ML_DEPLOYED_MODEL_COUNT).increment();
            this.modelCacheHelper.setModelState(modelId, MLModelState.DEPLOYED);
            this.modelCacheHelper.refreshLastAccessTime(modelId);
            wrappedListener.onResponse((Object)"successful");
            return;
        }
        log.info("Set connector {} for the model: {}", (Object)mlModel.getConnectorId(), (Object)modelId);
        this.getConnector(mlModel.getConnectorId(), mlModel.getTenantId(), (ActionListener<Connector>)ActionListenerHelper.wrap(connector -> {
            mlModel.setConnector(connector);
            this.setupParamsAndPredictable(modelId, mlModel);
            this.mlStats.getStat((Enum)MLNodeLevelStat.ML_DEPLOYED_MODEL_COUNT).increment();
            this.modelCacheHelper.setModelState(modelId, MLModelState.DEPLOYED);
            this.modelCacheHelper.refreshLastAccessTime(modelId);
            wrappedListener.onResponse((Object)"successful");
            log.info("Completed setting connector {} in the model {}", (Object)mlModel.getConnectorId(), (Object)modelId);
        }, arg_0 -> wrappedListener.onFailure(arg_0)));
    }

    private void setupParamsAndPredictable(String modelId, MLModel mlModel) {
        Map<String, Object> params = this.setUpParameterMap(modelId);
        Predictable predictable = this.mlEngine.deploy(mlModel, params);
        this.modelCacheHelper.setPredictor(modelId, predictable);
    }

    private Map<String, Object> setUpParameterMap(String modelId) {
        TokenBucket rateLimiter = this.getRateLimiter(modelId);
        Map<String, TokenBucket> userRateLimiterMap = this.getUserRateLimiterMap(modelId);
        MLGuard mlGuard = this.getMLGuard(modelId);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ml_engine", this.mlEngine);
        params.put("script_service", this.scriptService);
        params.put("client", this.client);
        params.put("xcontent_registry", this.xContentRegistry);
        params.put("cluster_service", this.clusterService);
        if (rateLimiter == null && userRateLimiterMap == null) {
            log.info("Setting up basic ML predictor parameters.");
        } else if (rateLimiter != null && userRateLimiterMap == null) {
            params.put("rate_limiter", rateLimiter);
            log.info("Setting up basic ML predictor parameters with model level throttling.");
        } else if (rateLimiter == null) {
            params.put("user_rate_limiter_map", userRateLimiterMap);
            log.info("Setting up basic ML predictor parameters with user level throttling.");
        } else {
            params.put("rate_limiter", rateLimiter);
            params.put("user_rate_limiter_map", userRateLimiterMap);
            log.info("Setting up basic ML predictor parameters with both model and user level throttling.");
        }
        if (mlGuard != null) {
            params.put("guardrails", mlGuard);
            log.info("Setting up ML guard parameter for ML predictor.");
        }
        params.put("connectorPrivateIpEnabled", this.mlFeatureEnabledSetting.isConnectorPrivateIpEnabled());
        return Collections.unmodifiableMap(params);
    }

    private void handleDeployModelException(String modelId, FunctionName functionName, ActionListener<String> listener, Exception e) {
        if (!(e instanceof MLLimitExceededException || e instanceof MLResourceNotFoundException || e instanceof IllegalArgumentException)) {
            this.mlStats.createCounterStatIfAbsent(functionName, ActionName.DEPLOY, MLActionLevelStat.ML_ACTION_FAILURE_COUNT).increment();
            this.mlStats.getStat((Enum)MLNodeLevelStat.ML_FAILURE_COUNT).increment();
        }
        this.removeModel(modelId);
        listener.onFailure(e);
    }

    public synchronized void updateModelCache(String modelId, ActionListener<String> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListenerHelper.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
            this.getModel(modelId, (ActionListener<MLModel>)ActionListenerHelper.wrap(mlModel -> {
                int eligibleNodeCount = this.getWorkerNodes(modelId, mlModel.getAlgorithm()).length;
                this.modelCacheHelper.setIsModelEnabled(modelId, mlModel.getIsEnabled());
                this.setupRateLimiter(modelId, eligibleNodeCount, mlModel.getRateLimiter());
                this.setupMLGuard(modelId, mlModel.getGuardrails());
                this.setupModelInterface(modelId, mlModel.getModelInterface());
                if (mlModel.getAlgorithm() == FunctionName.REMOTE) {
                    if (mlModel.getConnector() != null) {
                        this.setupParamsAndPredictable(modelId, (MLModel)mlModel);
                        wrappedListener.onResponse((Object)("Successfully updated model cache for the remote model " + modelId));
                        log.info("Completed the model cache update for the remote model {}", (Object)modelId);
                    } else {
                        this.getConnector(mlModel.getConnectorId(), mlModel.getTenantId(), (ActionListener<Connector>)ActionListenerHelper.wrap(connector -> {
                            mlModel.setConnector(connector);
                            this.setupParamsAndPredictable(modelId, (MLModel)mlModel);
                            wrappedListener.onResponse((Object)("Successfully updated model cache for the remote model " + modelId));
                            log.info("Completed the model cache update for the remote model {}", (Object)modelId);
                        }, arg_0 -> ((ActionListener)wrappedListener).onFailure(arg_0)));
                    }
                }
                wrappedListener.onResponse((Object)("Successfully updated model cache for the model " + modelId));
                log.info("Completed the model cache update for the model {}", (Object)modelId);
            }, arg_0 -> ((ActionListener)wrappedListener).onFailure(arg_0)));
        }
        catch (Exception e) {
            log.error("Failed to updated model cache for the model {}", (Object)modelId);
            listener.onFailure(e);
        }
    }

    public synchronized void deployControllerWithDeployedModel(String modelId, ActionListener<String> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            if (!this.mlFeatureEnabledSetting.isControllerEnabled().booleanValue()) {
                throw new IllegalStateException("Controller is currently disabled. To enable it, update the setting \"plugins.ml_commons.controller_enabled\" to true.");
            }
            if (!this.modelCacheHelper.isModelDeployed(modelId)) {
                throw new SkyliteStatusException("The model of this model controller has not deployed yet, please deploy the model first.", RestStatus.CONFLICT, new Object[0]);
            }
            ActionListener wrappedListener = ActionListenerHelper.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
            this.getModel(modelId, (ActionListener<MLModel>)ActionListenerHelper.wrap(mlModel -> this.getController(modelId, (ActionListener<MLController>)ActionListenerHelper.wrap(controller -> {
                int eligibleNodeCount = this.getWorkerNodes(modelId, mlModel.getAlgorithm()).length;
                this.setupUserRateLimiterMap(modelId, eligibleNodeCount, controller.getUserRateLimiter());
                if (mlModel.getAlgorithm() == FunctionName.REMOTE) {
                    if (mlModel.getConnector() != null) {
                        this.setupParamsAndPredictable(modelId, (MLModel)mlModel);
                        wrappedListener.onResponse((Object)("Successfully deployed model controller for the remote model " + modelId));
                        log.info("Deployed model controller for the remote model {}", (Object)modelId);
                    } else {
                        this.getConnector(mlModel.getConnectorId(), mlModel.getTenantId(), (ActionListener<Connector>)ActionListenerHelper.wrap(connector -> {
                            mlModel.setConnector(connector);
                            this.setupParamsAndPredictable(modelId, (MLModel)mlModel);
                            wrappedListener.onResponse((Object)("Successfully deployed model controller for the remote model " + modelId));
                            log.info("Deployed model controller for the remote model {}", (Object)modelId);
                        }, arg_0 -> ((ActionListener)wrappedListener).onFailure(arg_0)));
                    }
                    return;
                }
                wrappedListener.onResponse((Object)("Successfully deployed model controller for the model " + modelId));
                log.info("Deployed model controller for the model {}", (Object)modelId);
            }, arg_0 -> ((ActionListener)wrappedListener).onFailure(arg_0))), arg_0 -> ((ActionListener)wrappedListener).onFailure(arg_0)));
        }
        catch (Exception e) {
            log.error("Failed to deploy model controller for the model {}", (Object)modelId);
            listener.onFailure(e);
        }
    }

    public synchronized void undeployController(String modelId, ActionListener<String> listener) {
        if (this.modelCacheHelper.isModelDeployed(modelId)) {
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                ActionListener wrappedListener = ActionListenerHelper.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
                this.getModel(modelId, (ActionListener<MLModel>)ActionListenerHelper.wrap(mlModel -> {
                    this.removeUserRateLimiterMap(modelId);
                    if (mlModel.getAlgorithm() == FunctionName.REMOTE) {
                        if (mlModel.getConnector() != null) {
                            this.setupParamsAndPredictable(modelId, (MLModel)mlModel);
                            wrappedListener.onResponse((Object)("Successfully undeployed model controller for the remote model " + modelId));
                            log.info("Undeployed model controller for the remote model {}", (Object)modelId);
                        } else {
                            this.getConnector(mlModel.getConnectorId(), mlModel.getTenantId(), (ActionListener<Connector>)ActionListenerHelper.wrap(connector -> {
                                mlModel.setConnector(connector);
                                this.setupParamsAndPredictable(modelId, (MLModel)mlModel);
                                wrappedListener.onResponse((Object)("Successfully undeployed model controller for the remote model " + modelId));
                                log.info("Undeployed model controller for the remote model {}", (Object)modelId);
                            }, arg_0 -> ((ActionListener)wrappedListener).onFailure(arg_0)));
                        }
                        return;
                    }
                    wrappedListener.onResponse((Object)("Successfully undeployed model controller for the model " + modelId));
                    log.info("Undeployed model controller for the model {}", (Object)modelId);
                }, arg_0 -> ((ActionListener)wrappedListener).onFailure(arg_0)));
            }
            catch (Exception e) {
                log.error("Failed to undeploy model controller for the model {}", (Object)modelId);
                listener.onFailure(e);
            }
        } else if (this.isModelRunningOnNode(modelId)) {
            log.error("Failed to undeploy model controller because model is in ML cache but with a state other than deployed. Please check model: {}", (Object)modelId);
            listener.onFailure((Exception)new RuntimeException("Failed to undeploy model controller because model is in ML cache but with a state other than deployed. Please check model: " + modelId));
        } else {
            log.info("Successfully deployed model controller from cache due to model not exist in cache. Model ID: {}", (Object)modelId);
            listener.onResponse((Object)("Successfully deployed model controller from cache due to model not exist in cache. Model ID: " + modelId));
        }
    }

    private synchronized void deployControllerWithDeployingModel(MLModel mlModel, Integer eligibleNodeCount, ActionListener<String> listener) {
        String modelId = mlModel.getModelId();
        FetchSourceContext fetchContext = new FetchSourceContext(true);
        GetRequest getRequest = new GetRequest(".plugins-ml-controller").id(modelId).fetchSourceContext(fetchContext);
        this.client.get(getRequest, ActionListenerHelper.wrap(r -> {
            if (r != null && r.isExists()) {
                try (XContentParser parser = MLNodeUtils.createXContentParserFromRegistry((NamedXContentRegistry)this.xContentRegistry, (BytesReference)r.getSourceAsBytesRef());){
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                    MLController controller = MLController.parse((XContentParser)parser);
                    this.setupUserRateLimiterMap(modelId, eligibleNodeCount, controller.getUserRateLimiter());
                    log.info("Successfully redeployed model controller for model " + modelId);
                    listener.onResponse((Object)("Successfully redeployed model controller for model " + modelId));
                }
                catch (Exception e) {
                    log.error("Failed to parse ml task{}", (Object)r.getId());
                    listener.onFailure(e);
                }
            } else if (!mlModel.getIsControllerEnabled().booleanValue()) {
                listener.onResponse((Object)("No controller is deployed because the model " + modelId + " is expected not having an enabled model controller. Please use the create controller api to create one if this is unexpected."));
                log.debug("No controller is deployed because the model " + modelId + " is expected not having an enabled model controller.");
            } else {
                listener.onFailure((Exception)new SkyliteStatusException("Failed to find model controller", RestStatus.NOT_FOUND, new Object[0]));
            }
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                if (!mlModel.getIsControllerEnabled().booleanValue()) {
                    listener.onResponse((Object)("No controller is deployed because the model " + modelId + " is expected not having an enabled model controller. Please use the create model controller api to create one if this is unexpected."));
                    log.debug("No controller is deployed because the model " + modelId + " is expected not having an enabled model controller.");
                } else {
                    listener.onFailure((Exception)new SkyliteStatusException("Failed to find model controller", RestStatus.NOT_FOUND, new Object[0]));
                }
            } else {
                log.error("Failed to re-deploy the model controller for model: {}", (Object)modelId);
                listener.onFailure(e);
            }
        }));
    }

    public void deployControllerWithDeployingModel(MLModel mlModel, Integer eligibleNodeCount) {
        if (!this.mlFeatureEnabledSetting.isControllerEnabled().booleanValue()) {
            throw new IllegalStateException("Controller is currently disabled. To enable it, update the setting \"plugins.ml_commons.controller_enabled\" to true.");
        }
        if (mlModel.getModelState() != MLModelState.DEPLOYING) {
            throw new SkyliteStatusException("This method should only be called when model is in DEPLOYING state, but the model is in state: " + String.valueOf(mlModel.getModelState()), RestStatus.CONFLICT, new Object[0]);
        }
        this.deployControllerWithDeployingModel(mlModel, eligibleNodeCount, (ActionListener<String>)ActionListenerHelper.wrap(response -> {
            if (response.startsWith("Successfully")) {
                log.debug(response);
            } else if (response.endsWith("is expected not having a model controller. Please use the create model controller api to create one if this is unexpected.")) {
                log.warn(response);
            } else {
                log.error(response);
            }
        }, e -> log.error("Failed to re-deploy the model controller for model: {}", (Object)mlModel.getModelId())));
    }

    private void setupRateLimiter(String modelId, Integer eligibleNodeCount, MLRateLimiter rateLimiter) {
        if (rateLimiter != null) {
            this.modelCacheHelper.setRateLimiter(modelId, this.createTokenBucket(eligibleNodeCount, rateLimiter));
        } else {
            this.modelCacheHelper.removeRateLimiter(modelId);
        }
    }

    private void setupUserRateLimiterMap(String modelId, Integer eligibleNodeCount, Map<String, MLRateLimiter> userRateLimiter) {
        if (userRateLimiter != null && !userRateLimiter.isEmpty()) {
            HashMap userRateLimiterMap = new HashMap();
            userRateLimiter.forEach((user, rateLimiter) -> userRateLimiterMap.put(user, this.createTokenBucket(eligibleNodeCount, (MLRateLimiter)rateLimiter)));
            this.modelCacheHelper.setUserRateLimiterMap(modelId, userRateLimiterMap);
        } else {
            this.modelCacheHelper.removeUserRateLimiterMap(modelId);
        }
    }

    private void removeUserRateLimiterMap(String modelId) {
        this.modelCacheHelper.removeUserRateLimiterMap(modelId);
    }

    private TokenBucket createTokenBucket(Integer eligibleNodeCount, MLRateLimiter rateLimiter) {
        if (rateLimiter.isValid()) {
            double limit = Double.parseDouble(rateLimiter.getLimit());
            TimeUnit unit = rateLimiter.getUnit();
            log.info("Initializing the rate limiter with setting {} per {} (TPS limit {}), evenly distributed on {} nodes", (Object)limit, (Object)unit, (Object)(limit / (double)unit.toSeconds(1L)), (Object)eligibleNodeCount);
            return new TokenBucket(System::nanoTime, limit / (double)unit.toNanos(1L) / (double)eligibleNodeCount.intValue(), Math.max(limit / (double)eligibleNodeCount.intValue(), 1.0), Math.max(limit / (double)eligibleNodeCount.intValue(), 1.0));
        }
        return null;
    }

    public TokenBucket getRateLimiter(String modelId) {
        return this.modelCacheHelper.getRateLimiter(modelId);
    }

    public Map<String, TokenBucket> getUserRateLimiterMap(String modelId) {
        return this.modelCacheHelper.getUserRateLimiterMap(modelId);
    }

    private void setupModelInterface(String modelId, Map<String, String> modelInterface) {
        log.debug("Model interface for model: {} loaded into cache.", (Object)modelId);
        if (modelInterface != null) {
            this.modelCacheHelper.setModelInterface(modelId, modelInterface);
        } else {
            this.modelCacheHelper.removeModelInterface(modelId);
        }
    }

    public Map<String, String> getModelInterface(String modelId) {
        return this.modelCacheHelper.getModelInterface(modelId);
    }

    private void setupMLGuard(String modelId, Guardrails guardrails) {
        if (guardrails != null) {
            this.modelCacheHelper.setMLGuard(modelId, this.createMLGuard(guardrails, this.xContentRegistry, this.client));
        } else {
            this.modelCacheHelper.removeMLGuard(modelId);
        }
    }

    private MLGuard createMLGuard(Guardrails guardrails, NamedXContentRegistry xContentRegistry, Client client) {
        return new MLGuard(guardrails, xContentRegistry, (ReleasableSkyliteClient)client);
    }

    public MLGuard getMLGuard(String modelId) {
        return this.modelCacheHelper.getMLGuard(modelId);
    }

    public void getModel(String modelId, ActionListener<MLModel> listener) {
        this.getModel(modelId, null, listener);
    }

    public void getModel(String modelId, String tenantId, ActionListener<MLModel> listener) {
        this.getModel(modelId, tenantId, null, null, listener);
    }

    public void getModel(String modelId, String[] includes, String[] excludes, ActionListener<MLModel> listener) {
        GetDataObjectRequest getRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-model")).id(modelId)).fetchSourceContext(new FetchSourceContext(true, includes, excludes)).build();
        this.sdkClient.getDataObjectAsync(getRequest).whenComplete((r, throwable) -> {
            block13: {
                if (throwable == null) {
                    try {
                        GetResponse gr;
                        GetResponse getResponse = gr = r.parser() == null ? null : GetResponse.fromXContent((XContentParser)r.parser());
                        if (gr != null && gr.isExists()) {
                            try (XContentParser parser = MediaTypeRegistry.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, gr.getSourceAsString());){
                                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                                String algorithmName = r.source().get("algorithm").toString();
                                MLModel mlModel = MLModel.parse((XContentParser)parser, (String)algorithmName);
                                mlModel.setModelId(modelId);
                                listener.onResponse((Object)mlModel);
                                break block13;
                            }
                            catch (Exception e) {
                                log.error("Failed to parse ml task{}", (Object)r.id());
                                listener.onFailure(e);
                            }
                            break block13;
                        }
                        listener.onFailure((Exception)new SkyliteStatusException("Failed to find model", RestStatus.NOT_FOUND, new Object[0]));
                    }
                    catch (Exception e) {
                        listener.onFailure(e);
                    }
                } else {
                    Exception e = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                    listener.onFailure(e);
                }
            }
        });
    }

    public void getModel(String modelId, String tenantId, String[] includes, String[] excludes, ActionListener<MLModel> listener) {
        GetDataObjectRequest getRequest = this.buildGetRequest(modelId, tenantId, includes, excludes);
        this.sdkClient.getDataObjectAsync(getRequest).whenComplete((response, throwable) -> {
            if (throwable != null) {
                this.handleError((Throwable)throwable, listener);
                return;
            }
            this.processGetResponse((GetDataObjectResponse)response, modelId, listener);
        });
    }

    private GetDataObjectRequest buildGetRequest(String modelId, String tenantId, String[] includes, String[] excludes) {
        return ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-model")).id(modelId)).tenantId(tenantId)).fetchSourceContext(new FetchSourceContext(true, includes, excludes)).build();
    }

    private void handleError(Throwable throwable, ActionListener<MLModel> listener) {
        Exception exception = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
        listener.onFailure(exception);
    }

    private void processGetResponse(GetDataObjectResponse response, String modelId, ActionListener<MLModel> listener) {
        try {
            GetResponse getResponse = this.parseGetResponse(response);
            if (getResponse == null || !getResponse.isExists()) {
                listener.onFailure((Exception)new SkyliteStatusException("Failed to find model", RestStatus.NOT_FOUND, new Object[0]));
                return;
            }
            this.parseAndReturnModel(getResponse, response.source().get("algorithm").toString(), modelId, listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private GetResponse parseGetResponse(GetDataObjectResponse response) throws IOException {
        return response.parser() == null ? null : GetResponse.fromXContent((XContentParser)response.parser());
    }

    private void parseAndReturnModel(GetResponse getResponse, String algorithmName, String modelId, ActionListener<MLModel> listener) {
        try (XContentParser parser = MediaTypeRegistry.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, getResponse.getSourceAsString());){
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            MLModel mlModel = MLModel.parse((XContentParser)parser, (String)algorithmName);
            mlModel.setModelId(modelId);
            listener.onResponse((Object)mlModel);
        }
        catch (Exception e) {
            log.error("Failed to parse ml model {}", (Object)modelId);
            listener.onFailure(e);
        }
    }

    public void getController(String modelId, ActionListener<MLController> listener) {
        this.getController(modelId, listener, 0);
    }

    private void getController(String modelId, ActionListener<MLController> listener, int retryCount) {
        FetchSourceContext fetchContext = new FetchSourceContext(true);
        GetRequest getRequest = new GetRequest(".plugins-ml-controller").id(modelId).fetchSourceContext(fetchContext);
        this.client.get(getRequest, ActionListenerHelper.wrap(r -> {
            if (r != null && r.isExists()) {
                try (XContentParser parser = MLNodeUtils.createXContentParserFromRegistry((NamedXContentRegistry)this.xContentRegistry, (BytesReference)r.getSourceAsBytesRef());){
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                    MLController controller = MLController.parse((XContentParser)parser);
                    listener.onResponse((Object)controller);
                }
                catch (Exception e) {
                    log.error("Failed to parse ml controller {}", (Object)r.getId());
                    listener.onFailure(e);
                }
            } else {
                listener.onFailure((Exception)new SkyliteStatusException("Failed to find model controller", RestStatus.NOT_FOUND, new Object[0]));
            }
        }, e -> {
            boolean docMissing;
            boolean indexMissing = SkyliteExceptionsHelper.unwrap((Throwable)e, (Class[])new Class[]{IndexNotFoundException.class}) != null;
            boolean bl = docMissing = e instanceof SkyliteStatusException && ((SkyliteStatusException)e).status() == RestStatus.NOT_FOUND;
            if ((indexMissing || docMissing) && retryCount < 3) {
                AccessController.doPrivileged(() -> {
                    int nextRetry = retryCount + 1;
                    long delay = (long)nextRetry * 200L;
                    log.warn("Controller not ready for model {}, retry {} ({}ms)", (Object)modelId, (Object)nextRetry, (Object)delay);
                    Runnable retryTask = () -> this.mlIndicesHandler.initMLControllerIndex((ActionListener<Boolean>)ActionListener.wrap(ok -> this.getController(modelId, listener, nextRetry), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
                    this.threadPool.schedule(retryTask, TimeValue.timeValueMillis((long)delay), "generic");
                    return null;
                });
                return;
            }
            listener.onFailure(e);
        }));
    }

    public void getConnector(String connectorId, String tenantId, ActionListener<Connector> listener) {
        GetDataObjectRequest getDataObjectRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-connector")).id(connectorId)).tenantId(tenantId)).build();
        try (ThreadContext.StoredContext ctx = this.client.threadPool().getThreadContext().stashContext();){
            this.sdkClient.getDataObjectAsync(getDataObjectRequest).whenComplete((r, throwable) -> {
                block15: {
                    log.debug("Completed Get Connector Request, id:{}", (Object)connectorId);
                    ctx.restore();
                    if (throwable != null) {
                        Exception cause = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                        if (SkyliteExceptionsHelper.unwrap((Throwable)cause, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
                            log.error("Failed to get connector index", (Throwable)cause);
                            listener.onFailure((Exception)new SkyliteStatusException("Failed to find connector", RestStatus.NOT_FOUND, new Object[0]));
                        } else {
                            log.error("Failed to get ML connector {}", (Object)connectorId);
                            listener.onFailure(cause);
                        }
                    } else {
                        try {
                            GetResponse gr;
                            GetResponse getResponse = gr = r.parser() == null ? null : GetResponse.fromXContent((XContentParser)r.parser());
                            if (gr != null && gr.isExists()) {
                                try (XContentParser parser = MLNodeUtils.createXContentParserFromRegistry((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (BytesReference)gr.getSourceAsBytesRef());){
                                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                                    Connector connector = Connector.createConnector((XContentParser)parser);
                                    listener.onResponse((Object)connector);
                                    break block15;
                                }
                                catch (Exception e) {
                                    log.error("Failed to parse connector:{}", (Object)connectorId);
                                    listener.onFailure(e);
                                }
                                break block15;
                            }
                            listener.onFailure((Exception)new SkyliteStatusException("Failed to find connector:" + connectorId, RestStatus.NOT_FOUND, new Object[0]));
                        }
                        catch (Exception e) {
                            listener.onFailure(e);
                        }
                    }
                }
            });
        }
    }

    private void retrieveModelChunks(MLModel mlModelMeta, ActionListener<Path> listener) throws InterruptedException {
        String modelId = mlModelMeta.getModelId();
        String modelName = mlModelMeta.getName();
        Integer totalChunks = mlModelMeta.getTotalChunks();
        GetRequest getRequest = new GetRequest();
        getRequest.index(".plugins-ml-model");
        getRequest.id();
        Semaphore semaphore = new Semaphore(1);
        AtomicBoolean stopNow = new AtomicBoolean(false);
        Path modelZipPath = this.mlEngine.getDeployModelZipPath(modelId, modelName);
        ConcurrentLinkedDeque chunkFiles = new ConcurrentLinkedDeque();
        AtomicInteger retrievedChunks = new AtomicInteger(0);
        int i = 0;
        while (i < totalChunks) {
            semaphore.tryAcquire(10L, TimeUnit.SECONDS);
            if (stopNow.get()) {
                throw new MLException("Failed to deploy model");
            }
            String modelChunkId = this.getModelChunkId(modelId, i);
            int currentChunk = i++;
            this.getModel(modelChunkId, (ActionListener<MLModel>)this.threadedActionListener("lucenia_ml_deploy", ActionListenerHelper.wrap(model -> {
                Path chunkPath = this.mlEngine.getDeployModelChunkPath(modelId, Integer.valueOf(currentChunk));
                FileUtils.write((byte[])Base64.getDecoder().decode(model.getContent()), (String)chunkPath.toString());
                chunkFiles.add(chunkPath);
                retrievedChunks.getAndIncrement();
                if (retrievedChunks.get() == totalChunks.intValue()) {
                    FileUtils.mergeFiles((Queue)chunkFiles, (Path)modelZipPath);
                    listener.onResponse((Object)modelZipPath);
                }
                semaphore.release();
            }, e -> {
                stopNow.set(true);
                semaphore.release();
                log.error("Failed to retrieve model chunk {}", (Object)modelChunkId);
                if (retrievedChunks.get() == totalChunks - 1) {
                    listener.onFailure((Exception)new MLResourceNotFoundException("Fail to find model chunk " + modelChunkId));
                }
            })));
        }
    }

    public void updateModel(String modelId, String tenantId, Boolean isHidden, Map<String, Object> updatedFields) {
        this.updateModel(modelId, tenantId, updatedFields, (ActionListener<UpdateResponse>)ActionListenerHelper.wrap(response -> {
            if (response.status() == RestStatus.OK) {
                log.debug(Strings.getErrorMessage((String)"Updated ML model successfully: {}", (String)modelId, (boolean)isHidden));
            } else {
                log.error(Strings.getErrorMessage((String)"Failed to update provided ML model, status: {}", (String)modelId, (boolean)isHidden));
            }
        }, e -> log.error(Strings.getErrorMessage((String)"Failed to update the provided ML model", (String)modelId, (boolean)isHidden))));
    }

    public void updateModel(String modelId, String tenantId, Map<String, Object> updatedFields, ActionListener<UpdateResponse> listener) {
        this.updateModelWithRetry(modelId, tenantId, updatedFields, listener, 0);
    }

    private void updateModelWithRetry(String modelId, String tenantId, Map<String, Object> updatedFields, ActionListener<UpdateResponse> listener, int retryCount) {
        if (updatedFields == null || updatedFields.isEmpty()) {
            listener.onFailure((Exception)new IllegalArgumentException("Updated fields is null or empty"));
            return;
        }
        HashMap<String, Object> newUpdatedFields = new HashMap<String, Object>();
        newUpdatedFields.putAll(updatedFields);
        newUpdatedFields.put("last_updated_time", Instant.now().toEpochMilli());
        UpdateDataObjectRequest.Builder requestBuilder = ((UpdateDataObjectRequest.Builder)((UpdateDataObjectRequest.Builder)((UpdateDataObjectRequest.Builder)UpdateDataObjectRequest.builder().index(".plugins-ml-model")).id(modelId)).tenantId(tenantId)).dataObject(newUpdatedFields);
        if (updatedFields.containsKey("model_state") && MODEL_DONE_STATES.contains(newUpdatedFields.get("model_state"))) {
            requestBuilder.retryOnConflict(3);
        }
        UpdateDataObjectRequest updateDataObjectRequest = requestBuilder.build();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.sdkClient.updateDataObjectAsync(updateDataObjectRequest).whenComplete((r, throwable) -> {
                context.restore();
                if (throwable != null && retryCount < 3) {
                    boolean isDocumentMissing;
                    Exception cause = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                    String exceptionMessage = cause.getMessage() != null ? cause.getMessage().toLowerCase(Locale.ROOT) : "";
                    String exceptionClass = cause.getClass().getName().toLowerCase(Locale.ROOT);
                    boolean bl = isDocumentMissing = exceptionMessage.contains("document missing") || exceptionMessage.contains("documentmissingexception") || exceptionClass.contains("documentmissingexception");
                    if (isDocumentMissing) {
                        long delayMillis = (long)Math.pow(2.0, retryCount) * 100L;
                        log.warn("Document {} not found (attempt {}/3), retrying update after {}ms. Error: {}", (Object)modelId, (Object)(retryCount + 1), (Object)delayMillis, (Object)cause.getMessage());
                        this.client.threadPool().schedule(() -> this.updateModelWithRetry(modelId, tenantId, updatedFields, listener, retryCount + 1), TimeValue.timeValueNanos((long)TimeUnit.MILLISECONDS.toNanos(delayMillis)), "lucenia_ml_register");
                        return;
                    }
                }
                this.handleUpdateDataObjectCompletionStage((UpdateDataObjectResponse)r, (Throwable)throwable, this.getUpdateResponseListener(modelId, listener));
            });
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void updateModel(String modelId, Boolean isHidden, Map<String, Object> updatedFields) {
        this.updateModel(modelId, updatedFields, (ActionListener<UpdateResponse>)ActionListenerHelper.wrap(response -> {
            if (response.status() == RestStatus.OK) {
                log.debug(Strings.getErrorMessage((String)"Updated ML model successfully: {}", (String)modelId, (boolean)isHidden));
            } else {
                log.error(Strings.getErrorMessage((String)"Failed to update provided ML model, status: {}", (String)modelId, (boolean)isHidden));
            }
        }, e -> log.error(Strings.getErrorMessage((String)"Failed to update the provided ML model", (String)modelId, (boolean)isHidden))));
    }

    public void updateModel(String modelId, Map<String, Object> updatedFields, ActionListener<UpdateResponse> listener) {
        this.updateModelWithRetry(modelId, null, updatedFields, listener, 0);
    }

    private void handleUpdateDataObjectCompletionStage(UpdateDataObjectResponse r, Throwable throwable, ActionListener<UpdateResponse> updateListener) {
        if (throwable != null) {
            Exception cause = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
            updateListener.onFailure(cause);
        } else {
            try {
                UpdateResponse updateResponse = r.parser() == null ? null : UpdateResponse.fromXContent((XContentParser)r.parser());
                updateListener.onResponse((Object)updateResponse);
            }
            catch (IOException e) {
                updateListener.onFailure((Exception)e);
            }
        }
    }

    private ActionListener<UpdateResponse> getUpdateResponseListener(String modelId, ActionListener<UpdateResponse> actionListener) {
        return ActionListenerHelper.wrap(updateResponse -> {
            if (updateResponse != null && updateResponse.getResult() != DocWriteResponse.Result.UPDATED) {
                log.error("Failed to update the model with ID: {}", (Object)modelId);
                actionListener.onResponse(updateResponse);
                return;
            }
            log.info("Successfully updated the model with ID: {}", (Object)modelId);
            actionListener.onResponse(updateResponse);
        }, exception -> {
            log.error("Failed to update ML model with ID {}. Details: {}", (Object)modelId, exception);
            actionListener.onFailure(exception);
        });
    }

    public String getModelChunkId(String modelId, Integer chunkNumber) {
        return modelId + "_" + chunkNumber;
    }

    public void addModelWorkerNode(String modelId, String ... nodeIds) {
        if (nodeIds != null) {
            for (String nodeId : nodeIds) {
                this.modelCacheHelper.addWorkerNode(modelId, nodeId);
            }
        }
    }

    public void addModelWorkerNodes(List<String> nodeIds) {
        if (nodeIds != null) {
            String[] modelIds = this.getAllModelIds();
            for (String nodeId : nodeIds) {
                Arrays.stream(modelIds).forEach(x -> this.modelCacheHelper.addWorkerNode(x, nodeId));
            }
        }
    }

    public void removeModelWorkerNode(String modelId, boolean isFromUndeploy, String ... nodeIds) {
        if (nodeIds != null) {
            for (String nodeId : nodeIds) {
                this.modelCacheHelper.removeWorkerNode(modelId, nodeId, isFromUndeploy);
            }
        }
    }

    public void removeWorkerNodes(Set<String> removedNodes, boolean isFromUndeploy) {
        this.modelCacheHelper.removeWorkerNodes(removedNodes, isFromUndeploy);
    }

    public synchronized Map<String, String> undeployModel(String[] modelIds) {
        HashMap<String, String> modelUndeployStatus = new HashMap<String, String>();
        if (modelIds != null && modelIds.length > 0) {
            log.debug("undeploy models {}", (Object)Arrays.toString(modelIds));
            for (String modelId : modelIds) {
                if (this.modelCacheHelper.isModelDeployed(modelId)) {
                    modelUndeployStatus.put(modelId, "undeployed");
                    this.mlStats.getStat((Enum)MLNodeLevelStat.ML_DEPLOYED_MODEL_COUNT).decrement();
                    this.mlStats.getStat((Enum)MLNodeLevelStat.ML_REQUEST_COUNT).increment();
                    this.mlStats.createCounterStatIfAbsent(this.getModelFunctionName(modelId), ActionName.UNDEPLOY, MLActionLevelStat.ML_ACTION_REQUEST_COUNT).increment();
                    this.mlStats.createModelCounterStatIfAbsent(modelId, ActionName.UNDEPLOY, MLActionLevelStat.ML_ACTION_REQUEST_COUNT).increment();
                } else {
                    modelUndeployStatus.put(modelId, "not_found");
                }
                this.removeModel(modelId);
            }
        } else {
            log.debug("undeploy all models {}", (Object)Arrays.toString(this.getLocalDeployedModels()));
            for (String modelId : this.getLocalDeployedModels()) {
                modelUndeployStatus.put(modelId, "undeployed");
                this.mlStats.getStat((Enum)MLNodeLevelStat.ML_DEPLOYED_MODEL_COUNT).decrement();
                this.mlStats.createCounterStatIfAbsent(this.getModelFunctionName(modelId), ActionName.UNDEPLOY, MLActionLevelStat.ML_ACTION_REQUEST_COUNT).increment();
                this.mlStats.createModelCounterStatIfAbsent(modelId, ActionName.UNDEPLOY, MLActionLevelStat.ML_ACTION_REQUEST_COUNT).increment();
                this.removeModel(modelId);
            }
        }
        return modelUndeployStatus;
    }

    private void removeModel(String modelId) {
        this.modelCacheHelper.removeModel(modelId);
        this.modelDownloader.deleteFileCache(this.mlEngine, modelId);
    }

    public String[] getWorkerNodes(String modelId, FunctionName functionName, boolean onlyEligibleNode) {
        String[] workerNodeIds = this.modelCacheHelper.getWorkerNodes(modelId);
        if (!onlyEligibleNode) {
            return workerNodeIds;
        }
        if (workerNodeIds == null || workerNodeIds.length == 0) {
            return workerNodeIds;
        }
        String[] eligibleNodeIds = this.nodeHelper.filterEligibleNodes(functionName, workerNodeIds);
        if (eligibleNodeIds == null || eligibleNodeIds.length == 0) {
            throw new IllegalArgumentException("No eligible worker node found");
        }
        return eligibleNodeIds;
    }

    public int getWorkerNodesSize(String modelId, FunctionName functionName, boolean onlyEligibleNode) {
        return this.getWorkerNodes(modelId, functionName, onlyEligibleNode).length;
    }

    public String[] getWorkerNodes(String modelId, FunctionName functionName) {
        return this.getWorkerNodes(modelId, functionName, false);
    }

    public int getWorkerNodesSize(String modelId, FunctionName functionName) {
        return this.getWorkerNodes(modelId, functionName, false).length;
    }

    public Predictable getPredictor(String modelId) {
        return this.modelCacheHelper.getPredictor(modelId);
    }

    public String[] getAllModelIds() {
        return this.modelCacheHelper.getAllModels();
    }

    public String[] getLocalDeployedModels() {
        return this.modelCacheHelper.getDeployedModels();
    }

    public String[] getExpiredModels() {
        return this.modelCacheHelper.getExpiredModels();
    }

    public synchronized void syncModelWorkerNodes(Map<String, Set<String>> modelWorkerNodes) {
        this.modelCacheHelper.syncWorkerNodes(modelWorkerNodes);
    }

    public void clearRoutingTable() {
        this.modelCacheHelper.clearWorkerNodes();
    }

    public MLModelProfile getModelProfile(String modelId) {
        return this.modelCacheHelper.getModelProfile(modelId);
    }

    public <T> T trackPredictDuration(String modelId, Supplier<T> supplier) {
        long start = System.nanoTime();
        T t = supplier.get();
        long end = System.nanoTime();
        double durationInMs = (double)(end - start) / 1000000.0;
        this.modelCacheHelper.addModelInferenceDuration(modelId, durationInMs);
        return t;
    }

    public void trackPredictDuration(String modelId, long startTime) {
        long end = System.nanoTime();
        double durationInMs = (double)(end - startTime) / 1000000.0;
        this.modelCacheHelper.addModelInferenceDuration(modelId, durationInMs);
    }

    public FunctionName getModelFunctionName(String modelId) {
        return this.modelCacheHelper.getFunctionName(modelId);
    }

    public Optional<FunctionName> getOptionalModelFunctionName(String modelId) {
        return this.modelCacheHelper.getOptionalFunctionName(modelId);
    }

    public boolean isModelRunningOnNode(String modelId) {
        return this.modelCacheHelper.isModelRunningOnNode(modelId);
    }

    public boolean isModelDeployed(String modelId) {
        return this.modelCacheHelper.isModelDeployed(modelId);
    }

    public boolean isNodeEligible(String nodeId, FunctionName functionName) {
        Set allEligibleNodeIds = Arrays.stream(this.nodeHelper.getEligibleNodes(functionName)).map(DiscoveryNode::getId).collect(Collectors.toSet());
        return allEligibleNodeIds.contains(nodeId);
    }

    public MLModel addModelToAutoDeployCache(String modelId, MLModel model) {
        return this.modelCacheHelper.addModelToAutoDeployCache(modelId, model);
    }

    public void removeAutoDeployModel(String modelId) {
        this.modelCacheHelper.removeAutoDeployModel(modelId);
    }
}

