/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.model;

import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.client.Client;
import io.skylite.core.client.metadata.GetDataObjectRequest;
import io.skylite.core.client.metadata.MetadataClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.util.CollectionUtils;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.ExistsQueryBuilder;
import io.skylite.core.index.query.IdsQueryBuilder;
import io.skylite.core.index.query.MatchAllQueryBuilder;
import io.skylite.core.index.query.MatchPhraseQueryBuilder;
import io.skylite.core.index.query.MatchQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.RangeQueryBuilder;
import io.skylite.core.index.query.TermQueryBuilder;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.AccessMode;
import io.skylite.ml.common.cluster.MLNodeUtils;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.exception.MLResourceNotFoundException;
import io.skylite.ml.common.exception.MLValidationException;
import io.skylite.ml.common.model.MLModelGroup;
import io.skylite.ml.common.settings.MLCommonsSettings;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.TermsQueryBuilder;

public class ModelAccessControlHelper {
    private static final Logger log = LogManager.getLogger(ModelAccessControlHelper.class);
    private volatile Boolean modelAccessControlEnabled;
    private static final List<Class<?>> SUPPORTED_QUERY_TYPES = List.of(IdsQueryBuilder.class, MatchQueryBuilder.class, MatchAllQueryBuilder.class, MatchPhraseQueryBuilder.class, TermQueryBuilder.class, TermsQueryBuilder.class, ExistsQueryBuilder.class, RangeQueryBuilder.class);

    public ModelAccessControlHelper(ClusterService clusterService, Settings settings) {
        this.modelAccessControlEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_MODEL_ACCESS_CONTROL_ENABLED.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_MODEL_ACCESS_CONTROL_ENABLED, it -> {
            this.modelAccessControlEnabled = it;
        });
    }

    public void validateModelGroupAccess(User user, String modelGroupId, Client client, ActionListener<Boolean> listener) {
        if (modelGroupId == null || this.isAdmin(user) || !this.isSecurityEnabledAndModelAccessControlEnabled(user)) {
            listener.onResponse((Object)true);
            return;
        }
        GetRequest getModelGroupRequest = new GetRequest(".plugins-ml-model-group").id(modelGroupId);
        try (ThreadContext.StoredContext context = client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListenerHelper.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
            client.get(getModelGroupRequest, ActionListenerHelper.wrap(r -> {
                if (r != null && r.isExists()) {
                    try (XContentParser parser = MLNodeUtils.createXContentParserFromRegistry((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (BytesReference)r.getSourceAsBytesRef());){
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                        MLModelGroup mlModelGroup = MLModelGroup.parse((XContentParser)parser);
                        this.checkModelGroupPermission(mlModelGroup, user, (ActionListener<Boolean>)wrappedListener);
                    }
                    catch (Exception e) {
                        log.error("Failed to parse ml model group");
                        wrappedListener.onFailure(e);
                    }
                } else {
                    wrappedListener.onFailure((Exception)new MLResourceNotFoundException("Fail to find model group"));
                }
            }, e -> {
                if (e instanceof IndexNotFoundException) {
                    wrappedListener.onFailure((Exception)new MLResourceNotFoundException("Fail to find model group"));
                } else {
                    log.error("Fail to get model group", (Throwable)e);
                    wrappedListener.onFailure((Exception)new MLValidationException("Fail to get model group"));
                }
            }));
        }
        catch (Exception e2) {
            log.error("Failed to validate Access", (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    public void validateModelGroupAccess(User user, MLFeatureEnabledSetting mlFeatureEnabledSetting, String tenantId, String modelGroupId, Client client, MetadataClient metadataClient, ActionListener<Boolean> listener) {
        if (modelGroupId == null || !mlFeatureEnabledSetting.isMultiTenancyEnabled() && !(this.isAdmin(user) || this.isSecurityEnabledAndModelAccessControlEnabled(user))) {
            listener.onResponse((Object)true);
            return;
        }
        GetDataObjectRequest getModelGroupRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-model-group")).id(modelGroupId)).tenantId(tenantId)).build();
        try (ThreadContext.StoredContext context = client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListenerHelper.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
            metadataClient.getDataObjectAsync(getModelGroupRequest).whenComplete((r, throwable) -> {
                block18: {
                    if (throwable == null) {
                        try {
                            GetResponse gr;
                            GetResponse getResponse = gr = r.parser() == null ? null : GetResponse.fromXContent((XContentParser)r.parser());
                            if (gr != null && gr.isExists()) {
                                try (XContentParser parser = MediaTypeRegistry.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, gr.getSourceAsString());){
                                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                                    MLModelGroup mlModelGroup = MLModelGroup.parse((XContentParser)parser);
                                    if (TenantAwareHelper.validateTenantResource((MLFeatureEnabledSetting)mlFeatureEnabledSetting, (String)tenantId, (String)mlModelGroup.getTenantId(), (ActionListener)listener)) {
                                        if (this.isAdmin(user) || !this.isSecurityEnabledAndModelAccessControlEnabled(user)) {
                                            listener.onResponse((Object)true);
                                            return;
                                        }
                                        this.checkModelGroupPermission(mlModelGroup, user, (ActionListener<Boolean>)wrappedListener);
                                    }
                                    break block18;
                                }
                                catch (Exception e) {
                                    log.error("Failed to parse ml model group");
                                    wrappedListener.onFailure(e);
                                }
                                break block18;
                            }
                            wrappedListener.onFailure((Exception)new MLResourceNotFoundException("Fail to find model group"));
                        }
                        catch (Exception e) {
                            listener.onFailure(e);
                        }
                    } else {
                        Exception e = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                        if (SkyliteExceptionsHelper.unwrap((Throwable)e, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
                            wrappedListener.onFailure((Exception)new MLResourceNotFoundException("Fail to find model group"));
                        } else {
                            log.error("Fail to get model group", (Throwable)e);
                            wrappedListener.onFailure((Exception)new MLValidationException("Fail to get model group"));
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to validate Access", (Throwable)e);
            listener.onFailure(e);
        }
    }

    public void checkModelGroupPermission(MLModelGroup mlModelGroup, User user, ActionListener<Boolean> wrappedListener) {
        AccessMode modelAccessMode = AccessMode.from((String)mlModelGroup.getAccess());
        if (mlModelGroup.getOwner() == null) {
            wrappedListener.onResponse((Object)true);
        } else {
            switch (modelAccessMode) {
                case RESTRICTED: {
                    if (mlModelGroup.getBackendRoles() == null || mlModelGroup.getBackendRoles().isEmpty()) {
                        throw new IllegalStateException("Backend roles shouldn't be null");
                    }
                    wrappedListener.onResponse((Object)Optional.ofNullable(user.getBackendRoles()).orElse(Collections.emptyList()).stream().anyMatch(mlModelGroup.getBackendRoles()::contains));
                    break;
                }
                case PRIVATE: {
                    wrappedListener.onResponse((Object)this.isOwner(mlModelGroup.getOwner(), user));
                    break;
                }
                default: {
                    wrappedListener.onResponse((Object)true);
                }
            }
        }
    }

    public boolean skipModelAccessControl(User user) {
        return user == null || this.modelAccessControlEnabled == false || this.isAdmin(user);
    }

    public boolean isSecurityEnabledAndModelAccessControlEnabled(User user) {
        return user != null && this.modelAccessControlEnabled != false;
    }

    public boolean isAdmin(User user) {
        if (user == null) {
            return false;
        }
        if (CollectionUtils.isEmpty((Collection)user.getRoles())) {
            return false;
        }
        return user.getRoles().contains("all_access");
    }

    public boolean isOwner(User owner, User user) {
        if (user == null || owner == null) {
            return false;
        }
        return owner.getName().equals(user.getName());
    }

    public boolean isUserHasBackendRole(User user, MLModelGroup mlModelGroup) {
        AccessMode modelAccessMode = AccessMode.from((String)mlModelGroup.getAccess());
        if (AccessMode.PUBLIC == modelAccessMode) {
            return true;
        }
        if (AccessMode.PRIVATE == modelAccessMode) {
            return false;
        }
        return user.getBackendRoles() != null && mlModelGroup.getBackendRoles() != null && mlModelGroup.getBackendRoles().stream().anyMatch(x -> user.getBackendRoles().contains(x));
    }

    public boolean isOwnerStillHasPermission(User user, MLModelGroup mlModelGroup) {
        if (!this.isSecurityEnabledAndModelAccessControlEnabled(user)) {
            return true;
        }
        AccessMode access = AccessMode.from((String)mlModelGroup.getAccess());
        if (AccessMode.PUBLIC == access) {
            return true;
        }
        if (AccessMode.PRIVATE == access) {
            return this.isOwner(user, mlModelGroup.getOwner());
        }
        if (AccessMode.RESTRICTED == access) {
            if (CollectionUtils.isEmpty((Collection)mlModelGroup.getBackendRoles())) {
                throw new IllegalStateException("Backend roles should not be null");
            }
            return user.getBackendRoles() != null && new HashSet(mlModelGroup.getBackendRoles()).stream().anyMatch(x -> user.getBackendRoles().contains(x));
        }
        throw new IllegalStateException("Access shouldn't be null");
    }

    public boolean isModelAccessControlEnabled() {
        return this.modelAccessControlEnabled;
    }

    public SearchSourceBuilder addUserBackendRolesFilter(User user, SearchSourceBuilder searchSourceBuilder) {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"access", (String)AccessMode.PUBLIC.getValue()));
        boolQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"backend_roles.keyword", (Collection)user.getBackendRoles()));
        BoolQueryBuilder privateBoolQuery = new BoolQueryBuilder();
        String ownerName = "owner.name.keyword";
        TermQueryBuilder ownerNameTermQuery = QueryBuilders.termQuery((String)ownerName, (String)user.getName());
        NestedQueryBuilder nestedQueryBuilder = new NestedQueryBuilder("owner", (QueryBuilder)ownerNameTermQuery, ScoreMode.None);
        privateBoolQuery.must((QueryBuilder)nestedQueryBuilder);
        privateBoolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"access", (String)AccessMode.PRIVATE.getValue()));
        boolQueryBuilder.should((QueryBuilder)privateBoolQuery);
        QueryBuilder query = searchSourceBuilder.query();
        if (query == null) {
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        } else if (query instanceof BoolQueryBuilder) {
            ((BoolQueryBuilder)query).filter((QueryBuilder)boolQueryBuilder);
        } else {
            BoolQueryBuilder rewriteQuery = new BoolQueryBuilder();
            rewriteQuery.must(query);
            rewriteQuery.filter((QueryBuilder)boolQueryBuilder);
            searchSourceBuilder.query((QueryBuilder)rewriteQuery);
        }
        return searchSourceBuilder;
    }

    public SearchSourceBuilder createSearchSourceBuilder(User user) {
        return this.addUserBackendRolesFilter(user, new SearchSourceBuilder());
    }
}

